/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-INPUT AND and 2-INPUT NOR  into 2-INPUT NOR 
TRUTHTABLE     : 
        ------------------------
         A    B    C    D    Z
        ------------------------
         H    H    X    X    L
         X    X    L    L    L
         L    X    H    X    H
         L    X    X    H    H
         X    L    H    X    H
         X    L    X    H    H
        -------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_A2_OI2_OI (Z, A, B, C, D);

    input   A, B, C, D;

    output   Z;


        
        parameter vlib_flat_module = 1 ;

        U_A2_OI2_OI inst1 (Z, A, B, C, D);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 1 - BIT FULL ADDER 
TRUTHTABLE     : 
        -----------------------
         A    B    CI   S   CO  
        -----------------------
         L    L    L    L    L
         L    L    H    H    L
         L    H    L    H    L
         L    H    H    L    H
         H    L    L    H    L 
         H    L    H    L    H
         H    H    L    L    H
         H    H    H    H    H
        -----------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_ADDR1 (S, CO, CI, A, B);

    input   CI, A, B;

    output   S, CO;



        parameter vlib_flat_module = 1 ;
      
        U_ADDR2_S inst1 (S, A, B, CI);
        U_ADDR2_C inst2 (CO, A, B, CI);


    specify


    // Specify path delays

        (CI => S)  = (1.0, 1.0);
        (CI => CO) = (1.0, 1.0);
        (A => S)   = (1.0, 1.0);
        (B => S)   = (1.0, 1.0);
        (A => CO)  = (1.0, 1.0);
        (B => CO)  = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 3-INPUT AND-OR GATE 
TRUTHTABLE     : 
        -------------------
         A    B    C    Z
        -------------------
         H    H    X    H
         H    X    H    H
         X    H    H    H

         L    X    L    L
         L    L    X    L
         X    L    L    L
        -------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AO3 (Z, A, B, C);

    input   A, B, C;

    output   Z;



        parameter vlib_flat_module = 1 ;

        U_AO3 inst1 (Z, A, B, C);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : TWO 2-INPUT and ONE SINGLE INPUT AND into 3-INPUT NOR
TRUTHTABLE     : 
        --------------------------
         A    B    C    D   E   Z
        --------------------------
         H    H    X    X   X   L
         X    X    H    H   X   L
         X    X    X    X   H   L
         L    X    L    X   L   H
         L    X    X    L   L   H
         X    L    L    X   L   H
         X    L    X    L   L   H
        --------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AOI_1_2_2 (Z, A, B, C, D, E);

    input   A, B, C, D, E;

    output   Z;


 
         parameter vlib_flat_module = 1 ;

         U_AOI_1_2_2 inst1 (Z, A, B, C, D, E);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
        (E -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 1-INPUT, 2-INPUT and 3-INPUT AND into 3-INPUT NOR
TRUTHTABLE     : 
        -------------------------------
         A    B    C    D    E   F   Z
        -------------------------------
         H    H    H    X    X   X   L
         X    X    X    H    H   X   L
         X    X    X    X    X   H   L
         L    X    X    L    X   L   H
         L    X    X    X    L   L   H
         X    L    X    L    X   L   H
         X    L    X    X    L   L   H
         X    X    L    L    X   L   H
         X    X    L    X    L   L   H
        -------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AOI_1_2_3 (Z, A, B, C, D, E, F);

    input   A, B, C, D, E, F;

    output   Z;



         parameter vlib_flat_module = 1 ;

         U_AOI_1_2_3 inst1 (Z, A, B, C, D, E, F);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
        (E -=> Z ) = (1.0, 1.0);
        (F -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-WIDE 2-INPUT AND into 2-INPUT NOR 
TRUTHTABLE     : 
        ------------------------
         A    B    C    D    Z
        ------------------------
         H    H    X    X    L
         X    X    H    H    L
         L    X    L    X    H
         L    X    X    L    H
         X    L    L    X    H
         X    L    X    L    H
        -------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AOI_2_2 (Z, A, B, C, D);

    input   A, B, C, D;

    output   Z;


  
         parameter vlib_flat_module = 1 ;

         U_AOI_2_2 inst1 (Z, A, B, C, D);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 3-WIDE 2-INPUT AND into 3-INPUT NOR
TRUTHTABLE     : 
        --------------------------------
         A    B    C    D    E   F   Z
        --------------------------------
         H    H    X    X    X   X   L
         X    X    H    H    X   X   L
         X    X    X    X    H   H   L

         L    X    L    X    L   X   H
         L    X    L    X    X   L   H
         L    X    X    L    L   X   H
         L    X    X    L    X   L   H 
         X    L    L    X    L   X   H
         X    L    L    X    X   L   H
         X    L    X    L    L   X   H
         X    L    X    L    X   L   H 
        --------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AOI_2_2_2 (Z, A, B, C, D, E, F);

    input   A, B, C, D, E, F;

    output   Z;


          parameter vlib_flat_module = 1 ;
          U_AOI_2_2_2 inst1 (Z, A, B, C, D, E, F);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
        (E -=> Z ) = (1.0, 1.0);
        (F -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 4-WIDE 2-INPUT AND into 4-INPUT NOR
TRUTHTABLE     : 
        ------------------------------------------
         A    B    C    D    E    F    G   H   Z
        ------------------------------------------
         H    H    X    X    X    X    X   X   L
         X    X    H    H    X    X    X   X   L
         X    X    X    X    H    H    X   X   L
         X    X    X    X    X    X    H   H   L
             
           All other input combinations produce 
                      HIGH output

       -------------------------------------------
         
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AOI_2_2_2_2 (Z, A, B, C, D, E, F, G, H);

    input   A, B, C, D, E, F, G, H;

    output   Z;


          parameter vlib_flat_module = 1 ;

          U_AO_2_2 inst1 (Z1, A, B, C, D);
          U_AO_2_2 inst2 (Z2, E, F, G, H);
          nor      NR1   (Z, Z1, Z2);


    specify


    // Specify path delays

        (A -=> Z) = (1.0, 1.0);
        (B -=> Z) = (1.0, 1.0);
        (C -=> Z) = (1.0, 1.0);
        (D -=> Z) = (1.0, 1.0);
        (E -=> Z) = (1.0, 1.0);
        (F -=> Z) = (1.0, 1.0);
        (G -=> Z) = (1.0, 1.0);
        (H -=> Z) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-INPUT AND and 3-INPUT AND into 2-INPUT NOR   
TRUTHTABLE     : 
        -------------------------------
         A    B    C    D    E    Z
        ------------------------------
         H    H    H    X    X    L
         X    X    X    H    H    L
         L    X    X    L    X    H
         L    X    X    X    L    H
         X    L    X    L    X    H
         X    L    X    X    L    H
         X    X    L    L    X    H
         X    X    L    X    L    H
        -------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AOI_2_3 (Z, A, B, C, D, E);

    input   A, B, C, D, E;

    output   Z;



         parameter vlib_flat_module = 1 ;

         U_AOI_2_3 inst1 (Z, A, B, C, D, E);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
        (E -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 3-INPUT AND-OR INVERT GATE 
TRUTHTABLE     : 
        -------------------
         A    B    C    Z
        -------------------
         H    H    X    L
         H    X    H    L
         X    H    H    L

         L    X    L    H
         L    L    X    H
         X    L    L    H
        -------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AOI_3 (Z, A, B, C);

    input   A, B, C;

    output   Z;



        parameter vlib_flat_module = 1 ;

        U_AOI_3 inst1 (Z, A, B, C);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-WIDE 3-INPUT AND into 2-INPUT NOR 
TRUTHTABLE     : 
        -----------------------------
         A    B   C   D    E   D   Z
        -----------------------------
         H    H   H   X    X   X   L
         X    X   X   H    H   H   L
         
         All other input combinations
           produce a HIGH output

        -----------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AOI_3_3 (Z, A, B, C, D, E, F);

    input   A, B, C, D, E, F;

    output   Z;


  
         parameter vlib_flat_module = 1 ;

         U_AOI_3_3 inst1 (Z, A, B, C, D, E, F);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
        (E -=> Z ) = (1.0, 1.0);
        (F -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-WIDE 2-INPUT AND into 2-INPUT OR
TRUTHTABLE     :
        ---------------------
         A    B   C    D   Z
        ---------------------
         H    H   X   X    H
         X    X   H   H    H

         All other input 
         combinations produce 
          a LOW output

        ---------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AO_2_2 (Z, A, B, C, D);

    input   A, B, C, D;

    output   Z;

         parameter vlib_flat_module = 1 ;

         U_AO_2_2 inst1 (Z, A, B, C, D);

    specify


    // Specify path delays

        (A +=> Z) = (1.0, 1.0);
        (B +=> Z) = (1.0, 1.0);
        (C +=> Z) = (1.0, 1.0);
        (D +=> Z) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 3-WIDE 2-INPUT AND into 3-INPUT OR
TRUTHTABLE     : 
        --------------------------------
         A    B    C    D    E   F   Z
        --------------------------------
         H    H    X    X    X   X   H
         X    X    H    H    X   X   H
         X    X    X    X    H   H   H

         L    X    L    X    L   X   L
         L    X    L    X    X   L   L
         L    X    X    L    L   X   L
         L    X    X    L    X   L   L 
         X    L    L    X    L   X   L
         X    L    L    X    X   L   L
         X    L    X    L    L   X   L
         X    L    X    L    X   L   L 
        --------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AO_2_2_2 (Z, A, B, C, D, E, F);

    input   A, B, C, D, E, F;

    output   Z;


          parameter vlib_flat_module = 1 ;

          U_AO_2_2_2 inst1 (Z, A, B, C, D, E, F);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
        (D +=> Z ) = (1.0, 1.0);
        (E +=> Z ) = (1.0, 1.0);
        (F +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 4-WIDE 2-INPUT AND into 4-INPUT OR
TRUTHTABLE     : 
        ------------------------------------------
         A    B    C    D    E    F    G   H   Z
        ------------------------------------------
         H    H    X    X    X    X    X   X   H
         X    X    H    H    X    X    X   X   H
         X    X    X    X    H    H    X   X   H
         X    X    X    X    X    X    H   H   H
             
           All other input combinations produce 
                      LOW output

       -------------------------------------------
         
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AO_2_2_2_2 (Z, A, B, C, D, E, F, G, H);

    input   A, B, C, D, E, F, G, H;

    output   Z;


          parameter vlib_flat_module = 1 ;
          U_AO_2_2 inst1 (Z1, A, B, C, D);
          U_AO_2_2 inst2 (Z2, E, F, G, H);
          or        O1   (Z, Z1, Z2);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
        (D +=> Z ) = (1.0, 1.0);
        (E +=> Z ) = (1.0, 1.0);
        (F +=> Z ) = (1.0, 1.0);
        (G +=> Z ) = (1.0, 1.0);
        (H +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-INPUT AND and 3-INPUT AND into 2-INPUT OR   
TRUTHTABLE     : 
        -------------------------------
         A    B    C    D    E    Z
        -------------------------------
         H    H    H    X    X    H
         X    X    X    H    H    H
         L    X    X    L    X    L
         L    X    X    X    L    L
         X    L    X    L    X    L
         X    L    X    X    L    L
         X    X    L    L    X    L
         X    X    L    X    L    L
        -------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AO_2_3 (Z, A, B, C, D, E);

    input   A, B, C, D, E;

    output   Z;



         parameter vlib_flat_module = 1 ;

         U_AO_2_3 inst1 (Z, A, B, C, D, E);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
        (D +=> Z ) = (1.0, 1.0);
        (E +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 3-INPUT AND-OR GATE 
TRUTHTABLE     : 
        -------------------
         A    B    C    Z
        -------------------
         H    X    X    H
         X    H    H    H

         L    X    L    L
         L    L    X    L
        -------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AO_3 (Z, A, B, C);

    input   A, B, C;

    output   Z;



        parameter vlib_flat_module = 1 ;

        U_AO_3 inst1 (Z, A, B, C);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-WIDE 3-INPUT AND into 2-INPUT OR 
TRUTHTABLE     : 
        -----------------------------
         A    B   C   D    E   D   Z
        -----------------------------
         H    H   H   X    X   X   H
         X    X   X   H    H   H   H
         
         All other input combinations
           produce a LOW output

        -----------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AO_3_3 (Z, A, B, C, D, E, F);

    input   A, B, C, D, E, F;

    output   Z;


  
         parameter vlib_flat_module = 1 ;

         U_AO_3_3 inst1 (Z, A, B, C, D, E, F);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
        (D +=> Z ) = (1.0, 1.0);
        (E +=> Z ) = (1.0, 1.0);
        (F +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-WIDE 2-INPUT AND into 2-INPUT XOR 
TRUTHTABLE     : 
        ------------------------
         A    B    C    D    Z
        ------------------------
         H    H    H    H    L

         L    X    L    X    L
         L    X    X    L    L
         X    L    L    X    L
         X    L    X    L    L

         H    H    L    X    H
         H    H    X    L    H
         L    X    H    H    H
         X    L    H    H    H
        -------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AXO_2_2 (Z, A, B, C, D);

    input   A, B, C, D;

    output   Z;


  
         parameter vlib_flat_module = 1 ;

         U_AXO_2_2 inst1 (Z, A, B, C, D);


    specify


    // Specify path delays

        (A => Z ) = (1.0, 1.0);
        (B => Z ) = (1.0, 1.0);
        (C => Z ) = (1.0, 1.0);
        (D => Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-INPUT AND and 3-INPUT AND into 2-INPUT XOR   
TRUTHTABLE     : 
        -----------------------------
           A   B    C   D   E    Z
        -----------------------------
           H   H    H   H   H    L
        
           L   X    L   X   X    L
           L   X    X   L   X    L
           L   X    X   X   L    L
        
           X   L    L   X   X    L
           X   L    X   L   X    L
           X   L    X   X   L    L
        
           H   H    L   X   X    H
           H   H    X   L   X    H
           H   H    X   X   L    H
         
           L   X    H   H   H    H
           X   L    H   H   H    H
        ----------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AXO_2_3 (Z, A, B, C, D, E);

    input   A, B, C, D, E;

    output   Z;



         parameter vlib_flat_module = 1 ;

         U_AXO_2_3 inst1 (Z, A, B, C, D, E);


    specify


    // Specify path delays

        (A => Z ) = (1.0, 1.0);
        (B => Z ) = (1.0, 1.0);
        (C => Z ) = (1.0, 1.0);
        (D => Z ) = (1.0, 1.0);
        (E => Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-INPUT AND and 4-INPUT AND into 2-INPUT XOR   
TRUTHTABLE     : 
        -------------------------------
           A   B    C   D   E   F    Z
        -------------------------------
           H   H    L   X   X   X    H
           H   H    X   L   X   X    H
           H   H    X   X   L   X    H
           H   H    X   X   X   L    H
         
           L   X    H   H   H   H    H
           X   L    H   H   H   H    H

          All other input combinations 
              produce LOW output 

        -------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_AXO_2_4 (Z, A, B, C, D, E, F);

    input   A, B, C, D, E, F;

    output   Z;



         parameter vlib_flat_module = 1 ;

         U_AXO_2_4 inst1 (Z, A, B, C, D, E, F);


    specify


    // Specify path delays

        (A => Z ) = (1.0, 1.0);
        (B => Z ) = (1.0, 1.0);
        (C => Z ) = (1.0, 1.0);
        (D => Z ) = (1.0, 1.0);
        (E => Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BI-DIRCTIONAL BUFFER WITH TEST INPUTS .
TRUTHTABLE     : 
           -----------------------
             EN   A   TN     IO
           -----------------------
              L   L    H      L
              L   H    H      H
              H   X    X     HI-Z
              X   X    L     HI-Z
           -----------------------
    NOTE :  IO is input when EN = H or TN = L

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_BD (ZI, PO, A, EN, TN, PI, IO);

    input   A, EN, TN, PI;

    output   ZI, PO;

    inout   IO;


        parameter vlib_flat_module = 1 ;

        U_BUF  inst1 (ct, TN, EN);
        bufif0 inst2 (IO, A, ct);
        buf    inst3 (ZI, IO);
        nand   inst4 (PO, PI, IO);

    specify


    // Specify path delays

        (A +=> IO)  = (1.0, 1.0);
        (EN => IO)  = (1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        (IO +=> ZI) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BI-DIRCTIONAL BUFFER  WITH INVERTED OUTPUT
TRUTHTABLE     : 
           -----------------------
             EN   A   TN     IO
           -----------------------
              L   L    H      L
              L   H    H      H
              H   X    X     HI-Z
              X   X    L     HI-Z
           -----------------------
    NOTE :  IO is input when EN = H or TN = L

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_BD_I (ZI, PO, A, EN, TN, PI, IO);

    input   A, EN, TN, PI;

    output   ZI, PO;

    inout   IO;


        parameter vlib_flat_module = 1 ;

        U_BUF inst1 (ct, TN, EN);
        bufif0 inst2 (IO, A, ct);
        not inst3 (ZI_int, IO);        
        buf  inst4 (ZI, ZI_int);
        nand inst5 (PO, PI, ZI_int);


    specify


    // Specify path delays

        (A -=> IO ) = (1.0, 1.0);
        (EN => IO ) = (1.0, 1.0);
        (IO -=> ZI ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BI-DIRCTIONAL BUFFER  WITH OPEN DRAIN 
TRUTHTABLE     : 
           ------------------
             EN  TN     IO
           ------------------
              L   H      L
              H   X     HI-Z
              X   L     HI-Z
           ------------------
    NOTE :  IO is input when EN = H or TN = L

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_BD_OD (ZI, PO, EN, TN, PI, IO);

    input   EN, TN, PI;

    output   ZI, PO;

    inout   IO;


        parameter vlib_flat_module = 1 ;

        U_BUF_1 inst1 (cnt, TN, EN);
        nmos    inst2 (IO, 1'b0, cnt);
        buf     inst3 (ZI, IO);
        nand    inst4 (PO, PI, IO);

    specify

    // Specify path delays

        (EN => IO ) = (0.0, 0.0, 1.0, 0.0, 0.0, 1.0);
        (IO +=> ZI ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BI-DIRCTIONAL BUFFER  WITH OPEN DRAIN 
                 AND INVERTED OUTPUT
TRUTHTABLE     : 
           ------------------
             EN  TN     IO
           ------------------
              L   H      L
              H   X     HI-Z
              X   L     HI-Z
           ------------------
    NOTE :  IO is input when EN = H or TN = L

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_BD_OD_I (ZI, PO, EN, TN, PI, IO);

    input   EN, TN, PI;

    output   ZI, PO;

    inout   IO;



       parameter vlib_flat_module = 1 ;

        U_BUF_1 inst1 (cnt, TN, EN);
        nmos    inst2 (IO, 1'b0, cnt);
        not     inst3 (ZI_int, IO);
        buf     inst4 (ZI, ZI_int);
        nand    inst5 (PO, PI, ZI_int);


    specify


    // Specify path delays

        (EN => IO ) = (0.0, 0.0, 1.0, 0.0, 0.0, 1.0);
        (IO -=> ZI ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BI-DIRCTIONAL BUFFER  WITH OPEN SOURCE  
TRUTHTABLE     : 
           -----------------
              E  TN     IO
           -----------------
              H   H      H
              L   X     HI-Z
              X   L     HI-Z
           -----------------
    NOTE :  IO is input when EN = H or TN = L

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_BD_OS (ZI, PO, E, TN, PI, IO);

    input   E, TN, PI;

    output   ZI, PO;

    inout   IO;


       parameter vlib_flat_module = 1 ;
        nand inst1 (cnt, E, TN);
        pmos
             inst2  (IO, 1'b1, cnt);
        buf inst3 (ZI, IO);
        nand  inst4 (PO, PI, IO);


    specify


    // Specify path delays

        (E => IO ) = (0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        (IO +=> ZI ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BI-DIRCTIONAL BUFFER  WITH OPEN SOURCE  
              AND INVERTED OUPUT 
TRUTHTABLE     : 
           -------------------
              E   TN     IO
           -------------------
              H    H      H
              L    X     HI-Z
              X    L     HI-Z
           -------------------
    NOTE :  IO is input when EN = H or TN = L

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_BD_OS_I (ZI, PO, E, TN, PI, IO);

    input   E, TN, PI;

    output   ZI, PO;

    inout   IO;


     parameter vlib_flat_module = 1 ;

        nand inst1 (cnt, E, TN);
        pmos inst2 (IO, 1'b1, cnt);
        not  inst3 (ZI_int, IO);          
        buf  inst4 (ZI, ZI_int);
        nand inst5 (PO, PI, ZI_int);


    specify


    // Specify path delays

        (E => IO ) = (0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        (IO -=> ZI ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BI-DIRCTIONAL BUFFER  WITH PULL DOWN 
TRUTHTABLE     : 
           -----------------------
             EN   A   TN     IO
           -----------------------
              L   L    H      L
              L   H    H      H
              H   X    X     HI-Z
              X   X    L     HI-Z
           -----------------------
    NOTE :  IO is input when EN = H or TN = L

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_BD_PD (ZI, PO, A, EN, TN, PI, IO);

    input   A, EN, TN, PI;

    output   ZI, PO;

    inout   IO;


        parameter vlib_flat_module = 1 ;

        tri0 IO;
        U_BUF  B1 (ct, TN, EN);
        bufif0 g3 (IO, A, ct);
        buf    g4 (ZI, IO);
        nand   g5 (PO, PI, IO);


    specify


    // Specify path delays

        (A +=> IO)  = (1.0, 1.0);
        (EN => IO)  = (1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        (IO +=> ZI) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BI-DIRCTIONAL BUFFER  WITH PULL DOWN 
                 AND INVERTED OUPUT .
TRUTHTABLE     : 
           -----------------------
             EN   A   TN     IO
           -----------------------
              L   L    H      L
              L   H    H      H
              H   X    X     HI-Z
              X   X    L     HI-Z
           -----------------------
    NOTE :  IO is input when EN = H or TN = L

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_BD_PD_I (ZI, PO, A, EN, TN, PI, IO);

    input   A, EN, TN, PI;

    output   ZI, PO;

    inout   IO;



        parameter vlib_flat_module = 1 ;
        tri0 IO;
        U_BUF  B1 (ct, TN, EN);
        bufif0 g3 (IO, A, ct);
        not    g4 (ZI_int, IO);
        buf    g2 (ZI, ZI_int);
        nand   g5 (PO, PI, ZI_int);


    specify


    // Specify path delays

        (A -=> IO)  = (1.0, 1.0);
        (EN => IO)  = (1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        (IO -=> ZI) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BI-DIRCTIONAL BUFFER  WITH PULL UP
TRUTHTABLE     : 
           -----------------------
             EN   A   TN     IO
           -----------------------
              L   L    H      L
              L   H    H      H
              H   X    X     HI-Z
              X   X    L     HI-Z
           -----------------------
    NOTE :  IO is input when EN = H or TN = L

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_BD_PU (ZI, PO, A, EN, TN, PI, IO);

    input   A, EN, TN, PI;

    output   ZI, PO;

    inout   IO;



        parameter vlib_flat_module = 1 ;

        tri1 IO;
        U_BUF  B1 (ct, TN, EN);
        bufif0 g3 (IO, A, ct);
        buf    g4 (ZI, IO);
        nand   g5 (PO, PI, IO);


    specify


    // Specify path delays

        (A +=> IO)  = (1.0, 1.0);
        (EN => IO)  = (1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        (IO +=> ZI) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BI-DIRCTIONAL BUFFER  WITH PULL UP
                 AND INVERTED OUPUT .
TRUTHTABLE     : 
           -----------------------
             EN   A   TN     IO
           -----------------------
              L   L    H      L
              L   H    H      H
              H   X    X     HI-Z
              X   X    L     HI-Z
           -----------------------
    NOTE :  IO is input when EN = H or TN = L

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_BD_PU_I (ZI, PO, A, EN, TN, PI, IO);

    input   A, EN, TN, PI;

    output   ZI, PO;

    inout   IO;



        parameter vlib_flat_module = 1 ;

        tri1 IO;
        U_BUF  B1 (ct, TN, EN);
        bufif0 g3 (IO, A, ct);
        not    g4 (ZI_int, IO);
        buf    g2 (ZI, ZI_int);
        nand   g5 (PO, PI, ZI_int);


    specify


    // Specify path delays

        (A -=> IO)  = (1.0, 1.0);
        (EN => IO)  = (1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        (IO -=> ZI) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : THREE STATE OUTPUT BUFFER 
TRUTHTABLE     : 
          -------------------
           EN  A   TN    Z
          -------------------
           L    L   H    L
           L    H   H    H
           X    X   L   HI-Z
           H    X   X   HI-Z
          -------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_TRI (Z, A, EN, TN);

    input   A, EN, TN;

    output   Z;


     parameter vlib_flat_module = 1 ;

     U_BUF  B0  (CNT, TN, EN);
     bufif0 B1  (Z, A, CNT);

    specify


    // Specify path delays

        if (!EN && TN)
        (A +=> Z) = (1.0, 1.0);
        (EN => Z) = (1.0, 1.0, 1.0, 1.0, 1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : THREE STATE OUTPUT BUFFER WITH OPEN DRAIN
TRUTHTABLE     : 
          --------------
           EN  TN    Z
          --------------
           L   H    H
           X   L   HI-Z
           H   X   HI-Z
          --------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_TRI_OD (Z, EN, TN);

    input   EN, TN;

    output   Z;


     parameter vlib_flat_module = 1 ;

     U_BUF_1 B0  (CNT, TN, EN);
     nmos    B1  (Z, 1'b0, CNT);


    specify


    // Specify path delays

        (EN => Z) = (0.0, 0.0, 1.0, 0.0, 0.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : THREE STATE OUTPUT BUFFER WITH OPEN SOURCE
TRUTHTABLE     : 
          --------------
           E  TN    Z
          --------------
           H   H    H
           X   L   HI-Z
           L   X   HI-Z
          --------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_TRI_OS (Z, E, TN);

    input   E, TN;

    output   Z;


     parameter vlib_flat_module = 1 ;

     nand ND2 (CNT, E, TN);
     pmos B1  (Z, 1'b1, CNT);


    specify


    // Specify path delays

        (E => Z) = (0.0, 0.0, 0.0, 1.0, 1.0, 0.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : UNIDIRECT OUTPUT BUFFER
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_BUF_UNI (Z, A);

    input   A;

    output   Z;



     parameter vlib_flat_module = 1 ;

   buf B1 (Z,  A);


    specify


    // Specify path delays

        (A +=> Z) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : TWO TO FOUR DECODER
TRUTHTABLE     : 
         ------------------------------
          A   B        Z0   Z1  Z2  Z3
         ------------------------------
          L   L        L    H   H   H    
          H   L        H    L   H   H    
          L   H        H    H   L   H    
          H   H        H    H   H   L    
         ------------------------------ 
   
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_DECOD_2X4 (Z0, Z1, Z2, Z3, A, B);

    input   A, B;

    output   Z0, Z1, Z2, Z3;


        parameter vlib_flat_module = 1 ;

        not  N1  (nA, A),
             N2  (nB, B);
        nand
             ND1  (Z0, nA, nB),
             ND2  (Z1, A, nB),
             ND3  (Z2, nA, B),
             ND4  (Z3, A, B);

    specify

    // Specify path delays

        (A => Z0 ) = (1.0, 1.0);
        (B => Z0 ) = (1.0, 1.0);
        (A => Z1 ) = (1.0, 1.0);
        (B => Z1 ) = (1.0, 1.0);
        (A => Z2 ) = (1.0, 1.0);
        (B => Z2 ) = (1.0, 1.0);
        (A => Z3 ) = (1.0, 1.0);
        (B => Z3 ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : TWO TO FOUR DECODER WITH ACTVE HIGH GATE INPUT
TRUTHTABLE     : 
         ------------------------------
          A   B   G    Z0   Z1  Z2  Z3
         ------------------------------
          L   L   H    L    H   H   H    
          H   L   H    H    L   H   H    
          L   H   H    H    H   L   H    
          H   H   H    H    H   H   L    
          X   X   L    H    H   H   H    
         ------------------------------ 
   
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_DECOD_G_2X4 (Z0, Z1, Z2, Z3, A, B, G);

    input   A, B, G;

    output   Z0, Z1, Z2, Z3;


        parameter vlib_flat_module = 1 ;
        not  N1   (nA, A),
             N2   (nB, B);
            
        nand
            ND1  (Z0, nA, nB, G),
            ND2  (Z1, A, nB, G),
            ND3  (Z2, nA, B, G),
            ND4  (Z3, A, B, G);


    specify


    // Specify path delays

        if (G)
        (A => Z0) = (1.0, 1.0);
        (B => Z0) = (1.0, 1.0);
        (A => Z1) = (1.0, 1.0);
        (B => Z1) = (1.0, 1.0);
        (A => Z2) = (1.0, 1.0);
        (B => Z2) = (1.0, 1.0);
        (A => Z3) = (1.0, 1.0);
        (B => Z3) = (1.0, 1.0);

        (G => Z0) = (1.0, 1.0);
        (G => Z1) = (1.0, 1.0);
        (G => Z2) = (1.0, 1.0);
        (G => Z3) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : BUFFER WITH DIFFERENTIAL INPUT AND OUTPUT
TRUTHTABLE     : 

       TO IMPLEMENT THE LOGIC EQUATION Y = (A .~AN)

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                     DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_DIFF_BUF (Y, YN, A, AN);

    input   A, AN;

    output   Y, YN;


   
    parameter vlib_flat_module = 1 ;

    U_DIFF_BUF  inst1 (Y_int, A, AN); 
  
    parameter MAX_SKEW = 1;

    bufif0    B1 (Y_int, 1'bx, skew_chk);
    buf       B2 (Y, Y_int);
    not       N1 (YN, Y_int);

    xor    #(MAX_SKEW)  (skew_chk, A, AN);


    always @ (skew_chk)
       if (skew_chk == 1'b0)
         $display ( " Differential inputs  A, AN skew violation at time %12.5f ! ", $realtime);


    specify


    // Specify path delays

        (A  +=> Y)  = (1.0, 1.0);
        (AN +=> Y)  = (1.0, 1.0);
        (A  -=> YN) = (1.0, 1.0);
        (AN -=> YN) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : INVERTER INTO INVERTER
TRUTHTABLE     : 

     ----------------
      A    Y    Z
     ----------------
      L    H    L

      H    L    H    
     ----------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_DUAL_INV (Y, Z, A);

    input   A;

    output   Y, Z;


        parameter vlib_flat_module = 1 ;

    not N1 (Y, A);
    buf N2 (Z, A);


    specify


    // Specify path delays

        (A -=> Y ) = (1.0, 1.0);
        (A +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-TYPE FLIP-FLOP AND A D-TYPE LATCH WITH  
              ASYNCHRONOUS CLEAR and PRESET ( ACTIVE LOW ) .
TRUTHTABLE     : 
              --------------------------------------------------
                 SEL    D     SI     CP   RB   SB    Q    QN   
              --------------------------------------------------
                  X     X     X      X    L     H    L     H   
                  X     X     X      X    H     L    H     L   
                  X     X     X      X    L     L    L     L   
                                      _                 
                  H     L     X     _/    H     H    L     H   
                                      _              
                  H     H     X     _/    H     H    H     L   
                                    _                
                  H     X     X      \_   H     H    Q    QN   
                                                     
                  L     X     L      H    H     H    L     H   
                                                     
                  L     X     H      H    H     H    H     L   
              -------------------------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_LD_P_RB_SB (Q, QN, SEL, D, SI, CP, RB, SB);

    input   SEL, D, SI, CP, RB, SB;

    output   Q, QN;



         parameter vlib_flat_module = 1 ;

           U_FD_LD_P_RB_SB inst1 (Q, SEL, D_EFF, CP, RB, SB);
           U_FD_LD_P_RB_SB_QN inst2 (QN, SEL, D_EFF, CP, RB, SB);
           U_MUX_2_1 (D_EFF, SI, D, SEL);

           and                                    
             A1   (ENABLE, RB, SB),  
             A2   (EN_D, SEL, ENABLE),
             A3   (EN_SI1, CP, ENABLE),
             A4   (EN_SI2, SEL_, ENABLE);

           not
             N1 (SEL_, SEL);


    specify


    // Specify path delays

    if (RB && SB && SEL)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB && SEL)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);

    if (CP && RB && SB && !SEL)
        (SI +=> Q ) = (1.0, 1.0);
    if (CP && RB && SB && !SEL)
        (SI -=> QN ) = (1.0, 1.0);

    if (RB && SB && !SEL)
        (posedge CP =>  (Q +: SI)) = (1.0, 1.0);
    if (RB && SB && !SEL)
        (posedge CP =>  (QN -: SI)) = (1.0, 1.0);

    if (RB && SB && CP)
        (negedge SEL =>  (Q +: SI)) = (1.0, 1.0);
    if (RB && SB && CP)
        (negedge SEL =>  (QN -: SI)) = (1.0, 1.0);

    if (SB && CP && !SEL)
        (posedge RB =>  (Q +: SI)) = (1.0, 1.0);
    if (SB && CP && !SEL)
        (posedge RB =>  (QN -: SI)) = (1.0, 1.0);
    if (RB && CP && !SEL)
        (posedge SB =>  (Q +: SI)) = (1.0, 1.0);
    if (RB && CP && !SEL)
        (posedge SB =>  (QN -: SI)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      specparam
        t_SETUP$D  = 0.0 ,
        t_SETUP$SI  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_HOLD$SI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


 

    $setuphold(posedge CP &&& EN_D, D, t_SETUP$D, t_HOLD$D);
    $setuphold(posedge SEL &&& EN_SI1, SI, t_SETUP$SI, t_HOLD$SI);
    $setuphold(negedge CP &&& EN_SI2, SI, t_SETUP$SI, t_HOLD$SI);
                             
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(posedge CP &&& ENABLE, t_PW_H$CP);      

    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB); 


    $recovery(posedge RB &&& SB, negedge CP, t_RELEASE$RB$CP);
    $recovery(posedge SB &&& RB, negedge CP, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-TYPE FLIP-FLOP AND A D-TYPE LATCH WITH  
              ASYNCHRONOUS CLEAR and PRESET ( ACTIVE LOW ) .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------------------------
                 SEL    D     SI     CP   RB   SB    Q    QN   
              --------------------------------------------------
                  X     X     X      X    L     H    L     H   
                  X     X     X      X    H     L    H     L   
                  X     X     X      X    L     L    L     L   
                                      _                 
                  H     L     X     _/    H     H    L     H   
                                      _              
                  H     H     X     _/    H     H    H     L   
                                    _                
                  H     X     X      \_   H     H    Q    QN   
                                                     
                  L     X     L      H    H     H    L     H   
                                                     
                  L     X     H      H    H     H    H     L   
              -------------------------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_LD_P_RB_SB_NO (Q, QN, SEL, D, SI, CP, RB, SB);

    input   SEL, D, SI, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;

         parameter vlib_flat_module = 1 ;

           U_FD_LD_P_RB_SB_NO inst1 (Q, SEL, D_EFF, CP, RB, SB, NOTIFY_REG);
           U_FD_LD_P_RB_SB_NO_QN inst2 (QN, SEL, D_EFF, CP, RB, SB, NOTIFY_REG);
           U_MUX_2_1 (D_EFF, SI, D, SEL);

           and                                    
             A1   (ENABLE, RB, SB),  
             A2   (EN_D, SEL, ENABLE),
             A3   (EN_SI1, CP, ENABLE),
             A4   (EN_SI2, SEL_, ENABLE);
           not
             N1 (SEL_, SEL);


    specify


    // Specify path delays

    if (RB && SB && SEL)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB && SEL)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);

    if (CP && RB && SB && !SEL)
        (SI +=> Q ) = (1.0, 1.0);
    if (CP && RB && SB && !SEL)
        (SI -=> QN ) = (1.0, 1.0);

    if (RB && SB && !SEL)
        (posedge CP =>  (Q +: SI)) = (1.0, 1.0);
    if (RB && SB && !SEL)
        (posedge CP =>  (QN -: SI)) = (1.0, 1.0);

    if (RB && SB && CP)
        (negedge SEL =>  (Q +: SI)) = (1.0, 1.0);
    if (RB && SB && CP)
        (negedge SEL =>  (QN -: SI)) = (1.0, 1.0);

    if (SB && CP && !SEL)
        (posedge RB =>  (Q +: SI)) = (1.0, 1.0);
    if (SB && CP && !SEL)
        (posedge RB =>  (QN -: SI)) = (1.0, 1.0);

     if (RB && CP && !SEL)
        (posedge SB =>  (Q +: SI)) = (1.0, 1.0);
    if (RB && CP && !SEL)
        (posedge SB =>  (QN -: SI)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);


      // Timing checks 



      specparam
        t_SETUP$D  = 0.0 ,
        t_SETUP$SI  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_HOLD$SI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(posedge CP &&& EN_D, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(posedge SEL &&& EN_SI1, SI, t_SETUP$SI, t_HOLD$SI, NOTIFY_REG);
    $setuphold(negedge CP &&& EN_SI2, SI, t_SETUP$SI, t_HOLD$SI, NOTIFY_REG);
                             
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);      
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge RB &&& SB, posedge CP, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB &&& RB, posedge CP, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP 
TRUTHTABLE     : 
              -----------------
               D    CP      Q  
              -----------------
                    _ 
               L     \_     L  
                    _ 
               H     \_     H  
                      _
               X    _/      Q  
              -----------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N (Q, QN, D, CP);

    input   D, CP;

    output   Q, QN;


    
            parameter vlib_flat_module = 1 ;

            U_FD_N 
               inst1 (Q_int, D, CP);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

    specify


    // Specify path delays

        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;
  
    $setuphold(negedge CP, D, t_SETUP$D, t_HOLD$D);

    $width(posedge CP, t_PW_H$CP); 
    $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW CLOCK 
                 ENABLE 
TRUTHTABLE     :

            ------------------------
             D    CP   CEB   Q    QN
            ------------------------
                  _
             L     \_    L   L    H
                  _
             H     \_    L   H    L
                    _
             X    _/     L   Q    QN

             X     X     H   Q    QN
 
            ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FD_N_CEB_NO (Q, QN, D, CP, CEB);
    
    input    D, CP, CEB;

    output   Q, QN;
    
       reg NOTIFY_REG;
    
       U_FD_N_CEB_NO inst1 (Q_int, D, CP, CEB, NOTIFY_REG);

       buf           BU1   (Q, Q_int);
       not           NT1   (QN, Q_int);

    
    specify


      // Specify path delays
          
           (negedge CP =>  (Q +: D))  = (1.0, 1.0);  
           (negedge CP =>  (QN -: D))  = (1.0, 1.0);  


      // Timing Checks
      
      specparam
          t_SETUP$D    = 0.0,
          t_HOLD$D     = 0.0,                
          t_SETUP$CEB  = 0.0,              
          t_HOLD$CEB   = 0.0,             
          t_PW_H$CP    = 0.0,            
          t_PW_L$CP    = 0.0;            

           
      $setuphold(negedge CP &&& (~CEB), D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
      $setup(negedge CEB, negedge CP, t_SETUP$CEB, NOTIFY_REG);
      $hold(negedge CP, posedge CEB, t_HOLD$CEB, NOTIFY_REG);
    
      $width(negedge CP &&& (~CEB), t_PW_L$CP, 0, NOTIFY_REG);
      $width(posedge CP &&& (~CEB), t_PW_H$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP FLOP WITH ACTIVE LOW ENABLE
                 AND ACTIVE HIGH ASYNCHRONOUS PRESET.
                 This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     :
              -------------------------------
               D    CEB    CP     S   Q    QN
              -------------------------------
                           _
               L     L      \_    L    L    H
                           _
               H     L      \_    L    H    L
                             _
               X     L     _/     L    Q    QN

               X     H      X     L    Q    QN

               X     X      X     H    H    L
              -------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.5c, Veritime 1.1b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_CEB_S_NO (Q, QN, D, CEB, CP, S);

    input    D, CEB, CP, S;
    output   Q, QN;

    reg NOTIFY_REG;

       U_FD_N_CEB_S_NO
            inst1 (Q_int, D, CP, S, CEB, NOTIFY_REG);

       buf
            inst2 (Q, Q_int);

       not
            inst3 (QN, Q_int);

       // Additional Logic for Timing Checks

       nor   NR1   (ENABLE, CEB, S);

    specify

    // Specify Path Delays

          if (!S)
           (negedge CP =>  (Q +: D))  = (1.0:1.0:1.0, 1.0:1.0:1.0);
          if (!S)
           (negedge CP =>  (QN -: D))  = (1.0:1.0:1.0, 1.0:1.0:1.0);
        
          if (S)
           (posedge S => (Q +: 1'b1)) = (1.0:1.0:1.0, 1.0:1.0:1.0);
          if (S)
           (posedge S => (QN +: 1'b0)) = (1.0:1.0:1.0, 1.0:1.0:1.0);


    // Timing checks

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$CEB  = 0.0 ,
        t_HOLD$CEB  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ;

    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(negedge CEB, negedge CP &&& (~S), t_SETUP$CEB, NOTIFY_REG);
    $hold(negedge CP, posedge CEB &&& (~S), t_HOLD$CEB, NOTIFY_REG);

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG);

    $recovery(negedge S, negedge CP &&& ~CEB, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH CLOCK 
                 ENABLE 
TRUTHTABLE     :

            ------------------------
             D    CP    CE   Q    QN
            ------------------------
                  _
             L     \_    H   L    H
                  _
             H     \_    H   H    L
                    _
             X    _/     H   Q    QN

             X     X     L   Q    QN
 
            ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FD_N_CE_NO (Q, QN, D, CP, CE);
    
    input    D, CP, CE;

    output   Q, QN;
    
       reg NOTIFY_REG;
    
       U_FD_N_CE_NO inst1 (Q_int, D, CP, CE, NOTIFY_REG);

       buf           BU1   (Q, Q_int);
       not           NT1   (QN, Q_int);

    
    specify


      // Specify path delays
          
           (negedge CP =>  (Q +: D))  = (1.0, 1.0);  
           (negedge CP =>  (QN -: D))  = (1.0, 1.0);  


      // Timing Checks
      
      specparam
          t_SETUP$D    = 0.0,
          t_HOLD$D     = 0.0,                
          t_SETUP$CE  = 0.0,              
          t_HOLD$CE   = 0.0,             
          t_PW_H$CP    = 0.0,            
          t_PW_L$CP    = 0.0;            

           
      $setuphold(negedge CP &&& CE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
      $setup(posedge CE, negedge CP, t_SETUP$CE, NOTIFY_REG);
      $hold(negedge CP, negedge CE, t_HOLD$CE, NOTIFY_REG);
    
      $width(negedge CP &&& CE, t_PW_L$CP, 0, NOTIFY_REG);
      $width(posedge CP &&& CE, t_PW_H$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH CLOCK 
                 ENABLE AND ACTIVE LOW ASYNCHRONOUS RESET
TRUTHTABLE     :

            ----------------------------
             D    CP    RB  CE   Q    QN
            ----------------------------
                  _
             L     \_    H   H   L    H
                  _
             H     \_    H   H   H    L
                    _
             X    _/     H   H   Q    QN

             X     X     H   L   Q    QN

             X     X     L   X   L    H  
 
            ----------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FD_N_CE_RB_NO(Q, QN, D, CP, CE, RB);
    
    input    D, CP, CE, RB;

    output   Q, QN;
    
       reg NOTIFY_REG;
    
       U_FD_N_CE_RB_NO inst1 (Q_int, D, CP, RB, CE, NOTIFY_REG);

       buf             BU1   (Q, Q_int);
       not             NT1   (QN, Q_int);

                
       // Additional Logic for Timing Checks
       
       and             AN1  (ENABLE, CE, RB);
    

    specify


      // Path Delays
          
          if (RB)
          (negedge CP =>  (Q +: D))  = (1.0, 1.0);  
          if (RB)
          (negedge CP =>  (QN -: D))  = (1.0, 1.0);  

          if (!RB)
          (negedge RB => (Q +: 1'b0)) = (1.0, 1.0);
          if (!RB)
          (negedge RB => (QN +: 1'b1)) = (1.0, 1.0);          


      // Timing Checks
      
      specparam
          t_SETUP$D    = 0.0,
          t_HOLD$D     = 0.0,                
          t_SETUP$CE   = 0.0,              
          t_HOLD$CE    = 0.0,             
          t_PW_H$CP    = 0.0,            
          t_PW_L$CP    = 0.0,          
          t_PW_L$RB    = 0.0,
          t_RELEASE$RB$CP = 0.0;

      $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
      $setup(posedge CE, negedge CP &&& RB, t_SETUP$CE, NOTIFY_REG);
      $hold(negedge CP, negedge CE &&& RB, t_HOLD$CE, NOTIFY_REG);

      $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
      $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
      $width(negedge RB,t_PW_L$RB, 0, NOTIFY_REG);

      $recovery(posedge RB, negedge CP &&& CE, t_RELEASE$RB$CP , NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP FLOP WITH ACTIVE HIGH ENABLE
                 AND ACTIVE LOW ASYNCHRONOUS SET AND RESET.
                 This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     :
              ------------------------------------
               D    CE    CP     SB   RB   Q    QN
              ------------------------------------
                           _
               L     H      \_    H   H    L    H
                           _
               H     H      \_    H   H    H    L
                             _
               X     H     _/     H   H    Q    QN

               X     L      X     H   H    Q    QN

               X     X      X     L   H    H    L

               X     X      X     H   L    L    H

               X     X      X     L   L    X    X
              ------------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.5c, Veritime
 1.1b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_CE_RB_SB_X_NO (Q, QN, D, CE, RB, SB, CP);

    input    D, CE, RB, SB, CP;
    output   Q, QN;

    reg NOTIFY_REG;

       U_FD_N_CE_RB_SB_X_NO
                inst1 (Q_int, D, CP, RB, SB, CE, NOTIFY_REG);

       buf
            inst2 (Q, Q_int);

       not
            inst3 (QN, Q_int);


    // Additional Logic for Timing Checks

       and   AN1   (ENABLE, RB, SB, CE);
       and   AN2   (EN1, RB, SB);
       and   AN3   (EN2, SB, CE);
       and   AN4   (EN3, RB, CE);

    specify

    // Path Delays

          if (RB && SB)
           (negedge CP =>  (Q +: D))  = (1.0, 1.0);
          if (RB && SB)
           (negedge CP =>  (QN -: D))  = (1.0, 1.0);

           (negedge SB => (Q +: 1'b1)) = (1.0, 1.0);
           (negedge RB => (Q +: 1'b0)) = (1.0, 1.0);

           (negedge SB => (QN +: 1'b0)) = (1.0, 1.0);
           (negedge RB => (QN +: 1'b1)) = (1.0, 1.0);

    // Timing Checks

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$CE  = 0.0 ,
        t_HOLD$CE  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(posedge CE, negedge CP &&& EN1, t_SETUP$CE, NOTIFY_REG);
    $hold(negedge CP, negedge CE &&& EN1, t_HOLD$CE, NOTIFY_REG);

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG);
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG);

    $recovery(posedge SB, negedge CP &&& EN3, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, negedge CP &&& EN2, t_RELEASE$RB$CP, NOTIFY_REG);

   endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP FLOP WITH ACTIVE HIGH ENABLE
                 AND ACTIVE HIGH ASYNCHRONOUS SET.
                 This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     :
              -------------------------------
               D    CE    CP     S   Q    QN
              -------------------------------
                           _
               L     H      \_    L    L    H
                           _
               H     H      \_    L    H    L
                             _
               X     H     _/     L    Q    QN

               X     L      X     L    Q    QN

               X     X      X     H    H    L
              -------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.5c, Veritime 1.1b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_CE_S_NO (Q, QN, D, CE, CP, S);

    input    D, CE, CP, S;
    output   Q, QN;

    reg NOTIFY_REG;

       U_FD_N_CE_S_NO
            inst1 (Q_int, D, CP, S, CE, NOTIFY_REG);

       buf
            inst2 (Q, Q_int);

       not
            inst3 (QN, Q_int);

       // Additional Logic for Timing Checks

       not  N1    (S_, S);
       and  AN1   (ENABLE, CE, S_);

    specify

    // Specify Path Delays

          if (!S)
           (negedge CP =>  (Q +: D))  = (1.0, 1.0);
          if (!S)
           (negedge CP =>  (QN -: D))  = (1.0, 1.0);

          if (S)
           (posedge S => (Q +: 1'b1)) = (1.0, 1.0);
          if (S)
           (posedge S => (QN +: 1'b0)) = (1.0, 1.0);


    // Timing checks

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$CE  = 0.0 ,
        t_HOLD$CE  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ;



    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(posedge CE, negedge CP &&& S_, t_SETUP$CE, NOTIFY_REG);
    $hold(negedge CP, negedge CE &&& S_, t_HOLD$CE, NOTIFY_REG);

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG);

    $recovery(negedge S, negedge CP &&& CE, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              -----------------
               D    CP      Q  
              -----------------
                    _
               L     \_     L  
                    _
               H     \_     H  
                      _
               X    _/      Q  
              -----------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_NO (Q, QN, D, CP);

    input   D, CP;

    output   Q, QN;



        reg  NOTIFY_REG ;
    
            parameter vlib_flat_module = 1 ;

            U_FD_N_NO 
               inst1 (Q_int, D, CP, NOTIFY_REG); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 
            

    specify


    // Specify path delays

        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;
  
    $setuphold(negedge CP, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
               ASYNCHRONOUS CLEAR 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------- 
               D    CP     RB   Q    QN   
              ------------------------- 
                    _                  
               L     \_     H    L    H   
                    _                 
               H     \_     H    H    L   
                      _                  
               X    _/      H    Q    QN  
                                         
               X     X      L    L    H   
              ------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_RB_NO (Q, QN, D, CP, RB);

    input   D, CP, RB;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
            
            U_FD_N_RB_NO inst1
                  (Q_int, D, CP, RB, NOTIFY_REG); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (RB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 


    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(negedge CP &&& RB, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
   
    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, negedge CP &&& D, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                    _                         
               L     \_    H    H      L    H   
                    _                         
               H     \_    H    H      H    L   
                      _                          
               X    _/     H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      L    L   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_RB_SB (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_N_RB_SB
                    (Q, D, CP, RB, SB);
                U_FD_N_RB_SB_QN
                    (QN, D, CP, RB, SB);
                and
                    (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 




    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB); 

    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                    _                         
               L     \_    H    H      L    H   
                    _                         
               H     \_    H    H      H    L   
                      _                          
               X    _/     H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      L    L   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
              DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_RB_SB_NO (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_N_RB_SB_NO
                    (Q, D, CP, RB, SB, NOTIFY_REG);
                U_FD_N_RB_SB_NO_QN
                    (QN, D, CP, RB, SB, NOTIFY_REG);
                and
                    (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    
    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR . ILLEGAL OUPUT WHEN BOTH
              SET AND CLEAR ARE LOW .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                    _                         
               L     \_    H    H      L    H   
                    _                         
               H     \_    H    H      H    L   
                      _                          
               X    _/     H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      X    X   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_RB_SB_X (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_N_RB_SB_X
                  inst1  (Q_int, D, CP, RB, SB);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            and
               inst4 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    
    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB); 


    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR . ILLEGAL OUPUT WHEN BOTH
              SET AND CLEAR ARE LOW .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                    _                         
               L     \_    H    H      L    H   
                    _                         
               H     \_    H    H      H    L   
                      _                          
               X    _/     H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      X    X   
                                                
              --------------------------------  


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_RB_SB_X_NO (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
            U_FD_N_RB_SB_X_NO
               inst1 (Q_int, D, CP, RB, SB, NOTIFY_REG);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            and
               inst4 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    
    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
               ASYNCHRONOUS CLEAR 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------- 
               D    CP      R   Q    QN   
              ------------------------- 
                    _                  
               L     \_     L    L    H   
                    _                 
               H     \_     L    H    L   
                      _                  
               X    _/      L    Q    QN  
                                         
               X     X      H    L    H   
              ------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_R_NO (Q, QN, D, CP, R);

    input   D, CP, R;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
            
            U_FD_N_R_NO inst1
                  (Q_int, D, CP, R, NOTIFY_REG); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (!R)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (R)
        (negedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (R)
        (negedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 


    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    $setuphold(negedge CP &&& !R, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
   
    $width(posedge CP &&& !R, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& !R, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, negedge CP &&& D, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    R    S      Q    QN   
              --------------------------------  
                    _                         
               L     \_    L    L      L    H   
                    _                         
               H     \_    L    L      H    L   
                      _                           
               X    _/     L    L      Q   QN   
                                                
               X     X     H    L      L    H   
                                                
               X     X     L    H      H    L   

               X     X     H    H      L    L   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_R_S (Q, QN, D, CP, R, S);

    input   D, CP, R, S;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_N_R_S
                    (Q, D, CP, R, S);
                U_FD_N_R_S_QN
                    (QN, D, CP, R, S);
                nor
                    NR1  (ENABLE, R, S);


    specify


    // Specify path delays

    if (!R && !S)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    
    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(posedge S, t_PW_H$S);
    $width(posedge R, t_PW_H$R);

    $recovery(negedge S, negedge CP &&& ~R, t_RELEASE$S$CP);
    $recovery(negedge R, negedge CP &&& ~S, t_RELEASE$R$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    R    S      Q    QN   
              --------------------------------  
                    _                         
               L     \_    L    L      L    H   
                    _                         
               H     \_    L    L      H    L   
                      _                           
               X    _/     L    L      Q   QN   
                                                
               X     X     H    L      L    H   
                                                
               X     X     L    H      H    L   

               X     X     H    H      L    L   
                                                
              --------------------------------  


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_R_S_NO (Q, QN, D, CP, R, S);

    input   D, CP, R, S;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_N_R_S_NO
                    (Q, D, CP, R, S, NOTIFY_REG);
                U_FD_N_R_S_NO_QN
                    (QN, D, CP, R, S, NOTIFY_REG);
                nor
                    NR1  (ENABLE, R, S);


    specify


    // Specify path delays

    if (!R && !S)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    
    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge S, negedge CP &&& ~R, t_RELEASE$S$CP, NOTIFY_REG);
    $recovery(negedge R, negedge CP &&& ~S, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .ILLEGAL OUTPUT OCCURS WHEN
              BOTH SET AND CLEAR ARE ACTIVE .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    R    S      Q    QN   
              --------------------------------  
                    _                         
               L     \_     L    L      L    H   
                    _                         
               H     \_     L    L      H    L   
                      _                         
               X    _/      L    L      Q   QN   
                                                
               X     X      H    L      L    H   
                                                
               X     X      L    H      H    L   

               X     X      H    H      X    X   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_R_S_X (Q, QN, D, CP, R, S);

    input   D, CP, R, S;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_N_R_S_X
                    (Q_int, D, CP, R, S);
               buf
                  inst2 (Q, Q_int);

               not 
                  inst3 (QN, Q_int); 


               nor
                  NR1  (ENABLE, R, S);


    specify


    // Specify path delays

    if (!R && !S)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);

        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    
    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(posedge S, t_PW_H$S);
    $width(posedge R, t_PW_H$R);

    $recovery(negedge S, negedge CP &&& ~R, t_RELEASE$S$CP);
    $recovery(negedge R, negedge CP &&& ~S, t_RELEASE$R$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .ILLEGAL OUTPUT OCCURS WHEN
              BOTH SET AND CLEAR ARE ACTIVE .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    R    S      Q    QN   
              --------------------------------  
                    _                         
               L     \_     L    L      L    H   
                    _                         
               H     \_     L    L      H    L   
                      _                         
               X    _/      L    L      Q   QN   
                                                
               X     X      H    L      L    H   
                                                
               X     X      L    H      H    L   

               X     X      H    H      X    X   
                                                
              --------------------------------  


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_R_S_X_NO (Q, QN, D, CP, R, S);

    input   D, CP, R, S;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_N_R_S_X_NO
                    (Q_int, D, CP, R, S, NOTIFY_REG);

                buf
                   inst2 (Q, Q_int);

                not 
                    inst3 (QN, Q_int); 

                nor
                    NR1  (ENABLE, R, S);


    specify


    // Specify path delays

    if (!R && !S)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);

        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    
    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 


    $recovery(negedge S, negedge CP &&& ~R, t_RELEASE$S$CP, NOTIFY_REG);
    $recovery(negedge R, negedge CP &&& ~S, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
               ASYNCHRONOUS SET 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------- 
               D    CP     SB   Q    QN   
              ------------------------- 
                    _                 
               L     \_    H    L    H   
                    _                  
               H     \_    H    H    L   
                      _                  
               X    _/     H    Q    QN  
                                         
               X     X     L    H    L   
              ------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SB_NO (Q, QN, D, CP, SB);

    input   D, CP, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
            
            U_FD_N_SB_NO inst1
                  (Q_int, D, CP, SB, NOTIFY_REG); 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (SB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (SB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;



    $setuphold(negedge CP &&& SB, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
   
    $width(posedge CP &&& SB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& SB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 

    $recovery(posedge SB, negedge CP &&& ~D, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                    _                         
               L     \_    H    H      L    H   
                    _                         
               H     \_    H    H      H    L   
                      _                         
               X    _/     H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      H    H   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SB_RB (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_N_SB_RB
                    (Q, D, CP, RB, SB);
                U_FD_N_SB_RB_QN
                    (QN, D, CP, RB, SB);
                and
                    (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                    _                         
               L     \_    H    H      L    H   
                    _                         
               H     \_    H    H      H    L   
                      _                         
               X    _/     H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      H    H   
                                                
              --------------------------------  


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SB_RB_NO (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_N_SB_RB_NO
                    (Q, D, CP, RB, SB, NOTIFY_REG);
                U_FD_N_SB_RB_NO_QN
                    (QN, D, CP, RB, SB, NOTIFY_REG);
                and
                    (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    
    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH SCAN INPUTS 
TRUTHTABLE     : 
              -------------------------------
               D    CP     TI    TE   Q   QN  
              -------------------------------
                    _                      
               L     \_    X     L    L    H  
                    _                      
               H     \_    X     L    H    L  
                      _                      
               X    _/     X     X    Q    QN  
                    _                       
               X     \_    L     H    L    H  
                    _                       
               X     \_    H     H    H    L  
              -------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SD (Q, QN, D, CP, TI, TE);

    input   D, CP, TI, TE;

    output   Q, QN;


  
       parameter vlib_flat_module = 1 ;

       U_FD_N_SD    inst1 (Q_int, D, CP, TI, TE); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (!TE)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(negedge CP &&& (~TE), D, t_SETUP$D, t_HOLD$D);
    $setuphold(negedge CP &&& TE, TI, t_SETUP$TI, t_HOLD$TI);

    $width(posedge CP, t_PW_H$CP);
    $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH SCAN INPUTS 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              -------------------------------
               D    CP     TI    TE   Q   QN  
              -------------------------------
                    _                      
               L     \_    X     L    L    H  
                    _                      
               H     \_    X     L    H    L  
                      _                      
               X    _/     X     X    Q    QN  
                    _                       
               X     \_    L     H    L    H  
                    _                       
               X     \_    H     H    H    L  
              -------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SD_NO (Q, QN, D, CP, TI, TE);

    input   D, CP, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;
  
       parameter vlib_flat_module = 1 ;

       U_FD_N_SD_NO    inst1 (Q_int, D, CP, TI, TE, NOTIFY_REG);
 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (!TE)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(negedge CP &&& (~TE), D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(negedge CP &&& TE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS RESET WITH  SCAN INPUTS 
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     TI    TE  RB   Q    QN   
              ------------------------------------ 
                    _                             
               L     \_     X     L   H    L     H   
                    _                             
               H     \_     X     L   H    H     L   
                       _                               
               X     _/     X     X   H    Q    QN    
                                                    
               X     X      X     X   L    L     H   
                    _                              
               X     \_     L     H   H    L     H   
                    _                              
               X     \_     H     H   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SD_RB_NO (Q, QN, D, CP, RB, TI, TE);

    input   D, CP, RB, TI, TE;

    output   Q, QN;

         reg  NOTIFY_REG;
     
       parameter vlib_flat_module = 1;         

       U_FD_N_SD_RB_NO inst1
                (Q_int, D, CP, TI, TE, RB, NOTIFY_REG); 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            not                        // additional logic
                (TEB, TE);             // for timing checks
            and
                (D_ENABLE, TEB, RB),
                (TI_ENABLE, TE, RB);


    specify


    // Specify path delays

    if (!TE && RB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && RB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && RB)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && RB)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(negedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(negedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);
  
    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, negedge CP, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND SET,  AND WITH  SCAN INPUTS 
TRUTHTABLE     : 
              ------------------------------------------ 
               D    CP     TI    TE  RB   SB    Q    QN   
              ------------------------------------------ 
                    _                                   
               L     \_    X     L   H    H     L     H   
                    _                                   
               H     \_    X     L   H    H     H     L   
                      _                                    
               X    _/     X     X   H    H     Q    QN    
                                                          
               X     X     X     X   L    H     L     H   

               X     X     X     X   H    L     H     L   

               X     X     X     X   L    L     L     L   
                    _                                    
               X     \_    L     H   H    H     L     H   
                    _                                    
               X     \_    H     H   H    H     H     L   
              ------------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SD_RB_SB (Q, QN, D, CP, RB, SB, TI, TE);

    input   D, CP, RB, SB, TI, TE;

    output   Q, QN;



       parameter vlib_flat_module = 1;         

       U_FD_N_SD_RB_SB inst1
                 (Q, D, CP, TI, TE, RB, SB); 
       U_FD_N_SD_RB_SB_QN inst2
                 (QN, D, CP, TI, TE, RB, SB); 
   
       and ( ENABLE, RB, SB);              

            not                        // additional logic
                (TEB, TE);             // for timing checks
            and
                (D_ENABLE, TEB, ENABLE),
                (TI_ENABLE, TE, ENABLE);


    specify


    // Specify path delays

    if (!TE && RB && SB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && RB && SB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && RB && SB)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && RB && SB)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(negedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D);
    $setuphold(negedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB); 

    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND SET,  AND WITH  SCAN INPUTS 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------------ 
               D    CP     TI    TE  RB   SB    Q    QN   
              ------------------------------------------ 
                    _                                   
               L     \_    X     L   H    H     L     H   
                    _                                   
               H     \_    X     L   H    H     H     L   
                      _                                    
               X    _/     X     X   H    H     Q    QN    
                                                          
               X     X     X     X   L    H     L     H   

               X     X     X     X   H    L     H     L   

               X     X     X     X   L    L     L     L   
                    _                                    
               X     \_    L     H   H    H     L     H   
                    _                                    
               X     \_    H     H   H    H     H     L   
              ------------------------------------------ 

    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SD_RB_SB_NO (Q, QN, D, CP, RB, SB, TI, TE);

    input   D, CP, RB, SB, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;

       parameter vlib_flat_module = 1;  


       U_MUX_2_1
                 inst1 (D_EFF, D, TI, TE);       

       U_FD_N_RB_SB_NO inst2
                 (Q, D_EFF, CP, RB, SB, NOTIFY_REG); 
       U_FD_N_RB_SB_NO_QN inst3
                 (QN, D_EFF, CP, RB, SB, NOTIFY_REG); 
   
       and ( ENABLE, RB, SB);              

            not                        // additional logic
                (TEB, TE);             // for timing checks
            and
                (D_ENABLE, TEB, ENABLE),
                (TI_ENABLE, TE, ENABLE);


    specify


    // Specify path delays

    if (!TE && RB && SB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && RB && SB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && RB && SB)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && RB && SB)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(negedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(negedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);
    
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH SCAN INPUTS
              AND ACTIVE HIGH ASYNCHRONOUS CLEAR 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     TI    TE  R   Q    QN   
              ------------------------------------ 
                    _                             
               L     \_     X     L   L    L     H   
                    _                             
               H     \_     X     L   L    H     L   
                       _                              
               X     _/     X     X   L    Q    QN    
                                                    
               X     X      X     X   H    L     H   
                    _                              
               X     \_     L     H   L    L     H   
                    _                              
               X     \_     H     H   L    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SD_R_NO (Q, QN, D, CP, R, TI, TE);

    input   D, CP, R, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;

       parameter vlib_flat_module = 1 ;

       U_FD_N_SD_R_NO inst1
                (Q_int, D, CP, TI, TE, R, NOTIFY_REG);
 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            not                        // additional logic
                (TEB, TE);             // for timing checks

            not (RB, R);

            and
                (D_ENABLE, TEB, RB),
                (TI_ENABLE, TE, RB);


    specify


    // Specify path delays

    if (!TE && !R)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && !R)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && !R)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && !R)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);
    if (R)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (R)
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    $setuphold(negedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(negedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);
  
    $width(posedge CP &&& R, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& R, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, negedge CP, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET WITH  SCAN INPUTS 
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     TI    TE  SB   Q    QN   
              ------------------------------------ 
                    _                             
               L     \_     X     L   H    L     H   
                    _                             
               H     \_     X     L   H    H     L   
                       _                               
               X     _/     X     X   H    Q    QN    
                                                    
               X     X      X     X   L    H     L   
                    _                              
               X     \_     L     H   H    L     H   
                    _                              
               X     \_     H     H   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SD_SB_NO (Q, QN, D, CP, SB, TI, TE);

    input   D, CP, SB, TI, TE;

    output   Q, QN;

         reg  NOTIFY_REG;
     
       parameter vlib_flat_module = 1;         

       U_FD_N_SD_SB_NO inst1
                (Q_int, D, CP, TI, TE, SB, NOTIFY_REG); 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            not                        // additional logic
                (TEB, TE);             // for timing checks
            and
                (D_ENABLE, TEB, SB),
                (TI_ENABLE, TE, SB);


    specify


    // Specify path delays

    if (!TE && SB)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && SB)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && SB)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && SB)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;

    $setuphold(negedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(negedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);
  
    $width(posedge CP &&& SB, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& SB, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 

    $recovery(posedge SB, negedge CP, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET WITH  SCAN INPUTS 
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     TI    TE  S   Q    QN   
              ------------------------------------ 
                    _                             
               L     \_     X     L   L    L     H   
                    _                             
               H     \_     X     L   L    H     L   
                       _                               
               X     _/     X     X   L    Q    QN    
                                                    
               X     X      X     X   H    H     L   
                    _                              
               X     \_     L     H   L    L     H   
                    _                              
               X     \_     H     H   L    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_SD_S_NO (Q, QN, D, CP, S, TI, TE);

    input   D, CP, S, TI, TE;

    output   Q, QN;

         reg  NOTIFY_REG;
     
       parameter vlib_flat_module = 1;         

       U_FD_N_SD_S_NO inst1
                (Q_int, D, CP, TI, TE, S); 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            not                        // additional logic for timing checks
                (TEB, TE);

            not (SB, S);             
            and
                (D_ENABLE, TEB, SB),
                (TI_ENABLE, TE, SB);


    specify


    // Specify path delays

    if (!TE && !S)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && !S)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && !S)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && !S)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);
    if (S)
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (S)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ;

    $setuphold(negedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(negedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);
  
    $width(posedge CP &&& S, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& S, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 

    $recovery(posedge S, negedge CP, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
               ASYNCHRONOUS SET 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------- 
               D    CP     S   Q    QN   
              ------------------------- 
                    _                 
               L     \_    L    L    H   
                    _                  
               H     \_    L    H    L   
                      _                  
               X    _/     L   Q    QN  
                                         
               X     X     H    H    L   
              ------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_S_NO (Q, QN, D, CP, S);

    input   D, CP, S;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
            
            U_FD_N_S_NO inst1
                  (Q_int, D, CP, S, NOTIFY_REG); 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (!S)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!S)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (S)
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (S)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ;



    $setuphold(negedge CP &&& !S, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
   
    $width(posedge CP &&& !S, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& !S, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 

    $recovery(negedge S, negedge CP &&& ~D, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    S    R     Q    QN   
              --------------------------------  
                    _                         
               L     \_    L    L      L    H   
                    _                         
               H     \_    L    L      H    L   
                      _                          
               X    _/     L    L      Q   QN   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    H      H    H   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_S_R (Q, QN, D, CP, S, R);

    input   D, CP, S, R;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_N_S_R
                    (Q, D, CP, R, S);
                U_FD_N_S_R_QN
                    (QN, D, CP, R, S);

                nor
                    (ENABLE, S, R);


    specify


    // Specify path delays

    if (!R && !S)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    
    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(posedge S, t_PW_H$S);
    $width(posedge R, t_PW_H$R);

    $recovery(negedge R, negedge CP &&& ~S, t_RELEASE$R$CP);
    $recovery(negedge S, negedge CP &&& ~R, t_RELEASE$S$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .                       
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    S    R     Q    QN   
              --------------------------------  
                    _                         
               L     \_    L    L      L    H   
                    _                         
               H     \_    L    L      H    L   
                      _                          
               X    _/     L    L      Q   QN   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    H      H    H   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_N_S_R_NO (Q, QN, D, CP, S, R);

    input   D, CP, S, R;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_N_S_R_NO
                    (Q, D, CP, R, S, NOTIFY_REG);
                U_FD_N_S_R_NO_QN
                    (QN, D, CP, R, S, NOTIFY_REG);

                nor
                    (ENABLE, S, R);


    specify


    // Specify path delays

    if (!R && !S)
        (negedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (negedge CP =>  (QN -: D)) = (1.0, 1.0);
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    
    $setuphold(negedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, negedge CP &&& ~S, t_RELEASE$R$CP, NOTIFY_REG);
    $recovery(negedge S, negedge CP &&& ~R, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP 
TRUTHTABLE     : 
              -----------------
               D    CP      Q  
              -----------------
                      _
               L    _/      L  
                      _
               H    _/      H  
                    _
               X     \_     Q  
              -----------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P (Q, QN, D, CP);

    input   D, CP;

    output   Q, QN;


    
            parameter vlib_flat_module = 1 ;

            U_FD_P 
               inst1 (Q_int, D, CP); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;
  
    $setuphold(posedge CP, D, t_SETUP$D, t_HOLD$D);

    $width(posedge CP, t_PW_H$CP); 
    $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW CLOCK 
                 ENABLE 
TRUTHTABLE     :

            ------------------------
             D    CP   CEB   Q    QN
            ------------------------
                    _
             L    _/    L   L    H
                    _
             H    _/    L   H    L
                  _
             X     \_   L   Q    QN

             X     X    H   Q    QN
 
            ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FD_P_CEB_NO (Q, QN, D, CP, CEB);
    
    input    D, CP, CEB;

    output   Q, QN;
    
       reg NOTIFY_REG;
    
       U_FD_P_CEB_NO inst1 (Q_int, D, CP, CEB, NOTIFY_REG);

       buf           BU1   (Q, Q_int);
       not           NT1   (QN, Q_int);

    
    specify


      // Specify path delays
          
           (posedge CP =>  (Q +: D))  = (1.0, 1.0);  
           (posedge CP =>  (QN -: D))  = (1.0, 1.0);  


      // Timing Checks
      
      specparam
          t_SETUP$D    = 0.0,
          t_HOLD$D     = 0.0,                
          t_SETUP$CEB  = 0.0,              
          t_HOLD$CEB   = 0.0,             
          t_PW_H$CP    = 0.0,            
          t_PW_L$CP    = 0.0;            

           
      $setuphold(posedge CP &&& (~CEB), D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
      $setup(negedge CEB, posedge CP, t_SETUP$CEB, NOTIFY_REG);
      $hold(posedge CP, posedge CEB, t_HOLD$CEB, NOTIFY_REG);
    
      $width(negedge CP &&& (~CEB), t_PW_L$CP, 0, NOTIFY_REG);
      $width(posedge CP &&& (~CEB), t_PW_H$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP FLOP WITH ACTIVE LOW ENABLE
                 AND ACTIVE HIGH ASYNCHRONOUS SET.
                 This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     :
              -------------------------------
               D    CEB    CP     S   Q    QN
              -------------------------------
                             _
               L     L     _/     L    L    H
                             _
               H     L     _/     L    H    L
                           _
               X     L      \_    L    Q    QN

               X     H      X     L    Q    QN

               X     X      X     H    H    L
              -------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.5c, Veritime 1.1b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_CEB_S_NO (Q, QN, D, CEB, CP, S);

    input    D, CEB, CP, S;
    output   Q, QN;

    reg NOTIFY_REG;

       U_FD_P_CEB_S_NO
            inst1 (Q_int, D, CP, S, CEB, NOTIFY_REG);

       buf
            inst2 (Q, Q_int);

       not
            inst3 (QN, Q_int);

       // Additional Logic for Timing Checks

       nor   NR1   (ENABLE, CEB, S);

    specify

    // Specify Path Delays

          if (!S)
           (posedge CP =>  (Q +: D))  = (1.0, 1.0);
          if (!S)
           (posedge CP =>  (QN -: D))  = (1.0, 1.0);

          if (S)
           (posedge S => (Q +: 1'b1)) = (1.0, 1.0);
          if (S)
           (posedge S => (QN +: 1'b0)) = (1.0, 1.0);


    // Timing checks

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$CEB  = 0.0 ,
        t_HOLD$CEB  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ;

    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(negedge CEB, posedge CP &&& (~S), t_SETUP$CEB, NOTIFY_REG);
    $hold(posedge CP, posedge CEB &&& (~S), t_HOLD$CEB, NOTIFY_REG);

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG);

    $recovery(negedge S, posedge CP &&& ~CEB, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH CLOCK 
                 ENABLE 
TRUTHTABLE     :

            ------------------------
             D    CP    CE   Q    QN
            ------------------------
                    _
             L    _/     H   L    H
                    _
             H    _/     H   H    L
                  _
             X     \_    H   Q    QN

             X     X     L   Q    QN
 
            ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FD_P_CE_NO (Q, QN, D, CP, CE);
    
    input    D, CP, CE;

    output   Q, QN;
    
       reg NOTIFY_REG;
    
       U_FD_P_CE_NO inst1 (Q_int, D, CP, CE, NOTIFY_REG);

       buf           BU1   (Q, Q_int);
       not           NT1   (QN, Q_int);

    
    specify


      // Specify path delays
          
           (posedge CP =>  (Q +: D))  = (1.0, 1.0);  
           (posedge CP =>  (QN -: D))  = (1.0, 1.0);  


      // Timing Checks
      
      specparam
          t_SETUP$D    = 0.0,
          t_HOLD$D     = 0.0,                
          t_SETUP$CE  = 0.0,              
          t_HOLD$CE   = 0.0,             
          t_PW_H$CP    = 0.0,            
          t_PW_L$CP    = 0.0;            

           
      $setuphold(posedge CP &&& CE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
      $setup(posedge CE, posedge CP, t_SETUP$CE, NOTIFY_REG);
      $hold(posedge CP, negedge CE, t_HOLD$CE, NOTIFY_REG);
    
      $width(negedge CP &&& CE, t_PW_L$CP, 0, NOTIFY_REG);
      $width(posedge CP &&& CE, t_PW_H$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH CLOCK 
                 ENABLE AND ACTIVE LOW ASYNCHRONOUS RESET
TRUTHTABLE     :

            ----------------------------
             D    CP    RB  CE   Q    QN
            ----------------------------
                    _
             L    _/     H   H   L    H
                    _
             H    _/     H   H   H    L
                  _
             X     \_    H   H   Q    QN

             X     X     H   L   Q    QN

             X     X     L   X   L    H  
 
            ----------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FD_P_CE_RB_NO(Q, QN, D, CP, CE, RB);
    
    input    D, CP, CE, RB;

    output   Q, QN;
    
       reg NOTIFY_REG;
    
       U_FD_P_CE_RB_NO inst1 (Q_int, D, CP, RB, CE, NOTIFY_REG);

       buf             BU1   (Q, Q_int);
       not             NT1   (QN, Q_int);

                
       // Additional Logic for Timing Checks
       
       and             AN1  (ENABLE, CE, RB);
    

    specify


      // Path Delays
          
          if (RB)
          (posedge CP =>  (Q +: D))  = (1.0, 1.0);  
          if (RB)
          (posedge CP =>  (QN -: D))  = (1.0, 1.0);  

          if (!RB)
          (negedge RB => (Q +: 1'b0)) = (1.0, 1.0);
          if (!RB)
          (negedge RB => (QN +: 1'b1)) = (1.0, 1.0);          


      // Timing Checks
      
      specparam
          t_SETUP$D    = 0.0,
          t_HOLD$D     = 0.0,                
          t_SETUP$CE   = 0.0,              
          t_HOLD$CE    = 0.0,             
          t_PW_H$CP    = 0.0,            
          t_PW_L$CP    = 0.0,          
          t_PW_L$RB    = 0.0,
          t_RELEASE$RB$CP = 0.0;

      $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
      $setup(posedge CE, posedge CP &&& RB, t_SETUP$CE, NOTIFY_REG);
      $hold(posedge CP, negedge CE &&& RB, t_HOLD$CE, NOTIFY_REG);

      $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
      $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
      $width(negedge RB,t_PW_L$RB, 0, NOTIFY_REG);

      $recovery(posedge RB, posedge CP &&& CE, t_RELEASE$RB$CP , NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP FLOP WITH ACTIVE HIGH ENABLE
                 AND ACTIVE LOW ASYNCHRONOUS SET AND RESET.
                 This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     :
              ------------------------------------
               D    CE    CP     SB   RB   Q    QN
              ------------------------------------
                             _
               L     H     _/     H   H    L    H
                             _
               H     H     _/     H   H    H    L
                           _
               X     H      \_    H   H    Q    QN

               X     L      X     H   H    Q    QN

               X     X      X     L   H    H    L

               X     X      X     H   L    L    H

               X     X      X     L   L    X    X
              ------------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.5c, Veritime
 1.1b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_CE_RB_SB_X_NO (Q, QN, D, CE, RB, SB, CP);

    input    D, CE, RB, SB, CP;
    output   Q, QN;

    reg NOTIFY_REG;

       U_FD_P_CE_RB_SB_X_NO
                inst1 (Q_int, D, CP, RB, SB, CE, NOTIFY_REG);

       buf
            inst2 (Q, Q_int);

       not
            inst3 (QN, Q_int);


    // Additional Logic for Timing Checks

       and   AN1   (ENABLE, RB, SB, CE);
       and   AN2   (EN1, RB, SB);
       and   AN3   (EN2, SB, CE);
       and   AN4   (EN3, RB, CE);

    specify

    // Path Delays

          if (RB && SB)
           (posedge CP =>  (Q +: D))  = (1.0, 1.0);

          if (RB && SB)
           (posedge CP =>  (QN -: D))  = (1.0, 1.0);

           (negedge SB => (Q +: 1'b1)) = (1.0, 1.0);
           (negedge RB => (Q +: 1'b0)) = (1.0, 1.0);

           (negedge SB => (QN +: 1'b0)) = (1.0, 1.0);
           (negedge RB => (QN +: 1'b1)) = (1.0, 1.0);

    // Timing Checks

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$CE  = 0.0 ,
        t_HOLD$CE  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(posedge CE, posedge CP &&& EN1, t_SETUP$CE, NOTIFY_REG);
    $hold(posedge CP, negedge CE &&& EN1, t_HOLD$CE, NOTIFY_REG);

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG);
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG);

    $recovery(posedge SB, posedge CP &&& EN3, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, posedge CP &&& EN2, t_RELEASE$RB$CP, NOTIFY_REG);

   endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP FLOP WITH ACTIVE HIGH ENABLE
                 AND ACTIVE HIGH ASYNCHRONOUS SET.
                 This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     :
              -------------------------------
               D    CE    CP     S   Q    QN
              -------------------------------
                             _
               L     H     _/     L    L    H
                             _
               H     H     _/     L    H    L
                           _
               X     H      \_    L    Q    QN

               X     L      X     L    Q    QN

               X     X      X     H    H    L
              -------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.5c, Veritime 1.1b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_CE_S_NO (Q, QN, D, CE, CP, S);

    input    D, CE, CP, S;
    output   Q, QN;

    reg NOTIFY_REG;

       U_FD_P_CE_S_NO
            inst1 (Q_int, D, CP, S, CE, NOTIFY_REG);

       buf
            inst2 (Q, Q_int);

       not
            inst3 (QN, Q_int);

       // Additional Logic for Timing Checks

       not  N1    (S_, S);
       and  AN1   (ENABLE, CE, S_);

    specify

    // Specify Path Delays

          if (!S)
           (posedge CP =>  (Q +: D))  = (1.0:1.0:1.0, 1.0:1.0:1.0);
          if (!S)
           (posedge CP =>  (QN -: D))  = (1.0:1.0:1.0, 1.0:1.0:1.0);

          if (S)
           (posedge S => (Q +: 1'b1)) = (1.0:1.0:1.0, 1.0:1.0:1.0);
          if (S)
           (posedge S => (QN +: 1'b0)) = (1.0:1.0:1.0, 1.0:1.0:1.0);


    // Timing checks

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$CE  = 0.0 ,
        t_HOLD$CE  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ;



    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(posedge CE, posedge CP &&& S_, t_SETUP$CE, NOTIFY_REG);
    $hold(posedge CP, negedge CE &&& S_, t_HOLD$CE, NOTIFY_REG);

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG);

    $recovery(negedge S, posedge CP &&& CE, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              -----------------
               D    CP      Q  
              -----------------
                      _
               L    _/      L  
                      _
               H    _/      H  
                    _
               X     \_     Q  
              -----------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_NO (Q, QN, D, CP);

    input   D, CP;

    output   Q, QN;



        reg  NOTIFY_REG ;
    
            parameter vlib_flat_module = 1 ;

            U_FD_P_NO 
               inst1 (Q_int, D, CP, NOTIFY_REG); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;
  
    $setuphold(posedge CP, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH PARALLEL LOAD. 
TRUTHTABLE     : 
              -------------------------------
               D    CP     PD   PLD   Q   QN  
              -------------------------------
                      _                      
               L    _/     X     H    L    H  
                      _                      
               H    _/     X     H    H    L  
                    _                        
               X     \_    X     H    Q    QN  
                                             
               X     X     L     L    L    H  
                                             
               X     X     H     L    H    L  
              -------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_PLD (Q, QN, D, CP, PD, PLD);

    input   D, CP, PD, PLD;

    output   Q, QN;



           parameter vlib_flat_module = 1 ;

           U_FD_P_PLD inst1 (Q_int, D, CP, PD, PLD);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (PLD)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (PLD)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!PLD)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD)
        (PD -=> QN ) = (1.0, 1.0);
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;

    $setuphold(posedge PLD, PD, t_SETUP$PD, t_HOLD$PD);
    $setuphold(posedge CP &&& PLD, D, t_SETUP$D, t_HOLD$D);
                             
    $width(negedge CP &&& PLD, t_PW_H$CP);
    $width(posedge CP &&& PLD, t_PW_L$CP);
    $width(negedge PLD ,t_PW_L$PLD);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH PARALLEL LOAD. 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              -------------------------------
               D    CP     PD   PLD   Q   QN  
              -------------------------------
                      _                      
               L    _/     X     H    L    H  
                      _                      
               H    _/     X     H    H    L  
                    _                        
               X     \_    X     H    Q    QN  
                                             
               X     X     L     L    L    H  
                                             
               X     X     H     L    H    L  
              -------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_PLD_NO (Q, QN, D, CP, PD, PLD);

    input   D, CP, PD, PLD;

    output   Q, QN;



        reg  NOTIFY_REG ;

           parameter vlib_flat_module = 1 ;

           U_FD_P_PLD_NO inst1 (Q_int, D, CP, PD, PLD, NOTIFY_REG);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (PLD)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (PLD)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!PLD)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD)
        (PD -=> QN ) = (1.0, 1.0);
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);

      // Timing checks 





    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;

    $setuphold(posedge PLD, PD, t_SETUP$PD, t_HOLD$PD, NOTIFY_REG);
    $setuphold(posedge CP &&& PLD, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
                             
    $width(negedge CP &&& PLD, t_PW_H$CP, 0, NOTIFY_REG);
    $width(posedge CP &&& PLD, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge PLD ,t_PW_L$PLD, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
                ASYNCHRONOUS CLEAR 
TRUTHTABLE     : 
              --------------------------
               D    CP     R    Q    QN  
              --------------------------
                      _                 
               L    _/     L    L    H  
                      _                 
               H    _/     L    H    L  
                    _                   
               X     \_    L    Q    QN  
                                        
               X     X     H    L    H  
              --------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_FD_P_R (Q, QN, D, CP, R);

    input   D, CP, R;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;

            U_FD_P_R inst1
                  (Q_int, D, CP, R); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (!R)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (R)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (R)
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$R  = 0.0 ;



    $setuphold(posedge CP &&& ~R, D, t_SETUP$D, t_HOLD$D);
   
    $width(posedge CP &&& ~R, t_PW_H$CP); 
    $width(negedge CP &&& ~R, t_PW_L$CP); 
    $width(posedge R, t_PW_H$R); 

    $recovery(negedge R, posedge CP &&& D, t_RELEASE$R$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
               ASYNCHRONOUS CLEAR 
TRUTHTABLE     : 
              ------------------------- 
               D    CP     RB   Q    QN   
              ------------------------- 
                      _                  
               L    _/     H    L    H   
                      _                  
               H    _/     H    H    L   
                    _                    
               X     \_    H    Q    QN  
                                         
               X     X     L    L    H   
              ------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RB (Q, QN, D, CP, RB);

    input   D, CP, RB;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
            
            U_FD_P_RB inst1
                  (Q_int, D, CP, RB);
 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (RB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(posedge CP &&& RB, D, t_SETUP$D, t_HOLD$D);
   
    $width(posedge CP &&& RB, t_PW_H$CP); 
    $width(negedge CP &&& RB, t_PW_L$CP); 
    $width(negedge RB, t_PW_L$RB); 

    $recovery(posedge RB, posedge CP &&& D, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              SYNCHRONOUS CLEAR
TRUTHTABLE     : 
              ------------------------ 
               D    CP     RBC  Q   Q  
              -------------------- --- 
                      _                
               L    _/     H    L   H  
                      _                
               H    _/     H    H   L  
                    _                  
               X     \_    H    Q   QN 
                      _                
               X    _/     L    L   H  
              ------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RBC (Q, QN, D, CP, RBC);

    input   D, CP, RBC;

    output   Q, QN;


    parameter vlib_flat_module = 1 ;

    U_FD_P_RBC inst1
         (Q_int, D, CP, RBC); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (RBC)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RBC)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!RBC)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RBC)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 




    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$RBC  = 0.0 ,
        t_HOLD$RBC  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge CP &&& RBC , D , t_SETUP$D, t_HOLD$D);
    $setuphold(posedge CP, RBC , t_SETUP$RBC, t_HOLD$RBC);

    $width(posedge CP, t_PW_H$CP); 
    $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              SYNCHRONOUS CLEAR AND LOAD
TRUTHTABLE     : 
              ----------------------------------   
               D    CP    RBC   LD     Q    QN   
              ----------------------------------   
                      _                         
               L    _/     H    H      L    H   
                      _                         
               H    _/     H    H      H    L   
                    _                           
               X     \_    H    H      Q    QN   
                                                
                      _                         
               X    _/     L    X      L    H   
                                                
               X     X     H    L      Q    QN   
              ---------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RBC_LD (Q, QN, D, CP, RBC, LD);

    input   D, CP, RBC, LD;

    output   Q, QN;


    parameter vlib_flat_module = 1 ;

    U_FD_P_RBC_LD inst1
         (Q_int, D, CP, RBC, LD);
 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

    and A1 (ENABLE, RBC, LD);


    specify


    // Specify path delays

    if (RBC)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RBC)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!RBC)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RBC)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 




    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$RBC  = 0.0 ,
        t_HOLD$RBC  = 0.0 ,
        t_SETUP$LD  = 0.0 ,
        t_HOLD$LD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge CP &&& ENABLE , D , t_SETUP$D, t_HOLD$D);
    $setuphold(posedge CP, RBC , t_SETUP$RBC, t_HOLD$RBC);
    $setuphold(posedge CP &&& RBC, LD , t_SETUP$LD, t_HOLD$LD);

    $width(posedge CP, t_PW_H$CP); 
    $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              SYNCHRONOUS CLEAR AND LOAD      
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ----------------------------------   
               D    CP     RBC  LD     Q    QN   
              ----------------------------------   
                      _                         
               L    _/     H    H      L    H   
                      _                         
               H    _/     H    H      H    L   
                    _                           
               X     \_    H    H      Q    QN   
                                                
                      _                         
               X    _/     L    X      L    H   
                                                
               X     X     H    L      Q    QN   
              ---------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RBC_LD_NO (Q, QN, D, CP, RBC, LD);

    input   D, CP, RBC, LD;

    output   Q, QN;



        reg  NOTIFY_REG ;
    parameter vlib_flat_module = 1 ;

    U_FD_P_RBC_LD_NO inst1
         (Q_int, D, CP, RBC, LD, NOTIFY_REG); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    and A1 (ENABLE, RBC, LD);


    specify


    // Specify path delays

    if (RBC)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RBC)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!RBC)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RBC)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 




    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$RBC  = 0.0 ,
        t_HOLD$RBC  = 0.0 ,
        t_SETUP$LD  = 0.0 ,
        t_HOLD$LD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge CP &&& ENABLE , D , t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(posedge CP, RBC , t_SETUP$RBC, t_HOLD$RBC, NOTIFY_REG);
    $setuphold(posedge CP &&& RBC, LD , t_SETUP$LD, t_HOLD$LD, NOTIFY_REG);

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              SYNCHRONOUS CLEAR      
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------ 
               D    CP     RBC  Q   Q  
              -------------------- --- 
                      _                
               L    _/     H    L   H  
                      _                
               H    _/     H    H   L  
                    _                  
               X     \_    H    Q   QN 
                      _                
               X    _/     L    L   H  
              ------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RBC_NO (Q, QN, D, CP, RBC);

    input   D, CP, RBC;

    output   Q, QN;



        reg  NOTIFY_REG ;
    parameter vlib_flat_module = 1 ;

    U_FD_P_RBC_NO inst1
         (Q_int, D, CP, RBC, NOTIFY_REG); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (RBC)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RBC)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!RBC)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RBC)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 




    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$RBC  = 0.0 ,
        t_HOLD$RBC  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge CP &&& RBC , D , t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(posedge CP, RBC , t_SETUP$RBC, t_HOLD$RBC, NOTIFY_REG);

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
               ASYNCHRONOUS CLEAR 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------- 
               D    CP     RB   Q    QN   
              ------------------------- 
                      _                  
               L    _/     H    L    H   
                      _                  
               H    _/     H    H    L   
                    _                    
               X     \_    H    Q    QN  
                                         
               X     X     L    L    H   
              ------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RB_NO (Q, QN, D, CP, RB);

    input   D, CP, RB;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
            
            U_FD_P_RB_NO inst1
                  (Q_int, D, CP, RB, NOTIFY_REG); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (RB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 


    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(posedge CP &&& RB, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
   
    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, posedge CP &&& D, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
               ASYNCHRONOUS CLEAR AND PARALLEL LOAD .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     PD   PLD  RB   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     H   H    L     H   
                      _                             
               H    _/     X     H   H    H     L   
                    _                               
               X     \_    X     H   H    Q    QN    
                                                    
               X     X     X     X   L    L     H   
                                                    
               X     X     L     L   H    L     H   
                                                    
               X     X     H     L   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RB_PLD (Q, QN, D, CP, PD, PLD, RB);

    input   D, CP, PD, PLD, RB;

    output   Q, QN;



           parameter vlib_flat_module = 1 ;

           U_FD_P_RB_PLD inst1 (Q_int, D, CP, PD, PLD, RB);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

           and A1 (ENABLE, PLD, RB);


    specify


    // Specify path delays

    if (PLD && RB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (PLD && RB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!PLD && RB)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD && RB)
        (PD -=> QN ) = (1.0, 1.0);
    if (!PLD)
        (posedge RB =>   (Q +: PD)) = (1.0, 1.0);
    if (!PLD)
        (posedge RB =>   (QN -: PD)) = (1.0, 1.0);
    if (RB)
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
    if (RB)
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 





    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;



    $setuphold(posedge PLD &&& RB, PD, t_SETUP$PD, t_HOLD$PD);
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
                             
    $width(negedge CP &&& ENABLE, t_PW_H$CP);
    $width(posedge CP &&& ENABLE, t_PW_L$CP);
    $width(negedge RB, t_PW_L$RB); 
    $width(negedge PLD &&& RB, t_PW_L$PLD);

    $recovery (posedge RB, posedge CP &&& D, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
               ASYNCHRONOUS CLEAR AND PARALLEL LOAD .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     PD   PLD  RB   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     H   H    L     H   
                      _                             
               H    _/     X     H   H    H     L   
                    _                               
               X     \_    X     H   H    Q    QN    
                                                    
               X     X     X     X   L    L     H   
                                                    
               X     X     L     L   H    L     H   
                                                    
               X     X     H     L   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RB_PLD_NO (Q, QN, D, CP, PD, PLD, RB);

    input   D, CP, PD, PLD, RB;

    output   Q, QN;



        reg  NOTIFY_REG ;

           parameter vlib_flat_module = 1 ;

           U_FD_P_RB_PLD_NO inst1 (Q_int, D, CP, PD, PLD, RB, NOTIFY_REG);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

           and A1 (ENABLE, PLD, RB);


    specify


    // Specify path delays

    if (PLD && RB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (PLD && RB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!PLD && RB)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD && RB)
        (PD -=> QN ) = (1.0, 1.0);
    if (!PLD)
        (posedge RB =>   (Q +: PD)) = (1.0, 1.0);
    if (!PLD)
        (posedge RB =>   (QN -: PD)) = (1.0, 1.0);
    if (RB)
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
    if (RB)
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 





    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;


    $setuphold(posedge PLD &&& RB, PD, t_SETUP$PD, t_HOLD$PD, NOTIFY_REG);
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
                             
    $width(negedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(posedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 
    $width(negedge PLD &&& RB, t_PW_L$PLD, 0, NOTIFY_REG);

    $recovery (posedge RB, posedge CP &&& D, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                      _                         
               L    _/     H    H      L    H   
                      _                         
               H    _/     H    H      H    L   
                    _                           
               X     \_    H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      L    L   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RB_SB (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_P_RB_SB
                    (Q, D, CP, RB, SB);
                U_FD_P_RB_SB_QN
                    (QN, D, CP, RB, SB);
                and
                    (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB); 


    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                      _                         
               L    _/     H    H      L    H   
                      _                         
               H    _/     H    H      H    L   
                    _                           
               X     \_    H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      L    L   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RB_SB_NO (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_P_RB_SB_NO
                    (Q, D, CP, RB, SB, NOTIFY_REG);
                U_FD_P_RB_SB_NO_QN
                    (QN, D, CP, RB, SB, NOTIFY_REG);
                and
                    (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR . ILLEGAL OUPUT WHEN BOTH
              SET AND CLEAR ARE LOW .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                      _                         
               L    _/     H    H      L    H   
                      _                         
               H    _/     H    H      H    L   
                    _                           
               X     \_    H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      X    X   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RB_SB_X (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_P_RB_SB_X
                    (Q_int, D, CP, RB, SB);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

                and
                    (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB); 


    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR . ILLEGAL OUPUT WHEN BOTH
              SET AND CLEAR ARE LOW .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                      _                         
               L    _/     H    H      L    H   
                      _                         
               H    _/     H    H      H    L   
                    _                           
               X     \_    H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      X    X   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_RB_SB_X_NO (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_P_RB_SB_X_NO
                    (Q_int, D, CP, RB, SB, NOTIFY_REG);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int);
 
                and
                    (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
                ASYNCHRONOUS CLEAR 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------
               D    CP     R    Q    QN  
              --------------------------
                      _                 
               L    _/     L    L    H  
                      _                 
               H    _/     L    H    L  
                    _                   
               X     \_    L    Q    QN  
                                        
               X     X     H    L    H  
              --------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_FD_P_R_NO (Q, QN, D, CP, R);

    input   D, CP, R;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;

            U_FD_P_R_NO inst1
                  (Q_int, D, CP, R, NOTIFY_REG); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (!R)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (R)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (R)
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$R  = 0.0 ;



    $setuphold(posedge CP &&& ~R, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
   
    $width(posedge CP &&& ~R, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ~R, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, posedge CP &&& D, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
               ASYNCHRONOUS RESET AND PARALLEL LOAD .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     PD   PLD   R   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     H   L    L     H   
                      _                             
               H    _/     X     H   L    H     L   
                    _                               
               X     \_    X     H   L    Q    QN    
                                                    
               X     X     X     X   H    L     H   
                                                    
               X     X     L     L   L    L     H   
                                                    
               X     X     H     L   L    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_R_PLD (Q, QN, D, CP, PD, PLD, R);

    input   D, CP, PD, PLD, R;

    output   Q, QN;



           parameter vlib_flat_module = 1 ;

           U_FD_P_R_PLD inst1 (Q_int, D, CP, PD, PLD, R);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

           and A1 (ENABLE, PLD, R_);

           not N1 (R_, R);


    specify


    // Specify path delays

    if (PLD && !R)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (PLD && !R)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!PLD && !R)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD && !R)
        (PD -=> QN ) = (1.0, 1.0);
    if (!R)
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
    if (!R)
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);
    if (!PLD)
        (negedge R  =>  (Q +: PD)) = (1.0, 1.0);
    if (!PLD)
        (negedge R  =>  (QN -: PD)) = (1.0, 1.0);
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 





    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$R  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;

    $setuphold(posedge PLD &&& ~R, PD, t_SETUP$PD, t_HOLD$PD);
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
                             
    $width(negedge CP &&& ENABLE, t_PW_H$CP);
    $width(posedge CP &&& ENABLE, t_PW_L$CP);
    $width(posedge R, t_PW_H$R); 
    $width(negedge PLD &&& ~R, t_PW_L$PLD);

    $recovery (negedge R, posedge CP &&& D, t_RELEASE$R$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
               ASYNCHRONOUS RESET AND PARALLEL LOAD .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     PD   PLD   R   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     H   L    L     H   
                      _                             
               H    _/     X     H   L    H     L   
                    _                               
               X     \_    X     H   L    Q    QN    
                                                    
               X     X     X     X   H    L     H   
                                                    
               X     X     L     L   L    L     H   
                                                    
               X     X     H     L   L    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_R_PLD_NO (Q, QN, D, CP, PD, PLD, R);

    input   D, CP, PD, PLD, R;

    output   Q, QN;



        reg  NOTIFY_REG ;

           parameter vlib_flat_module = 1 ;

           U_FD_P_R_PLD_NO inst1 (Q_int, D, CP, PD, PLD, R, NOTIFY_REG);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

           and A1 (ENABLE, PLD, R_);

           not N1 (R_, R);


    specify


    // Specify path delays

    if (PLD && !R)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (PLD && !R)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!PLD && !R)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD && !R)
        (PD -=> QN ) = (1.0, 1.0);
    if (!R)
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
    if (!R)
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);
    if (!PLD)
        (negedge R  =>  (Q +: PD)) = (1.0, 1.0);
    if (!PLD)
        (negedge R  =>  (QN -: PD)) = (1.0, 1.0);
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 





    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$R  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;



    $setuphold(posedge PLD &&& ~R, PD, t_SETUP$PD, t_HOLD$PD, NOTIFY_REG);
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
                             
    $width(negedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(posedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 
    $width(negedge PLD &&& ~R, t_PW_L$PLD, 0, NOTIFY_REG);

    $recovery (negedge R, posedge CP &&& D, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    R    S      Q    QN   
              --------------------------------  
                      _                         
               L    _/     L    L      L    H   
                      _                         
               H    _/     L    L      H    L   
                    _                           
               X     \_    L    L      Q   QN   
                                                
               X     X     H    L      L    H   
                                                
               X     X     L    H      H    L   

               X     X     H    H      L    L   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_R_S (Q, QN, D, CP, R, S);

    input   D, CP, R, S;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_P_R_S
                    (Q, D, CP, R, S);
                U_FD_P_R_S_QN
                    (QN, D, CP, R, S);
                nor
                    NR1  (ENABLE, R, S);


    specify


    // Specify path delays

    if (!R && !S)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(posedge S, t_PW_H$S);
    $width(posedge R, t_PW_H$R);

    $recovery(negedge S, posedge CP &&& ~R, t_RELEASE$S$CP);
    $recovery(negedge R, posedge CP &&& ~S, t_RELEASE$R$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    R    S      Q    QN   
              --------------------------------  
                      _                         
               L    _/     L    L      L    H   
                      _                         
               H    _/     L    L      H    L   
                    _                           
               X     \_    L    L      Q   QN   
                                                
               X     X     H    L      L    H   
                                                
               X     X     L    H      H    L   

               X     X     H    H      L    L   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_R_S_NO (Q, QN, D, CP, R, S);

    input   D, CP, R, S;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_P_R_S_NO
                    (Q, D, CP, R, S, NOTIFY_REG);
                U_FD_P_R_S_NO_QN
                    (QN, D, CP, R, S, NOTIFY_REG);
                nor
                    NR1  (ENABLE, R, S);


    specify


    // Specify path delays

    if (!R && !S)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge S, posedge CP &&& ~R, t_RELEASE$S$CP, NOTIFY_REG);
    $recovery(negedge R, posedge CP &&& ~S, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .ILLEGAL OUTPUT OCCURS WHEN
              BOTH SET AND CLEAR ARE ACTIVE .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    R    S      Q    QN   
              --------------------------------  
                      _                         
               L    _/     L    L      L    H   
                      _                         
               H    _/     L    L      H    L   
                    _                           
               X     \_    L    L      Q   QN   
                                                
               X     X     H    L      L    H   
                                                
               X     X     L    H      H    L   

               X     X     H    H      X    X   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_R_S_X (Q, QN, D, CP, R, S);

    input   D, CP, R, S;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_P_R_S_X
                    (Q_int, D, CP, R, S);
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

                nor
                    NR1  (ENABLE, R, S);


    specify


    // Specify path delays

    if (!R && !S)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);

        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(posedge S, t_PW_H$S);
    $width(posedge R, t_PW_H$R);

    $recovery(negedge S, posedge CP &&& ~R, t_RELEASE$S$CP);
    $recovery(negedge R, posedge CP &&& ~S, t_RELEASE$R$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .ILLEGAL OUTPUT OCCURS WHEN
              BOTH SET AND CLEAR ARE ACTIVE .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    R    S      Q    QN   
              --------------------------------  
                      _                         
               L    _/     L    L      L    H   
                      _                         
               H    _/     L    L      H    L   
                    _                           
               X     \_    L    L      Q   QN   
                                                
               X     X     H    L      L    H   
                                                
               X     X     L    H      H    L   

               X     X     H    H      X    X   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_R_S_X_NO (Q, QN, D, CP, R, S);

    input   D, CP, R, S;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_P_R_S_X_NO
                    (Q_int, D, CP, R, S, NOTIFY_REG);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

                nor
                    NR1  (ENABLE, R, S);


    specify


    // Specify path delays

    if (!R && !S)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);

        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 


    $recovery(negedge S, posedge CP &&& ~R, t_RELEASE$S$CP, NOTIFY_REG);
    $recovery(negedge R, posedge CP &&& ~S, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
               ASYNCHRONOUS SET 
TRUTHTABLE     : 
              ------------------------- 
               D    CP     SB   Q    QN   
              ------------------------- 
                      _                  
               L    _/     H    L    H   
                      _                  
               H    _/     H    H    L   
                    _                    
               X     \_    H    Q    QN  
                                         
               X     X     L    H    L   
              ------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SB (Q, QN, D, CP, SB);

    input   D, CP, SB;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
            
            U_FD_P_SB inst1
                  (Q_int, D, CP, SB); 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;

    $setuphold(posedge CP &&& SB, D, t_SETUP$D, t_HOLD$D);
   
    $width(posedge CP &&& SB, t_PW_H$CP); 
    $width(negedge CP &&& SB, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB); 

    $recovery(posedge SB, posedge CP &&& ~D, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
               ASYNCHRONOUS SET 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------- 
               D    CP     SB   Q    QN   
              ------------------------- 
                      _                  
               L    _/     H    L    H   
                      _                  
               H    _/     H    H    L   
                    _                    
               X     \_    H    Q    QN  
                                         
               X     X     L    H    L   
              ------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SB_NO (Q, QN, D, CP, SB);

    input   D, CP, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
            
            U_FD_P_SB_NO inst1
                  (Q_int, D, CP, SB, NOTIFY_REG); 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;



    $setuphold(posedge CP &&& SB, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
   
    $width(posedge CP &&& SB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& SB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 

    $recovery(posedge SB, posedge CP &&& ~D, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
               ASYNCHRONOUS SET AND PARALLEL LOAD .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     PD   PLD  SB   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     H   H    L     H   
                      _                             
               H    _/     X     H   H    H     L   
                    _                               
               X     \_    X     H   H    Q    QN    
                                                    
               X     X     X     X   L    H     L   
                                                    
               X     X     L     L   H    L     H   
                                                    
               X     X     H     L   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SB_PLD (Q, QN, D, CP, PD, PLD, SB);

    input   D, CP, PD, PLD, SB;

    output   Q, QN;



           parameter vlib_flat_module = 1 ;

           U_FD_P_SB_PLD inst1 (Q_int, D, CP, PD, PLD, SB);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

           and A1 (ENABLE, PLD, SB);


    specify


    // Specify path delays

    if (PLD && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (PLD && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!PLD && SB)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD && SB)
        (PD -=> QN ) = (1.0, 1.0);
    if (SB)
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
    if (SB)
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);
    if (!PLD)
        (posedge SB  =>  (Q +: PD)) = (1.0, 1.0);
    if (!PLD)
        (posedge SB  =>  (QN -: PD)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 





    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;


    $setuphold(posedge PLD &&& SB, PD, t_SETUP$PD, t_HOLD$PD);
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
                             
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge PLD &&& SB, t_PW_L$PLD);

    $recovery (posedge SB, posedge CP &&& ~D, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
               ASYNCHRONOUS SET AND PARALLEL LOAD .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     PD   PLD  SB   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     H   H    L     H   
                      _                             
               H    _/     X     H   H    H     L   
                    _                               
               X     \_    X     H   H    Q    QN    
                                                    
               X     X     X     X   L    H     L   
                                                    
               X     X     L     L   H    L     H   
                                                    
               X     X     H     L   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SB_PLD_NO (Q, QN, D, CP, PD, PLD, SB);

    input   D, CP, PD, PLD, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;

           parameter vlib_flat_module = 1 ;

           U_FD_P_SB_PLD_NO inst1 (Q_int, D, CP, PD, PLD, SB, NOTIFY_REG);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

           and A1 (ENABLE, PLD, SB);


    specify


    // Specify path delays

    if (PLD && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (PLD && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!PLD && SB)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD && SB)
        (PD -=> QN ) = (1.0, 1.0);
    if (SB)
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
    if (SB)
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);
    if (!PLD)
        (posedge SB  =>  (Q +: PD)) = (1.0, 1.0);
    if (!PLD)
        (posedge SB  =>  (QN -: PD)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 





    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;



    $setuphold(posedge PLD &&& SB, PD, t_SETUP$PD, t_HOLD$PD, NOTIFY_REG);
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
                             
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge PLD &&& SB, t_PW_L$PLD, 0, NOTIFY_REG);

    $recovery (posedge SB, posedge CP &&& ~D, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                      _                         
               L    _/     H    H      L    H   
                      _                         
               H    _/     H    H      H    L   
                    _                           
               X     \_    H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      H    H   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SB_RB (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_P_SB_RB
                    (Q, D, CP, RB, SB);
                U_FD_P_SB_RB_QN
                    (QN, D, CP, RB, SB);
                and
                    (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND CLEAR .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    RB   SB     Q    QN   
              --------------------------------  
                      _                         
               L    _/     H    H      L    H   
                      _                         
               H    _/     H    H      H    L   
                    _                           
               X     \_    H    H      Q   QN   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    L      H    H   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SB_RB_NO (Q, QN, D, CP, RB, SB);

    input   D, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_P_SB_RB_NO
                    (Q, D, CP, RB, SB, NOTIFY_REG);
                U_FD_P_SB_RB_NO_QN
                    (QN, D, CP, RB, SB, NOTIFY_REG);
                and
                    (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH SCAN INPUTS 
TRUTHTABLE     : 
              -------------------------------
               D    CP     TI    TE   Q   QN  
              -------------------------------
                      _                      
               L    _/     X     L    L    H  
                      _                      
               H    _/     X     L    H    L  
                    _                        
               X     \_    X     X    Q    QN  
                      _                       
               X    _/     L     H    L    H  
                      _                       
               X    _/     H     H    H    L  
              -------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SD (Q, QN, D, CP, TI, TE);

    input   D, CP, TI, TE;

    output   Q, QN;


  
       parameter vlib_flat_module = 1 ;

       U_FD_P_SD    inst1 (Q_int, D, CP, TI, TE); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 



    specify


    // Specify path delays

    if (!TE)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);

      // Timing checks 



    specparam    
        t_SETUP$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge CP &&& (~TE), D, t_SETUP$D, t_HOLD$D);
    $setuphold(posedge CP &&& TE, TI, t_SETUP$TI, t_HOLD$TI);

    $width(posedge CP, t_PW_H$CP);
    $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH SCAN INPUTS 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              -------------------------------
               D    CP     TI    TE   Q   QN  
              -------------------------------
                      _                      
               L    _/     X     L    L    H  
                      _                      
               H    _/     X     L    H    L  
                    _                        
               X     \_    X     X    Q    QN  
                      _                       
               X    _/     L     H    L    H  
                      _                       
               X    _/     H     H    H    L  
              -------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SD_NO (Q, QN, D, CP, TI, TE);

    input   D, CP, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;
  
       parameter vlib_flat_module = 1 ;

       U_FD_P_SD_NO    inst1 (Q_int, D, CP, TI, TE, NOTIFY_REG); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (!TE)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge CP &&& (~TE), D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(posedge CP &&& TE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH SCAN INPUTS AND
              ACTIVE LOW ASYNCHRONOUS CLEAR 
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     TI    TE  RB   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     L   H    L     H   
                      _                             
               H    _/     X     L   H    H     L   
                    _                               
               X     \_    X     X   H    Q    QN    
                                                    
               X     X     X     X   L    L     H   
                      _                              
               X    _/     L     H   H    L     H   
                      _                              
               X    _/     H     H   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SD_RB (Q, QN, D, CP, RB, TI, TE);

    input   D, CP, RB, TI, TE;

    output   Q, QN;



       parameter vlib_flat_module = 1 ;

       U_FD_P_SD_RB inst1
                (Q_int, D, CP, TI, TE, RB); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int);
 
            not                        // additional logic
                (TEB, TE);             // for timing checks
            and
                (D_ENABLE, TEB, RB),
                (TI_ENABLE, TE, RB);


    specify


    // Specify path delays

    if (!TE && RB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && RB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && RB)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && RB)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);
    if (!RB)  
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    

    $setuphold(posedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D);
    $setuphold(posedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI);
  
    $width(posedge CP &&& RB, t_PW_H$CP);
    $width(negedge CP &&& RB, t_PW_L$CP);
    $width(negedge RB, t_PW_L$RB); 

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH SCAN INPUTS
              AND ACTIVE LOW ASYNCHRONOUS CLEAR 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     TI    TE  RB   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     L   H    L     H   
                      _                             
               H    _/     X     L   H    H     L   
                    _                               
               X     \_    X     X   H    Q    QN    
                                                    
               X     X     X     X   L    L     H   
                      _                              
               X    _/     L     H   H    L     H   
                      _                              
               X    _/     H     H   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SD_RB_NO (Q, QN, D, CP, RB, TI, TE);

    input   D, CP, RB, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;

       parameter vlib_flat_module = 1 ;

       U_FD_P_SD_RB_NO inst1
                (Q_int, D, CP, TI, TE, RB, NOTIFY_REG);
 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            not                        // additional logic
                (TEB, TE);             // for timing checks
            and
                (D_ENABLE, TEB, RB),
                (TI_ENABLE, TE, RB);


    specify


    // Specify path delays

    if (!TE && RB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && RB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && RB)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && RB)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(posedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(posedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);
  
    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND SET,  AND WITH  SCAN INPUTS 
TRUTHTABLE     : 
              ------------------------------------------ 
               D    CP     TI    TE  RB   SB    Q    QN   
              ------------------------------------------ 
                      _                                   
               L    _/     X     L   H    H     L     H   
                      _                                   
               H    _/     X     L   H    H     H     L   
                    _                                     
               X     \_    X     X   H    H     Q    QN    
                                                          
               X     X     X     X   L    H     L     H   

               X     X     X     X   H    L     H     L   

               X     X     X     X   L    L     L     L   
                      _                                    
               X    _/     L     H   H    H     L     H   
                      _                                    
               X    _/     H     H   H    H     H     L   
              ------------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SD_RB_SB (Q, QN, D, CP, RB, SB, TI, TE);

    input   D, CP, RB, SB, TI, TE;

    output   Q, QN;



       parameter vlib_flat_module = 1;         

       U_FD_P_SD_RB_SB inst1
                 (Q, D, CP, TI, TE, RB, SB); 
       U_FD_P_SD_RB_SB_QN inst2
                 (QN, D, CP, TI, TE, RB, SB); 
   
       and ( ENABLE, RB, SB);              

            not                        // additional logic
                (TEB, TE);             // for timing checks
            and
                (D_ENABLE, TEB, ENABLE),
                (TI_ENABLE, TE, ENABLE);


    specify


    // Specify path delays

    if (!TE && RB && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && RB && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && RB && SB)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && RB && SB)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(posedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D);
    $setuphold(posedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB); 

    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND SET,  AND WITH  SCAN INPUTS 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------------ 
               D    CP     TI    TE  RB   SB    Q    QN   
              ------------------------------------------ 
                      _                                   
               L    _/     X     L   H    H     L     H   
                      _                                   
               H    _/     X     L   H    H     H     L   
                    _                                     
               X     \_    X     X   H    H     Q    QN    
                                                          
               X     X     X     X   L    H     L     H   

               X     X     X     X   H    L     H     L   

               X     X     X     X   L    L     L     L   
                      _                                    
               X    _/     L     H   H    H     L     H   
                      _                                    
               X    _/     H     H   H    H     H     L   
              ------------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SD_RB_SB_NO (Q, QN, D, CP, RB, SB, TI, TE);

    input   D, CP, RB, SB, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;

       parameter vlib_flat_module = 1;  

        
       U_MUX_2_1
                inst1 (D_EFF, D, TI, TE);       

       U_FD_P_RB_SB_NO inst2
                 (Q, D_EFF, CP, RB, SB, NOTIFY_REG); 
       U_FD_P_RB_SB_NO_QN inst3
                 (QN, D_EFF, CP, RB, SB, NOTIFY_REG); 
   
       and ( ENABLE, RB, SB);              

            not                        // additional logic
                (TEB, TE);             // for timing checks
            and
                (D_ENABLE, TEB, ENABLE),
                (TI_ENABLE, TE, ENABLE);


    specify


    // Specify path delays

    if (!TE && RB && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && RB && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && RB && SB)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && RB && SB)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(posedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(posedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);
    
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH SCAN INPUTS
              AND ACTIVE HIGH ASYNCHRONOUS CLEAR 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     TI    TE  R   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     L   L    L     H   
                      _                             
               H    _/     X     L   L    H     L   
                    _                               
               X     \_    X     X   L    Q    QN    
                                                    
               X     X     X     X   H    L     H   
                      _                              
               X    _/     L     H   L    L     H   
                      _                              
               X    _/     H     H   L    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SD_R_NO (Q, QN, D, CP, R, TI, TE);

    input   D, CP, R, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;

       parameter vlib_flat_module = 1 ;

       U_FD_P_SD_R_NO inst1
                (Q_int, D, CP, TI, TE, R, NOTIFY_REG);
 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            not                        // additional logic
                (TEB, TE);             // for timing checks

            not (RB, R);

            and
                (D_ENABLE, TEB, RB),
                (TI_ENABLE, TE, RB);


    specify


    // Specify path delays

    if (!TE && !R)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && !R)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && !R)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && !R)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);
    if (R)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (R)
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    $setuphold(posedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(posedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);
  
    $width(posedge CP &&& R, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& R, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, posedge CP, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET WITH  SCAN INPUTS 
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     TI    TE  SB   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     L   H    L     H   
                      _                             
               H    _/     X     L   H    H     L   
                    _                               
               X     \_    X     X   H    Q    QN    
                                                    
               X     X     X     X   L    H     L   
                      _                              
               X    _/     L     H   H    L     H   
                      _                              
               X    _/     H     H   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SD_SB (Q, QN, D, CP, SB, TI, TE);

    input   D, CP, SB, TI, TE;

    output   Q, QN;


     
       parameter vlib_flat_module = 1;         

       U_FD_P_SD_SB inst1
                (Q_int, D, CP, TI, TE, SB); 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            not                        // additional logic
                (TEB, TE);             // for timing checks
            and
                (D_ENABLE, TEB, SB),
                (TI_ENABLE, TE, SB);


    specify


    // Specify path delays

    if (!TE && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && SB)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && SB)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;

    $setuphold(posedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D);
    $setuphold(posedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI);
  
    $width(posedge CP &&& SB, t_PW_H$CP);
    $width(negedge CP &&& SB, t_PW_L$CP);
    $width(negedge SB, t_PW_L$SB); 

    $recovery(posedge SB, posedge CP, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET WITH  SCAN INPUTS 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     TI    TE  SB   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     L   H    L     H   
                      _                             
               H    _/     X     L   H    H     L   
                    _                               
               X     \_    X     X   H    Q    QN    
                                                    
               X     X     X     X   L    H     L   
                      _                              
               X    _/     L     H   H    L     H   
                      _                              
               X    _/     H     H   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SD_SB_NO (Q, QN, D, CP, SB, TI, TE);

    input   D, CP, SB, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;
     
       parameter vlib_flat_module = 1;         

       U_FD_P_SD_SB_NO inst1
                (Q_int, D, CP, TI, TE, SB, NOTIFY_REG); 

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            not                        // additional logic
                (TEB, TE);             // for timing checks
            and
                (D_ENABLE, TEB, SB),
                (TI_ENABLE, TE, SB);


    specify


    // Specify path delays

    if (!TE && SB)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && SB)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && SB)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && SB)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;

    

    $setuphold(posedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(posedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);
  
    $width(posedge CP &&& SB, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& SB, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 

    $recovery(posedge SB, posedge CP, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET WITH  SCAN INPUTS 
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     TI    TE  S   Q    QN   
              ------------------------------------ 
                      _                            
               L    _/     X     L   L    L     H   
                      _                            
               H    _/     X     L   L    H     L   
                       _                               
               X     _/    X     X   L    Q    QN    
                                                    
               X     X     X     X   H    H     L   
                      _                             
               X    _/     L     H   L    L     H   
                      _                             
               X    _/     H     H   L    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_SD_S_NO (Q, QN, D, CP, S, TI, TE);

    input   D, CP, S, TI, TE;

    output   Q, QN;

         reg  NOTIFY_REG;
     
       parameter vlib_flat_module = 1;         

       U_FD_P_SD_S_NO inst1
                (Q_int, D, CP, TI, TE, S); 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

            not                        // additional logic for timing checks
                (TEB, TE);

            not (SB, S);             
            and
                (D_ENABLE, TEB, SB),
                (TI_ENABLE, TE, SB);


    specify


    // Specify path delays

    if (!TE && !S)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!TE && !S)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (TE && !S)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
    if (TE && !S)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);
    if (S)
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (S)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ;

    $setuphold(posedge CP &&& D_ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
    $setuphold(posedge CP &&& TI_ENABLE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);
  
    $width(posedge CP &&& S, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& S, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 

    $recovery(posedge S, posedge CP, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
               ASYNCHRONOUS SET 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------- 
               D    CP     S   Q    QN   
              ------------------------- 
                      _               
               L    _/    L    L    H   
                      _                
               H    _/    L    H    L   
                    _                 
               X     \_   L    Q    QN  
                                         
               X     X    H    H    L   
              ------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_S_NO (Q, QN, D, CP, S);

    input   D, CP, S;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
            
            U_FD_P_S_NO inst1
                  (Q_int, D, CP, S, NOTIFY_REG); 
            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 


    specify


    // Specify path delays

    if (!S)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!S)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (S)
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (S)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ;



    $setuphold(posedge CP &&& !S, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
   
    $width(posedge CP &&& !S, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& !S, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 

    $recovery(negedge S, posedge CP &&& ~D, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
               ASYNCHRONOUS SET AND PARALLEL LOAD ( ACTIVE LOW ) .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     PD   PLD  S   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     H   L    L     H   
                      _                             
               H    _/     X     H   L    H     L   
                    _                               
               X     \_    X     H   L    Q    QN    
                                                    
               X     X     X     X   H    H     L   
                                                    
               X     X     L     L   L    L     H   
                                                    
               X     X     H     L   L    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_S_PLD (Q, QN, D, CP, PD, PLD, S);

    input   D, CP, PD, PLD, S;

    output   Q, QN;



           parameter vlib_flat_module = 1 ;

           U_FD_P_S_PLD inst1 (Q_int, D, CP, PD, PLD, S);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

           and A1 (ENABLE, PLD, S_);

           not N1 (S_, S);


    specify


    // Specify path delays

    if (PLD && !S)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (PLD && !S)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!PLD && !S)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD && !S)
        (PD -=> QN ) = (1.0, 1.0);
    if (!S)
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
    if (!S)
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);
    if (!PLD)
        (negedge S =>  (Q +: PD)) = (1.0, 1.0);
    if (!PLD)
        (negedge S =>  (QN -: PD)) = (1.0, 1.0);
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 





    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;


    $setuphold(posedge PLD &&& ~S, PD, t_SETUP$PD, t_HOLD$PD);
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
                             
    $width(negedge CP &&& ENABLE, t_PW_H$CP);
    $width(posedge CP &&& ENABLE, t_PW_L$CP);
    $width(posedge S, t_PW_H$S); 
    $width(negedge PLD &&& ~S, t_PW_L$PLD);

    $recovery (negedge S, posedge CP &&& ~D, t_RELEASE$S$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
               ASYNCHRONOUS SET AND PARALLEL LOAD ( ACTIVE LOW ).
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------ 
               D    CP     PD   PLD  S   Q    QN   
              ------------------------------------ 
                      _                             
               L    _/     X     H   L    L     H   
                      _                             
               H    _/     X     H   L    H     L   
                    _                               
               X     \_    X     H   L    Q    QN    
                                                    
               X     X     X     X   H    H     L   
                                                    
               X     X     L     L   L    L     H   
                                                    
               X     X     H     L   L    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_S_PLD_NO (Q, QN, D, CP, PD, PLD, S);

    input   D, CP, PD, PLD, S;

    output   Q, QN;



        reg  NOTIFY_REG ;

           parameter vlib_flat_module = 1 ;

           U_FD_P_S_PLD_NO inst1 (Q_int, D, CP, PD, PLD, S, NOTIFY_REG);

            buf
               inst2 (Q, Q_int);

            not 
               inst3 (QN, Q_int); 

           and A1 (ENABLE, PLD, S_);

           not N1 (S_, S);


    specify


    // Specify path delays

    if (PLD && !S)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (PLD && !S)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
    if (!PLD && !S)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD && !S)
        (PD -=> QN ) = (1.0, 1.0);
    if (!S)
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
    if (!S)
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);
    if (!PLD)
        (negedge S =>  (Q +: PD)) = (1.0, 1.0);
    if (!PLD)
        (negedge S =>  (QN -: PD)) = (1.0, 1.0);
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 





    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;



    $setuphold(posedge PLD &&& ~S, PD, t_SETUP$PD, t_HOLD$PD, NOTIFY_REG);
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
                             
    $width(negedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(posedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(negedge PLD &&& ~S, t_PW_L$PLD, 0, NOTIFY_REG);

    $recovery (negedge S, posedge CP &&& ~D, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    S    R     Q    QN   
              --------------------------------  
                      _                         
               L    _/     L    L      L    H   
                      _                         
               H    _/     L    L      H    L   
                    _                           
               X     \_    L    L      Q   QN   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    H      H    H   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_S_R (Q, QN, D, CP, S, R);

    input   D, CP, S, R;

    output   Q, QN;



                parameter vlib_flat_module = 1 ;
 
                U_FD_P_S_R
                    (Q, D, CP, R, S);
                U_FD_P_S_R_QN
                    (QN, D, CP, R, S);

                nor
                    (ENABLE, S, R);


    specify


    // Specify path delays

    if (!R && !S)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(posedge S, t_PW_H$S);
    $width(posedge R, t_PW_H$R);

    $recovery(negedge R, posedge CP &&& ~S, t_RELEASE$R$CP);
    $recovery(negedge S, posedge CP &&& ~R, t_RELEASE$S$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED D FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND CLEAR .                       
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------------  
               D    CLK    S    R     Q    QN   
              --------------------------------  
                      _                         
               L    _/     L    L      L    H   
                      _                         
               H    _/     L    L      H    L   
                    _                           
               X     \_    L    L      Q   QN   
                                                
               X     X     H    L      H    L   
                                                
               X     X     L    H      L    H   
                                                
               X     X     H    H      H    H   
                                                
              --------------------------------  

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FD_P_S_R_NO (Q, QN, D, CP, S, R);

    input   D, CP, S, R;

    output   Q, QN;



        reg  NOTIFY_REG ;

                parameter vlib_flat_module = 1 ;
 
                U_FD_P_S_R_NO
                    (Q, D, CP, R, S, NOTIFY_REG);
                U_FD_P_S_R_NO_QN
                    (QN, D, CP, R, S, NOTIFY_REG);

                nor
                    (ENABLE, S, R);


    specify


    // Specify path delays

    if (!R && !S)
        (posedge CP =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (posedge CP =>  (QN -: D)) = (1.0, 1.0);
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    
    $setuphold(posedge CP &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, posedge CP &&& ~S, t_RELEASE$R$CP, NOTIFY_REG);
    $recovery(negedge S, posedge CP &&& ~R, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK_ FLIP FLOP  
TRUTHTABLE     :

            ----------------------
             J   K  CP     Q    QN
            ----------------------
                    _
             L   H   \_    Q    QN
                    _
             L   L   \_    L    H
                    _
             H   H   \_    H    L
                    _ 
             H   L   \_    QN   Q
                      _
             X   X  _/     Q    QN
 
            ----------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FJKB_N_NO (Q, QN, J, K, CP);

    input   J, K, CP;

    output  Q, QN;

        reg  NOTIFY_REG ;

        U_FJKB_N_NO inst1 (Q_int, J, K, CP, NOTIFY_REG);

        not         NT1   (QN, Q_int);
        buf         BU1   (Q, Q_int);

    specify

    // Specify path delays

        if (!(J && !K))
        (negedge CP => (Q +: J)) = (1.0, 1.0);
        if (J && !K)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && !K))
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && !K)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);

    // Timing checks 

    specparam
        t_SETUP$J  = 0,
        t_HOLD$J   = 0,
        t_SETUP$K  = 0,
        t_HOLD$K   = 0,
        t_PW_H$CP  = 0,
        t_PW_L$CP  = 0;

    $setuphold(negedge CP, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(negedge CP, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);


    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*
FUNCTION       : NEGATIVE EDGE TRIGGERED JK_ FLIP FLOP, WITH ACTIVE LOW
                 ASYNCHRONOUS CLEAR.
TRUTHTABLE     :
           ----------------------------
            J   K   CP   RB   Q    QN
           ----------------------------
                   _
            L   H   \_    H   Q    QN
                   _
            L   L   \_    H   L     H
                   _
            H   H   \_    H   H     L
                   _
            H   L   \_    H   QN    Q
                     _
            X   X  _/     H   Q    QN

            X   X   X     L   L     H

           -----------------------------
 
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .
*/

`celldefine
module CDS_GEN_FJKB_N_RB_NO (Q, QN, J, K, CP, RB);

    input   J, K, CP, RB;

    output   Q, QN;


        reg  NOTIFY_REG;
        
        U_FJKB_N_RB_NO inst1 (Q_int, J, K, CP, RB, NOTIFY_REG);   

        buf            BU1   (Q, Q_int);
        not            NT1   (QN, Q_int);

    specify

    // Specify path delays

        if (RB && !(J && !K))
        (negedge CP =>  (Q +: J)) = (1.0, 1.0);
        if (RB && J && !K)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);

        if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);

        if (RB && !(J && !K))
        (negedge CP =>  (QN +: K)) = (1.0, 1.0);
        if (RB && J && !K)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

        if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$J  = 0.0,
        t_HOLD$J   = 0.0,
        t_SETUP$K  = 0.0,
        t_HOLD$K   = 0.0,
        t_PW_H$CP  = 0.0,
        t_PW_L$CP  = 0.0,
        t_RELEASE$RB$CP = 0.0,
        t_PW_L$RB  = 0.0;

    $setuphold(negedge CP &&& RB, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(negedge CP &&& RB, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG);

    $recovery(posedge RB, negedge CP &&& J, t_RELEASE$RB$CP, NOTIFY_REG);
 
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*
FUNCTION       : NEGATIVE EDGE TRIGGERED JK_ FLIP FLOP, WITH ACTIVE LOW
                 ASYNCHRONOUS CLEAR AND SBSET . ILLEGAL OUTPUT OCCURS WHEN BOTH
                 SBSET AND CLEAR ARE ACTIVE
TRUTHTABLE     :
           ------------------------------------
            J   K   CP   RB   SB    Q    QN
           ------------------------------------
                   _
            L   L   \_    H    H     Q    QN
                   _
            L   H   \_    H    H     L     H
                   _
            H   L   \_    H    H     H     L
                   _
            H   H   \_    H    H     QN    Q
                     _
            X   X  _/     H    H     Q    QN

            X   X   X     L    H     L     H

            X   X   X     H    L     H     L

            X   X   X     L    L     X     X
           ------------------------------------
 
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .
*/

`celldefine
module CDS_GEN_FJKB_N_RB_SB_X_NO (Q, QN, J, K, CP, SB, RB);

    input   J, K, CP, SB, RB;

    output   Q, QN;


        reg  NOTIFY_REG ;
        
        U_FJKB_N_RB_SB_X_NO inst1 (Q_int, J, K, CP, RB, SB, NOTIFY_REG);   

        buf                 BU1   (Q, Q_int);
        not                 NT1   (QN, Q_int);

        and                 A1    (ENABLE, RB, SB);


    specify


    // Specify path delays

        if (SB && RB && !(J && !K))
        (negedge CP =>  (Q +: J)) = (1.0, 1.0);
        if (SB && RB && J && !K)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);


        if (SB && RB && !(J && !K))
        (negedge CP =>  (QN +: K)) = (1.0, 1.0);
        if (SB && RB && J && !K)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);


      // Timing checks 
 
    specparam
        t_SETUP$J = 0.0,
        t_SETUP$K = 0.0,
        t_HOLD$J  = 0.0,
        t_HOLD$K  = 0.0,
        t_PW_H$CP = 0.0,
        t_PW_L$CP = 0.0,
        t_RELEASE$RB$CP = 0.0,
        t_RELEASE$SB$CP = 0.0,
        t_PW_L$SB = 0.0,
        t_PW_L$RB = 0.0;
 
 
    $setuphold(negedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(negedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG);
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG);

    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK_ FLIP FLOP, WITH ACTIVE HIGH
                 ASYNCHRONOUS CLEAR.
TRUTHTABLE     :
           ----------------------------
            J   K   CP    R    Q    QN
           ----------------------------
                   _
            L   H   \_    L    Q    QN
                   _
            L   L   \_    L    L     H
                   _
            H   H   \_    L    H     L
                   _
            H   L   \_    L    QN    Q
                     _
            X   X  _/     L    Q    QN

            X   X   X     H    L     H

           -----------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FJKB_N_R_NO (Q, QN, J, K, CP, R);

    input  J, K, CP, R;

    output Q, QN;

        reg  NOTIFY_REG;
        
        U_FJKB_N_R_NO inst1 (Q_int, J, K, CP, R, NOTIFY_REG);   

        not           NT1   (QN, Q_int);
        buf           BU1   (Q, Q_int);


    specify


    // Specify path delays

        if (!R && !(J && !K))
        (negedge CP => (Q +: J)) = (1.0, 1.0);
        if (!R && J && !K)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!R && !(J && !K))
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (!R && J && !K)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);

        if (R)
        (posedge R => (Q +: 1'b0)) = (1.0, 1.0);
        if (R)
        (posedge R => (QN +: 1'b1)) = (1.0, 1.0);

    // Timing checks 

    specparam
        t_SETUP$J = 0.0,
        t_SETUP$K = 0.0,
        t_HOLD$J  = 0.0,
        t_HOLD$K  = 0.0,
        t_PW_H$CP = 0.0,
        t_PW_L$CP = 0.0,
        t_RELEASE$R$CP = 0.0,
        t_PW_H$R = 0.0;

    $setuphold(negedge CP &&& ~R, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(negedge CP &&& ~R, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP &&& ~R, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ~R, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG);

    $recovery(negedge R, negedge CP &&& J, t_RELEASE$R$CP, NOTIFY_REG);


    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK_ FLIP FLOP, WITH ACTIVE LOW
                 ASYNCHRONOUS SBSET. 
TRUTHTABLE     :
           -----------------------------
            J   K   CP   SB    Q    QN
           -----------------------------
                   _
            L   H   \_    H     Q    QN
                   _
            L   L   \_    H     L     H
                   _
            H   H   \_    H     H     L
                   _
            H   L   \_    H     QN    Q
                     _
            X   X  _/     H     Q    QN

            X   X   X     L     H     L
           -----------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .
*/

`celldefine
module CDS_GEN_FJKB_N_SB_NO (Q, QN, J, K, CP, SB);

    input   J, K, CP, SB;

    output   Q, QN;


        reg  NOTIFY_REG;
        
        U_FJKB_N_SB_NO inst1 (Q_int, J, K, CP, SB, NOTIFY_REG);   

        buf            BU1   (Q, Q_int);
        not            NT1   (QN, Q_int);


    specify


    // Specify path delays

        if (SB && !(J && !K))
        (negedge CP =>  (Q +: J)) = (1.0, 1.0);
        if (SB && J && !K)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);

        if (SB && !(J && !K))
        (negedge CP =>  (QN +: K)) = (1.0, 1.0);
        if (SB && J && !K)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

        if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    // Timing checks 

    specparam
        t_SETUP$J = 0.0,
        t_SETUP$K = 0.0,
        t_HOLD$J  = 0.0,
        t_HOLD$K  = 0.0,
        t_PW_H$CP = 0.0,
        t_PW_L$CP = 0.0,
        t_RELEASE$SB$CP = 0.0,
        t_PW_L$SB = 0.0;


    $setuphold(negedge CP &&& SB, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(negedge CP &&& SB, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP &&& SB, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& SB, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG);

    $recovery(posedge SB, negedge CP &&& K, t_RELEASE$SB$CP, NOTIFY_REG);
 
    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK_ FLIP FLOP, WITH ACTIVE HIGH
                 ASYNCHRONOUS SSET.
TRUTHTABLE     :
           -----------------------------
            J   K   CP   S     Q    QN
           -----------------------------
                   _
            L   H   \_    L     Q    QN
                   _
            L   L   \_    L     L     H
                   _
            H   H   \_    L     H     L
                   _
            H   L   \_    L     QN    Q
                     _
            X   X  _/     L     Q    QN

            X   X   X     H     H     L

           -----------------------------
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.

*/

`celldefine
module CDS_GEN_FJKB_N_S_NO (Q, QN, J, K, CP, S);

    input  J, K, CP, S;

    output Q, QN;

        reg  NOTIFY_REG;
        
        U_FJKB_N_S_NO inst1 (Q_int, J, K, CP, S, NOTIFY_REG);   

        buf           BU1   (Q, Q_int);
        not           NT1   (QN, Q_int);


    specify

    // Specify path delays

        if (!S && !(J && !K))
        (negedge CP => (Q +: J)) = (1.0, 1.0);
        if (!S && J && !K)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!S && !(J && !K))
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (!S && J && !K)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);

        if (S)
        (posedge S => (Q +: 1'b1)) = (1.0, 1.0);
        if (S)
        (posedge S => (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$J = 0.0,
        t_SETUP$K = 0.0,
        t_HOLD$J  = 0.0,
        t_HOLD$K  = 0.0,
        t_PW_H$CP = 0.0,
        t_PW_L$CP = 0.0,
        t_RELEASE$S$CP = 0.0,
        t_PW_H$S = 0.0;

    $setuphold(negedge CP &&& ~S, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(negedge CP &&& ~S, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP &&& ~S, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ~S, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG);

    $recovery(negedge S, negedge CP &&& K, t_RELEASE$S$CP, NOTIFY_REG);


    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK_ FLIP FLOP
TRUTHTABLE     :
            ----------------------
            J   K  CP    Q    QN
            ----------------------
                     _
            L   H  _/     Q    Q
                     _
            L   L  _/     L    H
                     _
            H   H  _/     H    L
                     _
            H   L  _/     QN   Q
                   _
            X   X   \_    Q    QN

            ----------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FJKB_P_NO (Q, QN, J, K, CP);

    input   J, K, CP;

    output  Q, QN;

        reg  NOTIFY_REG;

        U_FJKB_P_NO inst1 (Q_int, J, K, CP, NOTIFY_REG);

        buf         BU1   (Q, Q_int);
        not         NT1   (QN, Q_int);

    specify


    // Specify path delays

        if (!(J && !K))
        (posedge CP => (Q +: J)) = (1.0, 1.0);
        if (J && !K)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && !K))
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && !K)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);


    // Timing checks 

    specparam
        t_SETUP$J  = 0,
        t_HOLD$J   = 0,
        t_SETUP$K  = 0,
        t_HOLD$K   = 0,
        t_PW_H$CP  = 0,
        t_PW_L$CP  = 0;

    $setuphold(posedge CP, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);


    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK_ FLIP FLOP, WITH ASYNCHRONOUS CLEAR
                 ACTIVE LOW
TRUTHTABLE     :
            ----------------------------
            J   K  CP    RB     Q    QN
            ----------------------------
                     _
            L   H  _/     H      Q    QN
                     _
            L   L  _/     H      L    H
                     _
            H   H  _/     H      H    L
                     _
            H   L  _/     H      QN   Q
                   _
            X   X   \_    H      Q    QN

            X   X   X     L      L    H

            ----------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FJKB_P_RB_NO (Q, QN, J, K, CP, RB);

    input   J, K, CP, RB;

    output   Q, QN;


        reg  NOTIFY_REG;
        
        U_FJKB_P_RB_NO inst1 (Q_int, J, K, CP, RB, NOTIFY_REG);   

        buf            BU1   (Q, Q_int);
        not            NT1   (QN, Q_int);


    specify


    // Specify path delays

        if (RB && !(J && !K))
        (posedge CP =>  (Q +: J)) = (1.0, 1.0);
        if (RB && J && !K)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);

        if (RB && !(J && !K))
        (posedge CP =>  (QN +: K)) = (1.0, 1.0);
        if (RB && J && !K)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);


    // Timing checks 

    specparam
        t_SETUP$J  = 0.0,
        t_HOLD$J   = 0.0,
        t_SETUP$K  = 0.0,
        t_HOLD$K   = 0.0,
        t_PW_H$CP  = 0.0,
        t_PW_L$CP  = 0.0,
        t_RELEASE$RB$CP = 0.0,
        t_PW_L$RB  = 0.0;

    $setuphold(posedge CP &&& RB, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP &&& RB, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG);

    $recovery(posedge RB, posedge CP &&& J, t_RELEASE$RB$CP, NOTIFY_REG);
 

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK_ FLIP FLOP, WITH ACTIVE LOW
                 ASYNCHRONOUS CLEAR AND SBSET. ILLEGAL OUTPUT OCCURS WHEN BOTH
                 SBSET AND CLEAR ARE ACTIVE
TRUTHTABLE     :
           ----------------------------------
            J   K   CP   RB   SB    Q    QN
           ----------------------------------
                     _
            L   H  _/     H    H     Q    QN
                     _
            L   L  _/     H    H     L     H
                     _
            H   H  _/     H    H     H     L
                     _
            H   L  _/     H    H     QN    Q
                   _
            X   X   \_    H    H     Q    QN

            X   X   X     L    H     L     H

            X   X   X     H    L     H     L

            X   X   X     L    L     X     X
           ------------------------------------
i
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FJKB_P_RB_SB_X_NO (Q, QN, J, K, SB, RB, CP);

    input   J, K, SB, RB, CP;

    output  Q, QN;


        reg  NOTIFY_REG ;
        
        U_FJKB_P_RB_SB_X_NO inst1 (Q_int, J, K, CP, RB, SB, NOTIFY_REG);   

        buf                 BU1   (Q, Q_int);
        not                 NT1   (QN, Q_int);

        and                 A1    (ENABLE, RB, SB);

    specify


    // Specify path delays

        if (SB && RB && !(J && !K))
        (posedge CP =>  (Q +: J)) = (1.0, 1.0);
        if (SB && RB && J && !K)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);

        if (SB && RB && !(J && !K))
        (posedge CP =>  (QN +: K)) = (1.0, 1.0);
        if (SB && RB && J && !K)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
 
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$J = 0.0,
        t_SETUP$K = 0.0,
        t_HOLD$J  = 0.0,
        t_HOLD$K  = 0.0,
        t_PW_H$CP = 0.0,
        t_PW_L$CP = 0.0,
        t_RELEASE$RB$CP = 0.0,
        t_RELEASE$SB$CP = 0.0,
        t_PW_L$SB = 0.0,
        t_PW_L$RB = 0.0;
 
 
    $setuphold(posedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);
 
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG);
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG);
 
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
 

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK_ FLIP FLOP, WITH ASYNCHRONOUS CLEAR
                 ACTIVE HIGH
TRUTHTABLE     :
           ----------------------------
            J   K  CP    R     Q    QN
           ----------------------------
                     _
            L   H  _/    L     Q    QN
                     _
            L   L  _/    L     L    H
                     _
            H   H  _/    L     H    L
                     _
            H   L  _/    L     QN   Q
                   _
            X   X   \_   L     Q    QN

            X   X   X    H     L    H

           ----------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FJKB_P_R_NO (Q, QN, J, K, CP, R);

    input   J, K, CP, R;

    output   Q, QN;


        reg  NOTIFY_REG;
        
        U_FJKB_P_R_NO inst1 (Q_int, J, K, CP, R, NOTIFY_REG);   

        buf           BU1   (Q, Q_int);
        not           NT1   (QN, Q_int);


    specify

    // Specify path delays

        if (!R && !(J && !K))
        (posedge CP => (Q +: J)) = (1.0, 1.0);
        if (!R && J && !K)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!R && !(J && !K))
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (!R && J && !K)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);

        if (R)
        (posedge R => (Q +: 1'b0)) = (1.0, 1.0);
        if (R)
        (posedge R => (QN +: 1'b1)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$J = 0.0,
        t_SETUP$K = 0.0,
        t_HOLD$J  = 0.0,
        t_HOLD$K  = 0.0,
        t_PW_H$CP = 0.0,
        t_PW_L$CP = 0.0,
        t_RELEASE$R$CP = 0.0,
        t_PW_H$R = 0.0;

    $setuphold(posedge CP &&& ~R, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP &&& ~R, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP &&& ~R, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ~R, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG);

    $recovery(negedge R, posedge CP &&& J, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK_ FLIP FLOP, WITH ASYNCHRONOUS SET
                 ACTIVE LOW
TRUTHTABLE     :
            ----------------------------
            J   K  CP    SB     Q    QN
            ----------------------------
                     _
            L   H  _/     H      Q    QN
                     _
            L   L  _/     H      L    H
                     _
            H   H  _/     H      H    L
                     _
            H   L  _/     H      QN   Q
                   _
            X   X   \_    H      Q    QN

            X   X   X     L      H    L

            ----------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FJKB_P_SB_NO (Q, QN, J, K, CP, SB);

    input   J, K, CP, SB;

    output  Q, QN;


        reg  NOTIFY_REG;
        
        U_FJKB_P_SB_NO inst1 (Q_int, J, K, CP, SB, NOTIFY_REG);   

        buf            BU1   (Q, Q_int);
        not            NT1   (QN, Q_int);


    specify


    // Specify path delays

        if (SB && !(J && !K))
        (posedge CP =>  (Q +: J)) = (1.0, 1.0);
        if (SB && J && !K)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
 
        if (SB && !(J && !K))
        (posedge CP =>  (QN +: K)) = (1.0, 1.0);
        if (SB && J && !K)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);

        if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    // Timing checks 

    specparam
        t_SETUP$J = 0.0,
        t_SETUP$K = 0.0,
        t_HOLD$J  = 0.0,
        t_HOLD$K  = 0.0,
        t_PW_H$CP = 0.0,
        t_PW_L$CP = 0.0,
        t_RELEASE$SB$CP = 0.0,
        t_PW_L$SB = 0.0;


    $setuphold(posedge CP &&& SB, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP &&& SB, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP &&& SB, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& SB, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG);

    $recovery(posedge SB, posedge CP &&& K, t_RELEASE$SB$CP, NOTIFY_REG);
 

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK_ FLIP FLOP, WITH ASYNCHRONOUS SET
                 ACTIVE HIGH
TRUTHTABLE     :
           -----------------------------
            J   K  CP    S     Q    QN
           -----------------------------
                     _
            L   H  _/     L     Q    QN
                     _
            L   L  _/     L     L    H
                     _
            H   H  _/     L     H    L
                     _
            H   L  _/     L     QN   Q
                   _
            X   X   \_    L     Q    QN

            X   X   X     H     H    L

           -----------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_FJKB_P_S_NO (Q, QN, J, K, CP, S);

    input   J, K, CP, S;

    output  Q, QN;


        reg  NOTIFY_REG;
        
        U_FJKB_P_S_NO inst1 (Q_int, J, K, CP, S, NOTIFY_REG);   

        buf           BU1   (Q, Q_int);
        not           NT1   (QN, Q_int);

    specify

    // Specify path delays

        if (!S && !(J && !K))
        (posedge CP => (Q +: J)) = (1.0, 1.0);
        if (!S && J && !K)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!S && !(J && !K))
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (!S && J && !K)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);

        if (S)
        (posedge S => (Q +: 1'b1)) = (1.0, 1.0);
        if (S)
        (posedge S => (QN +: 1'b0)) = (1.0, 1.0);

    // Timing checks 

    specparam
        t_SETUP$J = 0.0,
        t_SETUP$K = 0.0,
        t_HOLD$J  = 0.0,
        t_HOLD$K  = 0.0,
        t_PW_H$CP = 0.0,
        t_PW_L$CP = 0.0,
        t_RELEASE$S$CP = 0.0,
        t_PW_H$S = 0.0;

    $setuphold(posedge CP &&& ~S, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP &&& ~S, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP &&& ~S, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ~S, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG);

    $recovery(negedge S, posedge CP &&& K, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK FLIP FLOP  
TRUTHTABLE     : 
            ----------------------  
            J   K  CLK     Q    QN   
            ----------------------  
                   _              
            L   L   \_      Q    QN   
                   _              
            L   H   \_      L    H   
                   _              
            H   L   \_      H    L   
                   _              
            H   H   \_      QN   Q  
                     _              
            X   X  _/       Q    QN  
                                    
            ----------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N (Q, QN, J, K, CP);

    input   J, K, CP;

    output   Q, QN;


        U_FJK_N inst1 (Q_int, J, K, CP);

        buf (Q, Q_int);

        not (QN, Q_int);

    specify

    // Specify path delays
      
        if (!(J && K))
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K))
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);


    // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(negedge CP, J, t_SETUP$J, t_HOLD$J);
    $setuphold(negedge CP, K, t_SETUP$K, t_HOLD$K);

    $width(posedge CP, t_PW_H$CP);
    $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK FLIP FLOP  
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
            ----------------------  
            J   K  CLK     Q    QN   
            ----------------------  
                   _              
            L   L   \_      Q    QN   
                   _              
            L   H   \_      L    H   
                   _              
            H   L   \_      H    L   
                   _              
            H   H   \_      QN   Q  
                     _              
            X   X  _/       Q    QN  
                                    
            ----------------------  


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_NO (Q, QN, J, K, CP);

    input   J, K, CP;

    output   Q, QN;



        reg  NOTIFY_REG ;
        U_FJK_N_NO inst1 (Q_int, J, K, CP, NOTIFY_REG);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays

        if (!(J && K))
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K))
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);


      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(negedge CP, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(negedge CP, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                   _                        
            L   L   \_    H    H     Q    QN  
                   _                        
            L   H   \_    H    H     L     H  
                   _                        
            H   L   \_    H    H     H     L  
                   _                        
            H   H   \_    H    H     QN    Q 
                     _                          
            X   X  _/     H    H     Q    QN  

            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     L     L  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_RB_SB (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;


        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_N_RB_SB   inst1
                    (Q, J, K, CP, RB, SB);   

        U_FJK_N_RB_SB_QN inst2
                    (QN, J, K, CP, RB, SB);   
        
        and   A1    (ENABLE, RB, SB);


    specify


    // Specify path delays

        if (!(J && K) && RB && SB) 
        (negedge CP => (Q +: J))  = (1.0, 1.0); 
        if (J && K && RB && SB)
        (negedge CP => (Q +: QN)) = (1.0, 1.0); 
 
        if (!(J && K) && RB && SB) 
        (negedge CP => (QN +: K)) = (1.0, 1.0); 
        if (J && K && RB && SB) 
        (negedge CP => (QN +: Q)) = (1.0, 1.0); 
 
        if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        if (RB)
        (negedge SB =>  (Q +: 1'b1))  = (1.0, 1.0);

        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0))  = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(negedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J); 
    $setuphold(negedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K); 
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                   _                        
            L   L   \_    H    H     Q    QN  
                   _                        
            L   H   \_    H    H     L     H  
                   _                        
            H   L   \_    H    H     H     L  
                   _                        
            H   H   \_    H    H     QN    Q 
                     _                          
            X   X  _/     H    H     Q    QN  

            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     L     L  
           ------------------------------------ 


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_RB_SB_NO (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_N_RB_SB_NO   inst1
                    (Q, J, K, CP, RB, SB, NOTIFY_REG);   

        U_FJK_N_RB_SB_NO_QN inst2
                    (QN, J, K, CP, RB, SB, NOTIFY_REG);   
        
        and   A1    (ENABLE, RB, SB);


    specify

    // Specify path delays
 
        if (!(J && K) && RB && SB)
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && RB && SB)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);
 
        if (!(J && K) && RB && SB)
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && RB && SB)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);
 
        if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        if (RB)
        (negedge SB =>  (Q +: 1'b1))  = (1.0, 1.0);
 
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0))  = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(negedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);  
    $setuphold(negedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);  

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET . ILLEGAL OUTPUT OCCURS WHEN BOTH
           PRESET AND CLEAR ARE ACTIVE 
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                   _                        
            L   L   \_    H    H     Q    QN  
                   _                        
            L   H   \_    H    H     L     H  
                   _                        
            H   L   \_    H    H     H     L  
                   _                        
            H   H   \_    H    H     QN    Q 
                     _
            X   X  _/     H    H     Q    QN  
                                              
            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     X     X  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_RB_SB_X (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;


        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_N_RB_SB_X   inst1
                    (Q_int, J, K, CP, RB, SB);

        buf (Q, Q_int);

        not (QN, Q_int);
   
        and   A1    (ENABLE, RB, SB);


    specify

    // Specify path delays

        if (!(J && K) && RB && SB)
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && RB && SB)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K) && RB && SB)
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && RB && SB)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0))  = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1))  = (1.0, 1.0);

        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);


      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(negedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J); 
    $setuphold(negedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K); 

    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET . ILLEGAL OUTPUT OCCURS WHEN BOTH
           PRESET AND CLEAR ARE ACTIVE 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                   _                        
            L   L   \_    H    H     Q    QN  
                   _                        
            L   H   \_    H    H     L     H  
                   _                        
            H   L   \_    H    H     H     L  
                   _                        
            H   H   \_    H    H     QN    Q 
                     _
            X   X  _/     H    H     Q    QN  
                                              
            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     X     X  
           ------------------------------------ 


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_RB_SB_X_NO (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_N_RB_SB_X_NO   inst1
                    (Q_int, J, K, CP, RB, SB, NOTIFY_REG);   

        buf (Q, Q_int);

        not (QN, Q_int); 
        
        and   A1    (ENABLE, RB, SB);


    specify

        if (!(J && K) && RB && SB)
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && RB && SB)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K) && RB && SB)
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && RB && SB)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0))  = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1))  = (1.0, 1.0);

        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(negedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG); 
    $setuphold(negedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG); 

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                   _                        
            L   L   \_    H    H     Q    QN  
                   _                        
            L   H   \_    H    H     L     H  
                   _                        
            H   L   \_    H    H     H     L  
                   _                        
            H   H   \_    H    H     QN    Q 
                     _
            X   X  _/     H    H     Q    QN  
                                              
            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     H     H  
           ------------------------------------ 


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_SB_RB (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;


        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_N_SB_RB   inst1
                    (Q, J, K, CP, RB, SB);   

        U_FJK_N_SB_RB_QN inst2
                    (QN, J, K, CP, RB, SB);   
        
        and   A1    (ENABLE, RB, SB);


    specify


    // Specify path delays
 
        if (!(J && K) && RB && SB)
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && RB && SB)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);
 
        if (!(J && K) && RB && SB)
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && RB && SB)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);
 
        if (SB)
        (negedge RB =>  (Q +: 1'b0))  = (1.0, 1.0);

        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1))  = (1.0, 1.0);
 
        if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
 

      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(negedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J); 
    $setuphold(negedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K); 

    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                   _                        
            L   L   \_    H    H     Q    QN  
                   _                        
            L   H   \_    H    H     L     H  
                   _                        
            H   L   \_    H    H     H     L  
                   _                        
            H   H   \_    H    H     QN    Q 
                     _
            X   X  _/     H    H     Q    QN  
                                              
            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     H     H  
           ------------------------------------ 


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_SB_RB_NO (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_N_SB_RB_NO   inst1
                    (Q, J, K, CP, RB, SB, NOTIFY_REG);   

        U_FJK_N_SB_RB_NO_QN inst2
                    (QN, J, K, CP, RB, SB, NOTIFY_REG);   
        
        and   A1    (ENABLE, RB, SB);


    specify


    // Specify path delays

        if (!(J && K) && RB && SB)
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && RB && SB)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);
  
        if (!(J && K) && RB && SB) 
        (negedge CP => (QN +: K)) = (1.0, 1.0); 
        if (J && K && RB && SB) 
        (negedge CP => (QN +: Q)) = (1.0, 1.0); 
  
        if (SB) 
        (negedge RB =>  (Q +: 1'b0))  = (1.0, 1.0);
 
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0); 
        (negedge SB =>  (Q +: 1'b1))  = (1.0, 1.0); 
  
        if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0); 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(negedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG); 
    $setuphold(negedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG); 

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   TI   TE    Q    QN  
           ------------------------------------ 
                   _                        
            L   L   \_    X    L     Q    QN  
                   _                        
            L   H   \_    X    L     L     H  
                   _                        
            H   L   \_    X    L     H     L  
                   _                        
            H   H   \_    X    L     QN    Q 
                     _                           
            X   X  _/     X    X     Q    QN  
                   _
            X   X   \_     L    H     L     H  
                   _                           
            X   X   \_     H    H     H     L  
           ------------------------------------ 


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_SD (Q, QN, J, K, CP, TI, TE);

    input   J, K, CP, TI, TE;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;
        U_MUX_2_1    inst1 (J_EFF, J, TI, TE);      
        not          inst2 (TI_EFF, TI);
        U_MUX_2_1    inst3 (K_EFF, K, TI_EFF, TE);  
        U_FJK_N      inst4 (Q_int, J_EFF, K_EFF, CP); 

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays

        if (!(J && K) && !TE)
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);
  
        if (!(J && K) && !TE) 
        (negedge CP => (QN +: K)) = (1.0, 1.0); 
        if (J && K && !TE) 
        (negedge CP => (QN +: Q)) = (1.0, 1.0); 
  
        if (TE)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
        if (TE)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(negedge CP &&& (~TE), J, t_SETUP$J, t_HOLD$J);
    $setuphold(negedge CP &&& (~TE), K, t_SETUP$K, t_HOLD$K);
    $setuphold(negedge CP &&& TE, TI, t_SETUP$TI, t_HOLD$TI); 

    $width(posedge CP, t_PW_H$CP); 
    $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   TI   TE    Q    QN  
           ------------------------------------ 
                   _                        
            L   L   \_    X    L     Q    QN  
                   _                        
            L   H   \_    X    L     L     H  
                   _                        
            H   L   \_    X    L     H     L  
                   _                        
            H   H   \_    X    L     QN    Q 
                     _                           
            X   X  _/     X    X     Q    QN  
                   _
            X   X   \_    L    H     L     H  
                   _                          
            X   X   \_    H    H     H     L  
           ------------------------------------ 


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_SD_NO (Q, QN, J, K, CP, TI, TE);

    input   J, K, CP, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;
        U_MUX_2_1    inst1 (J_EFF, J, TI, TE);      
        not          inst2 (TI_EFF, TI);
        U_MUX_2_1    inst3 (K_EFF, K, TI_EFF, TE);  
        U_FJK_N_NO      inst4 (Q_int, J_EFF, K_EFF, CP, NOTIFY_REG); 

        buf (Q, Q_int);

        not (QN, Q_int);


    specify

    // Specify path delays

        if (!(J && K) && !TE)
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE)
        (negedge CP => (Q +: QN)) = (1.0, 1.0); 
  
        if (!(J && K) && !TE)  
        (negedge CP => (QN +: K)) = (1.0, 1.0);  
        if (J && K && !TE)  
        (negedge CP => (QN +: Q)) = (1.0, 1.0);  
   
        if (TE)
        (negedge CP => (Q +: TI)) = (1.0, 1.0);
        if (TE)
        (negedge CP => (QN -: TI)) = (1.0, 1.0);

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(negedge CP &&& (~TE), J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(negedge CP &&& (~TE), K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);
    $setuphold(negedge CP &&& TE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG); 

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
              WITH ASYNCHRONOUS CLEAR AND SET ACTIVE LOW 
TRUTHTABLE     : 
           -----------------------------------------------
            J   K   CLK   TI   TE   RB   SB     Q    QN  
           ----------------------------------------------- 
                   _                                   
            L   L   \_    X    L    H    H      Q    QN  
                   _                                   
            L   H   \_    X    L    H    H      L     H  
                   _                                   
            H   L   \_    X    L    H    H      H     L  
                   _                                   
            H   H   \_    X    L    H    H      QN    Q 
                     _                                     
            X   X  _/     X    X    H    H      Q    QN  
                   _                          
            X   X   \_    L    H    H    H      L     H  
                   _                                     
            X   X   \_    H    H    H    H      H     L  
                                              
            X   X   X     X    X    L    H      L     H  

            X   X   X     X    X    H    L      H     L  

            X   X   X     X    X    L    L      L     L  
           ---------------------------------------------- 

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_SD_RB_SB (Q, QN, J, K, CP, RB, SB, TI, TE);

    input   J, K, CP, RB, SB, TI, TE;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;
                               

    U_MUX_2_1          inst1 (J_EFF, J, TI, TE);  
    not                 N1   (TI_EFF, TI);
    U_MUX_2_1          inst2 (K_EFF, K, TI_EFF, TE);  
    U_FJK_N_RB_SB      inst3 (Q, J_EFF, K_EFF, CP, RB, SB);   
    U_FJK_N_RB_SB_QN   inst4 (QN, J_EFF, K_EFF, CP, RB, SB);   
  
    and                 A1   (ENABLE, RB, SB);
    not                 N2   (JK_ENABLE, TE); 
    and                 A2   (SETUP_HOLD_EN, JK_ENABLE, ENABLE);
    and                 A3   (SH_EN_TI, TE, ENABLE);


    specify


    // Specify path delays

        if (!(J && K) && !TE && RB && SB)
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE && RB && SB)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K) && !TE && RB && SB)
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !TE && RB && SB)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);

        if (TE && RB && SB)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
        if (TE && RB && SB)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);

        if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(negedge CP &&& SETUP_HOLD_EN, J, t_SETUP$J, t_HOLD$J);
    $setuphold(negedge CP &&& SETUP_HOLD_EN, K, t_SETUP$K, t_HOLD$K);
    $setuphold(negedge CP &&& SH_EN_TI, TI, t_SETUP$TI, t_HOLD$TI);
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
              WITH ASYNCHRONOUS CLEAR AND SET ACTIVE LOW 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           -----------------------------------------------
            J   K   CLK   TI   TE   RB   SB     Q    QN  
           ----------------------------------------------- 
                   _                                   
            L   L   \_    X    L    H    H      Q    QN  
                   _                                   
            L   H   \_    X    L    H    H      L     H  
                   _                                   
            H   L   \_    X    L    H    H      H     L  
                   _                                   
            H   H   \_    X    L    H    H      QN    Q 
                     _                                     
            X   X  _/     X    X    H    H      Q    QN  
                   _                          
            X   X   \_    L    H    H    H      L     H  
                   _                                     
            X   X   \_    H    H    H    H      H     L  
                                              
            X   X   X     X    X    L    H      L     H  

            X   X   X     X    X    H    L      H     L  

            X   X   X     X    X    L    L      L     L  
           ---------------------------------------------- 


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_SD_RB_SB_NO (Q, QN, J, K, CP, RB, SB, TI, TE);

    input   J, K, CP, RB, SB, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;
                               

    U_MUX_2_1          inst1 (J_EFF, J, TI, TE);  
    not                 N1   (TI_EFF, TI);
    U_MUX_2_1          inst2 (K_EFF, K, TI_EFF, TE);  
    U_FJK_N_RB_SB_NO      inst3 (Q, J_EFF, K_EFF, CP, RB, SB, NOTIFY_REG);   
    U_FJK_N_RB_SB_NO_QN   inst4 (QN, J_EFF, K_EFF, CP, RB, SB, NOTIFY_REG);   
  
    and                 A1   (ENABLE, RB, SB);
    not                 N2   (JK_ENABLE, TE); 
    and                 A2   (SETUP_HOLD_EN, JK_ENABLE, ENABLE);
    and                 A3   (SH_EN_TI, TE, ENABLE);


    specify


    // Specify path delays

        if (!(J && K) && !TE && RB && SB)
        (negedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE && RB && SB)
        (negedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K) && !TE && RB && SB)
        (negedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !TE && RB && SB)
        (negedge CP => (QN +: Q)) = (1.0, 1.0);

        if (TE && RB && SB)
        (negedge CP =>  (Q +: TI)) = (1.0, 1.0);
        if (TE && RB && SB)
        (negedge CP =>  (QN -: TI)) = (1.0, 1.0);

        if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(negedge CP &&& SETUP_HOLD_EN, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(negedge CP &&& SETUP_HOLD_EN, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);
    $setuphold(negedge CP &&& SH_EN_TI, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG);

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE HIGH
               ASYNCHRONOUS CLEAR AND PRESET .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   R    S     Q    QN  
           ------------------------------------ 
                   _                        
            L   L   \_    L    L     Q    QN  
                   _                        
            L   H   \_    L    L     L     H  
                   _                        
            H   L   \_    L    L     H     L  
                   _                        
            H   H   \_    L    L     QN    Q 
                     _
            X   X  _/     L    L     Q    QN  
                                              
            X   X   X     H    L     L     H  
                                              
            X   X   X     L    H     H     L  
                                              
            X   X   X     H    H     H     H  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_S_R (Q, QN, J, K, CP, R, S);

    input   J, K, CP, R, S;

    output   Q, QN;


        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_N_S_R   inst1
                    (Q, J, K, CP, R, S);   

        U_FJK_N_S_R_QN inst2
                    (QN, J, K, CP, R, S);   


        nor   NR1    (ENABLE, R, S);


    specify


    // Specify path delays

    if (!(J && K) && !R && !S)
    (negedge CP =>  (Q +: J)) = (1.0, 1.0);
    if (J && K && !R && !S)
    (negedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (!(J && K) && !R && !S)
    (negedge CP =>  (QN +: K)) = (1.0, 1.0);
    if (J && K && !R && !S)
    (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!S)
    (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!R)
    (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(negedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J); 
    $setuphold(negedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K); 

    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(posedge S, t_PW_H$S);
    $width(posedge R, t_PW_H$R);

    $recovery(negedge S, negedge CP &&& ~R, t_RELEASE$S$CP);
    $recovery(negedge R, negedge CP &&& ~S, t_RELEASE$R$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE HIGH
               ASYNCHRONOUS CLEAR AND PRESET .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   R    S     Q    QN  
           ------------------------------------ 
                   _                        
            L   L   \_    L    L     Q    QN  
                   _                        
            L   H   \_    L    L     L     H  
                   _                        
            H   L   \_    L    L     H     L  
                   _                        
            H   H   \_    L    L     QN    Q 
                     _
            X   X  _/     L    L     Q    QN  
                                              
            X   X   X     H    L     L     H  
                                              
            X   X   X     L    H     H     L  
                                              
            X   X   X     H    H     H     H  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_N_S_R_NO (Q, QN, J, K, CP, R, S);

    input   J, K, CP, R, S;

    output   Q, QN;



        reg  NOTIFY_REG ;
        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_N_S_R_NO   inst1
                    (Q, J, K, CP, R, S, NOTIFY_REG);   

        U_FJK_N_S_R_NO_QN inst2
                    (QN, J, K, CP, R, S, NOTIFY_REG);   


        nor   NR1    (ENABLE, R, S);


    specify


    // Specify path delays

    if (!(J && K) && !R && !S)
    (negedge CP =>  (Q +: J)) = (1.0, 1.0);
    if (J && K && !R && !S)
    (negedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (!(J && K) && !R && !S)
    (negedge CP =>  (QN +: K)) = (1.0, 1.0);
    if (J && K && !R && !S)
    (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!S)
    (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!R)
    (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);


      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(negedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG); 
    $setuphold(negedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG); 

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge S, negedge CP &&& ~R, t_RELEASE$S$CP, NOTIFY_REG);
    $recovery(negedge R, negedge CP &&& ~S, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP  
TRUTHTABLE     : 
            ----------------------  
            J   K  CLK     Q    QN   
            ----------------------  
                     _              
            L   L  _/      Q    Q   
                     _              
            L   H  _/      L    H   
                     _              
            H   L  _/      H    L   
                     _              
            H   H  _/      QN   Q  
                   _                
            X   X   \_     Q    QN  
                                    
            ----------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P (Q, QN, J, K, CP);

    input   J, K, CP;

    output   Q, QN;


        U_FJK_P inst1 (Q_int, J, K, CP);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays

        if (!(J && K))
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K))
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);


      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge CP, J, t_SETUP$J, t_HOLD$J);
    $setuphold(posedge CP, K, t_SETUP$K, t_HOLD$K);

    $width(posedge CP, t_PW_H$CP);
    $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP  
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
            ----------------------  
            J   K  CLK     Q    QN   
            ----------------------  
                     _              
            L   L  _/      Q    Q   
                     _              
            L   H  _/      L    H   
                     _              
            H   L  _/      H    L   
                     _              
            H   H  _/      QN   Q  
                   _                
            X   X   \_     Q    QN  
                                    
            ----------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_NO (Q, QN, J, K, CP);

    input   J, K, CP;

    output   Q, QN;



        reg  NOTIFY_REG ;
        U_FJK_P_NO inst1 (Q_int, J, K, CP, NOTIFY_REG);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays
 
        if (!(J && K)) 
        (posedge CP => (Q +: J))  = (1.0, 1.0); 
        if (J && K) 
        (posedge CP => (Q +: QN)) = (1.0, 1.0); 
 
        if (!(J && K)) 
        (posedge CP => (QN +: K)) = (1.0, 1.0); 
        if (J && K) 
        (posedge CP => (QN +: Q)) = (1.0, 1.0); 
 

      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge CP, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ASYNCHRONOUS CLEAR 
              ACTIVE HIGH   
TRUTHTABLE     : 
            ----------------------------  
            J   K  CLK    R     Q    QN   
            ----------------------------  
                     _                    
            L   L  _/     L      Q    QN  
                     _                    
            L   H  _/     L      L    H   
                     _                    
            H   L  _/     L      H    L   
                     _                    
            H   H  _/     L      QN   Q   
                   _                      
            X   X   \_    L      Q    QN  
                                          
            X   X   X     H      L    H   
                                          
            ----------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_R (Q, QN, J, K, CP, R);

    input   J, K, CP, R;

    output   Q, QN;



        parameter vlib_flat_module = 1;         
        U_FJK_P_R (Q_int, J, K, CP, R);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays

        if (!(J && K) && !R)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !R)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K) && !R)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !R)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);

        if (R)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        if (R)
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(posedge CP &&& ~R, J, t_SETUP$J, t_HOLD$J);
    $setuphold(posedge CP &&& ~R, K, t_SETUP$K, t_HOLD$K);
 
    $width(posedge CP &&& ~R, t_PW_H$CP);
    $width(negedge CP &&& ~R, t_PW_L$CP);
    $width(posedge R, t_PW_H$R); 

    $recovery(negedge R, posedge CP &&& J, t_RELEASE$R$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ASYNCHRONOUS CLEAR 
              ACTIVE LOW   
TRUTHTABLE     : 
            ----------------------------  
            J   K  CLK    RB     Q    QN   
            ----------------------------  
                     _                    
            L   L  _/     H      Q    QN  
                     _                    
            L   H  _/     H      L    H   
                     _                    
            H   L  _/     H      H    L   
                     _                    
            H   H  _/     H      QN   Q   
                   _                      
            X   X   \_    H      Q    QN  
                                          
            X   X   X     L      L    H   
                                          
            ----------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_RB (Q, QN, J, K, CP, RB);

    input   J, K, CP, RB;

    output   Q, QN;



        parameter vlib_flat_module = 1;         
        U_FJK_P_RB (Q_int, J, K, CP, RB);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays
 
        if (!(J && K) && RB)
        (posedge CP => (Q +: J))  = (1.0, 1.0); 
        if (J && K && RB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0); 
 
        if (!(J && K) && RB) 
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && RB) 
        (posedge CP => (QN +: Q)) = (1.0, 1.0); 

        if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(posedge CP &&& RB, J, t_SETUP$J, t_HOLD$J);
    $setuphold(posedge CP &&& RB, K, t_SETUP$K, t_HOLD$K);
 
    $width(posedge CP &&& RB, t_PW_H$CP);
    $width(negedge CP &&& RB, t_PW_L$CP);
    $width(negedge RB, t_PW_L$RB); 

    $recovery(posedge RB, posedge CP &&& J, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ASYNCHRONOUS CLEAR 
              ACTIVE LOW   
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
            ----------------------------  
            J   K  CLK    RB     Q    QN   
            ----------------------------  
                     _                    
            L   L  _/     H      Q    QN  
                     _                    
            L   H  _/     H      L    H   
                     _                    
            H   L  _/     H      H    L   
                     _                    
            H   H  _/     H      QN   Q   
                   _                      
            X   X   \_    H      Q    QN  
                                          
            X   X   X     L      L    H   
                                          
            ----------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_RB_NO (Q, QN, J, K, CP, RB);

    input   J, K, CP, RB;

    output   Q, QN;



        reg  NOTIFY_REG ;

        parameter vlib_flat_module = 1;         
        U_FJK_P_RB_NO (Q_int, J, K, CP, RB, NOTIFY_REG);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays
 
        if (!(J && K) && RB)
        (posedge CP => (Q +: J))  = (1.0, 1.0); 
        if (J && K && RB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0); 
 
        if (!(J && K) && RB) 
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && RB) 
        (posedge CP => (QN +: Q)) = (1.0, 1.0); 
 
        if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(posedge CP &&& RB, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP &&& RB, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);
 
    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG);

    $recovery(posedge RB, posedge CP &&& J, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                     _                        
            L   L  _/     H    H     Q    QN  
                     _                        
            L   H  _/     H    H     L     H  
                     _                        
            H   L  _/     H    H     H     L  
                     _                        
            H   H  _/     H    H     QN    Q 
                   _                           
            X   X   \_    H    H     Q    QN  

            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     L     L  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_RB_SB (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;


        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_P_RB_SB   inst1
                    (Q, J, K, CP, RB, SB);   

        U_FJK_P_RB_SB_QN inst2
                    (QN, J, K, CP, RB, SB);   
        
        and   A1    (ENABLE, RB, SB);


    specify


    // Specify path delays
 
        if (!(J && K) && RB && SB)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && RB && SB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K) && RB && SB)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && RB && SB)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);

        if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        if (RB)
        (negedge SB =>  (Q +: 1'b1))  = (1.0, 1.0);

        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0))  = (1.0, 1.0);


      // Timing checks 
                             
    specparam
        t_SETUP$J  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ,
        t_PW_L$SB  = 0.0 ;

    $setuphold(posedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J);
    $setuphold(posedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K);
 
    $width(posedge CP &&& ENABLE, t_PW_H$CP);
    $width(negedge CP &&& ENABLE, t_PW_L$CP);
    $width(negedge RB, t_PW_L$RB); 
    $width(negedge SB, t_PW_L$SB); 

    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                     _                        
            L   L  _/     H    H     Q    QN  
                     _                        
            L   H  _/     H    H     L     H  
                     _                        
            H   L  _/     H    H     H     L  
                     _                        
            H   H  _/     H    H     QN    Q 
                   _                           
            X   X   \_    H    H     Q    QN  

            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     L     L  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_RB_SB_NO (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_P_RB_SB_NO   inst1
                    (Q, J, K, CP, RB, SB, NOTIFY_REG);   

        U_FJK_P_RB_SB_NO_QN inst2
                    (QN, J, K, CP, RB, SB, NOTIFY_REG);   
        
        and   A1    (ENABLE, RB, SB);


    specify


    // Specify path delays
 
        if (!(J && K) && RB && SB)
        (posedge CP => (Q +: J))  = (1.0, 1.0); 
        if (J && K && RB && SB) 
        (posedge CP => (Q +: QN)) = (1.0, 1.0);
 
        if (!(J && K) && RB && SB) 
        (posedge CP => (QN +: K)) = (1.0, 1.0); 
        if (J && K && RB && SB) 
        (posedge CP => (QN +: Q)) = (1.0, 1.0); 
 
        if (SB) 
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0); 
        if (RB) 
        (negedge SB =>  (Q +: 1'b1))  = (1.0, 1.0); 
 
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0))  = (1.0, 1.0); 
 

      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(posedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG); 
    $setuphold(posedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG); 
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET . ILLEGAL OUTPUT OCCURS WHEN BOTH
           PRESET AND CLEAR ARE ACTIVE 
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                     _                        
            L   L  _/     H    H     Q    QN  
                     _                        
            L   H  _/     H    H     L     H  
                     _                        
            H   L  _/     H    H     H     L  
                     _                        
            H   H  _/     H    H     QN    Q 
                   _
            X   X   \_    H    H     Q    QN  
                                              
            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     X     X  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_RB_SB_X (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;


        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_P_RB_SB_X   inst1
                    (Q_int, J, K, CP, RB, SB);   

        buf (Q, Q_int);

        not (QN, Q_int);
        
        and   A1    (ENABLE, RB, SB);


    specify


    // Specify path delays

        if (!(J && K) && RB && SB)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && RB && SB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);
 
        if (!(J && K) && RB && SB)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && RB && SB)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(posedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J); 
    $setuphold(posedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K); 
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET . ILLEGAL OUTPUT OCCURS WHEN BOTH
           PRESET AND CLEAR ARE ACTIVE 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                     _                        
            L   L  _/     H    H     Q    QN  
                     _                        
            L   H  _/     H    H     L     H  
                     _                        
            H   L  _/     H    H     H     L  
                     _                        
            H   H  _/     H    H     QN    Q 
                   _
            X   X   \_    H    H     Q    QN  
                                              
            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     X     X  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_RB_SB_X_NO (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_P_RB_SB_X_NO   inst1
                    (Q_int, J, K, CP, RB, SB, NOTIFY_REG);   

        buf (Q, Q_int);

        not (QN, Q_int);
 
        
        and   A1    (ENABLE, RB, SB);


    specify


    // Specify path delays

        if (!(J && K) && RB && SB)
        (posedge CP => (Q +: J))  = (1.0, 1.0); 
        if (J && K && RB && SB) 
        (posedge CP => (Q +: QN)) = (1.0, 1.0); 
  
        if (!(J && K) && RB && SB) 
        (posedge CP => (QN +: K)) = (1.0, 1.0); 
        if (J && K && RB && SB) 
        (posedge CP => (QN +: Q)) = (1.0, 1.0); 
 
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
 
      // Timing checks
 
 
    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(posedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG); 
    $setuphold(posedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG); 
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ASYNCHRONOUS CLEAR 
              ACTIVE HIGH   
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
            ----------------------------  
            J   K  CLK    R     Q    QN   
            ----------------------------  
                     _                    
            L   L  _/     L      Q    QN  
                     _                    
            L   H  _/     L      L    H   
                     _                    
            H   L  _/     L      H    L   
                     _                    
            H   H  _/     L      QN   Q   
                   _                      
            X   X   \_    L      Q    QN  
                                          
            X   X   X     H      L    H   
                                          
            ----------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_R_NO (Q, QN, J, K, CP, R);

    input   J, K, CP, R;

    output   Q, QN;



        reg  NOTIFY_REG ;

        parameter vlib_flat_module = 1;         
        U_FJK_P_R_NO (Q_int, J, K, CP, R, NOTIFY_REG);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays
 
        if (!(J && K) && !R)
        (posedge CP => (Q +: J))  = (1.0, 1.0); 
        if (J && K && !R)
        (posedge CP => (Q +: QN)) = (1.0, 1.0); 
 
        if (!(J && K) && !R) 
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !R) 
        (posedge CP => (QN +: Q)) = (1.0, 1.0); 
 
        if (R)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        if (R)
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(posedge CP &&& ~R, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP &&& ~R, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);
 
    $width(posedge CP &&& ~R, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ~R, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, posedge CP &&& J, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ASYNCHRONOUS SET 
              ACTIVE HIGH   
TRUTHTABLE     : 
            ----------------------------  
            J   K  CLK    S     Q    QN   
            ----------------------------  
                     _                    
            L   L  _/     L      Q    QN   
                     _                    
            L   H  _/     L      L    H   
                     _                    
            H   L  _/     L      H    L   
                     _                    
            H   H  _/     L      QN   Q  
                   _                      
            X   X   \_    L      Q    QN  
                                          
            X   X   X     H      H    L   
                                          
            ----------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_S (Q, QN, J, K, CP, S);

    input   J, K, CP, S;

    output   Q, QN;



        parameter vlib_flat_module = 1;   
     
        U_FJK_P_S (Q_int, J, K, CP, S);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays

        if (!(J && K) && !S)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !S)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);
        if (!(J && K) && !S)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !S)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);

        if (S)
        (posedge S => (Q +: 1'b1)) = (1.0, 1.0);
        if (S)
        (posedge S => (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ;

    $setuphold(posedge CP &&& ~S, J, t_SETUP$J, t_HOLD$J);
    $setuphold(posedge CP &&& ~S, K, t_SETUP$K, t_HOLD$K);
 
    $width(posedge CP &&& ~S, t_PW_H$CP);
    $width(negedge CP &&& ~S, t_PW_L$CP);
    $width(posedge S, t_PW_H$S); 

    $recovery(negedge S, posedge CP &&& K, t_RELEASE$S$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ASYNCHRONOUS SET 
              ACTIVE LOW  
TRUTHTABLE     : 
            ----------------------------  
            J   K  CLK    SB     Q    QN   
            ----------------------------  
                     _                    
            L   L  _/     H      Q    QN   
                     _                    
            L   H  _/     H      L    H   
                     _                    
            H   L  _/     H      H    L   
                     _                    
            H   H  _/     H      QN   Q  
                   _                      
            X   X   \_    H      Q    QN  
                                          
            X   X   X     L      H    L   
                                          
            ----------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SB (Q, QN, J, K, CP, SB);

    input   J, K, CP, SB;

    output   Q, QN;



        parameter vlib_flat_module = 1;   
     
        U_FJK_P_SB (Q_int, J, K, CP, SB);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays
 
        if (!(J && K) && SB)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && SB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);
        if (!(J && K) && SB)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && SB)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);
 
        if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
 
      // Timing checks
 
    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;

    $setuphold(posedge CP &&& SB, J, t_SETUP$J, t_HOLD$J);
    $setuphold(posedge CP &&& SB, K, t_SETUP$K, t_HOLD$K);
 
    $width(posedge CP &&& SB, t_PW_H$CP);
    $width(negedge CP &&& SB, t_PW_L$CP);
    $width(negedge SB, t_PW_L$SB); 

    $recovery(posedge SB, posedge CP &&& K, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ASYNCHRONOUS SET 
              ACTIVE LOW   
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
            ----------------------------  
            J   K  CLK    SB     Q    QN   
            ----------------------------  
                     _                    
            L   L  _/     H      Q    QN   
                     _                    
            L   H  _/     H      L    H   
                     _                    
            H   L  _/     H      H    L   
                     _                    
            H   H  _/     H      QN   Q  
                   _                      
            X   X   \_    H      Q    QN  
                                          
            X   X   X     L      H    L   
                                          
            ----------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SB_NO (Q, QN, J, K, CP, SB);

    input   J, K, CP, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;

        parameter vlib_flat_module = 1;   
     
        U_FJK_P_SB_NO (Q_int, J, K, CP, SB, NOTIFY_REG);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays
  
        if (!(J && K) && SB) 
        (posedge CP => (Q +: J))  = (1.0, 1.0); 
        if (J && K && SB) 
        (posedge CP => (Q +: QN)) = (1.0, 1.0); 
        if (!(J && K) && SB) 
        (posedge CP => (QN +: K)) = (1.0, 1.0); 
        if (J && K && SB)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);
 
        if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
  

      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;


    $setuphold(posedge CP &&& SB, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP &&& SB, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);
 
    $width(posedge CP &&& SB, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& SB, t_PW_L$CP, 0, NOTIFY_REG);
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 

    $recovery(posedge SB, posedge CP &&& K, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                     _                        
            L   L  _/     H    H     Q    QN  
                     _                        
            L   H  _/     H    H     L     H  
                     _                        
            H   L  _/     H    H     H     L  
                     _                        
            H   H  _/     H    H     QN    Q 
                   _                           
            X   X   \_    H    H     Q    QN  

            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     H     H  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SB_RB (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;


        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_P_SB_RB   inst1
                    (Q, J, K, CP, RB, SB);   

        U_FJK_P_SB_RB_QN inst2
                    (QN, J, K, CP, RB, SB);   
        
        and   A1    (ENABLE, RB, SB);


    specify


    // Specify path delays
 
        if (!(J && K) && RB && SB)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && RB && SB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K) && RB && SB)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && RB && SB)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);

        if (SB)
        (negedge RB =>  (Q +: 1'b0))  = (1.0, 1.0);

        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1))  = (1.0, 1.0);

        if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(posedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J); 
    $setuphold(posedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K); 
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE LOW 
           ASYNCHRONOUS CLEAR AND PRESET .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   RB   SB    Q    QN  
           ------------------------------------ 
                     _                        
            L   L  _/     H    H     Q    QN  
                     _                        
            L   H  _/     H    H     L     H  
                     _                        
            H   L  _/     H    H     H     L  
                     _                        
            H   H  _/     H    H     QN    Q 
                   _                           
            X   X   \_    H    H     Q    QN  

            X   X   X     L    H     L     H  
                                              
            X   X   X     H    L     H     L  
                                              
            X   X   X     L    L     H     H  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SB_RB_NO (Q, QN, J, K, CP, RB, SB);

    input   J, K, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_P_SB_RB_NO   inst1
                    (Q, J, K, CP, RB, SB, NOTIFY_REG);   

        U_FJK_P_SB_RB_NO_QN inst2
                    (QN, J, K, CP, RB, SB, NOTIFY_REG);   
        
        and   A1    (ENABLE, RB, SB);


    specify


    // Specify path delays
 
        if (!(J && K) && RB && SB)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && RB && SB) 
        (posedge CP => (Q +: QN)) = (1.0, 1.0); 
 
        if (!(J && K) && RB && SB) 
        (posedge CP => (QN +: K)) = (1.0, 1.0); 
        if (J && K && RB && SB) 
        (posedge CP => (QN +: Q)) = (1.0, 1.0); 
 
        if (SB) 
        (negedge RB =>  (Q +: 1'b0))  = (1.0, 1.0); 
 
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1))  = (1.0, 1.0);
 
        if (RB) 
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
 
 
      // Timing checks
 
    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;
 

    $setuphold(posedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG); 
    $setuphold(posedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG); 
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   TI   TE    Q    QN  
           ------------------------------------ 
                     _                        
            L   L  _/     X    L     Q    QN  
                     _                        
            L   H  _/     X    L     L     H  
                     _                        
            H   L  _/     X    L     H     L  
                     _                        
            H   H  _/     X    L     QN    Q 
                   _                            
            X   X   \_    X    X     Q    QN  
                      _
            X   X   _/    L    H     L     H  
                      _                        
            X   X   _/    H    H     H     L  
           ------------------------------------ 


REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SD (Q, QN, J, K, CP, TI, TE);

    input   J, K, CP, TI, TE;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;
        U_MUX_2_1    inst1 (J_EFF, J, TI, TE);      
        not          inst2 (TI_EFF, TI);
        U_MUX_2_1    inst3 (K_EFF, K, TI_EFF, TE);  
        U_FJK_P      inst4 (Q_int, J_EFF, K_EFF, CP); 

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays
 
        if (!(J && K) && !TE)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);
 
        if (!(J && K) && !TE)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !TE)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);
 
        if (TE)
        (posedge CP => (Q +: TI)) = (1.0, 1.0);
        if (TE)
        (posedge CP => (QN -: TI)) = (1.0, 1.0);


      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge CP &&& (~TE), J, t_SETUP$J, t_HOLD$J);
    $setuphold(posedge CP &&& (~TE), K, t_SETUP$K, t_HOLD$K);
    $setuphold(posedge CP &&& TE, TI, t_SETUP$TI, t_HOLD$TI); 

    $width(posedge CP, t_PW_H$CP); 
    $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   TI   TE    Q    QN  
           ------------------------------------ 
                     _                        
            L   L  _/     X    L     Q    QN  
                     _                        
            L   H  _/     X    L     L     H  
                     _                        
            H   L  _/     X    L     H     L  
                     _                        
            H   H  _/     X    L     QN    Q 
                   _                            
            X   X   \_    X    X     Q    QN  

            X   X   X     L    H     L     H  
                                              
            X   X   X     H    H     H     L  
           ------------------------------------ 


REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SD_NO (Q, QN, J, K, CP, TI, TE);

    input   J, K, CP, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;
        U_MUX_2_1    inst1 (J_EFF, J, TI, TE);      
        not          inst2 (TI_EFF, TI);
        U_MUX_2_1    inst3 (K_EFF, K, TI_EFF, TE);  
        U_FJK_P_NO      inst4 (Q_int, J_EFF, K_EFF, CP, NOTIFY_REG); 

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays
  
        if (!(J && K) && !TE) 
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE) 
        (posedge CP => (Q +: QN)) = (1.0, 1.0);
  
        if (!(J && K) && !TE) 
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !TE) 
        (posedge CP => (QN +: Q)) = (1.0, 1.0); 
  
        if (TE)
        (posedge CP => (Q +: TI)) = (1.0, 1.0); 
        if (TE) 
        (posedge CP => (QN -: TI)) = (1.0, 1.0); 
 

      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge CP &&& (~TE), J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP &&& (~TE), K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);
    $setuphold(posedge CP &&& TE, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG); 

    $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
              AND ASYNCHRONOUS CLEAR ACTIVE LOW 
TRUTHTABLE     : 
           -----------------------------------------
            J   K   CLK   TI   TE   RB    Q    QN  
           ----------------------------------------- 
                     _                             
            L   L  _/     X    L    H     Q    QN  
                     _                             
            L   H  _/     X    L    H     L     H  
                     _                             
            H   L  _/     X    L    H     H     L  
                     _                             
            H   H  _/     X    L    H     QN    Q 
                   _                                 
            X   X   \_    X    X    H     Q    QN  
                      _                  
            X   X   _/    L    H    H     L     H  
                      _                              
            X   X   _/    H    H    H     H     L  

            X   X   X     X    X    L     L     H  
           ---------------------------------------- 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SD_RB (Q, QN, J, K, CP, RB, TI, TE);

    input   J, K, CP, RB, TI, TE;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;


        U_MUX_2_1        inst1 (J_EFF, J, TI, TE);      
        not              inst5   (TI_EFF, TI);
        U_MUX_2_1        inst2 (K_EFF, K, TI_EFF, TE);  
        U_FJK_P_RB    inst3 (Q_int, J_EFF, K_EFF, CP, RB); 

        buf (Q, Q_int);

        not (QN, Q_int);

        not              inst6 (JK_ENABLE, TE);  
        and              inst7 (SETUP_HOLD_EN, RB, JK_ENABLE),
                         inst8 (SH_EN_TI, RB, TE);


    specify


    // Specify path delays

        if (!(J && K) && !TE && RB)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE && RB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K) && !TE && RB)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !TE && RB)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);

        if (TE && RB)
        (posedge CP => (Q +: TI)) = (1.0, 1.0);
        if (TE && RB)
        (posedge CP => (QN -: TI)) = (1.0, 1.0);

        if (!RB)
        (negedge RB => (Q +: 1'b0)) = (1.0, 1.0);
        if (!RB)
        (negedge RB => (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(posedge CP &&& SETUP_HOLD_EN, J, t_SETUP$J, t_HOLD$J); 
    $setuphold(posedge CP &&& SETUP_HOLD_EN, K, t_SETUP$K, t_HOLD$K); 
    $setuphold(posedge CP &&& SH_EN_TI, TI, t_SETUP$TI, t_HOLD$TI); 
   
    $width(posedge CP &&& RB, t_PW_H$CP); 
    $width(negedge CP &&& RB, t_PW_L$CP); 
    $width(negedge RB, t_PW_L$RB); 

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
              AND ASYNCHRONOUS CLEAR ACTIVE LOW 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           -----------------------------------------
            J   K   CLK   TI   TE   RB    Q    QN  
           ----------------------------------------- 
                     _                             
            L   L  _/     X    L    H     Q    QN  
                     _                             
            L   H  _/     X    L    H     L     H  
                     _                             
            H   L  _/     X    L    H     H     L  
                     _                             
            H   H  _/     X    L    H     QN    Q 
                   _                                 
            X   X   \_    X    X    H     Q    QN  
                      _                  
            X   X   _/    L    H    H     L     H  
                      _                             
            X   X   _/    H    H    H     H     L  

            X   X   X     X    X    L     L     H  
           ---------------------------------------- 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SD_RB_NO (Q, QN, J, K, CP, RB, TI, TE);

    input   J, K, CP, RB, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;


        U_MUX_2_1        inst1 (J_EFF, J, TI, TE);      
        not              inst5   (TI_EFF, TI);
        U_MUX_2_1        inst2 (K_EFF, K, TI_EFF, TE);  
        U_FJK_P_RB_NO    inst3 (Q_int, J_EFF, K_EFF, CP, RB, NOTIFY_REG); 

        buf (Q, Q_int);

        not (QN, Q_int);

        not              inst6 (JK_ENABLE, TE);  
        and              inst7 (SETUP_HOLD_EN, RB, JK_ENABLE),
                         inst8 (SH_EN_TI, RB, TE);


    specify


    // Specify path delays
 
        if (!(J && K) && !TE && RB)
        (posedge CP => (Q +: J))  = (1.0, 1.0); 
        if (J && K && !TE && RB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0); 
 
        if (!(J && K) && !TE && RB) 
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !TE && RB) 
        (posedge CP => (QN +: Q)) = (1.0, 1.0); 
 
        if (TE && RB)
        (posedge CP => (Q +: TI)) = (1.0, 1.0);
        if (TE && RB) 
        (posedge CP => (QN -: TI)) = (1.0, 1.0); 
 
        if (!RB)
        (negedge RB => (Q +: 1'b0)) = (1.0, 1.0);
        if (!RB)
        (negedge RB => (QN +: 1'b1)) = (1.0, 1.0);


      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(posedge CP &&& SETUP_HOLD_EN, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG); 
    $setuphold(posedge CP &&& SETUP_HOLD_EN, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG); 
    $setuphold(posedge CP &&& SH_EN_TI, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG); 
   
    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
              WITH ASYNCHRONOUS CLEAR AND SET ACTIVE LOW 
TRUTHTABLE     : 
           -----------------------------------------------
            J   K   CLK   TI   TE   RB   SB     Q    QN  
           ----------------------------------------------- 
                     _                                   
            L   L  _/     X    L    H    H      Q    QN  
                     _                                   
            L   H  _/     X    L    H    H      L     H  
                     _                                   
            H   L  _/     X    L    H    H      H     L  
                     _                                   
            H   H  _/     X    L    H    H      QN    Q 
                   _                                       
            X   X   \_    X    X    H    H      Q    QN  
                      _                        
            X   X   _/    L    H    H    H      L     H  
                      _                                   
            X   X   _/    H    H    H    H      H     L  
                                              
            X   X   X     X    X    L    H      L     H  

            X   X   X     X    X    H    L      H     L  

            X   X   X     X    X    L    L      L     L  
           ---------------------------------------------- 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SD_RB_SB (Q, QN, J, K, CP, RB, SB, TI, TE);

    input   J, K, CP, RB, SB, TI, TE;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;
                               

    U_MUX_2_1          inst1 (J_EFF, J, TI, TE);  
    not                 N1   (TI_EFF, TI);
    U_MUX_2_1          inst2 (K_EFF, K, TI_EFF, TE);  
    U_FJK_P_RB_SB      inst3 (Q, J_EFF, K_EFF, CP, RB, SB);   
    U_FJK_P_RB_SB_QN   inst4 (QN, J_EFF, K_EFF, CP, RB, SB);   
  
    and                 A1   (ENABLE, RB, SB);
    not                 N2   (JK_ENABLE, TE); 
    and                 A2   (SETUP_HOLD_EN, JK_ENABLE, ENABLE);
    and                 A3   (SH_EN_TI, TE, ENABLE);


    specify


    // Specify path delays

        if (!(J && K) && !TE && RB && SB)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE && RB && SB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);

        if (!(J && K) && !TE && RB && SB)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !TE && RB && SB)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);

        if (TE && RB && SB)
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);
        if (TE && RB && SB)
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);

        if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);


      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(posedge CP &&& SETUP_HOLD_EN, J, t_SETUP$J, t_HOLD$J); 
    $setuphold(posedge CP &&& SETUP_HOLD_EN, K, t_SETUP$K, t_HOLD$K); 
    $setuphold(posedge CP &&& SH_EN_TI, TI, t_SETUP$TI, t_HOLD$TI); 
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
              WITH ASYNCHRONOUS CLEAR AND SET ACTIVE LOW 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           -----------------------------------------------
            J   K   CLK   TI   TE   RB   SB     Q    QN  
           ----------------------------------------------- 
                     _                                   
            L   L  _/     X    L    H    H      Q    QN  
                     _                                   
            L   H  _/     X    L    H    H      L     H  
                     _                                   
            H   L  _/     X    L    H    H      H     L  
                     _                                   
            H   H  _/     X    L    H    H      QN    Q 
                   _                                       
            X   X   \_    X    X    H    H      Q    QN  
                      _                        
            X   X   _/    L    H    H    H      L     H  
                      _                                   
            X   X   _/    H    H    H    H      H     L  
                                              
            X   X   X     X    X    L    H      L     H  

            X   X   X     X    X    H    L      H     L  

            X   X   X     X    X    L    L      L     L  
           ---------------------------------------------- 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SD_RB_SB_NO (Q, QN, J, K, CP, RB, SB, TI, TE);

    input   J, K, CP, RB, SB, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;
                               

    U_MUX_2_1          inst1 (J_EFF, J, TI, TE);  
    not                 N1   (TI_EFF, TI);
    U_MUX_2_1          inst2 (K_EFF, K, TI_EFF, TE);  
    U_FJK_P_RB_SB_NO      inst3 (Q, J_EFF, K_EFF, CP, RB, SB, NOTIFY_REG);   
    U_FJK_P_RB_SB_NO_QN   inst4 (QN, J_EFF, K_EFF, CP, RB, SB, NOTIFY_REG);   
  
    and                 A1   (ENABLE, RB, SB);
    not                 N2   (JK_ENABLE, TE); 
    and                 A2   (SETUP_HOLD_EN, JK_ENABLE, ENABLE);
    and                 A3   (SH_EN_TI, TE, ENABLE);


    specify


    // Specify path delays
 
        if (!(J && K) && !TE && RB && SB)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE && RB && SB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);
 
        if (!(J && K) && !TE && RB && SB)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !TE && RB && SB)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);
 
        if (TE && RB && SB) 
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0); 
        if (TE && RB && SB) 
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0); 
 
        if (RB) 
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0); 
        if (SB) 
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0); 
 
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0); 
 
      // Timing checks 


    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $setuphold(posedge CP &&& SETUP_HOLD_EN, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG); 
    $setuphold(posedge CP &&& SETUP_HOLD_EN, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG); 
    $setuphold(posedge CP &&& SH_EN_TI, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG); 
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
              AND ASYNCHRONOUS SET ACTIVE LOW 
TRUTHTABLE     : 
           -----------------------------------------
            J   K   CLK   TI   TE   SB    Q    QN  
           ----------------------------------------- 
                     _                             
            L   L  _/     X    L    H     Q    QN  
                     _                             
            L   H  _/     X    L    H     L     H  
                     _                             
            H   L  _/     X    L    H     H     L  
                     _                             
            H   H  _/     X    L    H     QN    Q 
                   _                                 
            X   X   \_    X    X    H     Q    QN  
                      _                  
            X   X   _/    L    H    H     L     H  
                      _                             
            X   X   _/    H    H    H     H     L  

            X   X   X     X    X    L     H     L  
           ---------------------------------------- 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SD_SB (Q, QN, J, K, CP, SB, TI, TE);

    input   J, K, CP, SB, TI, TE;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;


        U_MUX_2_1        inst1 (J_EFF, J, TI, TE);      
        not              inst5   (TI_EFF, TI);
        U_MUX_2_1        inst2 (K_EFF, K, TI_EFF, TE);  
        U_FJK_P_SB    inst3 (Q_int, J_EFF, K_EFF, CP, SB); 

        buf (Q, Q_int);

        not (QN, Q_int);

        not              inst6 (JK_ENABLE, TE);  
        and              inst7 (SETUP_HOLD_EN, SB, JK_ENABLE),
                         inst8 (SH_EN_TI, SB, TE);


    specify


    // Specify path delays
 
        if (!(J && K) && !TE && SB)
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE && SB)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);
 
        if (!(J && K) && !TE && SB)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !TE && SB)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);
 
        if (TE && SB) 
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0); 
        if (TE && SB) 
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0); 
 
        if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;

    $setuphold(posedge CP &&& SETUP_HOLD_EN, J, t_SETUP$J, t_HOLD$J); 
    $setuphold(posedge CP &&& SETUP_HOLD_EN, K, t_SETUP$K, t_HOLD$K); 
    $setuphold(posedge CP &&& SH_EN_TI, TI, t_SETUP$TI, t_HOLD$TI); 
   
    $width(posedge CP &&& SB, t_PW_H$CP); 
    $width(negedge CP &&& SB, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB); 

    $recovery(posedge SB, posedge CP, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED J-K FLIP FLOP WITH SCAN INPUTS 
              AND ASYNCHRONOUS SET ACTIVE LOW 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           -----------------------------------------
            J   K   CLK   TI   TE   SB    Q    QN  
           ----------------------------------------- 
                     _                             
            L   L  _/     X    L    H     Q    QN  
                     _                             
            L   H  _/     X    L    H     L     H  
                     _                             
            H   L  _/     X    L    H     H     L  
                     _                             
            H   H  _/     X    L    H     QN    Q 
                   _                                 
            X   X   \_    X    X    H     Q    QN  
                                        
            X   X   X     L    H    H     L     H  
                                                   
            X   X   X     H    H    H     H     L  

            X   X   X     X    X    L     H     L  
           ---------------------------------------- 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_SD_SB_NO (Q, QN, J, K, CP, SB, TI, TE);

    input   J, K, CP, SB, TI, TE;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;


        U_MUX_2_1        inst1 (J_EFF, J, TI, TE);      
        not              inst5   (TI_EFF, TI);
        U_MUX_2_1        inst2 (K_EFF, K, TI_EFF, TE);  
        U_FJK_P_SB_NO    inst3 (Q_int, J_EFF, K_EFF, CP, SB, NOTIFY_REG); 

        buf (Q, Q_int);

        not (QN, Q_int);

        not              inst6 (JK_ENABLE, TE);  
        and              inst7 (SETUP_HOLD_EN, SB, JK_ENABLE),
                         inst8 (SH_EN_TI, SB, TE);


    specify

    // Specify path delays
 
        if (!(J && K) && !TE && SB) 
        (posedge CP => (Q +: J))  = (1.0, 1.0);
        if (J && K && !TE && SB) 
        (posedge CP => (Q +: QN)) = (1.0, 1.0); 
  
        if (!(J && K) && !TE && SB)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !TE && SB) 
        (posedge CP => (QN +: Q)) = (1.0, 1.0); 
  
        if (TE && SB)  
        (posedge CP =>  (Q +: TI)) = (1.0, 1.0);  
        if (TE && SB)  
        (posedge CP =>  (QN -: TI)) = (1.0, 1.0);  
  
        if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
 
      // Timing checks
 
    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_SETUP$TI  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_HOLD$TI  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;
 
    $setuphold(posedge CP &&& SETUP_HOLD_EN, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG); 
    $setuphold(posedge CP &&& SETUP_HOLD_EN, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG); 
    $setuphold(posedge CP &&& SH_EN_TI, TI, t_SETUP$TI, t_HOLD$TI, NOTIFY_REG); 
   
    $width(posedge CP &&& SB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& SB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 

    $recovery(posedge SB, posedge CP, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ASYNCHRONOUS SET 
              ACTIVE HIGH 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
            ----------------------------  
            J   K  CLK    S     Q    QN   
            ----------------------------  
                     _                    
            L   L  _/     L      Q    QN   
                     _                    
            L   H  _/     L      L    H   
                     _                    
            H   L  _/     L      H    L   
                     _                    
            H   H  _/     L      QN   Q  
                   _                      
            X   X   \_    L      Q    QN  
                                          
            X   X   X     H      H    L   
                                          
            ----------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_S_NO (Q, QN, J, K, CP, S);

    input   J, K, CP, S;

    output   Q, QN;



        reg  NOTIFY_REG ;

        parameter vlib_flat_module = 1;   
     
        U_FJK_P_S_NO (Q_int, J, K, CP, S, NOTIFY_REG);

        buf (Q, Q_int);

        not (QN, Q_int);


    specify


    // Specify path delays

        if (!(J && K) && !S)
        (posedge CP => (Q +: J)) = (1.0, 1.0);
        if (J && K && !S)
        (posedge CP => (Q +: QN)) = (1.0, 1.0);
        if (!(J && K) && !S)
        (posedge CP => (QN +: K)) = (1.0, 1.0);
        if (J && K && !S)
        (posedge CP => (QN +: Q)) = (1.0, 1.0);

        if (S)
        (posedge S => (Q +: 1'b1)) = (1.0, 1.0);
        if (S)
        (posedge S => (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ;

    $setuphold(posedge CP &&& ~S, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG);
    $setuphold(posedge CP &&& ~S, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG);
 
    $width(posedge CP &&& ~S, t_PW_H$CP, 0, NOTIFY_REG);
    $width(negedge CP &&& ~S, t_PW_L$CP, 0, NOTIFY_REG);
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 

    $recovery(negedge S, posedge CP &&& K, t_RELEASE$S$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE HIGH
               ASYNCHRONOUS CLEAR AND PRESET .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   R    S     Q    QN  
           ------------------------------------ 
                     _                        
            L   L  _/     L    L     Q    QN  
                     _                        
            L   H  _/     L    L     L     H  
                     _                        
            H   L  _/     L    L     H     L  
                     _                        
            H   H  _/     L    L     QN    Q 
                   _
            X   X   \_    H    H     Q    QN  
                                              
            X   X   X     H    L     L     H  
                                              
            X   X   X     L    H     H     L  
                                              
            X   X   X     H    H     H     H  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_S_R (Q, QN, J, K, CP, R, S);

    input   J, K, CP, R, S;

    output   Q, QN;


        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_P_S_R   inst1
                    (Q, J, K, CP, R, S);   

        U_FJK_P_S_R_QN inst2
                    (QN, J, K, CP, R, S);   


        nor   NR1    (ENABLE, R, S);


    specify


    // Specify path delays

    if (!(J && K) && !R && !S)
    (posedge CP =>  (Q +: J)) = (1.0, 1.0);
    if (J && K && !R && !S)
    (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (!(J && K) && !R && !S)
    (posedge CP =>  (QN +: K)) = (1.0, 1.0);
    if (J && K && !R && !S)
    (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!S)
    (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!R)
    (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;


    $setuphold(posedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J); 
    $setuphold(posedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K); 
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(posedge S, t_PW_H$S);
    $width(posedge R, t_PW_H$R);

    $recovery(negedge S, posedge CP &&& ~R, t_RELEASE$S$CP);
    $recovery(negedge R, posedge CP &&& ~S, t_RELEASE$R$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED JK FLIP FLOP, WITH ACTIVE HIGH
               ASYNCHRONOUS CLEAR AND PRESET .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ------------------------------------
            J   K   CLK   R    S     Q    QN  
           ------------------------------------ 
                     _                        
            L   L  _/     L    L     Q    QN  
                     _                        
            L   H  _/     L    L     L     H  
                     _                        
            H   L  _/     L    L     H     L  
                     _                        
            H   H  _/     L    L     QN    Q 
                   _
            X   X   \_    H    H     Q    QN  
                                              
            X   X   X     H    L     L     H  
                                              
            X   X   X     L    H     H     L  
                                              
            X   X   X     L    L     H     H  
           ------------------------------------ 

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FJK_P_S_R_NO (Q, QN, J, K, CP, R, S);

    input   J, K, CP, R, S;

    output   Q, QN;



        reg  NOTIFY_REG ;
        
        parameter vlib_flat_module = 1 ;
 
        U_FJK_P_S_R_NO   inst1
                    (Q, J, K, CP, R, S, NOTIFY_REG);   

        U_FJK_P_S_R_NO_QN inst2
                    (QN, J, K, CP, R, S, NOTIFY_REG);   


        nor   NR1    (ENABLE, R, S);


    specify


    // Specify path delays
 
    if (!(J && K) && !R && !S)
    (posedge CP =>  (Q +: J)) = (1.0, 1.0); 
    if (J && K && !R && !S) 
    (posedge CP =>  (Q +: QN)) = (1.0, 1.0); 
    if (!(J && K) && !R && !S) 
    (posedge CP =>  (QN +: K)) = (1.0, 1.0); 
    if (J && K && !R && !S) 
    (posedge CP =>  (QN +: Q)) = (1.0, 1.0); 
 
    if (!S) 
    (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0); 
    if (!R) 
    (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);
 
    (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0); 
 
 
      // Timing checks
 
    specparam
        t_SETUP$J  = 0.0 ,
        t_SETUP$K  = 0.0 ,
        t_HOLD$J  = 0.0 ,
        t_HOLD$K  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$R$CP  = 0.0 ,
        t_RELEASE$S$CP  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;
 

    $setuphold(posedge CP &&& ENABLE, J, t_SETUP$J, t_HOLD$J, NOTIFY_REG); 
    $setuphold(posedge CP &&& ENABLE, K, t_SETUP$K, t_HOLD$K, NOTIFY_REG); 
  
    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge S, posedge CP &&& ~R, t_RELEASE$S$CP, NOTIFY_REG);
    $recovery(negedge R, posedge CP &&& ~S, t_RELEASE$R$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED R-S FLIP-FLOP
TRUTHTABLE     : 
          ------------------------
           S   R   CP    Q    QN 
          ------------------------
                  _
           L   L   \_    Q    QN
                  _
           L   H   \_    L    H
                  _
           H   L   \_    H    L
                  _
           H   H   \_    L    L
                    _
           X   X  _/     Q    QN
          ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_N (Q, QN, S, R, CP);

    input   S, R, CP;

    output   Q, QN;



            parameter vlib_flat_module = 1 ;
 
             U_FRS_N inst1 (Q, S, R, CP);
             U_FRS_N_QN inst2 (QN, S, R, CP);

    specify


    // Specify path delays

      
    if (R)
        (negedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (S)
        (negedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (negedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (negedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

       $setuphold(negedge CP, S, t_SETUP$S, t_HOLD$S);
       $setuphold(negedge CP, R, t_SETUP$R, t_HOLD$R);

       $width(posedge CP, t_PW_H$CP);
       $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED R-S FLIP-FLOP
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
          ------------------------
           S   R   CP    Q    QN 
          ------------------------
                  _
           L   L   \_    Q    QN
                  _
           L   H   \_    L    H
                  _
           H   L   \_    H    L
                  _
           H   H   \_    L    L
                    _
           X   X  _/     Q    QN
          ------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_N_NO (Q, QN, S, R, CP);

    input   S, R, CP;

    output   Q, QN;



            reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
 
             U_FRS_N_NO inst1 (Q, S, R, CP, NOTIFY_REG);
             U_FRS_N_NO_QN inst2 (QN, S, R, CP, NOTIFY_REG);



    specify


    // Specify path delays

    if (R)
        (negedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (negedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S)
        (negedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R)
        (negedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

       $setuphold(negedge CP, S, t_SETUP$S, t_HOLD$S, NOTIFY_REG);
       $setuphold(negedge CP, R, t_SETUP$R, t_HOLD$R, NOTIFY_REG);

       $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG);
       $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND  RESET 
TRUTHTABLE     : 
          --------------------------------
           S   R   CP   SB   RB  Q    QN 
          --------------------------------
           X   X   X    L    H   H    L

           X   X   X    H    L   L    H

           X   X   X    L    L   L    L
                  _
           L   L   \_   H    H   Q    QN
                  _
           L   H   \_   H    H   L    H
                  _
           H   L   \_   H    H   H    L
                  _
           H   H   \_   H    H   L    L
                    _
           X   X  _/    H    H   Q    QN
          --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_N_RB_SB (Q, QN, S, R, CP, RB, SB);

    input   S, R, CP, RB, SB;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
 
             U_FRS_N_RB_SB inst1 (Q, S, R, CP, RB, SB);
             U_FRS_N_RB_SB_QN inst2 (QN, S, R, CP, RB, SB);
 
             and  A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (R && RB && SB)
        (negedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && RB && SB)
        (negedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && RB && SB)
        (negedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && RB && SB)
        (negedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

       $setuphold(negedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S);
       $setuphold(negedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R);

       $width(posedge CP &&& ENABLE, t_PW_H$CP);
       $width(negedge CP &&& ENABLE, t_PW_L$CP); 
       $width(negedge SB, t_PW_L$SB);
       $width(negedge RB, t_PW_L$RB);

       $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);
       $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND  RESET .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
          --------------------------------
           S   R   CP   SB   RB  Q    QN 
          --------------------------------
           X   X   X    L    H   H    L

           X   X   X    H    L   L    H

           X   X   X    L    L   L    L
                  _
           L   L   \_   H    H   Q    QN
                  _
           L   H   \_   H    H   L    H
                  _
           H   L   \_   H    H   H    L
                  _
           H   H   \_   H    H   L    L
                    _
           X   X  _/    H    H   Q    QN
          --------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_N_RB_SB_NO (Q, QN, S, R, CP, RB, SB);

    input   S, R, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
 
             U_FRS_N_RB_SB_NO inst1 (Q, S, R, CP, RB, SB, NOTIFY_REG);
             U_FRS_N_RB_SB_NO_QN inst2 (QN, S, R, CP, RB, SB, NOTIFY_REG);
 
             and  A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (R && RB && SB)
        (negedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && RB && SB)
        (negedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && RB && SB)
        (negedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && RB && SB)
        (negedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

       $setuphold(negedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S, NOTIFY_REG);
       $setuphold(negedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R, NOTIFY_REG);

       $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
       $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
       $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
       $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

       $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
       $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND  RESET . ILLEGAL OUTPUT OCCURS WHEN 
              BOTH SET AND RESET ARE ACTIVE .
TRUTHTABLE     : 
          --------------------------------
           S   R   CP   SB   RB  Q    QN 
          --------------------------------
           X   X   X    L    H   H    L

           X   X   X    H    L   L    H

           X   X   X    L    L   X    X
                  _
           L   L   \_   H    H   Q    QN
                  _
           L   H   \_   H    H   L    H
                  _
           H   L   \_   H    H   H    L
                  _
           H   H   \_   H    H   L    L
                    _
           X   X  _/    H    H   Q    QN
          --------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_N_SB_RB_X (Q, QN, S, R, CP, RB, SB);

    input   S, R, CP, RB, SB;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
 
             U_FRS_N_SB_RB_X inst1 (Q, S, R, CP, RB, SB);
             U_FRS_N_SB_RB_X_QN inst2 (QN, S, R, CP, RB, SB);
 
             and  A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (R && RB && SB)
        (negedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && RB && SB)
        (negedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && RB && SB)
        (negedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && RB && SB)
        (negedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

       $setuphold(negedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S);
       $setuphold(negedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R);

       $width(posedge CP &&& ENABLE, t_PW_H$CP);
       $width(negedge CP &&& ENABLE, t_PW_L$CP); 
       $width(negedge SB, t_PW_L$SB);
       $width(negedge RB, t_PW_L$RB);

       $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);
       $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND  RESET 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
          --------------------------------
           S   R   CP   SB   RB  Q    QN 
          --------------------------------
           X   X   X    L    H   H    L

           X   X   X    H    L   L    H

           X   X   X    L    L   X    X
                  _
           L   L   \_   H    H   Q    QN
                  _
           L   H   \_   H    H   L    H
                  _
           H   L   \_   H    H   H    L
                  _
           H   H   \_   H    H   L    L
                    _
           X   X  _/    H    H   Q    QN
          --------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_N_SB_RB_X_NO (Q, QN, S, R, CP, RB, SB);

    input   S, R, CP, RB, SB;

    output   Q, QN;



           reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
 
             U_FRS_N_SB_RB_X_NO inst1 (Q, S, R, CP, RB, SB, NOTIFY_REG);
             U_FRS_N_SB_RB_X_NO_QN inst2 (QN, S, R, CP, RB, SB, NOTIFY_REG);
 
             and  A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (R && RB && SB)
        (negedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && RB && SB)
        (negedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && RB && SB)
        (negedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && RB && SB)
        (negedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

       $setuphold(negedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S, NOTIFY_REG);
       $setuphold(negedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R, NOTIFY_REG);

       $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
       $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
       $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
       $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

       $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
       $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND  RESET . ILLEGAL OUTPUT OCCURS WHEN
              BOTH SET AND RESET ARE ACTIVE .
TRUTHTABLE     : 
          --------------------------------
           S   R   CP  SET RESET  Q    QN 
          --------------------------------
           X   X   X    H    L    H    L

           X   X   X    L    H    L    H

           X   X   X    H    H    X    X
                  _
           L   L   \_   L    L    Q    QN
                  _          
           L   H   \_   L    L    L    H
                  _          
           H   L   \_   L    L    H    L
                  _          
           H   H   \_   L    L    L    L
                    _             
           X   X  _/    L    L    Q    QN
          --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_N_S_R_X (Q, QN, S, R, CP, RESET, SET);

    input   S, R, CP, RESET, SET;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
 
             U_FRS_N_S_R_X inst1 (Q, S, R, CP, RESET, SET);
             U_FRS_N_S_R_X_QN inst2 (QN, S, R, CP, RESET, SET);
 
             nor  N1 (ENABLE, RESET, SET);


    specify


    // Specify path delays

    if (R && !RESET && !SET)
        (negedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && !RESET && !SET)
        (negedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && !RESET && !SET)
        (negedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && !RESET && !SET)
        (negedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (posedge RESET =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge RESET =>  (QN +: 1'b1)) = (1.0, 1.0);
        (posedge SET =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge SET =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SET$CP  = 0.0 ,
        t_RELEASE$RESET$CP  = 0.0 ,
        t_PW_H$SET  = 0.0 ,
        t_PW_H$RESET  = 0.0 ;

       $setuphold(negedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S);
       $setuphold(negedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R);

       $width(posedge CP &&& ENABLE, t_PW_H$CP);
       $width(negedge CP &&& ENABLE, t_PW_L$CP); 
       $width(posedge SET, t_PW_H$SET);
       $width(posedge RESET, t_PW_H$RESET);

       $recovery(negedge SET, negedge CP &&& ~RESET, t_RELEASE$SET$CP);
       $recovery(negedge RESET, negedge CP &&& ~SET, t_RELEASE$RESET$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND  RESET ILLEGAL OUTPUT OCCURS WHEN
              BOTH SET AND RESET ARE ACTIVE .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
          --------------------------------
           S   R   CP  SET RESET  Q    QN 
          --------------------------------
           X   X   X    H    L    H    L

           X   X   X    L    H    L    H

           X   X   X    H    H    X    X
                  _
           L   L   \_   L    L    Q    QN
                  _          
           L   H   \_   L    L    L    H
                  _          
           H   L   \_   L    L    H    L
                  _          
           H   H   \_   L    L    L    L
                    _             
           X   X  _/    L    L    Q    QN
          --------------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_N_S_R_X_NO (Q, QN, S, R, CP, RESET, SET);

    input   S, R, CP, RESET, SET;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
 
             U_FRS_N_S_R_X_NO inst1 (Q, S, R, CP, RESET, SET, NOTIFY_REG);
             U_FRS_N_S_R_X_NO_QN inst2 (QN, S, R, CP, RESET, SET, NOTIFY_REG);
 
             nor  N1 (ENABLE, RESET, SET);


    specify


    // Specify path delays

    if (R && !RESET && !SET)
        (negedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && !RESET && !SET)
        (negedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && !RESET && !SET)
        (negedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && !RESET && !SET)
        (negedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (posedge RESET =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge RESET =>  (QN +: 1'b1)) = (1.0, 1.0);
        (posedge SET =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge SET =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SET$CP  = 0.0 ,
        t_RELEASE$RESET$CP  = 0.0 ,
        t_PW_H$SET  = 0.0 ,
        t_PW_H$RESET  = 0.0 ;

       $setuphold(negedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S, NOTIFY_REG);
       $setuphold(negedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R, NOTIFY_REG);

       $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
       $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
       $width(posedge SET, t_PW_H$SET, 0, NOTIFY_REG);
       $width(posedge RESET, t_PW_H$RESET, 0, NOTIFY_REG);

       $recovery(negedge SET, negedge CP &&& ~RESET, t_RELEASE$SET$CP, NOTIFY_REG);
       $recovery(negedge RESET, negedge CP &&& ~SET, t_RELEASE$RESET$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED R-S FLIP-FLOP
TRUTHTABLE     : 
          ------------------------
           S   R   CP    Q    QN 
          ------------------------
                    _
           L   L  _/     Q    QN
                    _
           L   H  _/     L    H
                    _
           H   L  _/     H    L
                    _
           H   H  _/     L    L
                  _
           X   X   \_    Q    QN
          ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_P (Q, QN, S, R, CP);

    input   S, R, CP;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
 
             U_FRS_P inst1 (Q, S, R, CP);
             U_FRS_P_QN inst2 (QN, S, R, CP);


    specify


    // Specify path delays

    if (R)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S)
        (posedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R)
        (posedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

       $setuphold(posedge CP, S, t_SETUP$S, t_HOLD$S);
       $setuphold(posedge CP, R, t_SETUP$R, t_HOLD$R);

       $width(posedge CP, t_PW_H$CP);
       $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED R-S FLIP-FLOP
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
          ------------------------
           S   R   CP    Q    QN 
          ------------------------
                    _
           L   L  _/     Q    QN
                    _
           L   H  _/     L    H
                    _
           H   L  _/     H    L
                    _
           H   H  _/     L    L
                  _
           X   X   \_    Q    QN
          ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_P_NO (Q, QN, S, R, CP);

    input   S, R, CP;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
 
             U_FRS_P_NO inst1 (Q, S, R, CP, NOTIFY_REG);
             U_FRS_P_NO_QN inst2 (QN, S, R, CP, NOTIFY_REG);


    specify


    // Specify path delays

    if (R)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S)
        (posedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R)
        (posedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

       $setuphold(posedge CP, S, t_SETUP$S, t_HOLD$S, NOTIFY_REG);
       $setuphold(posedge CP, R, t_SETUP$R, t_HOLD$R, NOTIFY_REG);

       $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG);
       $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND  RESET 
TRUTHTABLE     : 
          --------------------------------
           S   R   CP   SB   RB  Q    QN 
          --------------------------------
           X   X   X    L    H   H    L

           X   X   X    H    L   L    H

           X   X   X    L    L   L    L
                    _
           L   L  _/    H    H   Q    QN
                    _          
           L   H  _/    H    H   L    H
                    _          
           H   L  _/    H    H   H    L
                    _          
           H   H  _/    H    H   L    L
                  _            
           X   X   \_   H    H   Q    QN
          --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_P_RB_SB (Q, QN, S, R, CP, RB, SB);

    input   S, R, CP, RB, SB;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
 
             U_FRS_P_RB_SB inst1 (Q, S, R, CP, RB, SB);
             U_FRS_P_RB_SB_QN inst2 (QN, S, R, CP, RB, SB);
 
             and  A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (R && RB && SB)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && RB && SB)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && RB && SB)
        (posedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && RB && SB)
        (posedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



       $setuphold(posedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S);
       $setuphold(posedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R);

       $width(posedge CP &&& ENABLE, t_PW_H$CP);
       $width(negedge CP &&& ENABLE, t_PW_L$CP); 
       $width(negedge SB, t_PW_L$SB);
       $width(negedge RB, t_PW_L$RB);

       $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);
       $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND  RESET .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
          --------------------------------
           S   R   CP   SB   RB  Q    QN 
          --------------------------------
           X   X   X    L    H   H    L

           X   X   X    H    L   L    H

           X   X   X    L    L   L    L
                    _
           L   L  _/    H    H   Q    QN
                    _          
           L   H  _/    H    H   L    H
                    _          
           H   L  _/    H    H   H    L
                    _          
           H   H  _/    H    H   L    L
                  _            
           X   X   \_   H    H   Q    QN
          --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_P_RB_SB_NO (Q, QN, S, R, CP, RB, SB);

    input   S, R, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
 
             U_FRS_P_RB_SB_NO inst1 (Q, S, R, CP, RB, SB, NOTIFY_REG);
             U_FRS_P_RB_SB_NO_QN inst2 (QN, S, R, CP, RB, SB, NOTIFY_REG);
 
             and  A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (R && RB && SB)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && RB && SB)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && RB && SB)
        (posedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && RB && SB)
        (posedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


       $setuphold(posedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S, NOTIFY_REG);
       $setuphold(posedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R, NOTIFY_REG);

       $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
       $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
       $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
       $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

       $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
       $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND  RESET . ILLEGAL OUTPUT OCCURS WHEN 
              BOTH SET AND RESET ARE ACTIVE .
TRUTHTABLE     : 
          --------------------------------
           S   R   CP   SB   RB  Q    QN 
          --------------------------------
           X   X   X    L    H   H    L

           X   X   X    H    L   L    H

           X   X   X    L    L   X    X
                    _
           L   L  _/    H    H   Q    QN
                    _          
           L   H  _/    H    H   L    H
                    _          
           H   L  _/    H    H   H    L
                    _          
           H   H  _/    H    H   L    L
                  _            
           X   X   \_   H    H   Q    QN
          --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_P_SB_RB_X (Q, QN, S, R, CP, RB, SB);

    input   S, R, CP, RB, SB;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
 
             U_FRS_P_SB_RB_X inst1 (Q, S, R, CP, RB, SB);
             U_FRS_P_SB_RB_X_QN inst2 (QN, S, R, CP, RB, SB);
 
             and  A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (R && RB && SB)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && RB && SB)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && RB && SB)
        (posedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && RB && SB)
        (posedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



       $setuphold(posedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S);
       $setuphold(posedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R);

       $width(posedge CP &&& ENABLE, t_PW_H$CP);
       $width(negedge CP &&& ENABLE, t_PW_L$CP); 
       $width(negedge SB, t_PW_L$SB);
       $width(negedge RB, t_PW_L$RB);


       $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);
       $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE LOW
              ASYNCHRONOUS SET AND  RESET 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
          --------------------------------
           S   R   CP   SB   RB  Q    QN 
          --------------------------------
           X   X   X    L    H   H    L

           X   X   X    H    L   L    H

           X   X   X    L    L   X    X
                    _
           L   L  _/    H    H   Q    QN
                    _          
           L   H  _/    H    H   L    H
                    _          
           H   L  _/    H    H   H    L
                    _          
           H   H  _/    H    H   L    L
                  _            
           X   X   \_   H    H   Q    QN
          --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_P_SB_RB_X_NO (Q, QN, S, R, CP, RB, SB);

    input   S, R, CP, RB, SB;

    output   Q, QN;



           reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
 
             U_FRS_P_SB_RB_X_NO inst1 (Q, S, R, CP, RB, SB, NOTIFY_REG);
             U_FRS_P_SB_RB_X_NO_QN inst2 (QN, S, R, CP, RB, SB, NOTIFY_REG);
 
             and  A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (R && RB && SB)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && RB && SB)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && RB && SB)
        (posedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && RB && SB)
        (posedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



       $setuphold(posedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S, NOTIFY_REG);
       $setuphold(posedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R, NOTIFY_REG);

       $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
       $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
       $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
       $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

       $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);
       $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND  RESET . ILLEGAL OUTPUT OCCURS WHEN
              BOTH SET AND RESET ARE ACTIVE .
TRUTHTABLE     : 
          --------------------------------
           S   R   CP  SET RESET  Q    QN 
          --------------------------------
           X   X   X    H    L    H    L

           X   X   X    L    H    L    H

           X   X   X    H    H    X    X
                    _
           L   L  _/    L    L    Q    QN
                    _          
           L   H  _/    L    L    L    H
                    _          
           H   L  _/    L    L    H    L
                    _          
           H   H  _/    L    L    L    L
                  _              
           X   X   \_   L    L    Q    QN
          --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_P_S_R_X (Q, QN, S, R, CP, RESET, SET);

    input   S, R, CP, RESET, SET;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
 
             U_FRS_P_S_R_X inst1 (Q, S, R, CP, RESET, SET);
             U_FRS_P_S_R_X_QN inst2 (QN, S, R, CP, RESET, SET);
 
             nor  N1 (ENABLE, RESET, SET);


    specify


    // Specify path delays

    if (R && !RESET && !SET)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S && !RESET && !SET)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && !RESET && !SET)
        (posedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && !RESET && !SET)
        (posedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (posedge RESET =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge RESET =>  (QN +: 1'b1)) = (1.0, 1.0);
        (posedge SET =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge SET =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 

     
       specparam
        t_SETUP$S  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SET$CP  = 0.0 ,
        t_RELEASE$RESET$CP  = 0.0 ,
        t_PW_H$SET  = 0.0 ,
        t_PW_H$RESET  = 0.0 ;


       $setuphold(posedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S);
       $setuphold(posedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R);

       $width(posedge CP &&& ENABLE, t_PW_H$CP);
       $width(negedge CP &&& ENABLE, t_PW_L$CP); 
       $width(posedge SET, t_PW_H$SET);
       $width(posedge RESET, t_PW_H$RESET);

       $recovery(negedge SET, posedge CP &&& RESET, t_RELEASE$SET$CP);
       $recovery(negedge RESET, posedge CP &&& SET, t_RELEASE$RESET$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED R-S FLIP-FLOP WITH ACTIVE HIGH
              ASYNCHRONOUS SET AND  RESET ILLEGAL OUTPUT OCCURS WHEN
              BOTH SET AND RESET ARE ACTIVE .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
          --------------------------------
           S   R   CP  SET RESET  Q    QN 
          --------------------------------
           X   X   X    H    L    H    L

           X   X   X    L    H    L    H

           X   X   X    H    H    X    X
                    _
           L   L  _/    L    L    Q    QN
                    _          
           L   H  _/    L    L    L    H
                    _          
           H   L  _/    L    L    H    L
                    _          
           H   H  _/    L    L    L    L
                  _              
           X   X   \_   L    L    Q    QN
          --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FRS_P_S_R_X_NO (Q, QN, S, R, CP, RESET, SET);

    input   S, R, CP, RESET, SET;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
 
             U_FRS_P_S_R_X_NO inst1 (Q, S, R, CP, RESET, SET, NOTIFY_REG);
             U_FRS_P_S_R_X_NO_QN inst2 (QN, S, R, CP, RESET, SET, NOTIFY_REG);
 
             nor  N1 (ENABLE, RESET, SET);


    specify


    // Specify path delays

    if (R && !RESET && !SET)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!S  && !RESET && !SET)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S && !RESET && !SET)
        (posedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R && !RESET && !SET)
        (posedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);

        (posedge RESET =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge RESET =>  (QN +: 1'b1)) = (1.0, 1.0);
        (posedge SET =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge SET =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SET$CP  = 0.0 ,
        t_RELEASE$RESET$CP  = 0.0 ,
        t_PW_H$SET  = 0.0 ,
        t_PW_H$RESET  = 0.0 ;


       $setuphold(posedge CP &&& ENABLE, S, t_SETUP$S, t_HOLD$S, NOTIFY_REG);
       $setuphold(posedge CP &&& ENABLE, R, t_SETUP$R, t_HOLD$R, NOTIFY_REG);

       $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG);
       $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
       $width(posedge SET, t_PW_H$SET, 0, NOTIFY_REG);
       $width(posedge RESET, t_PW_H$RESET, 0, NOTIFY_REG);

       $recovery(negedge SET, posedge CP &&& RESET, t_RELEASE$SET$CP, NOTIFY_REG);
       $recovery(negedge RESET, posedge CP &&& SET, t_RELEASE$RESET$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED R-S FLIP-FLOP
TRUTHTABLE     : 
          ------------------------
           S   R   CP    Q    QN 
          ------------------------
                  _
           L   L   \_    H    H
                  _
           L   H   \_    H    L
                  _
           H   L   \_    L    H
                  _
           H   H   \_    Q    QN
                    _
           X   X  _/     Q    QN
          ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FSR_N (Q, QN, S, R, CP);

    input   S, R, CP;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
 
             U_FSR_N inst1 (Q, S, R, CP);
             U_FSR_N_QN inst2 (QN, S, R, CP);


    specify


    // Specify path delays

    if (!S)
        (negedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (R)
        (negedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R)
        (negedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S)
        (negedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

       $setuphold(negedge CP, S, t_SETUP$S, t_HOLD$S);
       $setuphold(negedge CP, R, t_SETUP$R, t_HOLD$R);

       $width(posedge CP, t_PW_H$CP);
       $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED R-S FLIP-FLOP
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
          ------------------------
           S   R   CP    Q    QN 
          ------------------------
                  _
           L   L   \_    H    H
                  _
           L   H   \_    H    L
                  _
           H   L   \_    L    H
                  _
           H   H   \_    Q    QN
                    _
           X   X  _/     Q    QN
          ------------------------


REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FSR_N_NO (Q, QN, S, R, CP);

    input   S, R, CP;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
 
             U_FSR_N_NO inst1 (Q, S, R, CP, NOTIFY_REG);
             U_FSR_N_NO_QN inst2 (QN, S, R, CP, NOTIFY_REG);


    specify


    // Specify path delays

    if (!S)
        (negedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (R)
        (negedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R)
        (negedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S)
        (negedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

       $setuphold(negedge CP, S, t_SETUP$S, t_HOLD$S, NOTIFY_REG);
       $setuphold(negedge CP, R, t_SETUP$R, t_HOLD$R, NOTIFY_REG);

       $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG);
       $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED R-S FLIP-FLOP
TRUTHTABLE     : 
          ------------------------
           S   R   CP    Q    QN 
          ------------------------
                    _
           L   L  _/     H    H
                    _
           L   H  _/     H    L
                    _
           H   L  _/     L    H
                    _
           H   H  _/     Q    QN
                  _
           X   X   \_    Q    QN
          ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FSR_P (Q, QN, S, R, CP);

    input   S, R, CP;

    output   Q, QN;


            parameter vlib_flat_module = 1 ;
 
             U_FSR_P inst1 (Q, S, R, CP);
             U_FSR_P_QN inst2 (QN, S, R, CP);


    specify


    // Specify path delays

    if (!S)
        (posedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (R)
        (posedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

       $setuphold(posedge CP, S, t_SETUP$S, t_HOLD$S);
       $setuphold(posedge CP, R, t_SETUP$R, t_HOLD$R);

       $width(posedge CP, t_PW_H$CP);
       $width(negedge CP, t_PW_L$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED R-S FLIP-FLOP
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
          ------------------------
           S   R   CP    Q    QN 
          ------------------------
                    _
           L   L  _/     H    H
                    _
           L   H  _/     H    L
                    _
           H   L  _/     L    H
                    _
           H   H  _/     Q    QN
                  _
           X   X   \_    Q    QN
          ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FSR_P_NO (Q, QN, S, R, CP);

    input   S, R, CP;

    output   Q, QN;



        reg  NOTIFY_REG ;
            parameter vlib_flat_module = 1 ;
 
             U_FSR_P_NO inst1 (Q, S, R, CP, NOTIFY_REG);
             U_FSR_P_NO_QN inst2 (QN, S, R, CP, NOTIFY_REG);


    specify


    // Specify path delays

    if (!S)
        (posedge CP =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (R)
        (posedge CP =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!R)
        (posedge CP =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S)
        (posedge CP =>  (Q +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



      
       specparam
        t_SETUP$S  = 0.0 ,
        t_HOLD$S  = 0.0 ,
        t_SETUP$R  = 0.0 ,
        t_HOLD$R  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

       $setuphold(posedge CP, S, t_SETUP$S, t_HOLD$S, NOTIFY_REG);
       $setuphold(posedge CP, R, t_SETUP$R, t_HOLD$R, NOTIFY_REG);

       $width(posedge CP, t_PW_H$CP, 0, NOTIFY_REG);
       $width(negedge CP, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
            _                          
             \_    H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    L     L    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_N_RB_SB (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;


             parameter vlib_flat_module = 1 ;

             U_FT_N_RB_SB inst1
                   (Q, CP, RB, SB);
             U_FT_N_RB_SB_QN inst2
                   (QN, CP, RB, SB);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
            _                          
             \_    H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    L     L    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_N_RB_SB_NO (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
             parameter vlib_flat_module = 1 ;

             U_FT_N_RB_SB_NO inst1
                   (Q, CP, RB, SB, NOTIFY_REG);
             U_FT_N_RB_SB_NO_QN inst2
                   (QN, CP, RB, SB, NOTIFY_REG);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET. ILLEGAL OUTPUT OCCURS WHEN BOTH
              CLEAR AND PRESET ARE ACTIVE
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
            _                          
             \_    H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    X     X    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_N_RB_SB_X (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;


             parameter vlib_flat_module = 1 ;

             U_FT_N_RB_SB_X 
                inst1 (Q_int, CP, RB, SB);

             buf
                inst2 ( Q, Q_int );
           
             not
                inst3 ( QN, Q_int );

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);


    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET. ILLEGAL OUTPUT OCCURS WHEN BOTH
              CLEAR AND PRESET ARE ACTIVE
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
            _                          
             \_    H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    X     X    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_N_RB_SB_X_NO (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
             parameter vlib_flat_module = 1 ;

             U_FT_N_RB_SB_X_NO 
                 inst1 (Q_int, CP, RB, SB, NOTIFY_REG);
             
             buf
                inst2 ( Q, Q_int );

             not
                inst3 ( QN, Q_int );

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
            _                          
             \_    H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    H     H    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_N_SB_RB (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;


             parameter vlib_flat_module = 1 ;

             U_FT_N_SB_RB inst1
                   (Q, CP, RB, SB);
             U_FT_N_SB_RB_QN inst2
                   (QN, CP, RB, SB);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);


    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
            _                          
             \_    H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    H     H    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_N_SB_RB_NO (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
             parameter vlib_flat_module = 1 ;

             U_FT_N_SB_RB_NO inst1
                   (Q, CP, RB, SB, NOTIFY_REG);
             U_FT_N_SB_RB_NO_QN inst2
                   (QN, CP, RB, SB, NOTIFY_REG);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH TOGGLE ENABLE
              AND ACTIVE LOW  ASYNCHRONOUS CLEAR AND PRESET
TRUTHTABLE     : 
           ---------------------------------  
            TE    CP     RB    SB   Q     QN    
           ---------------------------------  
                  _                          
             H     \_    H     H    QN    Q   
                    _
             H    _/     H     H    Q     QN   
                                               
             L     X     H     H    Q     QN    

             X     X     L     H    L     H    
                                               
             X     X     H     L    H     L    
                                               
             X     X     L     L    L     L    
           ---------------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_N_TE_RB_SB (Q, QN, TE, CP, RB, SB);

    input   TE, CP, RB, SB;

    output   Q, QN;



             parameter vlib_flat_module = 1 ;

             U_FT_N_TE_RB_SB inst1
                   (Q, TE, CP, RB, SB);
             U_FT_N_TE_RB_SB_QN inst2
                   (QN, TE, CP, RB, SB);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 




    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NEGATIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH TOGGLE ENABLE
              AND ACTIVE LOW  ASYNCHRONOUS CLEAR AND PRESET
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ---------------------------------  
            TE    CP     RB    SB   Q     QN    
           ---------------------------------  
                  _                          
             H     \_    H     H    QN    Q   
                    _
             H    _/     H     H    Q     QN   
                                               
             L     X     H     H    Q     QN    

             X     X     L     H    L     H    
                                               
             X     X     H     L    H     L    
                                               
             X     X     L     L    L     L    
           ---------------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_N_TE_RB_SB_NO (Q, QN, TE, CP, RB, SB);

    input   TE, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
             parameter vlib_flat_module = 1 ;

             U_FT_N_TE_RB_SB_NO inst1
                   (Q, TE, CP, RB, SB, NOTIFY_REG);
             U_FT_N_TE_RB_SB_NO_QN inst2
                   (QN, TE, CP, RB, SB, NOTIFY_REG);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (negedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (negedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge RB, negedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, negedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP-FLOP WITH PARALLEL LOAD .
TRUTHTABLE     : 
              --------------------------- 
               CP     PD   PLD   Q    QN   
              --------------------------- 
                 _                         
               _/     X     H    QN    Q                   _                                                       
                \_    X     H    Q    QN                                                                           
                X     L     L    L     H                                             
                X     H     L    H     L   
              --------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_PLD (Q, QN, CP, PD, PLD);

    input   CP, PD, PLD;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;

        U_FT_P_PLD 
           inst1 (Q_int, CP, PD, PLD);

        buf
           inst2 ( Q, Q_int );

        not
           inst3 ( QN, Q_int );



    specify


    // Specify path delays

    if (PLD)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (PLD)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!PLD)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD)
        (PD -=> QN ) = (1.0, 1.0);

        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;

    $setuphold(posedge PLD, PD, t_SETUP$PD, t_HOLD$PD);

    $width(posedge CP &&& PLD, t_PW_H$CP); 
    $width(negedge CP &&& PLD, t_PW_L$CP); 
    $width(negedge PLD , t_PW_L$PLD);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP-FLOP WITH PARALLEL LOAD .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              --------------------------- 
               CP     PD   PLD   Q    QN   
              --------------------------- 
                 _                         
               _/     X     H    QN    Q                   _                                                       
                \_    X     H    Q    QN                                                                           
                X     L     L    L     H                                             
                X     H     L    H     L   
              --------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_PLD_NO (Q, QN, CP, PD, PLD);

    input   CP, PD, PLD;

    output   Q, QN;



        reg  NOTIFY_REG ;

        parameter vlib_flat_module = 1 ;

        U_FT_P_PLD_NO 
            inst1 (Q_int, CP, PD, PLD, NOTIFY_REG);

        buf
            inst2 ( Q, Q_int );

        not
            inst3 ( QN, Q_int );



    specify


    // Specify path delays

    if (PLD)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (PLD)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!PLD)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD)
        (PD -=> QN ) = (1.0, 1.0);

        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;

    $setuphold(posedge PLD, PD, t_SETUP$PD, t_HOLD$PD, NOTIFY_REG);

    $width(posedge CP &&& PLD, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& PLD, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge PLD , t_PW_L$PLD, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH 
              ACTIVE LOW ASYNCHRONOUS CLEAR .
TRUTHTABLE     : 
           --------------------
            CP     RB   Q   QN
           --------------------
              _
            _/     H    QN   Q
           
             X     L    L    H
           --------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_RB (Q, QN, CP, RB);

    input   CP, RB;

    output   Q, QN;



    parameter vlib_flat_module = 1 ;

    U_FT_P_RB  
        inst1 ( Q_int, CP, RB);

    buf
        inst2 ( Q, Q_int );

    not
        inst3 ( QN, Q_int );


    specify


    // Specify path delays

    if (RB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $width(posedge CP &&& RB, t_PW_H$CP); 
    $width(negedge CP &&& RB, t_PW_L$CP); 
    $width(negedge RB, t_PW_L$RB); 

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH 
              ACTIVE LOW ASYNCHRONOUS CLEAR .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           --------------------
            CP     RB   Q   QN
           --------------------
              _
            _/     H    QN   Q
           
             X     L    L    H
           --------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_RB_NO (Q, QN, CP, RB);

    input   CP, RB;

    output   Q, QN;



        reg  NOTIFY_REG ;

    parameter vlib_flat_module = 1 ;

    U_FT_P_RB_NO  
        inst1 ( Q_int, CP, RB, NOTIFY_REG);

    buf
        inst2 ( Q, Q_int );

    not
        inst3 ( QN, Q_int );

    specify


    // Specify path delays

    if (RB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!RB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!RB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP-FLOP
              WITH ACTIVE LOW ASYNCHRONOUS CLEAR AND PARALLEL LOAD .
TRUTHTABLE     : 
             ------------------------------- 
               CP    PD   PLD  RB   Q    QN   
             ------------------------------- 
                _                             
              _/     X     H   H    QN    Q                                                                              
               X     X     H   H    Q    QN                  _                                                           
               \_    X     X   H    Q    QN                                                                              
               X     X     X   L    L     H   
                                                                         
               X     L     L   H    L     H                                                
               X     H     L   H    H     L   
             ------------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_RB_PLD (Q, QN, CP, PD, PLD, RB);

    input   CP, PD, PLD, RB;

    output   Q, QN;



        parameter vlib_flat_module = 1 ;

        U_FT_P_RB_PLD 
            inst1 ( Q_int, CP, PD, PLD, RB);

        buf
            inst2 ( Q, Q_int );
  
        not
            inst3 ( QN, Q_int );

    specify


    // Specify path delays

    if (PLD && RB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (PLD && RB)
        (posedge CP =>  (QN +: QN)) = (1.0, 1.0);

    if (!PLD && RB)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD && RB)
        (PD -=> QN ) = (1.0, 1.0);

    if (RB)
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
    if (RB)
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);

    if (!PLD)
        (posedge RB => (Q +: PD)) = (1.0, 1.0);
    if (!PLD)
        (posedge RB => (QN -: PD)) = (1.0, 1.0);
    
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;

    
    $setuphold(posedge PLD &&& RB, PD, t_SETUP$PD, t_HOLD$PD);

    $width(posedge CP &&& RB, t_PW_H$CP); 
    $width(negedge CP &&& RB, t_PW_L$CP); 
    $width(negedge RB, t_PW_L$RB); 
    $width(negedge PLD &&& RB, t_PW_L$PLD);

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP-FLOP
              WITH ACTIVE LOW ASYNCHRONOUS CLEAR AND PARALLEL LOAD .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
             ------------------------------- 
               CP    PD   PLD  RB   Q    QN   
             ------------------------------- 
                _                             
              _/     X     H   H    QN    Q                                                                              
               X     X     H   H    Q    QN                  _                                                           
               \_    X     X   H    Q    QN                                                                              
               X     X     X   L    L     H   
                                                                         
               X     L     L   H    L     H                                                
               X     H     L   H    H     L   
             ------------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_RB_PLD_NO (Q, QN, CP, PD, PLD, RB);

    input   CP, PD, PLD, RB;

    output   Q, QN;



        reg  NOTIFY_REG ;

        parameter vlib_flat_module = 1 ;

        U_FT_P_RB_PLD_NO 
           inst1 ( Q_int, CP, PD, PLD, RB, NOTIFY_REG);

        buf
           inst2 ( Q, Q_int );

        not
           inst3 ( QN, Q_int );




    specify


    // Specify path delays

    if (PLD && RB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (PLD && RB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!PLD && RB)
        (PD +=> Q ) = (1.0, 1.0);
    if (!PLD && RB)
        (PD -=> QN ) = (1.0, 1.0);

    if (RB)
        (negedge PLD =>  (Q +: PD)) = (1.0, 1.0);
    if (RB)
        (negedge PLD =>  (QN -: PD)) = (1.0, 1.0);

    if (!PLD)
        (posedge RB => (Q +: PD)) = (1.0, 1.0);
    if (!PLD)
        (posedge RB => (QN -: PD)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;

    
    $setuphold(posedge PLD &&& RB, PD, t_SETUP$PD, t_HOLD$PD, NOTIFY_REG);

    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 
    $width(negedge PLD &&& RB, t_PW_L$PLD, 0, NOTIFY_REG);

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
              _                          
            _/     H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    L     L    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_RB_SB (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;


             parameter vlib_flat_module = 1 ;

             U_FT_P_RB_SB inst1
                   (Q, CP, RB, SB);
             U_FT_P_RB_SB_QN inst2
                   (QN, CP, RB, SB);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);


    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
              _                          
            _/     H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    L     L    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_RB_SB_NO (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
             parameter vlib_flat_module = 1 ;

             U_FT_P_RB_SB_NO inst1
                   (Q, CP, RB, SB, NOTIFY_REG);
             U_FT_P_RB_SB_NO_QN inst2
                   (QN, CP, RB, SB, NOTIFY_REG);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET. ILLEGAL OUTPUT OCCURS WHEN BOTH
              CLEAR AND PRESET ARE ACTIVE
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
              _                          
            _/     H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    X     X    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_RB_SB_X (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;


             parameter vlib_flat_module = 1 ;

             U_FT_P_RB_SB_X 
                inst1 ( Q_int, CP, RB, SB);

             buf
                inst2 ( Q, Q_int );
            
             not
                inst3 ( QN, Q_int );


             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);


    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET. ILLEGAL OUTPUT OCCURS WHEN BOTH
              CLEAR AND PRESET ARE ACTIVE
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
              _                          
            _/     H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    X     X    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_RB_SB_X_NO (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
             parameter vlib_flat_module = 1 ;

             U_FT_P_RB_SB_X_NO 
                 inst1 ( Q_int, CP, RB, SB, NOTIFY_REG);

             buf
                 inst2 ( Q, Q_int );

             not
                 inst3 ( QN, Q_int );


             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH
              ASYNCHRONOUS SET ( ACTIVE LOW ) .
TRUTHTABLE     : 
           --------------------
            CP     SB   Q   QN
           --------------------
              _
            _/     H    QN   Q
           
             X     L    H    L
           --------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_SB (Q, QN, CP, SB);

    input   CP, SB;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;
  


    U_FT_P_SB  
        inst1 ( Q_int, CP, SB);

    buf
        inst2 ( Q, Q_int );

    not
        inst3 ( QN, Q_int );



    specify


    // Specify path delays

    if (SB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (SB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;


    $width(posedge CP &&& SB, t_PW_H$CP); 
    $width(negedge CP &&& SB, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB); 

    $recovery(posedge SB, posedge CP, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH
              ASYNCHRONOUS SET ( ACTIVE LOW ) .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           --------------------
            CP     SB   Q   QN
           --------------------
              _
            _/     H    QN   Q
           
             X     L    H    L
           --------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_SB_NO (Q, QN, CP, SB);

    input   CP, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;
  


    U_FT_P_SB_NO   
        inst1 ( Q_int, CP, SB, NOTIFY_REG);

    buf
        inst2 ( Q, Q_int );

    not
        inst3 ( QN, Q_int );

    specify


    // Specify path delays

    if (SB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (SB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!SB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!SB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ;


    $width(posedge CP &&& SB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& SB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 

    $recovery(posedge SB, posedge CP, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
              _                          
            _/     H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    H     H    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_SB_RB (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;


             parameter vlib_flat_module = 1 ;

             U_FT_P_SB_RB inst1
                   (Q, CP, RB, SB);
             U_FT_P_SB_RB_QN inst2
                   (QN, CP, RB, SB);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);


    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH ACTIVE LOW
              ASYNCHRONOUS CLEAR AND PRESET
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ---------------------------  
            CP     RB    SB   Q     QN    
           ---------------------------  
              _                          
            _/     H     H    QN    Q   
                                         
             X     L     H    L     H    
                                         
             X     H     L    H     L    
                                         
             X     L     L    H     H    
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_SB_RB_NO (Q, QN, CP, RB, SB);

    input   CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
             parameter vlib_flat_module = 1 ;

             U_FT_P_SB_RB_NO inst1
                   (Q, CP, RB, SB, NOTIFY_REG);
             U_FT_P_SB_RB_NO_QN inst2
                   (QN, CP, RB, SB, NOTIFY_REG);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;

    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP-FLOP WITH
              TOGGLE ENABLE AND  PARALLEL LOAD .
TRUTHTABLE     : 
              -------------------------------- 
               TE   CP     PD   PLD   Q    QN   
              -------------------------------- 
                      _                         
               H    _/     X     L    QN    Q                                                                                
               L     X     X     L    Q    QN                        _                                                       
               X     \_    X     L    Q    QN                                                                                
               X     X     L     H    L     H                                                  
               X     X     H     H    H     L   
              -------------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_TE_PLD (Q, QN, TE, CP, PD, PLD);

    input   TE, CP, PD, PLD;

    output   Q, QN;



        parameter vlib_flat_module = 1 ;

        U_FT_P_TE_PLD 
           inst1 ( Q_int, TE, CP, PD, PLD);

        buf
           inst2 ( Q, Q_int );

        not
           inst3 ( QN, Q_int );

    specify


    // Specify path delays

    if (!PLD)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (!PLD)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (PLD)
        (PD +=> Q ) = (1.0, 1.0);
    if (PLD)
        (PD -=> QN ) = (1.0, 1.0);

        (posedge PLD =>  (Q +: PD)) = (1.0, 1.0);
        (posedge PLD =>  (QN -: PD)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;

    $setuphold(negedge PLD, PD, t_SETUP$PD, t_HOLD$PD);

    $width(posedge CP &&& ~PLD, t_PW_H$CP); 
    $width(negedge CP &&& ~PLD, t_PW_L$CP); 
    $width(posedge PLD , t_PW_L$PLD);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP-FLOP WITH
              TOGGLE ENABLE AND  PARALLEL LOAD .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              -------------------------------- 
               TE   CP     PD   PLD   Q    QN   
              -------------------------------- 
                      _                         
               H    _/     X     L    QN    Q                                                                                
               L     X     X     L    Q    QN                        _                                                       
               X     \_    X     L    Q    QN                                                                                
               X     X     L     H    L     H                                                  
               X     X     H     H    H     L   
              -------------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_TE_PLD_NO (Q, QN, TE, CP, PD, PLD);

    input   TE, CP, PD, PLD;

    output   Q, QN;



        reg  NOTIFY_REG ;

        parameter vlib_flat_module = 1 ;

        U_FT_P_TE_PLD_NO 
           inst1 ( Q_int, TE, CP, PD, PLD, NOTIFY_REG);

        buf
           inst2 ( Q, Q_int );

        not
           inst3 ( QN, Q_int );


    specify


    // Specify path delays

    if (!PLD)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (!PLD)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (PLD)
        (PD +=> Q ) = (1.0, 1.0);
    if (PLD)
        (PD -=> QN ) = (1.0, 1.0);

        (posedge PLD =>  (Q +: PD)) = (1.0, 1.0);
        (posedge PLD =>  (QN -: PD)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_PW_L$PLD  = 0.0 ;

    $setuphold(negedge PLD, PD, t_SETUP$PD, t_HOLD$PD, NOTIFY_REG);

    $width(posedge CP &&& ~PLD, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ~PLD, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(posedge PLD ,t_PW_L$PLD, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH TOGGLE ENABLE
              AND ACTIVE LOW  ASYNCHRONOUS CLEAR 
TRUTHTABLE     : 
           ---------------------------  
            TE    CP     RB   Q     QN    
           ---------------------------  
                    _                    
             H    _/     H    QN    Q   
                  _
             H     \_    H    Q     QN   
                                         
             L     X     H    Q     QN    

             X     X     L    L     H    
                                         
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_TE_RB (Q, QN, TE, CP, RB);

    input   TE, CP, RB;

    output   Q, QN;


             parameter vlib_flat_module = 1 ;

             U_FT_P_TE_RB 
                inst1 ( Q_int, TE, CP, RB);

             buf
                inst2 ( Q, Q_int );

             not
                inst3 ( QN, Q_int );

    specify


    // Specify path delays

    if (RB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $width(posedge CP &&& RB, t_PW_H$CP); 
    $width(negedge CP &&& RB, t_PW_L$CP); 
    $width(negedge RB, t_PW_L$RB); 

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH TOGGLE ENABLE
              AND ACTIVE LOW  ASYNCHRONOUS CLEAR 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ---------------------------  
            TE    CP     RB   Q     QN    
           ---------------------------  
                    _                    
             H    _/     H    QN    Q   
                  _
             H     \_    H    Q     QN   
                                         
             L     X     H    Q     QN    

             X     X     L    L     H    
                                         
           ---------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_TE_RB_NO (Q, QN, TE, CP, RB);

    input   TE, CP, RB;

    output   Q, QN;



        reg  NOTIFY_REG ;
             parameter vlib_flat_module = 1 ;

             U_FT_P_TE_RB_NO 
                inst1 ( Q_int, TE, CP, RB, NOTIFY_REG);

             buf
                inst2 ( Q, Q_int );

             not
                inst3 ( QN, Q_int );

    specify


    // Specify path delays

    if (RB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP-FLOP WITH
              TOGGLE ENABLE AND ACTIVE LOW ASYNCHRONOUS CLEAR
              AND SYNCHRONOUS PARALLEL LOAD .
TRUTHTABLE     : 
              ------------------------------------ 
               TE   CP     PD   PLD  RB   Q    QN   
              ------------------------------------ 
                      _                             
               H    _/     X     H   H    QN    Q                                                                                    
               L     X     X     H   H    Q    QN                        _                                                           
               X     \_    X     X   H    Q    QN                                                                                    
               X     X     X     X   L    L     H   
                      _                                                         
               X    _/     L     L   H    L     H                          _                             
               X    _/     H     L   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_TE_RB_PLDC (Q, QN, TE, CP, PD, PLD, RB);

    input   TE, CP, PD, PLD, RB;

    output   Q, QN;



        parameter vlib_flat_module = 1 ;

        U_FT_P_TE_RB_PLDC 
           inst1 ( Q_int, TE, CP, PD, PLD, RB);

        buf
           inst2 ( Q, Q_int );

        not
           inst3 ( QN, Q_int );


        not    N1  (PLD_ , PLD);

        and    A1  (EN_PD, RB, PLD_);


    specify


    // Specify path delays

    if (PLD && RB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (PLD && RB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!PLD && RB)
        (posedge CP =>  (Q +: PD)) = (1.0, 1.0);
    if (!PLD && RB)
        (posedge CP =>  (QN -: PD)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(posedge CP &&& EN_PD, PD, t_SETUP$PD, t_HOLD$PD);

    $width(posedge CP &&& RB, t_PW_H$CP); 
    $width(negedge CP &&& RB, t_PW_L$CP); 
    $width(negedge RB, t_PW_L$RB); 

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP-FLOP WITH
              TOGGLE ENABLE AND ACTIVE LOW ASYNCHRONOUS CLEAR
              AND SYNCHRONOUS PARALLEL LOAD .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
              ------------------------------------ 
               TE   CP     PD   PLD  RB   Q    QN   
              ------------------------------------ 
                      _                             
               H    _/     X     H   H    QN    Q                                                                                    
               L     X     X     H   H    Q    QN                        _                                                           
               X     \_    X     X   H    Q    QN                                                                                    
               X     X     X     X   L    L     H   
                      _                                                         
               X    _/     L     L   H    L     H                          _                             
               X    _/     H     L   H    H     L   
              ------------------------------------ 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_TE_RB_PLDC_NO (Q, QN, TE, CP, PD, PLD, RB);

    input   TE, CP, PD, PLD, RB;

    output   Q, QN;



        reg  NOTIFY_REG ;

        parameter vlib_flat_module = 1 ;

        U_FT_P_TE_RB_PLDC_NO
           inst1 ( Q_int, TE, CP, PD, PLD, RB, NOTIFY_REG);

        buf
           inst2 ( Q, Q_int );

        not
           inst3 ( QN, Q_int );


        not    N1  (PLD_ , PLD);

        and    A1  (EN_PD, RB, PLD_);


    specify


    // Specify path delays

    if (PLD && RB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (PLD && RB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

    if (!PLD && RB)
        (posedge CP =>  (Q +: PD)) = (1.0, 1.0);
    if (!PLD && RB)
        (posedge CP =>  (QN -: PD)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$PD  = 0.0 ,
        t_HOLD$PD  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(posedge CP &&& EN_PD, PD, t_SETUP$PD, t_HOLD$PD, NOTIFY_REG);

    $width(posedge CP &&& RB, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& RB, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery(posedge RB, posedge CP, t_RELEASE$RB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH TOGGLE ENABLE
              AND ACTIVE LOW  ASYNCHRONOUS CLEAR AND PRESET
TRUTHTABLE     : 
           ---------------------------------  
            TE    CP     RB    SB   Q     QN    
           ---------------------------------  
                    _                          
             H    _/     H     H    QN    Q   
                  _
             H     \_    H     H    Q     QN   
                                               
             L     X     H     H    Q     QN    

             X     X     L     H    L     H    
                                               
             X     X     H     L    H     L    
                                               
             X     X     L     L    L     L    
           ---------------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_TE_RB_SB (Q, QN, TE, CP, RB, SB);

    input   TE, CP, RB, SB;

    output   Q, QN;


             parameter vlib_flat_module = 1 ;

             U_FT_P_TE_RB_SB inst1
                   (Q, TE, CP, RB, SB);
             U_FT_P_TE_RB_SB_QN inst2
                   (QN, TE, CP, RB, SB);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $width(posedge CP &&& ENABLE, t_PW_H$CP); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);


    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH TOGGLE ENABLE
              AND ACTIVE LOW  ASYNCHRONOUS CLEAR AND PRESET
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
           ---------------------------------  
            TE    CP     RB    SB   Q     QN    
           ---------------------------------  
                    _                          
             H    _/     H     H    QN    Q   
                  _
             H     \_    H     H    Q     QN   
                                               
             L     X     H     H    Q     QN    

             X     X     L     H    L     H    
                                               
             X     X     H     L    H     L    
                                               
             X     X     L     L    L     L    
           ---------------------------------  
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_FT_P_TE_RB_SB_NO (Q, QN, TE, CP, RB, SB);

    input   TE, CP, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
             parameter vlib_flat_module = 1 ;

             U_FT_P_TE_RB_SB_NO inst1
                   (Q, TE, CP, RB, SB, NOTIFY_REG);
             U_FT_P_TE_RB_SB_NO_QN inst2
                   (QN, TE, CP, RB, SB, NOTIFY_REG);

             and A1 (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (RB && SB)
        (posedge CP =>  (Q +: QN)) = (1.0, 1.0);
    if (RB && SB)
        (posedge CP =>  (QN +: Q)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (SB)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ,
        t_RELEASE$RB$CP  = 0.0 ,
        t_RELEASE$SB$CP  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $width(posedge CP &&& ENABLE, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge CP &&& ENABLE, t_PW_L$CP, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge RB, posedge CP &&& SB, t_RELEASE$RB$CP, NOTIFY_REG);
    $recovery(posedge SB, posedge CP &&& RB, t_RELEASE$SB$CP, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : HALF ADDER
TRUTHTABLE     : 

        -------------------
         A    B     S   CO 
        -------------------
        
         L    L     L   L
     
         L    H     H   L
    
         H    L     H   L
    
         H    H     L   H
        ------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_HALF_ADDR (S, CO, A, B);

    input   A, B;

    output   S, CO;


        parameter vlib_flat_module = 1 ;
       xor (S, A, B);
       and (CO, A, B);


    specify


    // Specify path delays

        (A => S ) = (1.0, 1.0);
        (B => S ) = (1.0, 1.0);
        (A => CO ) = (1.0, 1.0);
        (B => CO ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : TO IMPLEMENT THE LOGIC EQUATION  YN = ~( ~A & ~B & C )
TRUTHTABLE     : 
     --------------------
      A    B    C    Z
     -------------------- 
      H    X    X    H
 
      X    H    X    H

      X    X    L    H

      L    L    H    L
     --------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_IAI_2_3 (Z, A, B, C);

    input   A, B, C;

    output   Z;


  
         parameter vlib_flat_module = 1 ;

         U_IAI_2_3 inst1 (Z, A, B, C);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : TO IMPLEMENT THE LOGIC EQUATION  Z = ~( A & ~B || C & D ) 
TRUTHTABLE     : 
        ------------------------
         A    B    C    D    Z
        ------------------------
         H    L    X    X    L
         X    X    H    H    L
         L    X    L    X    H
         L    X    X    L    H
         X    H    L    X    H
         X    H    X    L    H
        -------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_IAOI_2_2 (Z, A, B, C, D);

    input   A, B, C, D;

    output   Z;


  
         parameter vlib_flat_module = 1 ;

         U_IAOI_2_2 inst1 (Z, A, B, C, D);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : TO IMPLEMENT THE LOGIC EQUATION  Z = ( A & ~B || C & D ) 
TRUTHTABLE     : 
        ------------------------
         A    B    C    D    Z
        ------------------------
         H    L    X    X    H
         X    X    H    H    H
         L    X    L    X    L
         L    X    X    L    L
         X    H    L    X    L
         X    H    X    L    L
        -------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_IAO_2_2 (Z, A, B, C, D);

    input   A, B, C, D;

    output   Z;


  
         parameter vlib_flat_module = 1 ;

         U_IAO_2_2 inst1 (Z, A, B, C, D);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
        (D +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : TO IMPLEMENT THE LOGIC EQUATION  Z = ( ~A & ~B & C )
TRUTHTABLE     : 
     --------------------
      A    B    C    Z
     -------------------- 
      H    X    X    L
 
      X    H    X    L

      X    X    L    L

      L    L    H    H
     --------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_IA_2_3 (Z, A, B, C);

    input   A, B, C;

    output   Z;


  
         parameter vlib_flat_module = 1 ;

         U_IA_2_3 inst1 (Z, A, B, C);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW  
TRUTHTABLE     : 
         -------------------   
         D    GN      Q   QN    
         -------------------   
         L    L       L   H    
         H    L       H   L    
         X    H       Q   QN    
         --------------------   
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N (Q, QN, D, GN);

    input   D, GN;

    output   Q, QN;



        parameter vlib_flat_module = 1 ;


    U_LD_N    inst1 (Q_int, D, GN);

    buf  (Q, Q_int);

    not  (QN, Q_int); 

    specify


    // Specify path delays

    if (!GN)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN)
        (D -=> QN ) = (1.0, 1.0);
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ;

    $setuphold(posedge GN, D, t_SETUP$D, t_HOLD$D);

    $width(posedge GN, t_PW_H$GN); 
    $width(negedge GN, t_PW_L$GN);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : D-LATCH WITH ACTIVE LOW GATE & GATE ENABLE
TRUTHTABLE     :

            ----------------------
             D   G  E      Q    QN
            ----------------------
             0   0  0      0    1
             1   0  0      1    0
             x   1  x      No change
             x   x  1      No change
            ----------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_LD_N_CEB_NO (Q, QN, D, E, G);

    input  D, E, G;

    output Q, QN;


    reg  NOTIFY_REG ;

    U_LD_N_CEB_NO inst1 (Q_int, D, G, E, NOTIFY_REG);

    buf          BU1   (Q, Q_int);
    not          NT1   (QN, Q_int);

    specify


    // Specify path delays

    if (!G && !E)
    (D +=> Q) = (1.0, 1.0);

    if (!E)
    (negedge G => (Q +: D)) = (1.0, 1.0);

    if (!G)
    (negedge E => (Q +: D)) = (1.0, 1.0);

    if (!G && !E)
    (D -=> QN) = (1.0, 1.0);

    if (!E)
    (negedge G => (QN -: D)) = (1.0, 1.0);

    if (!G)
    (negedge E => (QN -: D)) = (1.0, 1.0);

    // Timing checks 

    specparam
        t_SETUP$D = 0.0,
        t_HOLD$D  = 0.0,
        t_SETUP$E = 0.0,
        t_HOLD$E  = 0.0,
        t_PW_L$G  = 0.0,
        t_PW_L$E  = 0.0;

    $setuphold(posedge G &&& (~E), D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(negedge E, posedge G, t_SETUP$E, NOTIFY_REG);
    $hold(posedge G, posedge E, t_HOLD$E, NOTIFY_REG);

    $width(negedge G &&& (~E), t_PW_L$G, 0, NOTIFY_REG); 
    $width(negedge E, t_PW_L$E, 0, NOTIFY_REG); 

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : D-LATCH WITH ACTIVE LOW GATE, ACTIVE LOW GATE ENABLE & ACTIVE LOW RESET
TRUTHTABLE     :

            ------------------------
             D   G  E  RB   Q    QN
            ------------------------
             0   0  0  1    0    1
             1   0  0  1    1    0
             x   1  x  1    No change
             x   x  1  1    No change
             x   x  x  0    0    1
            ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_LD_N_CEB_RB_NO (Q, QN, D, E, G, RB);

    input  D, E, G, RB;

    output Q, QN;


    reg  NOTIFY_REG ;

    U_LD_N_CEB_RB_NO inst1 (Q_int, D, G, E, RB, NOTIFY_REG);

    buf          BU1   (Q, Q_int);
    not          NT1   (QN, Q_int);

    not         NR1   (EB, E);
    and         AN1   (ENABLE, RB, EB);

    specify


    // Specify path delays

    if (!G && !E && RB)
    (D +=> Q) = (1.0, 1.0);

    if (!E && RB)
    (negedge G => (Q +: D)) = (1.0, 1.0);

    if (!G && RB)
    (negedge E => (Q +: D)) = (1.0, 1.0);

    (negedge RB => (Q +: 1'b0)) = (1.0, 1.0);

    if (!G && !E)
    (posedge RB => (Q +: D)) = (1.0, 1.0);

    if (!G && !E && RB)
    (D -=> QN) = (1.0, 1.0);

    if (!E && RB)
    (negedge G => (QN -: D)) = (1.0, 1.0);

    if (!G && RB)
    (negedge E => (QN -: D)) = (1.0, 1.0);

    (negedge RB => (QN +: 1'b1)) = (1.0, 1.0);

    if (!G && !E)
    (posedge RB => (QN -: D)) = (1.0, 1.0);


    // Timing checks 

    specparam
        t_SETUP$D = 0.0,
        t_HOLD$D  = 0.0,
        t_SETUP$E = 0.0,
        t_HOLD$E  = 0.0,
        t_PW_L$G  = 0.0,
        t_PW_L$RB = 0.0,
        t_PW_L$E  = 0.0,
        t_RELEASE$RB$G = 0.0;

    $setuphold(posedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(negedge E, posedge G &&& RB, t_SETUP$E, NOTIFY_REG);
    $hold(posedge G, posedge E &&& RB, t_HOLD$E, NOTIFY_REG);

    $width(negedge G &&& ENABLE, t_PW_L$G, 0, NOTIFY_REG); 
    $width(posedge E &&& RB, t_PW_L$E, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

    $recovery (posedge RB, posedge G &&& EB, t_RELEASE$RB$G, NOTIFY_REG);

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : D-LATCH WITH ACTIVE LOW GATE, ACTIVE LOW GATE ENABLE & ACTIVE HIGH RESET
TRUTHTABLE     :

            ------------------------
             D   G  E  R    Q    QN
            ------------------------
             0   0  0  0    0    1
             1   0  0  0    1    0
             x   1  x  0    No change
             x   x  1  0    No change
             x   x  x  1    0    1
            ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_LD_N_CEB_R_NO (Q, QN, D, E, G, R);

    input  D, E, G, R;

    output Q, QN;


    reg  NOTIFY_REG ;

    U_LD_N_CEB_R_NO inst1 (Q_int, D, G, E, R, NOTIFY_REG);

    buf          BU1   (Q, Q_int);
    not          NT1   (QN, Q_int);

    nor         NR1   (ENABLE, R, E);

    specify


    // Specify path delays

    if (!G && !E && !R)
    (D +=> Q) = (1.0, 1.0);

    if (!E && !R)
    (negedge G => (Q +: D)) = (1.0, 1.0);

    if (!G && !R)
    (negedge E => (Q +: D)) = (1.0, 1.0);

    (posedge R => (Q +: 1'b0)) = (1.0, 1.0);

    if (!G && !E)
    (negedge R => (Q +: D)) = (1.0, 1.0);

    if (!G && !E && !R)
    (D -=> QN) = (1.0, 1.0);

    if (!E && !R)
    (negedge G => (QN -: D)) = (1.0, 1.0);

    if (!G && !R)
    (negedge E => (QN -: D)) = (1.0, 1.0);

    (posedge R => (QN +: 1'b1)) = (1.0, 1.0);

    if (!G && !E)
    (negedge R => (QN -: D)) = (1.0, 1.0);


    // Timing checks 

    specparam
        t_SETUP$D = 0.0,
        t_HOLD$D  = 0.0,
        t_SETUP$E = 0.0,
        t_HOLD$E  = 0.0,
        t_PW_L$G  = 0.0,
        t_PW_H$R  = 0.0,
        t_PW_L$E  = 0.0,
        t_RELEASE$R$G = 0.0;

    $setuphold(posedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(negedge E, posedge G &&& (~R), t_SETUP$E, NOTIFY_REG);
    $hold(posedge G, posedge E &&& (~R), t_HOLD$E, NOTIFY_REG);

    $width(negedge G &&& ENABLE, t_PW_L$G, 0, NOTIFY_REG); 
    $width(posedge E &&& (~R), t_PW_L$E, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery (negedge R, posedge G &&& (~E), t_RELEASE$R$G, NOTIFY_REG);

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : D-LATCH WITH ACTIVE LOW GATE, ACTIVE HIGH GATE ENABLE & ACTIVE LOW SET
TRUTHTABLE     :

            ------------------------
             D   G  E  SB   Q    QN
            ------------------------
             0   0  0  1    0    1
             1   0  0  1    1    0
             x   1  x  1    No change
             x   x  1  1    No change
             x   x  x  0    1    0
            ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_LD_N_CEB_SB_NO (Q, QN, D, E, G, SB);

    input  D, E, G, SB;

    output Q, QN;


    reg  NOTIFY_REG ;

    U_LD_N_CEB_SB_NO inst1 (Q_int, D, G, E, SB, NOTIFY_REG);

    buf          BU1   (Q, Q_int);
    not          NT1   (QN, Q_int);

    not          NT2   (EB, E);
    and          AN1   (ENABLE, SB, EB);


    specify


    // Specify path delays

    if (!G && !E && SB)
    (D +=> Q) = (1.0, 1.0);

    if (!E && SB)
    (negedge G => (Q +: D)) = (1.0, 1.0);

    if (!G && SB)
    (negedge E => (Q +: D)) = (1.0, 1.0);

    (negedge SB => (Q +: 1'b1)) = (1.0, 1.0);

    if (!G && !E)
    (posedge SB => (Q +: D)) = (1.0, 1.0);

    if (!G && !E && SB)
    (D -=> QN) = (1.0, 1.0);

    if (!E && SB)
    (negedge G => (QN -: D)) = (1.0, 1.0);

    if (!G && SB)
    (negedge E => (QN -: D)) = (1.0, 1.0);

    (negedge SB => (QN +: 1'b0)) = (1.0, 1.0);

    if (!G && !E)
    (posedge SB => (QN -: D)) = (1.0, 1.0);


    // Timing checks 

    specparam
        t_SETUP$D = 0.0,
        t_HOLD$D  = 0.0,
        t_SETUP$E = 0.0,
        t_HOLD$E  = 0.0,
        t_PW_L$G  = 0.0,
        t_PW_L$SB = 0.0,
        t_PW_L$E  = 0.0,
        t_RELEASE$SB$G = 0.0;

    $setuphold(posedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(negedge E, posedge G &&& SB, t_SETUP$E, NOTIFY_REG);
    $hold(posedge G, negedge E &&& SB, t_HOLD$E, NOTIFY_REG);

    $width(negedge G &&& ENABLE, t_PW_L$G, 0, NOTIFY_REG); 
    $width(negedge E &&& SB, t_PW_L$E, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 

    $recovery (posedge SB, posedge G &&& EB, t_RELEASE$SB$G, NOTIFY_REG);

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : D-LATCH WITH ACTIVE LOW GATE, ACTIVE HIGH GATE ENABLE & ACTIVE HIGH SET
TRUTHTABLE     :

            ------------------------
             D   G  E  S    Q    QN
            ------------------------
             0   0  0  0    0    1
             1   0  0  0    1    0
             x   1  x  0    No change
             x   x  1  0    No change
             x   x  x  1    1    0
            ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_LD_N_CEB_S_NO (Q, QN, D, E, G, S);

    input  D, E, G, S;

    output Q, QN;


    reg  NOTIFY_REG ;

    U_LD_N_CEB_S_NO inst1 (Q_int, D, G, E, S, NOTIFY_REG);

    buf          BU1   (Q, Q_int);
    not          NT1   (QN, Q_int);

    nor         NR1   (ENABLE, E, S);

    specify


    // Specify path delays

    if (!G && !E && !S)
    (D +=> Q) = (1.0, 1.0);

    if (!E && !S)
    (negedge G => (Q +: D)) = (1.0, 1.0);

    if (!G && !S)
    (negedge E => (Q +: D)) = (1.0, 1.0);

    (posedge S => (Q +: 1'b1)) = (1.0, 1.0);

    if (!G && !E)
    (negedge S => (Q +: D)) = (1.0, 1.0);

    if (!G && !E && !S)
    (D -=> QN) = (1.0, 1.0);

    if (!E && !S)
    (negedge G => (QN -: D)) = (1.0, 1.0);

    if (!G && !S)
    (negedge E => (QN -: D)) = (1.0, 1.0);

    (posedge S => (QN +: 1'b0)) = (1.0, 1.0);

    if (!G && !E)
    (negedge S => (QN -: D)) = (1.0, 1.0);


    // Timing checks 

    specparam
        t_SETUP$D = 0.0,
        t_HOLD$D  = 0.0,
        t_SETUP$E = 0.0,
        t_HOLD$E  = 0.0,
        t_PW_L$G  = 0.0,
        t_PW_H$S  = 0.0,
        t_PW_L$E  = 0.0,
        t_RELEASE$S$G = 0.0;

    $setuphold(posedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(negedge E, posedge G &&& (~S), t_SETUP$E, NOTIFY_REG);
    $hold(posedge G, negedge E &&& (~S), t_HOLD$E, NOTIFY_REG);

    $width(negedge G &&& ENABLE, t_PW_L$G, 0, NOTIFY_REG); 
    $width(negedge E &&& (~S), t_PW_L$E, 0, NOTIFY_REG); 
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 

    $recovery (negedge S, posedge G &&& (~E), t_RELEASE$S$G, NOTIFY_REG);

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : D-LATCH WITH ACTIVE LOW GATE & ACTIVE HIGH GATE ENABLE
TRUTHTABLE     :

            ----------------------
             D   G  E      Q    QN
            ----------------------
             0   0  1      0    1
             1   0  1      1    0
             x   1  x      No change
             x   x  0      No change
            ----------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_LD_N_CE_NO (Q, QN, D, E, G);

    input  D, E, G;

    output Q, QN;


    reg  NOTIFY_REG ;

    U_LD_P_CEB_NO inst1 (Q_int, D, E, G, NOTIFY_REG);

    buf          BU1   (Q, Q_int);
    not          NT1   (QN, Q_int);

    specify


    // Specify path delays

    if (!G && E)
    (D +=> Q) = (1.0, 1.0);

    if (E)
    (negedge G => (Q +: D)) = (1.0, 1.0);

    if (!G)
    (posedge E => (Q +: D)) = (1.0, 1.0);

    if (!G && E)
    (D -=> QN) = (1.0, 1.0);

    if (E)
    (negedge G => (QN -: D)) = (1.0, 1.0);

    if (!G)
    (posedge E => (QN -: D)) = (1.0, 1.0);

    // Timing checks 

    specparam
        t_SETUP$D = 0.0,
        t_HOLD$D  = 0.0,
        t_SETUP$E = 0.0,
        t_HOLD$E  = 0.0,
        t_PW_L$G  = 0.0,
        t_PW_H$E  = 0.0;

    $setuphold(posedge G &&& E, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(posedge E, posedge G, t_SETUP$E, NOTIFY_REG);
    $hold(posedge G, negedge E, t_HOLD$E, NOTIFY_REG);

    $width(negedge G &&& E, t_PW_L$G, 0, NOTIFY_REG); 
    $width(posedge E, t_PW_H$E, 0, NOTIFY_REG); 

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : D-LATCH WITH ACTIVE LOW GATE, ACTIVE HIGH GATE ENABLE & ACTIVE HIGH RESET
TRUTHTABLE     :

            ------------------------
             D   G  E  R    Q    QN
            ------------------------
             0   0  1  0    0    1
             1   0  1  0    1    0
             x   1  x  0    No change
             x   x  0  0    No change
             x   x  x  1    0    1
            ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_LD_N_CE_R_NO (Q, QN, D, E, G, R);

    input  D, E, G, R;

    output Q, QN;


    reg  NOTIFY_REG ;

    U_LD_N_CE_R_NO inst1 (Q_int, D, G, E, R, NOTIFY_REG);

    buf          BU1   (Q, Q_int);
    not          NT1   (QN, Q_int);

    not         NT2   (RB, R);
    and         AN2   (ENABLE, RB, E);

    specify


    // Specify path delays

    if (!G && E && !R)
    (D +=> Q) = (1.0, 1.0);

    if (E && !R)
    (negedge G => (Q +: D)) = (1.0, 1.0);

    if (!G && !R)
    (posedge E => (Q +: D)) = (1.0, 1.0);

    (posedge R => (Q +: 1'b0)) = (1.0, 1.0);

    if (!G && E)
    (negedge R => (Q +: D)) = (1.0, 1.0);

    if (!G && E && !R)
    (D -=> QN) = (1.0, 1.0);

    if (E && !R)
    (negedge G => (QN -: D)) = (1.0, 1.0);

    if (!G && !R)
    (posedge E => (QN -: D)) = (1.0, 1.0);

    (posedge R => (QN +: 1'b1)) = (1.0, 1.0);

    if (!G && E)
    (negedge R => (QN -: D)) = (1.0, 1.0);


    // Timing checks 

    specparam
        t_SETUP$D = 0.0,
        t_HOLD$D  = 0.0,
        t_SETUP$E = 0.0,
        t_HOLD$E  = 0.0,
        t_PW_L$G  = 0.0,
        t_PW_H$R  = 0.0,
        t_PW_H$E  = 0.0,
        t_RELEASE$R$G = 0.0;

    $setuphold(posedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(posedge E, posedge G &&& RB, t_SETUP$E, NOTIFY_REG);
    $hold(posedge G, negedge E &&& RB, t_HOLD$E, NOTIFY_REG);

    $width(negedge G &&& ENABLE, t_PW_L$G, 0, NOTIFY_REG); 
    $width(posedge E &&& RB, t_PW_H$E, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery (negedge R, posedge G &&& E, t_RELEASE$R$G, NOTIFY_REG);

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : D-LATCH WITH ACTIVE LOW GATE, ACTIVE HIGH GATE ENABLE & ACTIVE HIGH SET
TRUTHTABLE     :

            ------------------------
             D   G  E  S    Q    QN
            ------------------------
             0   0  1  0    0    1
             1   0  1  0    1    0
             x   1  x  0    No change
             x   x  0  0    No change
             x   x  x  1    1    0
            ------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_LD_N_CE_S_NO (Q, QN, D, E, G, S);

    input  D, E, G, S;

    output Q, QN;


    reg  NOTIFY_REG ;

    U_LD_N_CE_S_NO inst1 (Q_int, D, G, E, S, NOTIFY_REG);

    buf          BU1   (Q, Q_int);
    not          NT1   (QN, Q_int);

    not         NT2   (SB, S);
    and         AN2   (ENABLE, SB, E);

    specify


    // Specify path delays

    if (!G && E && !S)
    (D +=> Q) = (1.0, 1.0);

    if (E && !S)
    (negedge G => (Q +: D)) = (1.0, 1.0);

    if (!G && !S)
    (posedge E => (Q +: D)) = (1.0, 1.0);

    (posedge S => (Q +: 1'b1)) = (1.0, 1.0);

    if (!G && E)
    (negedge S => (Q +: D)) = (1.0, 1.0);

    if (!G && E && !S)
    (D -=> QN) = (1.0, 1.0);

    if (E && !S)
    (negedge G => (QN -: D)) = (1.0, 1.0);

    if (!G && !S)
    (posedge E => (QN -: D)) = (1.0, 1.0);

    (posedge S => (QN +: 1'b0)) = (1.0, 1.0);

    if (!G && E)
    (negedge S => (QN -: D)) = (1.0, 1.0);


    // Timing checks 

    specparam
        t_SETUP$D = 0.0,
        t_HOLD$D  = 0.0,
        t_SETUP$E = 0.0,
        t_HOLD$E  = 0.0,
        t_PW_L$G  = 0.0,
        t_PW_H$S  = 0.0,
        t_PW_H$E  = 0.0,
        t_RELEASE$S$G = 0.0;

    $setuphold(posedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(posedge E, posedge G &&& SB, t_SETUP$E, NOTIFY_REG);
    $hold(posedge G, negedge E &&& SB, t_HOLD$E, NOTIFY_REG);

    $width(negedge G &&& ENABLE, t_PW_L$G, 0, NOTIFY_REG); 
    $width(posedge E &&& SB, t_PW_H$E, 0, NOTIFY_REG); 
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 

    $recovery (negedge S, posedge G &&& E, t_RELEASE$S$G, NOTIFY_REG);

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         -------------------   
         D    GN      Q   QN    
         -------------------   
         L    L       L   H    
         H    L       H   L    
         X    H       Q   QN    
         --------------------   
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_NO (Q, QN, D, GN);

    input   D, GN;

    output   Q, QN;



        reg  NOTIFY_REG ;

        parameter vlib_flat_module = 1 ;


    U_LD_N_NO    inst1 (Q_int, D, GN, NOTIFY_REG); 

    buf  (Q, Q_int);

    not  (QN, Q_int); 

    specify


    // Specify path delays

    if (!GN)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN)
        (D -=> QN ) = (1.0, 1.0);
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$CP  = 0.0 ,
        t_PW_L$CP  = 0.0 ;

    $setuphold(posedge GN, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge GN, t_PW_H$CP, 0, NOTIFY_REG); 
    $width(negedge GN, t_PW_L$CP, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / CLEAR DIRECT 
TRUTHTABLE     : 
         ---------------------- 
         D    GN   RB    Q   QN  
         ---------------------- 
         L    L    H     L   H  
         H    L    H     H   L  
         X    H    H     Q   QN  
         X    X    L     L   H  
         ---------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_RB (Q, QN, D, GN, RB);

    input   D, GN, RB;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;


   U_LD_N_RB    inst1 (Q_int, D, GN, RB);

    buf  (Q, Q_int);

    not  (QN, Q_int); 

    specify


    // Specify path delays

    if (!GN && RB)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && RB)
        (D -=> QN ) = (1.0, 1.0);
    if (RB)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (RB)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

    if (!GN)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);


      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$RB$GN  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(posedge GN &&& RB, D, t_SETUP$D, t_HOLD$D);

    $width(posedge GN &&& RB, t_PW_H$GN); 
    $width(negedge GN &&& RB, t_PW_L$GN); 
    $width(negedge RB, t_PW_L$RB); 

  
    $recovery(posedge RB, posedge  GN &&& D, t_RELEASE$RB$GN);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / CLEAR DIRECT 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         ---------------------- 
         D    GN   RB    Q   QN  
         ---------------------- 
         L    L    H     L   H  
         H    L    H     H   L  
         X    H    H     Q   QN  
         X    X    L     L   H  
         ---------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_RB_NO (Q, QN, D, GN, RB);

    input   D, GN, RB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;


   U_LD_N_RB_NO    inst1 (Q_int, D, GN, RB, NOTIFY_REG);

    buf  (Q, Q_int);

    not  (QN, Q_int);

    specify


    // Specify path delays

    if (!GN && RB)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && RB)
        (D -=> QN ) = (1.0, 1.0);
    if (RB)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (RB)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

    if (!GN)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);


      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$RB$GN  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(posedge GN &&& RB, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge GN &&& RB, t_PW_H$GN, 0, NOTIFY_REG); 
    $width(negedge GN &&& RB, t_PW_L$GN, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

  
    $recovery(posedge RB, posedge GN &&& D, t_RELEASE$RB$GN, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / CLEAR AND PRESET DIRECT 
TRUTHTABLE     : 
         ---------------------------- 
         D    GN   RB    SB    Q   QN  
         ---------------------------- 
         L    L    H     H     L   H  
         H    L    H     H     H   L  
         X    H    H     H     Q   QN  
         X    X    L     H     L   H  
         X    X    H     L     H   L  
         X    X    L     L     X   X  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_RB_SB_X (Q, QN, D, GN, RB, SB);

    input   D, GN, RB, SB;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;


   U_LD_N_RB_SB_X    inst1 (Q_int, D, GN, RB, SB);

    buf  (Q, Q_int);

    not  (QN, Q_int); 
     
   and               A1   (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (!GN && RB && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && RB && SB)
        (D -=> QN ) = (1.0, 1.0);
    if (RB && SB)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!GN && SB)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && SB)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);

    if (!GN && RB)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && RB)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);



      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$SB$GN  = 0.0 ,
        t_RELEASE$RB$GN  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(posedge GN &&& ENABLE, D, t_SETUP$D, t_HOLD$D);

    $width(posedge GN &&& ENABLE, t_PW_H$GN); 
    $width(negedge GN &&& ENABLE, t_PW_L$GN); 
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB); 

  
    $recovery(posedge RB, posedge GN &&& D, t_RELEASE$RB$GN);
    $recovery(posedge SB, posedge GN &&& ~D, t_RELEASE$SB$GN);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / CLEAR AND PRESET DIRECT 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         ---------------------------- 
         D    GN   RB    SB    Q   QN  
         ---------------------------- 
         L    L    H     H     L   H  
         H    L    H     H     H   L  
         X    H    H     H     Q   QN  
         X    X    L     H     L   H  
         X    X    H     L     H   L  
         X    X    L     L     X   X  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_RB_SB_X_NO (Q, QN, D, GN, RB, SB);

    input   D, GN, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;


   U_LD_N_RB_SB_X_NO    inst1 (Q_int, D, GN, RB, SB, NOTIFY_REG);

    buf  (Q, Q_int);

    not  (QN, Q_int); 
     
   and               A1   (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (!GN && RB && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && RB && SB)
        (D -=> QN ) = (1.0, 1.0);
    if (RB && SB)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!GN && SB)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && SB)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);

    if (!GN && RB)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && RB)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$SB$GN  = 0.0 ,
        t_RELEASE$RB$GN  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(posedge GN &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge GN &&& ENABLE, t_PW_H$GN, 0, NOTIFY_REG); 
    $width(negedge GN &&& ENABLE, t_PW_L$GN, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

  
    $recovery(posedge RB, posedge  GN &&& D, t_RELEASE$RB$GN, NOTIFY_REG);
    $recovery(posedge SB, posedge  GN &&& ~D, t_RELEASE$SB$GN, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / CLEAR AND PRESET DIRECT 
TRUTHTABLE     : 
         ---------------------------- 
         D    GN   R     S     Q   QN  
         ---------------------------- 
         L    L    L     L     L   H  
         H    L    L     L     H   L  
         X    H    L     L     Q   QN  
         X    X    H     L     L   H  
         X    X    L     H     H   L  
         X    X    H     H     X   X  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_R_S_X (Q, QN, D, GN, R, S);

    input   D, GN, R, S;

    output   Q, QN;



        parameter vlib_flat_module = 1 ;

   U_LD_N_R_S_X    inst1 (Q_int, D, GN, R, S);

    buf  (Q, Q_int);

    not  (QN, Q_int); 
     
   nor              A1   (ENABLE, R, S);


    specify


    // Specify path delays

    if (!GN && !R && !S)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && !R && !S)
        (D -=> QN ) = (1.0, 1.0);
    if (!R && !S)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!GN && !S)
        (negedge R =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && !S)
        (negedge R =>  (QN -: D)) = (1.0, 1.0);

    if (!GN && !R)
        (negedge S =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && !R)
        (negedge S =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$S$GN  = 0.0 ,
        t_RELEASE$R$GN  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(posedge GN &&& ENABLE, D, t_SETUP$D, t_HOLD$D);

    $width(posedge GN &&& ENABLE, t_PW_H$GN); 
    $width(negedge GN &&& ENABLE, t_PW_L$GN); 
    $width(posedge S, t_PW_H$S); 
    $width(posedge R, t_PW_H$R); 

    $recovery(negedge R, posedge GN &&& D, t_RELEASE$R$GN);
    $recovery(negedge S, posedge GN &&& ~D, t_RELEASE$S$GN);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / CLEAR AND PRESET DIRECT 
TRUTHTABLE     : 
         ---------------------------- 
         D    GN   R     S     Q   QN  
         ---------------------------- 
         L    L    L     L     L   H  
         H    L    L     L     H   L  
         X    H    L     L     Q   QN  
         X    X    H     L     L   H  
         X    X    L     H     H   L  
         X    X    H     H     X   X  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_R_S_X_NO (Q, QN, D, GN, R, S);

    input   D, GN, R, S;

    output   Q, QN;



        reg NOTIFY_REG;

        parameter vlib_flat_module = 1 ;

   U_LD_N_R_S_X_NO    inst1 (Q_int, D, GN, R, S, NOTIFY_REG);

    buf  (Q, Q_int);

    not  (QN, Q_int); 
     
   nor              A1   (ENABLE, R, S);


    specify


    // Specify path delays

    if (!GN && !R && !S)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && !R && !S)
        (D -=> QN ) = (1.0, 1.0);
    if (!R && !S)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!GN && !S)
        (negedge R =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && !S)
        (negedge R =>  (QN -: D)) = (1.0, 1.0);

    if (!GN && !R)
        (negedge S =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && !R)
        (negedge S =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$S$GN  = 0.0 ,
        t_RELEASE$R$GN  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(posedge GN &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge GN &&& ENABLE, t_PW_H$GN, 0, NOTIFY_REG); 
    $width(negedge GN &&& ENABLE, t_PW_L$GN, 0, NOTIFY_REG); 
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, posedge GN &&& D, t_RELEASE$R$GN, NOTIFY_REG);
    $recovery(negedge S, posedge GN &&& ~D, t_RELEASE$S$GN, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / PRESET DIRECT  
TRUTHTABLE     : 
         ---------------------- 
         D    GN   SB    Q   QN  
         ---------------------- 
         L    L    H     L   H  
         H    L    H     H   L  
         X    H    H     Q   QN  
         X    X    L     H   L  
         ---------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GNENIRIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_SB (Q, QN, D, GN, SB);

    input   D, GN, SB;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;


   U_LD_N_SB    inst1 (Q_int, D, GN, SB);

    buf  (Q, Q_int);

    not  (QN, Q_int); 


    specify


    // Specify path delays

    if (!GN && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && SB)
        (D -=> QN ) = (1.0, 1.0);
    if (SB)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (SB)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!GN)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);



      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$SB$GN  = 0.0 ,
        t_PW_L$SB  = 0.0 ;



    $setuphold(posedge GN &&& SB, D, t_SETUP$D, t_HOLD$D);

    $width(posedge GN &&& SB, t_PW_H$GN); 
    $width(negedge GN &&& SB, t_PW_L$GN); 
    $width(negedge SB, t_PW_L$SB); 


    $recovery(posedge SB, posedge  GN &&& ~D, t_RELEASE$SB$GN);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / PRESET DIRECT  
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         ---------------------- 
         D    GN   SB    Q   QN  
         ---------------------- 
         L    L    H     L   H  
         H    L    H     H   L  
         X    H    H     Q   QN  
         X    X    L     H   L  
         ---------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GNENIRIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_SB_NO (Q, QN, D, GN, SB);

    input   D, GN, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;


   U_LD_N_SB_NO    inst1 (Q_int, D, GN, SB, NOTIFY_REG);

    buf  (Q, Q_int);

    not  (QN, Q_int); 


    specify


    // Specify path delays

    if (!GN && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && SB)
        (D -=> QN ) = (1.0, 1.0);
    if (SB)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (SB)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!GN)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$SB$GN  = 0.0 ,
        t_PW_L$SB  = 0.0 ;


    $setuphold(posedge GN &&& SB, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge GN &&& SB, t_PW_H$GN, 0, NOTIFY_REG); 
    $width(negedge GN &&& SB, t_PW_L$GN, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 


    $recovery(posedge SB, posedge  GN &&& ~D, t_RELEASE$SB$GN, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / CLEAR AND PRESET DIRECT 
TRUTHTABLE     : 
         ---------------------------- 
         D    GN   RB    SB    Q   QN  
         ---------------------------- 
         L    L    H     H     L   H  
         H    L    H     H     H   L  
         X    H    H     H     Q   QN  
         X    X    L     H     L   H  
         X    X    H     L     H   L  
         X    X    L     L     H   H  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_SB_RB (Q, QN, D, GN, RB, SB);

    input   D, GN, RB, SB;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;


   U_LD_N_SB_RB    inst1 (Q, D, GN, RB, SB);
   U_LD_N_SB_RB_QN inst2 (QN, D, GN, RB, SB);
     
   and               A1   (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (!GN && RB && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && RB && SB)
        (D -=> QN ) = (1.0, 1.0);

    if (RB && SB)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!GN && SB)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && SB)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);

    if (!GN && RB)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && RB)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 
    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$SB$GN  = 0.0 ,
        t_RELEASE$RB$GN  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(posedge GN &&& ENABLE, D, t_SETUP$D, t_HOLD$D);

    $width(posedge GN &&& ENABLE, t_PW_H$GN); 
    $width(negedge GN &&& ENABLE, t_PW_L$GN); 
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB); 

  
    $recovery(posedge RB, posedge  GN &&& D, t_RELEASE$RB$GN);
    $recovery(posedge SB, posedge  GN &&& ~D, t_RELEASE$SB$GN);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / CLEAR AND PRESET DIRECT 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         ---------------------------- 
         D    GN   RB    SB    Q   QN  
         ---------------------------- 
         L    L    H     H     L   H  
         H    L    H     H     H   L  
         X    H    H     H     Q   QN  
         X    X    L     H     L   H  
         X    X    H     L     H   L  
         X    X    L     L     H   H  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_SB_RB_NO (Q, QN, D, GN, RB, SB);

    input   D, GN, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;


   U_LD_N_SB_RB_NO    inst1 (Q, D, GN, RB, SB, NOTIFY_REG);
   U_LD_N_SB_RB_NO_QN inst2 (QN, D, GN, RB, SB, NOTIFY_REG);
     
   and               A1   (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (!GN && RB && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && RB && SB)
        (D -=> QN ) = (1.0, 1.0);

    if (RB && SB)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!GN && SB)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && SB)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);

    if (!GN && RB)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && RB)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$SB$GN  = 0.0 ,
        t_RELEASE$RB$GN  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(posedge GN &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge GN &&& ENABLE, t_PW_H$GN, 0, NOTIFY_REG); 
    $width(negedge GN &&& ENABLE, t_PW_L$GN, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

  
    $recovery(posedge RB, posedge GN &&& D, t_RELEASE$RB$GN, NOTIFY_REG);
    $recovery(posedge SB, posedge  GN &&& ~D, t_RELEASE$SB$GN, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / CLEAR AND PRESET DIRECT 
TRUTHTABLE     : 
         ---------------------------- 
         D    GN   R     S     Q   QN  
         ---------------------------- 
         L    L    L     L     L   H  
         H    L    L     L     H   L  
         X    H    L     L     Q   QN  
         X    X    H     L     L   H  
         X    X    L     H     H   L  
         X    X    H     H     H   H
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_S_R (Q, QN, D, GN, R, S);

    input   D, GN, R, S;

    output   Q, QN;



        parameter vlib_flat_module = 1 ;

   U_LD_N_S_R    inst1 (Q, D, GN, R, S);
   U_LD_N_S_R_QN inst2 (QN, D, GN, R, S);
     
   nor            A1   (ENABLE, R, S);


    specify


    // Specify path delays

    if (!GN && !R && !S)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && !R && !S)
        (D -=> QN ) = (1.0, 1.0);
    if (!R && !S)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

    if (!S)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!GN && !S)
        (negedge R =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && !S)
        (negedge R =>  (QN -: D)) = (1.0, 1.0);

    if (!GN && !R)
        (negedge S =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && !R)
        (negedge S =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$S$GN  = 0.0 ,
        t_RELEASE$R$GN  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(posedge GN &&& ENABLE, D, t_SETUP$D, t_HOLD$D);

    $width(posedge GN &&& ENABLE, t_PW_H$GN); 
    $width(negedge GN &&& ENABLE, t_PW_L$GN); 
    $width(posedge S, t_PW_H$S); 
    $width(posedge R, t_PW_H$R); 

    $recovery(negedge R, posedge GN &&& D, t_RELEASE$R$GN);
    $recovery(negedge S, posedge GN &&& ~D, t_RELEASE$S$GN);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE LOW / CLEAR AND PRESET DIRECT 
TRUTHTABLE     : 
         ---------------------------- 
         D    GN   R     S     Q   QN  
         ---------------------------- 
         L    L    L     L     L   H  
         H    L    L     L     H   L  
         X    H    L     L     Q   QN  
         X    X    H     L     L   H  
         X    X    L     H     H   L  
         X    X    H     H     H   H
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_N_S_R_NO (Q, QN, D, GN, R, S);

    input   D, GN, R, S;

    output   Q, QN;



        reg NOTIFY_REG;

        parameter vlib_flat_module = 1 ;

   U_LD_N_S_R_NO    inst1 (Q, D, GN, R, S, NOTIFY_REG);
   U_LD_N_S_R_NO_QN inst2 (QN, D, GN, R, S, NOTIFY_REG);
     
   nor               A1   (ENABLE, R, S);


    specify


    // Specify path delays

    if (!GN && !R && !S)
        (D +=> Q ) = (1.0, 1.0);
    if (!GN && !R && !S)
        (D -=> QN ) = (1.0, 1.0);
    if (!R && !S)
        (negedge GN =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (negedge GN =>  (QN -: D)) = (1.0, 1.0);

    if (!S)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!GN && !S)
        (negedge R =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && !S)
        (negedge R =>  (QN -: D)) = (1.0, 1.0);

    if (!GN && !R)
        (negedge S =>  (Q +: D)) = (1.0, 1.0);
    if (!GN && !R)
        (negedge S =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$GN  = 0.0 ,
        t_PW_L$GN  = 0.0 ,
        t_RELEASE$S$GN  = 0.0 ,
        t_RELEASE$R$GN  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(posedge GN &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge GN &&& ENABLE, t_PW_H$GN, 0, NOTIFY_REG); 
    $width(negedge GN &&& ENABLE, t_PW_L$GN, 0, NOTIFY_REG); 
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, posedge GN &&& D, t_RELEASE$R$GN, NOTIFY_REG);
    $recovery(negedge S, posedge GN &&& ~D, t_RELEASE$S$GN, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH GATED ACTIVE HIGH 
TRUTHTABLE     : 
         -------------------   
         D    G       Q   QN    
         -------------------   
         L    H       L   H    
         H    H       H   L    
         X    L       Q   QN    
         --------------------   
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P (Q, QN, D, G);

    input   D, G;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;

    U_LD_P   inst1 (Q_int, D, G); 

    buf  (Q, Q_int);

    not  (QN, Q_int); 


    specify


    // Specify path delays

    if (G)
        (D +=> Q ) = (1.0, 1.0);
    if (G)
        (D -=> QN ) = (1.0, 1.0);
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP  = 0.0 ,
        t_HOLD  = 0.0 ,
        t_PW_H  = 0.0 ,
        t_PW_L  = 0.0 ;

    $setuphold(negedge G, D, t_SETUP, t_HOLD);

    $width(posedge G, t_PW_H); 
    $width(negedge G, t_PW_L);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : D-LATCH WITH ACTIVE HIGH GATE & ACTIVE LOW GATE ENABLE
TRUTHTABLE     :

            ----------------------
             D   G  E      Q    QN
            ----------------------
             0   1  0      0    1
             1   1  0      1    0
             x   0  x      No change
             x   x  1      No change
            ----------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_LD_P_CEB_NO (Q, QN, D, E, G);

    input  D, E, G;

    output Q, QN;


    reg  NOTIFY_REG ;

    U_LD_P_CEB_NO inst1 (Q_int, D, G, E, NOTIFY_REG);

    buf          BU1   (Q, Q_int);
    not          NT1   (QN, Q_int);

    specify


    // Specify path delays

    if (G && !E)
    (D +=> Q) = (1.0, 1.0);

    if (!E)
    (posedge G => (Q +: D)) = (1.0, 1.0);

    if (G)
    (negedge E => (Q +: D)) = (1.0, 1.0);

    // Timing checks 

    if (G && !E)
    (D -=> QN) = (1.0, 1.0);

    if (!E)
    (posedge G => (QN -: D)) = (1.0, 1.0);

    if (G)
    (negedge E => (QN -: D)) = (1.0, 1.0);

    specparam
        t_SETUP$D = 0.0,
        t_HOLD$D  = 0.0,
        t_SETUP$E = 0.0,
        t_HOLD$E  = 0.0,
        t_PW_H$G  = 0.0,
        t_PW_L$E  = 0.0;

    $setuphold(negedge G &&& (~E), D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(negedge E, negedge G, t_SETUP$E, NOTIFY_REG);
    $hold(negedge G, posedge E, t_HOLD$E, NOTIFY_REG);

    $width(posedge G &&& (~E), t_PW_H$G, 0, NOTIFY_REG); 
    $width(negedge E, t_PW_L$E, 0, NOTIFY_REG); 

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

FUNCTION       : D-LATCH WITH ACTIVE HIGH GATE & GATE ENABLE
TRUTHTABLE     :

            ----------------------
             D   G  E      Q    QN
            ----------------------
             0   1  1      0    1
             1   1  1      1    0
             x   0  x      No change
             x   x  0      No change
            ----------------------

REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.
*/

`celldefine
module CDS_GEN_LD_P_CE_NO (Q, QN, D, E, G);

    input  D, E, G;

    output Q, QN;


    reg  NOTIFY_REG ;

    U_LD_P_CE_NO inst1 (Q_int, D, G, E, NOTIFY_REG);

    buf          BU1   (Q, Q_int);
    not          NT1   (QN, Q_int);

    specify


    // Specify path delays

    if (G && E)
    (D +=> Q) = (1.0, 1.0);

    if (E)
    (posedge G => (Q +: D)) = (1.0, 1.0);

    if (G)
    (posedge E => (Q +: D)) = (1.0, 1.0);

    if (G && E)
    (D -=> QN) = (1.0, 1.0);

    if (E)
    (posedge G => (QN -: D)) = (1.0, 1.0);

    if (G)
    (posedge E => (QN -: D)) = (1.0, 1.0);

    // Timing checks 

    specparam
        t_SETUP$D = 0.0,
        t_HOLD$D  = 0.0,
        t_SETUP$E = 0.0,
        t_HOLD$E  = 0.0,
        t_PW_H$G  = 0.0,
        t_PW_H$E  = 0.0;

    $setuphold(negedge G &&& E, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $setup(posedge E, negedge G, t_SETUP$E, NOTIFY_REG);
    $hold(negedge G, negedge E, t_HOLD$E, NOTIFY_REG);

    $width(posedge G &&& E, t_PW_H$G, 0, NOTIFY_REG); 
    $width(posedge E, t_PW_H$E, 0, NOTIFY_REG); 

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH GATED ACTIVE HIGH   
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         -------------------   
         D    G       Q   QN    
         -------------------   
         L    H       L   H    
         H    H       H   L    
         X    L       Q   QN    
         --------------------   
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_NO (Q, QN, D, G);

    input   D, G;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;

    U_LD_P_NO   inst1 (Q_int, D, G, NOTIFY_REG);
 
    buf  (Q, Q_int);

    not  (QN, Q_int); 


    specify


    // Specify path delays

    if (G)
        (D +=> Q ) = (1.0, 1.0);
    if (G)
        (D -=> QN ) = (1.0, 1.0);
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 



    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ;

    $setuphold(negedge G, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge G, t_PW_H$G, 0, NOTIFY_REG); 
    $width(negedge G, t_PW_L$G, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / CLEAR DIRECT  
TRUTHTABLE     : 
         ---------------------- 
         D    G    RB    Q   QN  
         ---------------------- 
         L    H    H     L   H  
         H    H    H     H   L  
         X    L    H     Q   QN  
         X    X    L     L   H  
         ---------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_RB (Q, QN, D, G, RB);

    input   D, G, RB;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;


   U_LD_P_RB    inst1 (Q_int, D, G, RB);

    buf  (Q, Q_int);

    not  (QN, Q_int); 


    specify


    // Specify path delays

    if (G && RB)
        (D +=> Q ) = (1.0, 1.0);
    if (G && RB)
        (D -=> QN ) = (1.0, 1.0);
    if (RB)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (RB)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

    if (G)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (G)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$RB$G  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(negedge G &&& RB, D, t_SETUP$D, t_HOLD$D);

    $width(posedge G &&& RB, t_PW_H$G); 
    $width(negedge G &&& RB, t_PW_L$G); 
    $width(negedge RB, t_PW_L$RB); 


    $recovery(posedge RB, negedge G &&& D, t_RELEASE$RB$G);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / CLEAR DIRECT . 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         ---------------------- 
         D    G    RB    Q   QN  
         ---------------------- 
         L    H    H     L   H  
         H    H    H     H   L  
         X    L    H     Q   QN  
         X    X    L     L   H  
         ---------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_RB_NO (Q, QN, D, G, RB);

    input   D, G, RB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;


   U_LD_P_RB_NO    inst1 (Q_int, D, G, RB, NOTIFY_REG);
    buf  (Q, Q_int);

    not  (QN, Q_int); 


    specify


    // Specify path delays

    if (G && RB)
        (D +=> Q ) = (1.0, 1.0);
    if (G && RB)
        (D -=> QN ) = (1.0, 1.0);
    if (RB)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (RB)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

    if (G)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (G)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);

     // Timing checks 


    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$RB$G  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(negedge G &&& RB, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge G &&& RB, t_PW_H$G, 0, NOTIFY_REG); 
    $width(negedge G &&& RB, t_PW_L$G, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 


    $recovery(posedge RB, negedge G &&& D, t_RELEASE$RB$G, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / CLEAR AND PRESET DIRECT
              ILLEGAL OUTPUT OCCURS WHEN BOTH CLEAR AND PRESET ARE ACTIVE .
TRUTHTABLE     : 
         ---------------------------- 
         D    G   RB    SB    Q   QN  
         ---------------------------- 
         L    H    H     H     L   H  
         H    H    H     H     H   L  
         X    L    H     H     Q   QN  
         X    X    L     H     L   H  
         X    X    H     L     H   L  
         X    X    L     L     X   X  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_RB_SB_X (Q, QN, D, G, RB, SB);

    input   D, G, RB, SB;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;


   U_LD_P_RB_SB_X    inst1 (Q_int, D, G, RB, SB);

    buf  (Q, Q_int);

    not  (QN, Q_int); 
     
   and               A1   (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (G && RB && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (G && RB && SB)
        (D -=> QN ) = (1.0, 1.0);
    if (RB && SB)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (G && SB)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (G && SB)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);

    if (G && RB)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (G && RB)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);


      // Timing checks 
    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$SB$G  = 0.0 ,
        t_RELEASE$RB$G  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(negedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D);

    $width(posedge G &&& ENABLE, t_PW_H$G); 
    $width(negedge G &&& ENABLE, t_PW_L$G); 
    $width(negedge SB, t_PW_L$SB); 
    $width(negedge RB, t_PW_L$RB); 

  
    $recovery(posedge RB, negedge G &&& D, t_RELEASE$RB$G);
    $recovery(posedge SB, negedge G &&& ~D, t_RELEASE$SB$G);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / CLEAR AND PRESET DIRECT .
              ILLEGAL OUTPUT OCCURS WHEN BOTH CLEAR AND PRESET ARE ACTIVE .              
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         ---------------------------- 
         D    G   RB    SB    Q   QN  
         ---------------------------- 
         L    H    H     H     L   H  
         H    H    H     H     H   L  
         X    L    H     H     Q   QN  
         X    X    L     H     L   H  
         X    X    H     L     H   L  
         X    X    L     L     X   X  
         ---------------------------- 
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_RB_SB_X_NO (Q, QN, D, G, RB, SB);

    input   D, G, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;


   U_LD_P_RB_SB_X_NO    inst1 (Q_int, D, G, RB, SB, NOTIFY_REG);

    buf  (Q, Q_int);

    not  (QN, Q_int); 
     
   and               A1   (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (G && RB && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (G && RB && SB)
        (D -=> QN ) = (1.0, 1.0);
    if (RB && SB)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (G && SB)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (G && SB)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);

    if (G && RB)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (G && RB)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 
    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$SB$G  = 0.0 ,
        t_RELEASE$RB$G  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(negedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge G &&& ENABLE, t_PW_H$G, 0, NOTIFY_REG); 
    $width(negedge G &&& ENABLE, t_PW_L$G, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

  
    $recovery(posedge RB, negedge G &&& D, t_RELEASE$RB$G, NOTIFY_REG);
    $recovery(posedge SB, negedge G &&& ~D, t_RELEASE$SB$G, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / CLEAR AND PRESET DIRECT 
TRUTHTABLE     : 
         ---------------------------- 
         D    G    R     S     Q   QN  
         ---------------------------- 
         L    H    L     L     L   H  
         H    H    L     L     H   L  
         X    L    L     L     Q   QN  
         X    X    H     L     L   H  
         X    X    L     H     H   L  
         X    X    H     H     X   X  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
              DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_R_S_X (Q, QN, D, G, R, S);

    input   D, G, R, S;

    output   Q, QN;



        parameter vlib_flat_module = 1 ;

   U_LD_P_R_S_X    inst1 (Q_int, D, G, R, S);

    buf  (Q, Q_int);

    not  (QN, Q_int); 

     
   nor              A1   (ENABLE, R, S);


    specify


    // Specify path delays

    if (G && !R && !S)
        (D +=> Q ) = (1.0, 1.0);
    if (G && !R && !S)
        (D -=> QN ) = (1.0, 1.0);
    if (!R && !S)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (G && !S)
        (negedge R =>  (Q +: D)) = (1.0, 1.0);
    if (G && !S)
        (negedge R =>  (QN -: D)) = (1.0, 1.0);

    if (G && !R)
        (negedge S =>  (Q +: D)) = (1.0, 1.0);
    if (G && !R)
        (negedge S =>  (QN -: D)) = (1.0, 1.0);

      // Timing checks 
    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$S$G  = 0.0 ,
        t_RELEASE$R$G  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(negedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D);

    $width(posedge G &&& ENABLE, t_PW_H$G); 
    $width(negedge G &&& ENABLE, t_PW_L$G); 
    $width(posedge S, t_PW_H$S); 
    $width(posedge R, t_PW_H$R); 

    $recovery(negedge R, negedge G &&& D, t_RELEASE$R$G);
    $recovery(negedge S, negedge G &&& ~D, t_RELEASE$S$G);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / CLEAR AND PRESET DIRECT 
TRUTHTABLE     : 
         ---------------------------- 
         D    G    R     S     Q   QN  
         ---------------------------- 
         L    H    L     L     L   H  
         H    H    L     L     H   L  
         X    L    L     L     Q   QN  
         X    X    H     L     L   H  
         X    X    L     H     H   L  
         X    X    H     H     X   X  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
              DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_R_S_X_NO (Q, QN, D, G, R, S);

    input   D, G, R, S;

    output   Q, QN;



   reg NOTIFY_REG;

   parameter vlib_flat_module = 1 ;

   U_LD_P_R_S_X_NO    inst1 (Q_int, D, G, R, S, NOTIFY_REG);

    buf  (Q, Q_int);

    not  (QN, Q_int); 
     
   nor              A1   (ENABLE, R, S);


    specify


    // Specify path delays

    if (G && !R && !S)
        (D +=> Q ) = (1.0, 1.0);
    if (G && !R && !S)
        (D -=> QN ) = (1.0, 1.0);
    if (!R && !S)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (G && !S)
        (negedge R =>  (Q +: D)) = (1.0, 1.0);
    if (G && !S)
        (negedge R =>  (QN -: D)) = (1.0, 1.0);

    if (G && !R)
        (negedge S =>  (Q +: D)) = (1.0, 1.0);
    if (G && !R)
        (negedge S =>  (QN -: D)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$S$G  = 0.0 ,
        t_RELEASE$R$G  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(negedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge G &&& ENABLE, t_PW_H$G, 0, NOTIFY_REG); 
    $width(negedge G &&& ENABLE, t_PW_L$G, 0, NOTIFY_REG); 
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, negedge G &&& D, t_RELEASE$R$G, NOTIFY_REG);
    $recovery(negedge S, negedge G &&& ~D, t_RELEASE$S$G, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / PRESET DIRECT  
TRUTHTABLE     : 
         ---------------------- 
         D    G    SB    Q   QN  
         ---------------------- 
         L    H    H     L   H  
         H    H    H     H   L  
         X    L    H     Q   QN  
         X    X    L     H   L  
         ---------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_SB (Q, QN, D, G, SB);

    input   D, G, SB;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;


   U_LD_P_SB    inst1 (Q_int, D, G, SB);

    buf  (Q, Q_int);

    not  (QN, Q_int); 


    specify


    // Specify path delays

    if (G && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (G && SB)
        (D -=> QN ) = (1.0, 1.0);
    if (SB)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (SB)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (G)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (G)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);



      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$SB$G  = 0.0 ,
        t_PW_L$SB  = 0.0 ;



    $setuphold(negedge G &&& SB, D, t_SETUP$D, t_HOLD$D);

    $width(posedge G &&& SB, t_PW_H$G); 
    $width(negedge G &&& SB, t_PW_L$G); 
    $width(negedge SB, t_PW_L$SB); 


    $recovery(posedge SB, negedge G &&& ~D, t_RELEASE$SB$G);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / PRESET DIRECT .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         ---------------------- 
         D    G    SB    Q   QN  
         ---------------------- 
         L    H    H     L   H  
         H    H    H     H   L  
         X    L    H     Q   QN  
         X    X    L     H   L  
         ---------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_SB_NO (Q, QN, D, G, SB);

    input   D, G, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;


   U_LD_P_SB_NO    inst1 (Q_int, D, G, SB, NOTIFY_REG);

    buf  (Q, Q_int);

    not  (QN, Q_int); 


    specify


    // Specify path delays

    if (G && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (G && SB)
        (D -=> QN ) = (1.0, 1.0);
    if (SB)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (SB)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (G)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (G)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);


      // Timing checks 
    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$SB$G  = 0.0 ,
        t_PW_L$SB  = 0.0 ;



    $setuphold(negedge G &&& SB, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge G &&& SB, t_PW_H$G, 0, NOTIFY_REG); 
    $width(negedge G &&& SB, t_PW_L$G, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 


    $recovery(posedge SB, negedge G &&& ~D, t_RELEASE$SB$G, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / CLEAR AND PRESET DIRECT .
TRUTHTABLE     : 
         ---------------------------- 
         D    G   RB    SB    Q   QN  
         ---------------------------- 
         L    H    H     H     L   H  
         H    H    H     H     H   L  
         X    L    H     H     Q   QN  
         X    X    L     H     L   H  
         X    X    H     L     H   L  
         X    X    L     L     H   H  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_SB_RB (Q, QN, D, G, RB, SB);

    input   D, G, RB, SB;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;


   U_LD_P_SB_RB   inst1 (Q, D, G, RB, SB);
   U_LD_P_SB_RB_QN inst2 (QN, D, G, RB, SB);
     
   and               A1   (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (G && RB && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (G && RB && SB)
        (D -=> QN ) = (1.0, 1.0);
    if (RB && SB)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (G && SB)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (G && SB)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);

    if (G && RB)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (G && RB)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);


      // Timing checks 
    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$SB$G  = 0.0 ,
        t_RELEASE$RB$G  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;



    $setuphold(negedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D);

    $width(posedge G &&& ENABLE, t_PW_H$G); 
    $width(negedge G &&& ENABLE, t_PW_L$G); 
    $width(negedge SB, t_PW_L$SB);
    $width(negedge RB, t_PW_L$RB);

  
    $recovery(posedge RB, negedge G &&& D, t_RELEASE$RB$G);
    $recovery(posedge SB, negedge G &&& ~D, t_RELEASE$SB$G);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / CLEAR AND PRESET DIRECT.
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         ---------------------------- 
         D    G   RB    SB    Q   QN  
         ---------------------------- 
         L    H    H     H     L   H  
         H    H    H     H     H   L  
         X    L    H     H     Q   QN  
         X    X    L     H     L   H  
         X    X    H     L     H   L  
         X    X    L     L     H   H  
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_SB_RB_NO (Q, QN, D, G, RB, SB);

    input   D, G, RB, SB;

    output   Q, QN;



        reg  NOTIFY_REG ;
        parameter vlib_flat_module = 1 ;


   U_LD_P_SB_RB_NO   inst1 (Q, D, G, RB, SB, NOTIFY_REG);
   U_LD_P_SB_RB_NO_QN inst2 (QN, D, G, RB, SB, NOTIFY_REG);
     
   and               A1   (ENABLE, RB, SB);


    specify


    // Specify path delays

    if (G && RB && SB)
        (D +=> Q ) = (1.0, 1.0);
    if (G && RB && SB)
        (D -=> QN ) = (1.0, 1.0);
    if (RB && SB)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (RB && SB)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

    if (SB)
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (RB)
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (G && SB)
        (posedge RB =>  (Q +: D)) = (1.0, 1.0);
    if (G && SB)
        (posedge RB =>  (QN -: D)) = (1.0, 1.0);

    if (G && RB)
        (posedge SB =>  (Q +: D)) = (1.0, 1.0);
    if (G && RB)
        (posedge SB =>  (QN -: D)) = (1.0, 1.0);


      // Timing checks 
    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$SB$G  = 0.0 ,
        t_RELEASE$RB$G  = 0.0 ,
        t_PW_L$SB  = 0.0 ,
        t_PW_L$RB  = 0.0 ;


    $setuphold(negedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge G &&& ENABLE, t_PW_H$G, 0, NOTIFY_REG); 
    $width(negedge G &&& ENABLE, t_PW_L$G, 0, NOTIFY_REG); 
    $width(negedge SB, t_PW_L$SB, 0, NOTIFY_REG); 
    $width(negedge RB, t_PW_L$RB, 0, NOTIFY_REG); 

  
    $recovery(posedge RB, negedge G &&& D, t_RELEASE$RB$G, NOTIFY_REG);
    $recovery(posedge SB, negedge G &&& ~D, t_RELEASE$SB$G, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / CLEAR AND PRESET DIRECT 
TRUTHTABLE     : 
         ---------------------------- 
         D    G    R     S     Q   QN  
         ---------------------------- 
         L    H    L     L     L   H  
         H    H    L     L     H   L  
         X    L    L     L     Q   QN  
         X    X    H     L     L   H  
         X    X    L     H     H   L  
         X    X    H     H     H   H
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
              DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_S_R (Q, QN, D, G, R, S);

    input   D, G, R, S;

    output   Q, QN;



        parameter vlib_flat_module = 1 ;

   U_LD_P_S_R    inst1 (Q, D, G, R, S);
   U_LD_P_S_R_QN inst2 (QN, D, G, R, S);
     
   nor              A1   (ENABLE, R, S);


    specify


    // Specify path delays

    if (G && !R && !S)
        (D +=> Q ) = (1.0, 1.0);
    if (G && !R && !S)
        (D -=> QN ) = (1.0, 1.0);
    if (!R && !S)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

    if (!S)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (G && !S)
        (negedge R =>  (Q +: D)) = (1.0, 1.0);
    if (G && !S)
        (negedge R =>  (QN -: D)) = (1.0, 1.0);

    if (G && !R)
        (negedge S =>  (Q +: D)) = (1.0, 1.0);
    if (G && !R)
        (negedge S =>  (QN -: D)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$S$G  = 0.0 ,
        t_RELEASE$R$G  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(negedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D);

    $width(posedge G &&& ENABLE, t_PW_H$G); 
    $width(negedge G &&& ENABLE, t_PW_L$G); 
    $width(posedge S, t_PW_H$S); 
    $width(posedge R, t_PW_H$R); 

    $recovery(negedge R, negedge G &&& D, t_RELEASE$R$G);
    $recovery(negedge S, negedge G &&& ~D, t_RELEASE$S$G);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH, GATED ACTIVE HIGH / CLEAR AND PRESET DIRECT 
TRUTHTABLE     : 
         ---------------------------- 
         D    G    R     S     Q   QN  
         ---------------------------- 
         L    H    L     L     L   H  
         H    H    L     L     H   L  
         X    L    L     L     Q   QN  
         X    X    H     L     L   H  
         X    X    L     H     H   L  
         X    X    H     H     H   H
         ---------------------------- 
    
REFERENCE      : CADENCE - GENERIC LIBRARY-  Version2.0- February 1992- Verilog1.6a, Veritime1.2b 
              DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_P_S_R_NO (Q, QN, D, G, R, S);

    input   D, G, R, S;

    output   Q, QN;



   reg NOTIFY_REG;

   parameter vlib_flat_module = 1 ;

   U_LD_P_S_R_NO    inst1 (Q, D, G, R, S, NOTIFY_REG);
   U_LD_P_S_R_NO_QN inst2 (QN, D, G, R, S, NOTIFY_REG);
     
   nor               A1   (ENABLE, R, S);


    specify


    // Specify path delays

    if (G && !R && !S)
        (D +=> Q ) = (1.0, 1.0);
    if (G && !R && !S)
        (D -=> QN ) = (1.0, 1.0);
    if (!R && !S)
        (posedge G =>  (Q +: D)) = (1.0, 1.0);
    if (!R && !S)
        (posedge G =>  (QN -: D)) = (1.0, 1.0);

    if (!S)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        (posedge R =>  (QN +: 1'b1)) = (1.0, 1.0);

        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!R)
        (posedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (G && !S)
        (negedge R =>  (Q +: D)) = (1.0, 1.0);
    if (G && !S)
        (negedge R =>  (QN -: D)) = (1.0, 1.0);

    if (G && !R)
        (negedge S =>  (Q +: D)) = (1.0, 1.0);
    if (G && !R)
        (negedge S =>  (QN -: D)) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$G  = 0.0 ,
        t_PW_L$G  = 0.0 ,
        t_RELEASE$S$G  = 0.0 ,
        t_RELEASE$R$G  = 0.0 ,
        t_PW_H$S  = 0.0 ,
        t_PW_H$R  = 0.0 ;

    $setuphold(negedge G &&& ENABLE, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG);

    $width(posedge G &&& ENABLE, t_PW_H$G, 0, NOTIFY_REG); 
    $width(negedge G &&& ENABLE, t_PW_L$G, 0, NOTIFY_REG); 
    $width(posedge S, t_PW_H$S, 0, NOTIFY_REG); 
    $width(posedge R, t_PW_H$R, 0, NOTIFY_REG); 

    $recovery(negedge R, negedge G &&& D, t_RELEASE$R$G, NOTIFY_REG);
    $recovery(negedge S, negedge G &&& ~D, t_RELEASE$S$G, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH WITH SCAN TEST INPUTS 
TRUTHTABLE     : 
 
       ---------------------------------
        D1   C1    D2   C2    Q    QN
       ---------------------------------
        X    L     X     L    Q    QN

        X    L     H     H    H     L

        X    L     L     H    L     H

        H    H     X     L    H     L

        L    H     X     L    L     H      

        D1   H     D1    H    D1   ~D1

        D1   H    ~D1    H    X     X
       --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_SD (Q, QN, D1, C1, D2, C2);

    input   D1, C1, D2, C2;

    output   Q, QN;


         parameter vlib_flat_module = 1 ;
     
         U_LD_SD inst1
                (Q_int, D1, D2, C1, C2);

         buf  (Q, Q_int);

         not  (QN, Q_int); 
 

    specify


    // Specify path delays

    if (!C2)
        (posedge C1 =>  (Q +: D1)) = (1.0, 1.0);

    if (C2)
        (negedge C1 =>  (Q +: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (Q +: D2)) = (1.0, 1.0);

    if (C1)
        (negedge C2 => (Q +: D1)) = (1.0, 1.0);

    if (!C2)
        (posedge C1 =>  (QN -: D1)) = (1.0, 1.0);

    if (C2)
        (negedge C1 =>  (QN -: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (QN -: D2)) = (1.0, 1.0);

    if (C1)
        (negedge C2 => (QN -: D1)) = (1.0, 1.0);

    if (C1)
        (D1 +=> Q) = (1.0, 1.0);

     if (C2)
        (D2 +=> Q ) = (1.0, 1.0);
 
    if (C1)
        (D1 -=> QN ) = (1.0, 1.0);
 
    if (C2)
        (D2 -=> QN ) = (1.0, 1.0);

      // Timing checks 


    specparam
        t_SETUP$D1  = 0.0 ,
        t_HOLD$D1  = 0.0 ,
        t_SETUP$D2  = 0.0 ,
        t_HOLD$D2  = 0.0 ,
        t_PW_H$C1  = 0.0 ,
        t_PW_L$C1  = 0.0 ,
        t_PW_H$C2  = 0.0 ,
        t_PW_L$C2  = 0.0 ;

    $setuphold(negedge C1 &&& (~C2), D1, t_SETUP$D1, t_HOLD$D1); 
    $setuphold(negedge C2 &&& (~C1), D2, t_SETUP$D2, t_HOLD$D2); 

    $width(posedge C1, t_PW_H$C1); 
    $width(negedge C1, t_PW_L$C1); 
    $width(posedge C2, t_PW_H$C2); 
    $width(negedge C2, t_PW_L$C2);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH WITH SCAN TEST INPUTS WITH DATA ANDed   
TRUTHTABLE     : 
 
       ---------------------------------
        D1   C1    D2   C2    Q    QN
       ---------------------------------
        X    L     X     L    Q    QN

        X    L     H     H    H     L

        X    L     L     H    L     H

        H    H     X     L    H     L

        L    H     X     L    L     H

        L    H     X     H    L     H

        X    H     L     H    L     H 
        
        H    H     H     H    H     L
       --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_SDA (Q, QN, D1, C1, D2, C2);

    input   D1, C1, D2, C2;

    output   Q, QN;



         parameter vlib_flat_module = 1 ;
   
         U_LD_SDA inst1
                (Q_int, D1, D2, C1, C2);
         buf  (Q, Q_int);

         not  (QN, Q_int); 


    specify


    // Specify path delays

    if (!C2)
        (posedge C1 =>  (Q +: D1)) = (1.0, 1.0);
    if (C2)
        (posedge C1 =>  (Q +: D1 & D2)) = (1.0, 1.0);
    if (C2 && D2 && !D1)
        (negedge C1 =>  (Q +: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (Q +: D2)) = (1.0, 1.0);
    if (C1)
        (posedge C2 =>  (Q +: D1 & D2)) = (1.0, 1.0);
    if (C1 && D1 && !D2)
        (negedge C2 =>  (Q +: D1)) = (1.0, 1.0);

    if (!C2)
        (posedge C1 =>  (QN -: D1)) = (1.0, 1.0);
    if (C2)
        (posedge C1 =>  (QN -: D1 & D2)) = (1.0, 1.0);
    if (C2 && D2 && !D1)
        (negedge C1 =>  (QN -: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (QN -: D2)) = (1.0, 1.0);
    if (C1)
        (posedge C2 =>  (QN -: D1 & D2)) = (1.0, 1.0);
    if (C1 && D1 && !D2)
        (negedge C2 =>  (QN -: D1)) = (1.0, 1.0);

    if (C1 && !C2)
        (D1 +=> Q) = (1.0, 1.0);
    if (C1 && C2 && D2)
        (D1 +=> Q) = (1.0, 1.0);

    if (C1 && !C2)
        (D1 -=> QN) = (1.0, 1.0);
    if (C1 && C2 && D2)
        (D1 -=> QN) = (1.0, 1.0);

    if (!C1 && C2)
        (D2 +=> Q) = (1.0, 1.0);
    if (C1 && C2 && D1)
        (D2 +=> Q) = (1.0, 1.0);

    if (!C1 && C2)
        (D2 -=> QN) = (1.0, 1.0);
    if (C1 && C2 && D1)
        (D2 -=> QN) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D1  = 0.0 ,
        t_HOLD$D1  = 0.0 ,
        t_SETUP$D2  = 0.0 ,
        t_HOLD$D2  = 0.0 ,
        t_PW_H$C1  = 0.0 ,
        t_PW_L$C1  = 0.0 ,
        t_PW_H$C2  = 0.0 ,
        t_PW_L$C2  = 0.0 ;

    $setuphold(negedge C1 &&& (~C2), D1, t_SETUP$D1, t_HOLD$D1); 
    $setuphold(negedge C2 &&& (~C1), D2, t_SETUP$D2, t_HOLD$D2); 

    $width(posedge C1, t_PW_H$C1); 
    $width(negedge C1, t_PW_L$C1); 
    $width(posedge C2, t_PW_H$C2); 
    $width(negedge C2, t_PW_L$C2);


    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH WITH SCAN TEST INPUTS WITH DATA ANDed   
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
 
       ---------------------------------
        D1   C1    D2   C2    Q    QN
       ---------------------------------
        X    L     X     L    Q    QN

        X    L     H     H    H     L

        X    L     L     H    L     H

        H    H     X     L    H     L

        L    H     X     L    L     H

        L    H     X     H    L     H

        X    H     L     H    L     H 

        H    H     H     H    H     L
       --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_SDA_NO (Q, QN, D1, C1, D2, C2);

    input   D1, C1, D2, C2;

    output   Q, QN;



        reg  NOTIFY_REG ;

         parameter vlib_flat_module = 1 ;
   
         U_LD_SDA_NO inst1
                (Q_int, D1, D2, C1, C2, NOTIFY_REG);

         buf  (Q, Q_int);

         not  (QN, Q_int); 


    specify


    // Specify path delays

    if (!C2)
        (posedge C1 =>  (Q +: D1)) = (1.0, 1.0);
    if (C2)
        (posedge C1 =>  (Q +: D1 & D2)) = (1.0, 1.0);
    if (C2 && D2 && !D1)
        (negedge C1 =>  (Q +: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (Q +: D2)) = (1.0, 1.0);
    if (C1)
        (posedge C2 =>  (Q +: D1 & D2)) = (1.0, 1.0);
    if (C1 && D1 && !D2)
        (negedge C2 =>  (Q +: D1)) = (1.0, 1.0);

    if (!C2)
        (posedge C1 =>  (QN -: D1)) = (1.0, 1.0);
    if (C2)
        (posedge C1 =>  (QN -: D1 & D2)) = (1.0, 1.0);
    if (C2 && D2 && !D1)
        (negedge C1 =>  (QN -: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (QN -: D2)) = (1.0, 1.0);
    if (C1)
        (posedge C2 =>  (QN -: D1 & D2)) = (1.0, 1.0);
    if (C1 && D1 && !D2)
        (negedge C2 =>  (QN -: D1)) = (1.0, 1.0);

    if (C1 && !C2)
        (D1 +=> Q) = (1.0, 1.0);
    if (C1 && C2 && D2)
        (D1 +=> Q) = (1.0, 1.0);

    if (C1 && !C2)
        (D1 -=> QN) = (1.0, 1.0);
    if (C1 && C2 && D2)
        (D1 -=> QN) = (1.0, 1.0);

    if (!C1 && C2)
        (D2 +=> Q) = (1.0, 1.0);
    if (C1 && C2 && D1)
        (D2 +=> Q) = (1.0, 1.0);

    if (!C1 && C2)
        (D2 -=> QN) = (1.0, 1.0);
    if (C1 && C2 && D1)
        (D2 -=> QN) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$D1  = 0.0 ,
        t_HOLD$D1  = 0.0 ,
        t_SETUP$D2  = 0.0 ,
        t_HOLD$D2  = 0.0 ,
        t_PW_H$C1  = 0.0 ,
        t_PW_L$C1  = 0.0 ,
        t_PW_H$C2  = 0.0 ,
        t_PW_L$C2  = 0.0 ;

    $setuphold(negedge C1 &&& (~C2), D1, t_SETUP$D1, t_HOLD$D1, NOTIFY_REG); 
    $setuphold(negedge C2 &&& (~C1), D2, t_SETUP$D2, t_HOLD$D2, NOTIFY_REG); 

    $width(posedge C1, t_PW_H$C1, 0, NOTIFY_REG);
    $width(negedge C1, t_PW_L$C1, 0, NOTIFY_REG); 
    $width(posedge C2, t_PW_H$C2, 0, NOTIFY_REG); 
    $width(negedge C2, t_PW_L$C2, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH WITH SCAN TEST INPUTS WITH DATA ORed .  
TRUTHTABLE     : 
 
       ---------------------------------
        D1   C1    D2   C2    Q    QN
       ---------------------------------
        X    L     X     L    Q    QN

        X    L     H     H    H     L

        X    L     L     H    L     H

        H    H     X     L    H     L

        L    H     X     L    L     H

        H    H     X     H    H     L

        X    H     H     H    H     L

        L    H     L     H    L     H
       --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_SDO (Q, QN, D1, C1, D2, C2);

    input   D1, C1, D2, C2;

    output   Q, QN;



         parameter vlib_flat_module = 1 ;
   
         U_LD_SDO inst1
                (Q_int, D1, D2, C1, C2);
         buf  (Q, Q_int);

         not  (QN, Q_int); 


    specify


    // Specify path delays

    if (!C2)
        (posedge C1 =>  (Q +: D1)) = (1.0, 1.0);
    if (C2)
        (posedge C1 =>  (Q +: D1 | D2)) = (1.0, 1.0);
    if (C2 && !D2 && D1)
        (negedge C1 =>  (Q +: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (Q +: D2)) = (1.0, 1.0);
    if (C1)
        (posedge C2 =>  (Q +: D1 | D2)) = (1.0, 1.0);
    if (C1 && !D1 && D2)
        (negedge C2 =>  (Q +: D1)) = (1.0, 1.0);

    if (!C2)
        (posedge C1 =>  (QN -: D1)) = (1.0, 1.0);
    if (C2)
        (posedge C1 =>  (QN -: D1 | D2)) = (1.0, 1.0);
    if (C2 && !D2 && D1)
        (negedge C1 =>  (QN -: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (QN -: D2)) = (1.0, 1.0);
    if (C1)
        (posedge C2 =>  (QN -: D1 | D2)) = (1.0, 1.0);
    if (C1 && !D1 && D2)
        (negedge C2 =>  (QN -: D1)) = (1.0, 1.0);

    if (C1)
        (D1 +=> Q) = (1.0, 1.0);

    if (C1)
        (D1 -=> QN) = (1.0, 1.0);
    if (C1 && C2 && !D2)
        (D1 -=> QN) = (1.0, 1.0);

    if (C2)
        (D2 +=> Q) = (1.0, 1.0);
    if (C2)
        (D2 -=> QN) = (1.0, 1.0);


   // Timing checks 

   specparam
        t_SETUP$D1  = 0.0 ,
        t_HOLD$D1  = 0.0 ,
        t_SETUP$D2  = 0.0 ,
        t_HOLD$D2  = 0.0 ,
        t_PW_H$C1  = 0.0 ,
        t_PW_L$C1  = 0.0 ,
        t_PW_H$C2  = 0.0 ,
        t_PW_L$C2  = 0.0 ;

    $setuphold(negedge C1 &&& (~C2), D1, t_SETUP$D1, t_HOLD$D1); 
    $setuphold(negedge C2 &&& (~C1), D2, t_SETUP$D2, t_HOLD$D2); 

    $width(posedge C1, t_PW_H$C1); 
    $width(negedge C1, t_PW_L$C1); 
    $width(posedge C2, t_PW_H$C2); 
    $width(negedge C2, t_PW_L$C2);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH WITH SCAN TEST INPUTS WITH DATA ORed   
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
 
       ---------------------------------
        D1   C1    D2   C2    Q    QN
       ---------------------------------
        X    L     X     L    Q    QN

        X    L     H     H    H     L

        X    L     L     H    L     H

        H    H     X     L    H     L

        L    H     X     L    L     H

        H    H     X     H    H     L

        X    H     H     H    H     L

        L    H     L     H    L     H
       --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_SDO_NO (Q, QN, D1, C1, D2, C2);

    input   D1, C1, D2, C2;

    output   Q, QN;



        reg  NOTIFY_REG ;

         parameter vlib_flat_module = 1 ;
   
         U_LD_SDO_NO inst1
                (Q_int, D1, D2, C1, C2, NOTIFY_REG);

         buf  (Q, Q_int);

         not  (QN, Q_int); 


    specify


    // Specify path delays

    if (!C2)
        (posedge C1 =>  (Q +: D1)) = (1.0, 1.0);
    if (C2)
        (posedge C1 =>  (Q +: D1 | D2)) = (1.0, 1.0);
    if (C2 && !D2 && D1)
        (negedge C1 =>  (Q +: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (Q +: D2)) = (1.0, 1.0);
    if (C1)
        (posedge C2 =>  (Q +: D1 | D2)) = (1.0, 1.0);
    if (C1 && !D1 && D2)
        (negedge C2 =>  (Q +: D1)) = (1.0, 1.0);

    if (!C2)
        (posedge C1 =>  (QN -: D1)) = (1.0, 1.0);
    if (C2)
        (posedge C1 =>  (QN -: D1 | D2)) = (1.0, 1.0);
    if (C2 && !D2 && D1)
        (negedge C1 =>  (QN -: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (QN -: D2)) = (1.0, 1.0);
    if (C1)
        (posedge C2 =>  (QN -: D1 | D2)) = (1.0, 1.0);
    if (C1 && !D1 && D2)
        (negedge C2 =>  (QN -: D1)) = (1.0, 1.0);


    if (C1 && !C2)
        (D1 +=> Q) = (1.0, 1.0);
    if (C1 && C2 && !D2)
        (D1 +=> Q) = (1.0, 1.0);

    if (C1 && !C2)
        (D1 -=> QN) = (1.0, 1.0);
    if (C1 && C2 && !D2)
        (D1 -=> QN) = (1.0, 1.0);

    if (!C1 && C2)
        (D2 +=> Q) = (1.0, 1.0);
    if (C1 && C2 && !D1)
        (D2 +=> Q) = (1.0, 1.0);

    if (!C1 && C2)
        (D2 -=> QN) = (1.0, 1.0);
    if (C1 && C2 && !D1)
        (D2 -=> QN) = (1.0, 1.0);


      // Timing checks 

    specparam
        t_SETUP$D1  = 0.0 ,
        t_HOLD$D1  = 0.0 ,
        t_SETUP$D2  = 0.0 ,
        t_HOLD$D2  = 0.0 ,
        t_PW_H$C1  = 0.0 ,
        t_PW_L$C1  = 0.0 ,
        t_PW_H$C2  = 0.0 ,
        t_PW_L$C2  = 0.0 ;

    $setuphold(negedge C1 &&& (~C2), D1, t_SETUP$D1, t_HOLD$D1, NOTIFY_REG); 
    $setuphold(negedge C2 &&& (~C1), D2, t_SETUP$D2, t_HOLD$D2, NOTIFY_REG); 

    $width(posedge C1, t_PW_H$C1, 0, NOTIFY_REG);
    $width(negedge C1, t_PW_L$C1, 0, NOTIFY_REG); 
    $width(posedge C2, t_PW_H$C2, 0, NOTIFY_REG); 
    $width(negedge C2, t_PW_L$C2, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : DLATCH WITH SCAN TEST INPUTS 
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
 
       ---------------------------------
        D1   C1    D2   C2    Q    QN
       ---------------------------------
        X    L     X     L    Q    QN

        X    L     H     H    H     L

        X    L     L     H    L     H

        H    H     X     L    H     L

        L    H     X     L    L     H      

        D1   H     D1    H    D1   ~D1

        D1   H    ~D1    H    X     X
       --------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_SD_NO (Q, QN, D1, C1, D2, C2);

    input   D1, C1, D2, C2;

    output   Q, QN;



        reg  NOTIFY_REG ;
         parameter vlib_flat_module = 1 ;
     
         U_LD_SD_NO inst1
                (Q_int, D1, D2, C1, C2, NOTIFY_REG);

         buf  (Q, Q_int);

         not  (QN, Q_int); 

    specify


    // Specify path delays

    if (!C2)
        (posedge C1 =>  (Q +: D1)) = (1.0, 1.0);

    if (C2)
        (negedge C1 =>  (Q +: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (Q +: D2)) = (1.0, 1.0);

    if (C1)
        (negedge C2 => (Q +: D1)) = (1.0, 1.0);

    if (!C2)
        (posedge C1 =>  (QN -: D1)) = (1.0, 1.0);

    if (C2)
        (negedge C1 =>  (QN -: D2)) = (1.0, 1.0);

    if (!C1)
        (posedge C2 =>  (QN -: D2)) = (1.0, 1.0);

    if (C1)
        (negedge C2 => (QN -: D1)) = (1.0, 1.0);

    if (C1) 
        (D1 +=> Q) = (1.0, 1.0);
    if (C2)
        (D2 +=> Q ) = (1.0, 1.0);
  
    if (C1)
        (D1 -=> QN ) = (1.0, 1.0);
 
    if (C2) 
        (D2 -=> QN ) = (1.0, 1.0); 

      // Timing checks 

    specparam
        t_SETUP$D1  = 0.0 ,
        t_HOLD$D1  = 0.0 ,
        t_SETUP$D2  = 0.0 ,
        t_HOLD$D2  = 0.0 ,
        t_PW_H$C1  = 0.0 ,
        t_PW_L$C1  = 0.0 ,
        t_PW_H$C2  = 0.0 ,
        t_PW_L$C2  = 0.0 ;

    $setuphold(negedge C1 &&& (~C2), D1, t_SETUP$D1, t_HOLD$D1, NOTIFY_REG); 
    $setuphold(negedge C2 &&& (~C1), D2, t_SETUP$D2, t_HOLD$D2, NOTIFY_REG); 

    $width(posedge C1, t_PW_H$C1, 0, NOTIFY_REG);
    $width(negedge C1, t_PW_L$C1, 0, NOTIFY_REG); 
    $width(posedge C2, t_PW_H$C2, 0, NOTIFY_REG); 
    $width(negedge C2, t_PW_L$C2, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH WITH DUAL CLOCK INPUTS ( SCAN DESIGN )
TRUTHTABLE     : 
         -------------------------   
         D    C1    C2    Q   QN   
         -------------------------   
         L    H     L     L   H   
         H    H     L     H   L  
                                  
         X    L     X     Q   QN   
         X    X     H     Q   QN   
         -------------------------   
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_SD_O (Q, QN, D, C1, C2);

    input   D, C1, C2;

    output   Q, QN;


             parameter vlib_flat_module = 1 ;

             U_LD_SD_O inst1 (Q_int, D, C1, C2);

             buf  (Q, Q_int);

             not  (QN, Q_int); 


    specify


    // Specify path delays

        (posedge C1 =>  (Q +: D)) = (1.0, 1.0);
    if (C1)
        (negedge C2 =>  (Q +: D)) = (1.0, 1.0);
        (posedge C1 =>  (QN -: D)) = (1.0, 1.0);
    if (C1)
        (negedge C2 =>  (QN -: D)) = (1.0, 1.0);

    if (C1 && !C2)
        (D +=> Q) = (1.0, 1.0);
    if (C1 && !C2)
        (D -=> QN) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$C1  = 0.0 ,
        t_PW_L$C1  = 0.0 ,
        t_PW_H$C2  = 0.0 ,
        t_PW_L$C2  = 0.0 ;

    $setuphold(posedge C1 &&& (~C2), D, t_SETUP$D, t_HOLD$D); 
    $setuphold(negedge C2 &&& C1, D, t_SETUP$D, t_HOLD$D); 

    $width(posedge C1, t_PW_H$C1); 
    $width(negedge C1, t_PW_L$C1); 
    $width(posedge C2, t_PW_H$C2); 
    $width(negedge C2, t_PW_L$C2);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : D-LATCH WITH DUAL CLOCK INPUTS ( SCAN DESIGN ) .
              This model is provided with Verilog NOTIFIER REGISTER feature .
TRUTHTABLE     : 
         -------------------------   
         D    C1    C2    Q   QN   
         -------------------------   
         L    H     L     L   H   
         H    H     L     H   L  
                                  
         X    L     X     Q   QN   
         X    X     H     Q   QN   
         -------------------------   
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_LD_SD_O_NO (Q, QN, D, C1, C2);

    input   D, C1, C2;

    output   Q, QN;



        reg  NOTIFY_REG ;
             parameter vlib_flat_module = 1 ;

             U_LD_SD_O_NO inst1 (Q_int, D, C1, C2, NOTIFY_REG);

             buf  (Q, Q_int);

             not  (QN, Q_int); 


    specify


    // Specify path delays

        (posedge C1 =>  (Q +: D)) = (1.0, 1.0);
    if (C1)
        (negedge C2 =>  (Q +: D)) = (1.0, 1.0);

        (posedge C1 =>  (QN -: D)) = (1.0, 1.0);
    if (C1)
        (negedge C2 =>  (QN -: D)) = (1.0, 1.0);

    if (C1 && !C2)
        (D +=> Q) = (1.0, 1.0);
    if (C1 && !C2)
        (D -=> QN) = (1.0, 1.0);

      // Timing checks 

    specparam
        t_SETUP$D  = 0.0 ,
        t_HOLD$D  = 0.0 ,
        t_PW_H$C1  = 0.0 ,
        t_PW_L$C1  = 0.0 ,
        t_PW_H$C2  = 0.0 ,
        t_PW_L$C2  = 0.0 ;

    $setuphold(posedge C1 &&& (~C2), D, t_SETUP$D, t_HOLD$D, NOTIFY_REG); 
    $setuphold(negedge C2 &&& C1, D, t_SETUP$D, t_HOLD$D, NOTIFY_REG); 

    $width(posedge C1, t_PW_H$C1, 0, NOTIFY_REG); 
    $width(negedge C1, t_PW_L$C1, 0, NOTIFY_REG); 
    $width(posedge C2, t_PW_H$C2, 0, NOTIFY_REG); 
    $width(negedge C2, t_PW_L$C2, 0, NOTIFY_REG);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : S-R LATCH WITH COMMON GATED INPUTS, AND ASYNCHRONOUS
              SET & RESET ( ACTIVE LOW ) .
TRUTHTABLE     : 
        --------------------------------------
          S    R   G   SB   RB      Q     QN
        --------------------------------------
          X    X   X   L    L       H     H
                  
          L    X   L   X    L       H     H

          X    L   L   L    X       H     H

          L    L   L   X    X       H     H

          H    X   X   H    L       L     H

          H    L   L   H    H       L     H
          L    H   L   H    H       H     L

          X    H   X   L    H       H     L

          X    X   H   L    H       H     L

          X    X   H   H    L       L     H

          H    H   X   H    H       Q     QN

          X    X   H   H    H       Q     QN

          X    X   H   H    H       Q     QN
        --------------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_L_N_SR_SB_RB (Q, QN, S, R, G, SB, RB);

    input   S, R, G, SB, RB;

    output   Q, QN;


              parameter vlib_flat_module = 1 ;

              U_L_N_SR_SB_RB ( Q, S, R, SB, RB, G);
              U_L_N_SR_SB_RB_QN ( QN, S, R, SB, RB, G);


    specify


    // Specify path delays

    if (SB && !G )
        (negedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (SB && !G && !(RB && R))
        (posedge S =>  (Q +: 1'b0)) = (1.0, 1.0);

    if (S || G)
       (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);

    if (!(RB && (G || R)) && (G || S))
        (posedge SB =>  (Q +: 1'b0)) = (1.0, 1.0);

    if (RB && !G && SB && S)
        (negedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (RB && !G && !(S && SB))
        (posedge R =>  (Q +: 1'b1)) = (1.0, 1.0);

    if (SB && (G || R) && (G || S))
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);
    if (!(SB && (G || S)) && (G || R))
        (posedge RB =>  (Q +: 1'b1)) = (1.0, 1.0);

    if (RB && !G)
        (negedge R =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (RB && !G && !(SB && S))
        (posedge R =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (R || G)
       (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);

    if (!(SB && (G || S)) && (G || R))
        (posedge RB =>  (QN +: 1'b0)) = (1.0, 1.0);


    if (SB && !G && (RB && R))
        (negedge S =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (SB && !G && !(RB && R))
        (posedge S =>  (QN +: 1'b1)) = (1.0, 1.0);

    if (RB && (G || R) && (G || S))
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);
    if (!(RB && (G || R)) && (G || S))
        (posedge SB =>  (QN +: 1'b1)) = (1.0, 1.0);

    if (!S && SB)
        (negedge G => (Q +: 1'b1)) = (1.0, 1.0);
    if (!R && S && RB && SB)
        (negedge G => (Q +: 1'b0)) = (1.0, 1.0);
    if (!R && RB)
        (negedge G => (QN +: 1'b1)) = (1.0, 1.0);
    if (!S && R && RB && SB)
        (negedge G => (QN +: 1'b0)) = (1.0, 1.0);

    if (SB && !RB && !S)
        (posedge G => (Q +: 1'b0)) = (1.0, 1.0);

    if (RB && !SB && !R)
        (posedge G => (QN +: 1'b0)) = (1.0, 1.0);

 
     (S => Q) = (1.0, 1.0);
     (R => Q) = (1.0, 1.0);
     (SB => Q) = (1.0, 1.0);
     (RB => Q) = (1.0, 1.0);
     (G => Q) = (1.0, 1.0);

     (S => QN) = (1.0, 1.0);
     (R => QN) = (1.0, 1.0);
     (SB => QN) = (1.0, 1.0);
     (RB => QN) = (1.0, 1.0);
     (G => QN) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : POSITIVE LEVEL SENSITVE S-R TYPE LATCH 
TRUTHTABLE     : 
      ----------------------
         S   R   G   Q   QN 
      ----------------------
         L   L   H   Q   QN
         L   H   H   L   H
         H   L   H   H   L
         H   H   H   H   H
         X   X   L   Q   QN
      ----------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_L_P_S_R (Q, QN, S, R, G);

    input   S, R, G;

    output   Q, QN;

                      


        parameter vlib_flat_module = 1 ;
        U_L_P_S_R    U1 ( Q, S, R, G );
        U_L_P_S_R_QN U2 ( QN, S, R, G );


    specify
    // Specify path delays       

        if (G)
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (R && G)
        (negedge S =>  (Q +: 1'b0)) = (1.0, 1.0);
        if (!S)                   
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);

        if (G)
        (posedge R =>  (QN +: 1'b1)) =  (1.0, 1.0);
        if (S && G)
        (negedge R =>  (QN +: 1'b0)) =  (1.0, 1.0);
        if (!R)                                 
        (posedge S =>  (QN +: 1'b0)) =  (1.0, 1.0);

        if (S)
        (posedge G => (Q +: 1'b1)) = (1.0, 1.0);
        if (!S && R)
        (posedge G => (Q +: 1'b0)) = (1.0, 1.0);

        if (R)
        (posedge G => (QN +: 1'b1)) = (1.0, 1.0);
        if (S && !R)
        (posedge G => (QN +: 1'b0)) = (1.0, 1.0);

    endspecify


endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : S-R LATCH
TRUTHTABLE     : 
      --------------------
         S   R    Q   QN 
      --------------------
         L   L    L   L
         L   H    H   L
         H   L    L   H
         H   H    Q   QN
      --------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_L_RB_SB (Q, QN, S, R);

    input   S, R;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;
        U_L_RB_SB    U1 ( Q, S, R );
        U_L_RB_SB_QN U2 ( QN, S, R );


    specify


    // Specify path delays

    if (R)
        (negedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!S)
        (posedge R =>  (Q +: 1'b1)) = (1.0, 1.0);

    (negedge R =>  (Q +: 1'b0)) = (1.0, 1.0);


    (negedge S =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (!R)
        (posedge S =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (S)
        (negedge R =>  (QN +: 1'b1)) = (1.0, 1.0);


    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : S-R LATCH 
TRUTHTABLE     : 
      --------------------
         S   R    Q   QN 
      --------------------
         L   L    Q   QN
         L   H    L   H
         H   L    H   L
         H   H    L   L
      --------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_L_R_S (Q, QN, S, R);

    input   S, R;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;
        U_L_R_S    U1 ( Q, S, R );
        U_L_R_S_QN U2 ( QN, S, R );


    specify


    // Specify path delays

        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        if (S)
        (negedge R =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (!R)
        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);

        (posedge S =>  (QN +: 1'b0)) =  (1.0, 1.0);
        if (R)
        (negedge S =>  (QN +: 1'b1)) =  (1.0, 1.0);
        if (!S)
        (posedge R =>  (QN +: 1'b1)) =  (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : S-R LATCH
TRUTHTABLE     : 
      --------------------
         S   R    Q   QN 
      --------------------
         L   L    H   H
         L   H    H   L
         H   L    L   H
         H   H    Q   QN
      --------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_L_SB_RB (Q, QN, S, R);

    input   S, R;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;
        U_L_SB_RB    U1 ( Q, S, R );
        U_L_SB_RB_QN U2 ( QN, S, R );


    specify

    // Specify path delays    

        (negedge S =>  (Q +: 1'b1)) = (1.0, 1.0); 
        if (S)
        (negedge R =>  (Q +: 1'b0)) = (1.0, 1.0);
        if (!R)
        (posedge S =>  (Q +: 1'b0)) = (1.0, 1.0); 
             
        (negedge R =>  (QN +: 1'b1)) = (1.0, 1.0); 
        if (!S)
        (posedge R =>  (QN +: 1'b0)) = (1.0, 1.0); 
        if (R)
        (negedge S =>  (QN +: 1'b0)) = (1.0, 1.0); 

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : S-R LATCH WITH SEPARATE GATE INPUTS AND ASYNCHRONOUS
              SET & RESET ( ACTIVE LOW ) / STANDARB DRIVE .
TRUTHTABLE     : 
     -------------------------------------------------
      S1   S2   R1   R2       SB   RB      Q     QN
     -------------------------------------------------
      X    X    X    X         L   L       H      H

      L    L    X    X         X   L       H      H

      X    X    L    L         L   X       H      H

      L    L    L    L         X   X       H      H

      H    X    X    X         H   L       L      H

      X    H    X    X         H   L       L      H

      X    X    H    X         L   H       H      L

      X    X    X    H         L   H       H      L

      H    X    H    X         H   H       Q     QN

      H    X    X    H         H   H       Q     QN

      X    H    H    X         H   H       Q     QN

      X    H    X    H         H   H       Q     QN
     ------------------------------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_L_SR_SB_RB (Q, QN, S1, S2, SB, R1, R2, RB);

    input   S1, S2, SB, R1, R2, RB;

    output   Q, QN;


              parameter vlib_flat_module = 1 ;

              U_L_SR_SB_RB    inst1 (Q, S1, S2, R1, R2, SB, RB);
              U_L_SR_SB_RB_QN inst2 (QN, S1, S2, R1, R2, SB, RB);



    specify


    // Specify path delays

    if (S1 || S2)
        (negedge SB =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!((R1 || R2) && RB) && (S1 || S2))
        (posedge SB => (Q +: 1'b0)) = (1.0, 1.0);

    if (SB && !S2)
        (negedge S1 =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!(RB && (R1 || R2)) && SB && !S2)
        (posedge S1 =>  (Q +: 1'b0)) = (1.0, 1.0);

    if (SB && !S1)
        (negedge S2 =>  (Q +: 1'b1)) = (1.0, 1.0);
    if (!(RB && (R1 || R2)) && SB && !S1)
        (posedge S2 =>  (Q +: 1'b0)) = (1.0, 1.0);

    if (RB && (R1 || R2) && (S1 || S2))
        (negedge SB =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (RB && (R1 || R2) && SB && !S2)
        (negedge S1 =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (RB && (R1 || R2) && SB && !S1)
        (negedge S2 =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (SB && (S1 || S2) && (R1 && R2))
        (negedge RB =>  (Q +: 1'b0)) = (1.0, 1.0);

    if (SB && (S1 || S2) && RB && !R2)
        (negedge R1 =>  (Q +: 1'b0)) = (1.0, 1.0);

    if (SB && (S1 || S2) && RB && !R1)
        (negedge R2 =>  (Q +: 1'b0)) = (1.0, 1.0);

    if (R1 || R2)
        (negedge RB =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (!(SB && (S1 || S2)) && (R1 || R2))
        (posedge RB => (QN +: 1'b0)) = (1.0, 1.0);

    if (RB && !R2)
        (negedge R1 =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (!(SB && (S1 || S2)) && RB && !R2)
        (posedge R1 =>  (QN +: 1'b0)) = (1.0, 1.0);

    if (RB && !R1)
        (negedge R2 =>  (QN +: 1'b1)) = (1.0, 1.0);
    if (!(SB && (S1 || S2)) && RB && !R1)
        (posedge R2 =>  (QN +: 1'b0)) = (1.0, 1.0);

    (S1 => Q) = (1.0, 1.0);
    (S2 => Q) = (1.0, 1.0);
    (R1 => Q) = (1.0, 1.0);
    (R2 => Q) = (1.0, 1.0);
    (RB => Q) = (1.0, 1.0);
    (SB => Q) = (1.0, 1.0);

    (S1 => QN) = (1.0, 1.0);
    (S2 => QN) = (1.0, 1.0);
    (R1 => QN) = (1.0, 1.0);
    (R2 => QN) = (1.0, 1.0);
    (RB => QN) = (1.0, 1.0);
    (SB => QN) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : S-R LATCH 
TRUTHTABLE     : 
      --------------------
         S   R    Q   QN 
      --------------------
         L   L    Q   QN
         L   H    L   H
         H   L    H   L
         H   H    H   H
      --------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_L_S_R (Q, QN, S, R);

    input   S, R;

    output   Q, QN;


        parameter vlib_flat_module = 1 ;
        U_L_S_R    U1 ( Q, S, R );
        U_L_S_R_QN U2 ( QN, S, R );


    specify


    // Specify path delays         

        (posedge S =>  (Q +: 1'b1)) = (1.0, 1.0);
        if (R)
        (negedge S =>  (Q +: 1'b0)) = (1.0, 1.0);
        if (!S)
        (posedge R =>  (Q +: 1'b0)) = (1.0, 1.0);

        (posedge R =>  (QN +: 1'b1)) =  (1.0, 1.0);
        if (S)
        (negedge R =>  (QN +: 1'b0)) =  (1.0, 1.0);
        if (!R)
        (posedge S =>  (QN +: 1'b0)) =  (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : ONE TO ONE MULTIPLEXER WITH STORAGE .
TRUTHTABLE     : 
         -----------
         A    SL   Q
         -----------
         L    L    L
         H    L    H
         X    H    Q
         -----------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_1 (Q, A, SL);

    input   A, SL;

    output   Q;



        U_MUX_1 inst1 (Q, A, SL);


    specify


    // Specify path delays

    if (!SL)
        (A +=> Q ) = (1.0, 1.0);

        (SL => Q ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 16 TO ONE  NON-INVERTING MULTIPLEXER
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_16X1 (Z, D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, 
                         D12, D13, D14, D15, A, B, C, D);

    input   D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, 
            D15, A, B, C, D;

    output   Z;



        U_MUX_4_2 M1 (OUT_UDP_D0_TO_3_IN, D0, D1, D2, D3, A, B); 
        U_MUX_4_2 M2 (OUT_UDP_D4_TO_7_IN, D4, D5, D6, D7, A, B); 
        U_MUX_4_2 M3 (OUT_UDP_D8_TO_11_IN, D8, D9, D10, D11, A, B); 
        U_MUX_4_2 M4 (OUT_UDP_D12_TO_15_IN, D12, D13, D14, D15, A, B); 
        U_MUX_4_2 M5 (Z, OUT_UDP_D0_TO_3_IN, OUT_UDP_D4_TO_7_IN,  
                         OUT_UDP_D8_TO_11_IN, OUT_UDP_D12_TO_15_IN, C, D);


    specify


    // Specify path delays

      if (!A && !B && !C && !D)
        (D0 +=> Z ) = (1.0, 1.0);
      if (A && !B && !C && !D)
        (D1 +=> Z ) = (1.0, 1.0);
      if (!A && B && !C && !D)
        (D2 +=> Z ) = (1.0, 1.0);
      if (A && B && !C && !D)
        (D3 +=> Z ) = (1.0, 1.0);
      if (!A && !B && C && !D)
        (D4 +=> Z ) = (1.0, 1.0);
      if (A && !B && C && !D)
        (D5 +=> Z ) = (1.0, 1.0);
      if (!A && B && C && !D)
        (D6 +=> Z ) = (1.0, 1.0);
      if (A && B && C && !D)
        (D7 +=> Z ) = (1.0, 1.0);
      if (!A && !B && !C && D)
        (D8 +=> Z ) = (1.0, 1.0);
      if (A && !B && !C && D)
        (D9 +=> Z ) = (1.0, 1.0);
      if (!A && B && !C && D)
        (D10 +=> Z ) = (1.0, 1.0);
      if (A && B && !C && D)
        (D11 +=> Z ) = (1.0, 1.0);
      if (!A && !B && C && D)
        (D12 +=> Z ) = (1.0, 1.0);
      if (A && !B && C && D)
        (D13 +=> Z ) = (1.0, 1.0);
      if (!A && B && C && D)
        (D14 +=> Z ) = (1.0, 1.0);
      if (A && B && C && D)
        (D15 +=> Z ) = (1.0, 1.0);

        (A => Z ) = (1.0, 1.0);
        (B => Z ) = (1.0, 1.0);
        (C => Z ) = (1.0, 1.0);
        (D => Z ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : ONE TO ONE MULTIPLEXER WITH INVERTING OUTPUT
              AND STORAGE .
TRUTHTABLE     : 
         -----------
         A    SL   Q
         -----------
         L    L    H
         H    L    L
         X    H    Q
         -----------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_1_INV (Q, A, SL);

    input   A, SL;

    output   Q;



        U_MUX_1_INV inst1 (Q, A, SL);


    specify


    // Specify path delays

    if (!SL)
        (A -=> Q ) = (1.0, 1.0);

        (SL => Q ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : NON-INVERTING TWO-TO-ONE MULTIPLEXER
TRUTHTABLE     : 
         ----------------
         A    B    S    Z
         ----------------
         L    X    L    L
         H    X    L    H
         X    L    H    L
         X    H    H    H
         ----------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_2_1 (Z, A, B, S);

    input   A, B, S;

    output   Z;


        parameter vlib_flat_module = 1 ;

        U_MUX_2_1 M1 (Z, A, B, S);


    specify


    // Specify path delays

    if (!S)
        (A +=> Z ) = (1.0, 1.0);
    if (S)
        (B +=> Z ) = (1.0, 1.0);

        (S => Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : TWO-TO-ONE MULTIPLEXER WITH INVERTING OUTPUT 
TRUTHTABLE     : 
         ----------------
         A    B    S    Z
         ----------------
         L    X    L    H
         H    X    L    L
         X    L    H    H
         X    H    H    L
         ----------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_2_1_INV (Z, A, B, S);

    input   A, B, S;

    output   Z;


        parameter vlib_flat_module = 1 ;

        U_MUX_2_1_INV M1 (Z, A, B, S);


    specify


    // Specify path delays

    if (!S)
        (A -=> Z ) = (1.0, 1.0);
    if (S)
        (B -=> Z ) = (1.0, 1.0);

        (S => Z ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : TWO TO ONE MULTIPLEXER, WITH TWO SELECT CONTROLS . 
TRUTHTABLE     : 
         ---------------------
         A    B    S    SN   Z
         ---------------------
         L    X    L    H    L
         H    X    L    H    H
         X    L    H    L    L
         X    H    H    L    H
         ---------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_2_2 (Z, A, B, S, SN);

    input   A, B, S, SN;

    output   Z;


        parameter vlib_flat_module = 1 ;

        U_MUX_2_2 M3 (Z, A, B, S, SN);


    specify


    // Specify path delays

    if (!S && SN)
        (A +=> Z ) = (1.0, 1.0);
    if (S && !SN)
        (B +=> Z ) = (1.0, 1.0);

        (S => Z ) = (1.0, 1.0);
        (SN => Z ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : TWO TO ONE MULTIPLEXER, WITH TWO SELECT CONTROLS 
              AND INVERTING OUTPUT
TRUTHTABLE     : 
         ---------------------
         A    B    S    SN   Z
         ---------------------
         L    X    L    H    H
         H    X    L    H    L
         X    L    H    L    H
         X    H    H    L    L
         ---------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_2_2_INV (Z, SN, A, S, B);

    input   SN, A, S, B;

    output   Z;


        parameter vlib_flat_module = 1 ;

        U_MUX_2_2_INV M3 (Z, A, B, S, SN);


    specify


    // Specify path delays

    if (!S && SN)
        (A -=> Z ) = (1.0, 1.0);
    if (S && !SN)
        (B -=> Z ) = (1.0, 1.0);

        (S => Z ) = (1.0, 1.0);
        (SN => Z ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : THREE TO ONE MULTIPLEXER WITH 2 SELECT CONTROLS
               AND INVERTING OUTPUT 
TRUTHTABLE     : 
         --------------------------
         D0   D1   D1   S1   S2   Q
         --------------------------
         L    X    X    L    L    L
         H    X    X    L    L    H
         X    L    X    H    L    L
         X    H    X    H    L    H
         X    X    L    X    H    L
         X    X    H    X    H    H
         --------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_3_2 (Z, D0, D1, D2, A, B);

    input   D0, D1, D2, A, B;

    output   Z;


        parameter vlib_flat_module = 1 ;

        U_MUX_3_2 M3 (Z, D0, D1, D2, A, B);


    specify


    // Specify path delays

    if (!A && !B)
        (D0 +=> Z ) = (1.0, 1.0);
    if (A && !B)
        (D1 +=> Z ) = (1.0, 1.0);
    if (B)
        (D2 +=> Z ) = (1.0, 1.0);

        (A => Z ) = (1.0, 1.0);
        (B => Z ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : THREE TO ONE MULTIPLEXER WITH 2 SELECT CONTROLS
               AND INVERTING OUTPUT 
TRUTHTABLE     : 
         --------------------------
         D0   D1   D1   S1   S2   Q
         --------------------------
         L    X    X    L    L    H
         H    X    X    L    L    L
         X    L    X    H    L    H
         X    H    X    H    L    L
         X    X    L    X    H    H
         X    X    H    X    H    L
         --------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_3_2_INV (Z, D0, D1, D2, A, B);

    input   D0, D1, D2, A, B;

    output   Z;


        parameter vlib_flat_module = 1 ;

        U_MUX_3_2_INV M3 (Z, D0, D1, D2, A, B);


    specify


    // Specify path delays

    if (!A && !B)
        (D0 -=> Z ) = (1.0, 1.0);
    if (A && !B)
        (D1 -=> Z ) = (1.0, 1.0);
    if (B)
        (D2 -=> Z ) = (1.0, 1.0);

        (A => Z ) = (1.0, 1.0);
        (B => Z ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : FOUR TO ONE MULTIPLEXER WITH 2 SELECT CONTROLS .
TRUTHTABLE     : 
         -----------------
           A    B  | Z
         -----------------           
           L    L  | D0
                   |
           H    L  | D1
                   |
           L    H  | D2
                   |
           H    H  | D3
         ----------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_4_2 (Z, D0, D1, D2, D3, A, B);

    input   D0, D1, D2, D3, A, B;

    output   Z;


        parameter vlib_flat_module = 1 ;
 
      U_MUX_4_2 M5 (Z, D0, D1, D2, D3, A, B);


    specify


    // Specify path delays

    if (!A && !B)
        (D0 +=> Z ) = (1.0, 1.0);
    if (A && !B)
        (D1 +=> Z ) = (1.0, 1.0);
    if (!A && B)
        (D2 +=> Z ) = (1.0, 1.0);
    if (A && B)
        (D3 +=> Z ) = (1.0, 1.0);

        (A => Z ) = (1.0, 1.0);
        (B => Z ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : FOUR TO ONE MULTIPLEXER WITH 2 SELECT CONTROLS AND INVERTING OUTPUT .
TRUTHTABLE     : 
         -----------------
           A    B  | Z
         -----------------           
           L    L  | ~D0
                   |
           H    L  | ~D1
                   |
           L    H  | ~D2
                   |
           H    H  | ~D3
         ----------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_4_2_INV (Z, D0, D1, D2, D3, A, B);

    input   D0, D1, D2, D3, A, B;

    output   Z;


        parameter vlib_flat_module = 1 ;
 
      U_MUX_4_2_INV M5 (Z, D0, D1, D2, D3, A, B);


    specify


    // Specify path delays

    if (!A && !B)
        (D0 -=> Z ) = (1.0, 1.0);
    if (A && !B)
        (D1 -=> Z ) = (1.0, 1.0);
    if (!A && B)
        (D2 -=> Z ) = (1.0, 1.0);
    if (A && B)
        (D3 -=> Z ) = (1.0, 1.0);

        (A => Z ) = (1.0, 1.0);
        (B => Z ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 5 TO ONE NON-INVERTING MULTIPLEXER
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_5X1 (Z, D0, D1, D2, D3, D4, A, B, C);

    input   D0, D1, D2, D3, D4, A, B, C;

    output   Z;

        parameter vlib_flat_module = 1 ;

        U_MUX_4_2 M5 (Y, D0, D1, D2, D3, A, B);
        U_MUX_2_1 M1 (Z, Y, D4, C);

    specify

    // Specify path delays

    if (!A && !B)
        (D0 +=> Z) = (1.0, 1.0);
    if (A && !B)
        (D1 +=> Z) = (1.0, 1.0);
    if (!A && B)
        (D2 +=> Z) = (1.0, 1.0);
    if (A && B)
        (D3 +=> Z) = (1.0, 1.0);
    if (C)
        (D4 +=> Z) = (1.0, 1.0);

        (A => Z) = (1.0, 1.0);
        (B => Z) = (1.0, 1.0);
        (C => Z) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 8 TO ONE NON-INVERTING MULTIPLEXER
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_MUX_8X1 (Z, D0, D1, D2, D3, D4, D5, D6, D7, A, B, C);

    input   D0, D1, D2, D3, D4, D5, D6, D7, A, B, C;

    output   Z;


        parameter vlib_flat_module = 1 ;

        U_MUX_4_2 M5 (OUT_UDP_D0_TO_3_IN, D0, D1, D2, D3, A, B); 
        U_MUX_4_2 M6 (OUT_UDP_D4_TO_7_IN, D4, D5, D6, D7, A, B); 
        U_MUX_2_1 M1 (Z, OUT_UDP_D0_TO_3_IN, OUT_UDP_D4_TO_7_IN, C);


    specify


    // Specify path delays

    if (!A && !B && !C)
        (D0 +=> Z ) = (1.0, 1.0);
    if (A && !B && !C)
        (D1 +=> Z ) = (1.0, 1.0);
    if (!A && B && !C)
        (D2 +=> Z ) = (1.0, 1.0);
    if (A && B && !C)
        (D3 +=> Z ) = (1.0, 1.0);
    if (!A && !B && C)
        (D4 +=> Z ) = (1.0, 1.0);
    if (A && !B && C)
        (D5 +=> Z ) = (1.0, 1.0);
    if (!A && B && C)
        (D6 +=> Z ) = (1.0, 1.0);
    if (A && B && C)
        (D7 +=> Z ) = (1.0, 1.0);

        (A => Z ) = (1.0, 1.0);
        (B => Z ) = (1.0, 1.0);
        (C => Z ) = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-INPUT OR and 2-INPUT NAND  into 2-INPUT NAND 
TRUTHTABLE     : 
     ---- ---------------------
       A   B   C   D    Z  
     --------------------------
       L   L   X   X    H

       X   X   H   H    H

      All other combinations 
       produce LOW output
     --------------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_O2_AI2_AI (Z, A, B, C, D);

    input   A, B, C, D;

    output   Z;


        parameter vlib_flat_module = 1 ;
        U_O2_AI2_AI  U4 (Z, A, B, C, D);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-WIDE 2-INPUT OR into 2-INPUT NAND 
TRUTHTABLE     : 
        ------------------------
         A    B    C    D    Z
        ------------------------
         L    L    X    X    H
         X    X    L    L    H
         H    X    H    X    L
         H    X    X    H    L
         X    H    H    X    L
         X    H    X    H    L
        -------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_OAI_2_2 (Z, A, B, C, D);

    input   A, B, C, D;

    output   Z;


        parameter vlib_flat_module = 1 ;
         U_OAI_2_2 inst1 (Z, A, B, C, D);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 4-WIDE 2-INPUT OR into 4-INPUT NAND
TRUTHTABLE     : 
        ------------------------------------------
         A    B    C    D    E    F    G   H   Z
        ------------------------------------------
         L    L    X    X    X    X    X   X   H
         X    X    L    L    X    X    X   X   H
         X    X    X    X    L    L    X   X   H
         X    X    X    X    X    X    L   L   H
             
           All other input combinations produce 
                      LOW output

       -------------------------------------------
         
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_OAI_2_2_2_2 (Z, A, B, C, D, E, F, G, H);

    input   A, B, C, D, E, F, G, H;

    output   Z;


         parameter vlib_flat_module = 1 ;
         U_OA_2_2 inst1 (Z1, A, B, C, D);
         U_OA_2_2 inst2 (Z2, E, F, G, H);
         nand      ND1   (Z, Z1, Z2);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
        (E -=> Z ) = (1.0, 1.0);
        (F -=> Z ) = (1.0, 1.0);
        (G -=> Z ) = (1.0, 1.0);
        (H -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-INPUT OR and 3-INPUT OR into 2-INPUT NAND 
TRUTHTABLE     : 
        -------------------------------
         A    B    C    D    E    Z
        ------------------------------
         L    L    L    X    X    H
         X    X    X    L    L    H

         H    X    X    H    X    L
         H    X    X    X    H    L
         X    H    X    H    X    L
         X    H    X    X    H    L
         X    X    H    H    X    L
         X    X    H    X    H    L
        -------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_OAI_2_3 (Z, A, B, C, D, E);

    input   A, B, C, D, E;

    output   Z;



         parameter vlib_flat_module = 1 ;

         U_OAI_2_3 inst1 (Z, A, B, C, D, E);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
        (E -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-WIDE 3-INPUT OR into 2-INPUT NAND 
TRUTHTABLE     : 
        -----------------------------
         A    B   C   D    E   F   Z
        -----------------------------
         L    L   L   X    X   X   H
         X    X   X   L    L   L   H
         
         All other input combinations
           produce a LOW output

        -----------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_OAI_3_3 (Z, A, B, C, D, E, F);

    input   A, B, C, D, E, F;

    output   Z;


  
         parameter vlib_flat_module = 1 ;

         U_OAI_3_3 inst1 (Z, A, B, C, D, E, F);


    specify


    // Specify path delays

        (A -=> Z ) = (1.0, 1.0);
        (B -=> Z ) = (1.0, 1.0);
        (C -=> Z ) = (1.0, 1.0);
        (D -=> Z ) = (1.0, 1.0);
        (E -=> Z ) = (1.0, 1.0);
        (F -=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-WIDE 2-INPUT OR into 2-INPUT AND 
TRUTHTABLE     : 
        ------------------------
         A    B    C    D    Z
        ------------------------
         L    L    X    X    L
         X    X    L    L    L
         H    X    H    X    H
         H    X    X    H    H
         X    H    H    X    H
         X    H    X    H    H
        -------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_OA_2_2 (Z, A, B, C, D);

    input   A, B, C, D;

    output   Z;


        parameter vlib_flat_module = 1 ;
         U_OA_2_2 inst1 (Z, A, B, C, D);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
        (D +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-INPUT OR and 3-INPUT OR into 2-INPUT AND 
TRUTHTABLE     : 
        -------------------------------
         A    B    C    D    E    Z
        ------------------------------
         L    L    L    X    X    L
         X    X    X    L    L    L

         H    X    X    H    X    H
         H    X    X    X    H    H
         X    H    X    H    X    H
         X    H    X    X    H    H
         X    X    H    H    X    H
         X    X    H    X    H    H
        -------------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_OA_2_3 (Z, A, B, C, D, E);

    input   A, B, C, D, E;

    output   Z;



         parameter vlib_flat_module = 1 ;

         U_OA_2_3 inst1 (Z, A, B, C, D, E);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
        (D +=> Z ) = (1.0, 1.0);
        (E +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 2-WIDE 3-INPUT OR into 2-INPUT AND 
TRUTHTABLE     : 
        -----------------------------
         A    B   C   D    E   F   Z
        -----------------------------
         L    L   L   X    X   X   L
         X    X   X   L    L   L   L
         
         All other input combinations
           produce a HIGH output

        -----------------------------
    
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_OA_3_3 (Z, A, B, C, D, E, F);

    input   A, B, C, D, E, F;

    output   Z;


  
         parameter vlib_flat_module = 1 ;

         U_OA_3_3 inst1 (Z, A, B, C, D, E, F);


    specify


    // Specify path delays

        (A +=> Z ) = (1.0, 1.0);
        (B +=> Z ) = (1.0, 1.0);
        (C +=> Z ) = (1.0, 1.0);
        (D +=> Z ) = (1.0, 1.0);
        (E +=> Z ) = (1.0, 1.0);
        (F +=> Z ) = (1.0, 1.0);
    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 1-BIT RAM , WITH ADDED THREE-STATE OUTPUT
TRUTHTABLE     : 
        ------------------------
          D    WR   WRN     Q
        ------------------------
          X    L     H      Q
          L    H     L      L
          H    H     L      H
        ------------------------

        ----------------------
          RD    Q      Z
        ----------------------
          L     X     HI-Z
          H     L      L
          H     H      H
        ----------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_RAM1 (ZN, Q, D, WR, WRN, RD);

    input   D, WR, WRN, RD;

    output   ZN, Q;


        parameter vlib_flat_module = 1 ;

        tri   ZN;               

        U_RAM1 inst1 (Q, D, WR, WRN);     
        bufif1    B1    (ZN, Q, RD);


    specify

    // Specify path delays

    if (WR && !WRN)
       (D +=> Q) = (1.0, 1.0);

       (posedge WR =>  (Q +: D)) = (1.0, 1.0);

       (negedge WRN =>  (Q +: D)) = (1.0, 1.0);

       (RD => ZN) = (1.0, 1.0, 1.0, 1.0, 1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 1-BIT RAM , WITH ADDED THREE-STATE OUTPUT
TRUTHTABLE     : 
        ------------------------
          D    WR   WRN    QN
        ------------------------
          X    L     H     QN
          L    H     L      H
          H    H     L      L
        ------------------------

        ----------------------
          RD    QN     Z
        ----------------------
          L     X     HI-Z
          H     L      L
          H     H      H
        ----------------------

REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
             DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992 .


*/

`celldefine
module CDS_GEN_RAM1_QN (ZN, QN, D, WR, WRN, RD);

    input   D, WR, WRN, RD;

    output   ZN, QN;


        parameter vlib_flat_module = 1 ;

        tri   ZN;               

        U_RAM1_QN inst1 (QN, D, WR, WRN);     
        bufif1    B1    (ZN, QN, RD);


    specify

    // Specify path delays

    if (WR && !WRN)
       (D -=> QN) = (1.0, 1.0);

       (posedge WR => (QN -: D)) = (1.0, 1.0);

       (negedge WRN => (QN -: D)) = (1.0, 1.0);

       (RD => ZN) = (1.0, 1.0, 1.0, 1.0, 1.0, 1.0);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1992  by Cadence Design Systems .       *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

FUNCTION       : 1 - BIT SUBTRACTOR  
TRUTHTABLE     : To implement the logic equation 
              ( A - B - CI_ ) .
REFERENCE      : CADENCE - GENERIC LIBRARY -Version2.0 -February 1992- Verilog1.6a, Veritime1.2b 
                 DATASHEET- GENERIC LIBRARY Version2.0 DATA-SHEET., 1992.


*/

`celldefine
module CDS_GEN_SUB1 (D, CO, A, B, CI);

    input   A, B, CI;

    output   D, CO;



        parameter vlib_flat_module = 1 ;
      
        U_SUB2_D inst1 (D, A, B, CI);
        U_SUB2_C inst2 (CO, A, B, CI);


    specify


    // Specify path delays

        (CI => D)  = (1.0, 1.0);
        (CI => CO) = (1.0, 1.0);
        (A => D)   = (1.0, 1.0);
        (B => D)   = (1.0, 1.0);
        (A => CO)  = (1.0, 1.0);
        (B => CO)  = (1.0, 1.0);

    endspecify

endmodule
`endcelldefine
