`celldefine
module BUF1(o1,i1);
input i1;
output o1;

   buf g1(o1,i1);

   specify
      (i1 *> o1) = 5;
   endspecify
endmodule
`endcelldefine


`celldefine
module INV(o1,i1);
input i1;
output o1;

   not g1(o1,i1);

   specify
      (i1 *> o1) = 3;
   endspecify
endmodule
`endcelldefine


`celldefine
module AND2(o1,i1,i2);
input i1, i2;
output o1;

   and g1(o1,i1,i2);

   specify
      (i1,i2 *> o1) = 8;
   endspecify
endmodule
`endcelldefine


`celldefine
module OR2(o1,i1,i2);
input i1, i2;
output o1;

   or g1(o1,i1,i2);

   specify
      (i1,i2 *> o1) = 10;
   endspecify
endmodule
`endcelldefine


module MUX21(out,d1,d2,sel);
input d1, d2, sel;
output out;

   INV m1(sel_,sel);
   AND2 m2(d1m,d1,sel_);
   AND2 m3(d2m,d2,sel);
   OR2 m4(out,d1m,d2m);
endmodule


module top;
reg in1, in2, sel;

   MUX21 m1(out,in1,in2,sel);

   initial
   begin
      // start monitoring
      $monitor($time,,,"in1=%b  in2=%b  sel=%b  out=%b",in1,in2,sel,out);

      // start toggle test
      $toggle_test(m1);

      // test first data line passing 0
      sel = 0;
      in1 = 0;

      // check toggle status
      #50 $toggle_test_summary;

      // test first data line passing 1
      #10 in1 = 1;

      // check toggle status
      #50 $toggle_test_summary;

      // test second data line passing 0
      #10 sel = 1;
      in2 = 0;

      // check toggle status
      #50 $toggle_test_summary;

      // test second data line passing 1
      #10 in2 = 1;

      // check toggle status
      #50 $toggle_test_summary;

      // exit simulation
      $finish(2);
   end
endmodule
      



