/* toggle_reports.c
 *
 * This file contains the routines associated with the system task that
 * allows users to retrieve and output toggle count result information.
 *
 */

#include <stdio.h>
#include "veriuser.h"
#include "acc_user.h"
#include "tc_toggle.h"
#include "tc_routines.h"


/* tg_summary_call()
 *
 * This routine prints summary toggle count information.
 *
 */
int tg_summary_call()
{
   FILE *net_file;
   FILE *port_file;
   int i;
   p_tg_net curr_net;
   p_tg_name curr_port;

   /* process the buffer to ensure data is current */
   tg_process_buffer();

   /* open files */
   net_file = fopen("toggle_count.nets","w");
   port_file = fopen("toggle_count.ports","w");

   /* write header information to files */
   fprintf(net_file,"*** TOGGLE COUNT NET INFORMATION ***\n\n");
   fprintf(net_file,"%d nets monitored\n\n",tg_num_mon_nets);
   fprintf(net_file,"NET NAME (0->1 TOGGLE COUNT) (1->0 TOGGLE COUNT)\n\n");
   fprintf(port_file,"*** TOGGLE COUNT PORT BIT INFORMATION ***\n\n");
   fprintf(port_file,"%d port bits monitored\n\n",tg_num_mon_port_bits);
   fprintf(port_file,"PORT BIT NAME (0->1 TOGGLE COUNT) (1->0 TOGGLE COUNT)\n\n");

   /* scan data structure and write information to files */
   for (i = 0; i < TABLE_SIZE; i++)
   {
      /* only process if this location is used */
      if (tg_nets[i].used)
      {
         /* process all nets at this location */
         curr_net = &tg_nets[i];
         while (curr_net != null)
         {
            /* write net information */
            fprintf(net_file,"%s (%d) (%d)\n",curr_net->full_name,
                                              curr_net->zero_to_one,
                                              curr_net->one_to_zero);

            /* process all port bits for this net */
            curr_port = tg_nets[i].ports;
            while (curr_port != null)
            {
               /* write port information */
               fprintf(port_file,"%s (%d) (%d)\n",curr_port->name,
                                                  curr_net->zero_to_one,
                                                  curr_net->one_to_zero);

               /* get next port */
               curr_port = curr_port->next;
            }

            /* get next net */
            curr_net = curr_net->next;
         }
      }
   }

   /* close files */
   fclose(net_file);
   fclose(port_file);

   return 0;
}
