/* toggle_hash.c
 *
 * This file contains the routines that perform the hashing operations for
 * the toggle count application.
 *
 */

#include "acc_user.h"
#include "tc_toggle.h"
#include "tc_routines.h"


/* tg_hash_enter()
 *
 * This routine is called to make an entry for a net (passed as the first
 * argument to the routine) in the hash table.  If the net does not already
 * exist in the hash table, then a new entry is made for the net and the
 * routine returns TRUE.  If the net already exists in the hash table, then
 * no entry is made and the routine returns FALSE.  In either case, information
 * about the connected port (passed as the second argument to the routine) is
 * stored with the net in the hash table, and the address of the net structure
 * in the hash table is written to the variable addressed by the third argument
 * passed to the routine.
 *
 */
int tg_hash_enter(net,port,net_addr)
handle net;
handle port;
p_tg_net *net_addr;
{
   int hash_val;
   int new = TRUE;
   char full_name[BIG_STRING];
   char *port_name;
   char* name;
   p_tg_net curr_net;
   p_tg_net curr_net_list;
   p_tg_name curr_port_list;

   /* get the full name and hash value of this net */
   strcpy(full_name,acc_fetch_fullname(net));
   hash_val = tg_hash(full_name); 

   /* if no entry at hash_val address, make an entry for this net */
   if (!tg_nets[hash_val].used)
   {
      tg_hash_fill_net(&tg_nets[hash_val],net,full_name,port);
      *net_addr = &tg_nets[hash_val];
   }

   /* else scan nets at this location */
   else
   {
      curr_net = &tg_nets[hash_val];
      while (curr_net != null)
      {
         /* if this net matches, store the port information and end scan */
         if (strcmp(curr_net->full_name,full_name) == 0)
         {
            curr_port_list = curr_net->ports;
            curr_net->ports = (p_tg_name) malloc(sizeof(s_tg_name));
			if (acc_object_of_type(port, accConcatPort))
				name = full_name;
			else
				name = acc_fetch_fullname(port);
		
    		curr_net->ports->name = (char *) malloc(
                       strlen(port_name = name) + 1);

            strcpy(curr_net->ports->name,port_name);
            curr_net->ports->next = curr_port_list;
            curr_net->num_ports++;
            *net_addr = curr_net;
            new = FALSE;
            break;
         }

         /* get next net in list */
         curr_net = curr_net->next;
      }

      /* if a matching net was not found, make an entry for this net */
      if (curr_net == null)
      {
         curr_net_list = tg_nets[hash_val].next;
         tg_nets[hash_val].next = (p_tg_net) malloc(sizeof(s_tg_net));
         tg_hash_fill_net(tg_nets[hash_val].next,net,full_name,port); 
         tg_nets[hash_val].next->next = curr_net_list;
         *net_addr = tg_nets[hash_val].next;
      }
   }

   return(new);
}


/* tg_hash()
 *
 * This routine returns the hash value of the string addressed by the
 * argument passed to the routine.  The hash value of a string is given
 * by the following:
 *
 *      (Sum of values of characters in string) modulo (Hash table size) 
 *
 * The size of the hash table is given as a pre-defined constant.
 *
 */
int tg_hash(str)
char *str;
{
   int size = strlen(str);
   int sum = 0;
   int hash_value;
   int i;

   /* add character values */
   for (i = 0; i < size; i++) 
      sum = sum + str[i];   

   /* calculate hash value */
   hash_value = sum % TABLE_SIZE;

   /* return hash value */
   return(hash_value);
}


/* tg_hash_fill_net()
 *
 * This routine initializes the net structure addressed by the first
 * argument to the routine.  The second argument to the routine is
 * a handle to the net that the structure will represent, the third
 * argument to the routine is the full name of the net and the fourth
 * argument to the rougine is a handle to a port connected to the net.
 *
 */ 
void tg_hash_fill_net(net_loc,net,full_name,port)
p_tg_net net_loc;
handle net;
char *full_name;
handle port;
{
   char *port_full_name;
   char* name;

   /* initialize net information */
   net_loc->used = TRUE;
   net_loc->net_handle = net;
   net_loc->full_name = (char *) malloc(strlen(full_name) + 1);
   strcpy(net_loc->full_name,full_name);
   net_loc->one_to_zero = 0;
   net_loc->zero_to_one = 0;
   net_loc->next = null;

   /* initialize port information for this net */
   net_loc->num_ports = 1;
   net_loc->ports = (p_tg_name) malloc(sizeof(s_tg_name));
   
	if (acc_object_of_type(port, accConcatPort))
		name = full_name;
	else
		name = acc_fetch_fullname(port);
		
    net_loc->ports->name = (char *) malloc(
                       strlen(port_full_name = name) + 1);

   strcpy(net_loc->ports->name,port_full_name);
   net_loc->ports->next = null;
}


        
            


    
   
   

