/* Created:   Tue Feb 12 16:11:22 1991 by rays */
/* Last Edit: Tue Mar 26 12:48:17 1991 by rays */

#include "set_values.h"
/***********************************************************************
			     utilities.c

This file contains routines that are called by all the other routines,
but that don't fit into any specific functionality.

It contains the following routines:

  char *strtoupper();
  void set_bit();
  void clear_bit();

  int myrand();	++jrb change names to avoid clash with libc
  int mysrand();

	
and the following global variable:

  unsigned long int next = 1;   (Used by rand and srand)

**********************************************************************/

/***********************************************************************
			      STRTOUPPER

This routine takes a string and converts all the alphanumeric characters
to upper case.  It returns the pointer to the string.
**********************************************************************/
char *strtoupper(string)
char *string;  /* The string to be converted */
{
  char *ptr;   /* A pointer into the string */

  ptr = string;
  while (*ptr != '\0')
    {
      if ((*ptr >= 'a') && (*ptr <= 'z')) 
	*ptr = toupper(*ptr);
      ++ptr;
    }
  return string;
}


/***********************************************************************
			       SET BIT

This routine will set a bit within a byte.  The byte's bits are numbered as
follows: 01234567

Assumes that the bitnumb is within the byte.
  
**********************************************************************/
void set_bit(byte, bitnumb)
     char *byte;  /* A pointer to the byte we will modify */
     int bitnumb; /* The number of the bit to set */
{
  int mask = 0x80; /* The mask that will do our dirty work */
  
  mask = mask >> bitnumb;  /* Shift the mask */

  *byte = *byte | mask;  /* Set the bit */
}

/***********************************************************************
			      CLEAR BIT
This routine will clear a bit within a byte.  The byte's bits are numbered as
follows: 01234567

Assumes that the bitnumb is within the byte.

**********************************************************************/
void clear_bit (byte, bitnumb)
     char *byte;  /* A pointer to the byte we will modify */
     int bitnumb; /* The bit number of the bit to clear */
{
  int mask = 0x80;  /* The mask that will clear the bit */

  mask = mask >> bitnumb; /* Shift the mask */
  mask = mask ^ 0xff;     /* bitwise invert it */

  *byte = *byte & mask; /* Clear the bit */
}


#if 1

unsigned long int next = 1;  /* Used by the random number generator */

/***********************************************************************
				 RAND
return pseudo-random integer on 0..MY_RAND_MAX.  
   This code is from page 46 of K&R second edition 
**********************************************************************/


int myrand ()
{
  next = next * 1103515245 + 12345;
  return (unsigned int) (next/(MY_RAND_MAX * 2)) % MY_RAND_MAX;
}

/***********************************************************************
				SRAND

Sets the seed for rand
**********************************************************************/

int mysrand (seed)
     unsigned int seed;
{
  return (next = seed);
}

#endif
