module test;

reg a, b, c, display;
reg [1:5] ab;
wire q;
reg [1:8] mem [1:23];
integer init;
initial
begin
  $display("----------- MEM -------------");
  $set_values("random", mem[0]);
  for (init = 1; init <= 23; init = init +1)
     $displayb(mem[init]);
  $stop;
  $display("----------- REG -------------");
  for (init = 1; init <= 10; init = init +1)
  begin
    $set_values("random",ab);
    $displayb(ab);
  end
  $set_values("z",ab);
  $displayb(ab);
  $set_values("zzz00xx0",ab);
  $displayb(ab);
  $stop;
  $display("------------ UDP -----------");
  for (init = 1; init <= 10; init = init +1)
  begin
  $displayb(q);
  $set_values("random", dff);
  #1 $displayb(q);
  $set_values("rAnDoM", dff);
  #1 $displayb(q);
  end
  $stop;
  $display("----------- MOD -------------");
  $display(" -------- $set_values(\"01010z\", t); --------");
  display = 0;
  $set_values("01010z", t); 
  #1 display = ~display;
  #1 $display(" -------- $set_values (\"xxzz11\",test.t.b); --------");
  $set_values ("random",test.t.b);
  #1 display = ~display;
  #1 $display(" -------- $set_values (\"x\", t.b.b,\"r\"); --------");
  $set_values ("RANDOM", t.b.b,"r");
  #1 display = ~display;
  #1 $display(" -------- $set_values (\"0\", t.b.b,\"u\"); --------");
  $set_values ("random", t.b.b,"u");
  #1 display = ~display;
  #1 $display(" -------- $set_values (\"z\", t); --------");
  $set_values ("RANdom", t);
  #1 display = ~display;
  #10 $finish;

end	

dflop dff (q, a, b, c);

/*, mem[1] ,a, t,"u" , c, t, "ru"); */
  
mya t(a,display);

endmodule

module mya(a, display);
input a, display;
reg [1:5] joe;

myb b(a,display);
wire q;
dflop p1(q,a,a,a);

always @display
	$displayb("%m: ", joe,,q);

endmodule

module myb(a, display);
input a, display;
reg [1:5] joe;
wire q;
dflop p1(q,a,a,a);

myc b(a,display);

always @display
	$displayb("%m: ", joe,,q);

endmodule

module myc(a, display);
input a, display;
reg [1:5] joe;
wire q;

dflop p1(q,a,a,a);
myd b(a, display);

always @display
	$displayb("%m: ", joe,,q);

endmodule
module myd(a, display);
input a, display;
reg [1:5] joe;
wire q;
dflop p1(q,a,a,a);

always @display
	$displayb("%m: ", joe,,q);

endmodule


primitive dflop(q,d,clk,rst);
input d,clk,rst;
output q;
reg q;

table
//	d	clk	rst	: q_old : q_new
	?	?	0	:   ?   :  0;
	?	?	x	:   0   :  0;
	0	(01)	1	:   ?   :  0;
	1	(01)	1	:   ?   :  1;
	?	(10)	1	:   ?   :  -;
	*	?	?	:   ?   :  -;
	?	?	*	:   ?   :  -;
endtable
endprimitive


