/* Last Edit: Tue Mar 26 11:53:45 1991 by rays */

#include "set_values.h"

/***********************************************************************
			     stuff_udp.c

This file contains the routine which implements the UPD setting funcitonality
in $set_values.  It contains the following:

  void stuff_udp();

**********************************************************************/
/***********************************************************************
                           STUFF UDP

   stuff_udp will put a new value into a UDP.  It uses acc_set_value which
   is discussed at length in file stuff_register.c.

   The difference between stuff_udp and stuff_register lies in the
   value_s structure.  The register takes a string value for data,
   while a udp takes a scalar value.  

   We have to store accScalarVal in value_s and then we store a scalar
   in value_s.value.scalar.

   Scalars are the integers acc1, acc0, accX, or accZ, which are
   defined in acc_user.h.  get_new_value will return the scalar as a
   pointer to a string, we must cast it into an integer.

***********************************************************************/


void stuff_udp(udp)
     handle udp;
{
  
  char *get_new_value();
  
  static s_setval_delay delay_s = {{accRealTime}, accNoDelay};
  static s_setval_value value_s = {accScalarVal};
  
  value_s.value.scalar = (int) get_new_value(udp);
  delay_s.time.real = 0;
  
  acc_set_value (udp, &value_s, &delay_s);
}  
