/* Last Edit: Tue Mar 26 11:53:16 1991 by rays */

#include "set_values.h"
/***********************************************************************
			   stuff_register.c

This file contains the routines that implement the register setting 
functionality of $set_values.  It contains the following routines:

  void stuff_register();
**********************************************************************/



/***********************************************************************
                             STUFF REGISTER

This routine will place the value from tfarg 1 into a register.  It works
by calling the routine acc_set_value.  Before it can do this it has
to set up the arguments for acc_set_value.

acc_set_value takes three arguments, a handle and two structures which
describe the new value and the delay: delay_s and value_s.  

value_s is of type s_setval_value.  Here is that type's description:

s_setval_value contains an integer that stores the format of the new
value, and a union which stores the new value.  The type of the union
is determined by the format.

typedef struct t_setval_value {
  int format;  S* This format can have one of the following values:

		  accBinStrVal 
		  accOctStrVal 
		  accDecStrVal 
		  accHexStrVal 
		  accScalarVal 
		  accIntVal    
		  accRealVal   
		  accStringVal 
*S

  union {
    char *str;  S** for acc???StrVal or accStringVal**S
    int scalar; S** for accScalarVal *S S* acc0, acc1, accX, accZ **S
    int integer; S* for accIntVal *S
    double real; S* for accRealval *S
  } value;
} s_setval_value, *p_setval_value;


delay_s is of type s_setval_delay.  Here is that types description:

s_setval_delay consists of a structure which holds the delay time, and
an integer which hold the type of delay.


typedef struct t_setval_delay { 
    s_acc_time time;
    int model;     
        S* accNoDelay *S
        S* accInertialDelay *S
        S* accTransportDelay *S
        S* accPureTransportDelay *S
} s_setval_delay, *p_setval_delay; 


The s_acc_time structure looks like this:

typedef struct t_acc_time { 
    int type;        S* one of accTime accSimTime accRealTime *S 
    int low, high; S* for accTime and accSimTime *S 
    double real;   S* for accRealTime *S 
} s_acc_time, *p_acc_time;

The type is one of the following:

accTime             S* timescaled time *S
accSimTime          S* internal simulation time *S
accRealTime         S* timescaled real time *S

64-bit times are stored in high and low.  Real times are stored in real.


There are four delay models:

accNoDelay - No Delay before changing value

accInertialDelay - Remove all other changes to this register from the
                   event queue -- Current or Future

accTransportDelay - Remove all Future changes to this register.

accPureTransportDelay - Don't remove any other changes to this register
                        from the event queue.


stuff_register sets the delay_s and value_s structures to the correct
values and calls acc_set_value.
***********************************************************************/

void stuff_register(reg)
     handle reg;
     
{
  
  char 
    *get_new_value(); /* Generates a string that will be stored in the 
			 register.  This routine handles the leading 0's
			 and the truncations for registers that are a different
			 size than the new_value.  It also handles the random
			 new value feature.
                      */
  
 /* Actually we can use the compiler to set the values that don't change */

  static s_setval_delay delay_s = {{accRealTime}, accNoDelay};
  static s_setval_value value_s = {accBinStrVal};

  value_s.value.str = get_new_value(reg);
  delay_s.time.real = 0;

  acc_set_value (reg, &value_s, &delay_s);
}

