  /* Created:   Tue Feb 12 15:18:10 1991 by rays */
/* Last Edit: Tue Mar 26 13:50:06 1991 by rays */
#include "set_values.h"



/***********************************************************************

                            SET CHECK

   This routine will check the tfarguments for $set_value.  $set_value
has the following invocation:

$set_value(<value_item>, <storage_item>?<,<storage_item>>);

The first item is a value_item.  This can be a Verilog constant or a
string that must be equal to "random".  All the strings in this syntax
are case insensitive.

<value_item> ::=   Verilog Constant
             ||=   "random" (case insensitive)


After the value_item is a list of storage_items.  A storage_item is an
identifier that points to a register data type, a memory, a sequential UDP,
or a module.

If the storage_item points to a module then the module identifier can
be followed by a string which can be "r", "u", "ru", or "ur".

<storage_item> ::= UDP_Identifier
               ||= REGISTER_Identifier
	       ||= MEMORY Identifer
	       ||= <module pair>

<module pair>  ::= MODULE Identifier
               ||= MODULE Identifier, <selection_string>

<selection_string> ::= "r"
                   ||= "u"
                   ||= "ur"
                   ||= "ru"


Any deviation from this syntax will cause a syntax error.


                     The Checker Design

This syntax checker will be a state machine that runs through the 
tfarg list and ensures that each argument follows the syntax.  Here
is the state machine:


1.  IF tfarg(0) is a constant or "random"
    THEN inc argcntr and goto state 2
    ELSE *error*

2.  IF tfarg(argcntr) is a Register identifier
                      or a UDP identifer
		      or a Memory identifier
    THEN inc argcntr and goto state 2
    ELSE goto state 3


3.  IF tfarg(argcntr) is a Module identifier
    THEN inc argcntr and goto state 4
    ELSE *error*

4.  IF tfarg(argcntr) is an string
    goto state 5
    ELSE
    goto state 2

5.  IF tfarg(argcntr) is a string equal to "ru" 
                                        or "ur"
					or "u"
					or "r"
    THEN goto state 2
    ELSE *error*


The statemachine will stop when argcntr is = the number of tfarguments.


The state machine is implemented with recursive functions that call
each other as they search through the list.  It assumes that we won't
have a list long enough to explode the stack.

***********************************************************************/
int set_values_checktf()
{
 
  char
    *string;

  int
    value_string_length,
    ptr;

 long int dummy;

  void need_storage_or_module();

  /* First check the value argument.  If it is a string, then we */
  /* should make sure that string is equal to "random"           */

  acc_initialize();
#if 0
  acc_configure(accDevelopmentVersion, "1.6");
#endif

#if 0 /* doing this makes it impossible to regression test the code */
  mysrand((unsigned int)time(&dummy));   /* Initialize random number generator */
#endif 
  
  if (tf_typep(1) != tf_string)
	tf_message(ERR_ERROR, "Verilog", "ARGMBS",
		   "The first argument must be a string");
  else
    {
      value_string_length = strlen(acc_fetch_tfarg_str(1));
      if (value_string_length == 0) 
	tf_message(ERR_ERROR, "Verilog", "VLMNB0",
		   "The value string must have at least one character");
      string = acc_fetch_tfarg_str(1);
      string = strtoupper(string);
      for (ptr = 0; ptr < value_string_length; ptr++)
	  switch(string[ptr])
	    {
	    case '0':
	    case '1':
	    case 'X':
	    case 'Z':
	      break;
	    default:
	      if (strcmp(string, RANDOM_STRING))
		tf_message(ERR_ERROR, "Verilog", "SCICHR", 
			   "Value String contains invalid characters");
	    }

    }

/* Start the state machine with the first storage tfarg */
  need_storage_or_module(FIRST_STORAGE_TFARG, tf_nump()); 

  acc_close();

  return 0;
}
		     
/***********************************************************************
                     NEED STORAGE OR MODULE

    This routine fills state 2 of the syntax checking state machine.

    If the current tfarg is a storage element or a memory, then we
    look for another storage element or memory (back to state 2).
    
    Else we check to see if it's a module.  If it isn't a module then
    there will be an error.

2.  IF tfarg(argcntr) is a Register identifier
                      or a UDP identifer
		      or a Memory identifier
    THEN inc argcntr and goto state 2
    ELSE goto state 3


***********************************************************************/
    

void need_storage_or_module(tfarg, numb_args)
int 
  tfarg,   /* The number of the argument being examined */
  numb_args;    /* The number of arguments on the command line */
{
  
  
  static int legal_identifiers[3] =
    {accRegister, accSeqPrim, 0};
  bool tfarg_is_a_memory();
  void need_module();

  /* If we are through the list, then return */
  if (tfarg > numb_args)
    return;

  /* Check to see if this is a storage element or a memory */
  if (tfarg_is_a_memory(tfarg))
    need_storage_or_module(tfarg+1, numb_args);
  else
    if (acc_object_in_typelist(acc_handle_tfarg(tfarg), legal_identifiers))
	need_storage_or_module (tfarg + 1, numb_args);
    else
    /* This isn't a storage element, check to see if its a module */
      need_module (tfarg, numb_args);
}
      
/***********************************************************************
                         NEED MODULE

    This routine handles state 3 of the state table.  
    need_storage_or_module_identifier() checked for a storage element.  Since
    it didn't find one, it called this routine.  If the argument in question
    isn't a module, then we have an error.  Otherwise, we can check for
    a control string

3.  IF tfarg(argcntr) is a Module identifier
    THEN inc argcntr and goto state 4
    ELSE *error*

***********************************************************************/
  
     
void need_module(tfarg, numb_args)
int
  tfarg,     /* The number of the tfarg that I'm checking */
  numb_args; /* The number of tfargs in the tfarg list */

{

  void check_for_string();

  if (acc_fetch_type(acc_handle_tfarg(tfarg)) != accModule)
    /* tfarg isn't a module!  This is an error */
    tf_message(ERR_ERROR, "Verilog", "MBSEOM", "Argument %d is the wrong type",
	       tfarg, "It should be a register, sequential UDP, or module");
  else
    check_for_string (tfarg + 1, numb_args);

}


/***********************************************************************
                     CHECK FOR STRING

   The last tfarg was a module identifier, we should check the next
   tfarg to see if it is a string.  If it is a string, we must check
   to see if it's one of the allowed formats, otherwise we check to see
   if it's one of the allowed identifiers

4.  IF tfarg(argcntr) is an string
    goto state 5
    ELSE
    goto state 2

***********************************************************************/

void check_for_string (tfarg, numb_args)
int
  tfarg,      /* The current tfarg */
  numb_args;  /* The total number of tfargs in the list */


{
  void 
    check_format_of_sel_string(),
    need_storage_or_module();
  
  if (tfarg > numb_args)
    return;
  
  if (tf_typep(tfarg) == tf_string)
    check_format_of_sel_string(tfarg, numb_args);
  else
    need_storage_or_module(tfarg, numb_args);  /* State 2 */
  
}

/***********************************************************************
                 CHECK FORMAT OF STRING

   Check to see that the selection string is one of the allowable formats.
   If it is, then look for an identifier, else we have an error.

5.  IF tfarg(argcntr) is a string equal to "ru"  REG_UDP
                                        or "ur"  UDP_REG
					or "u"   UPD
					or "r"   REG
    THEN goto state 2
    ELSE *error*

***********************************************************************/

void check_format_of_sel_string (tfarg, numb_args)
int
  tfarg,      /* The current tfarg */
  numb_args;  /* The total number of tfargs in the list */

{
  void need_storage_or_module();

  char *string = acc_fetch_tfarg_str(tfarg);

  string = strtoupper(string);
  
  if (!strcmp(string, REG))
    need_storage_or_module (tfarg + 1, numb_args);
else
  if (!strcmp(string, REG_UDP))
    need_storage_or_module (tfarg + 1, numb_args);
else
  if (!strcmp(string, UDP_REG))
    need_storage_or_module (tfarg + 1, numb_args);
else
  if (!strcmp(string, UDP))
    need_storage_or_module (tfarg + 1, numb_args);
else
  /* Apparently we don't have a legal string combination */
    tf_message(ERR_ERROR, "Verilog", "ILSELST", 
	     "Argument %d contains an illegal string.", tfarg, string); 
}

/***********************************************************************
                 TFARG IS A MEMORY

This function returns true if the tfarg in question points to a memory
storage element.

***********************************************************************/

bool tfarg_is_a_memory(tfarg)
     int tfarg;   /* The argument number we are going to check */

{
  s_tfnodeinfo node;

 
  if (tf_typep(tfarg) != tf_readwrite)
    return false;
  else{
     tf_nodeinfo (tfarg, &node);
     return (node.node_type == tf_memory_node);
  }
}
