/* Created:   Tue Dec 18 09:59:57 1990 by rays */
/* Last Edit: Tue May  7 16:48:22 1991 by rays */
#include "dtran.h"

/*
			     DTRAN MISCTF

PLEASE READ DTRAN_PROGRAM.DOC BEFORE READING THIS DOCUMENTATION

dtran_misctf is the last step of the dtran functionality.  It evaluates
the a_net and b_net and places the new values for these nets in the
registers that drive the other direction.

The dtran misctf also handles the $save and $restart.  It does this by 
warning the user that we don't support these functions.

dtran_misctf calls routine handle_value_changes to evaluate the current
state of the dtran.  This is documented below

handle_value_changes does the following:

0. Set up information to use acc_set_values.  We use this routine to place
   values in the registers.

1. get the pointer to the instance specific structure.  This structure
   looks like this:
      
typedef struct {
  int 
    number_of_a_drivers,
    number_of_b_drivers,
    *a_values, 
    *b_values,
    a_nettype,
    b_nettype;
} dtran_inst_info;

a_values and b_values are arrays that store the current state of the
driving terminals.  Since we have been called at the end of the timestep
these values should have settled.

2. evaluate the a_values and b_values arrays by ORing their elements together.
   This process is discussed in the file dtran_program.doc.

3. use acc_set_values to place the new values on the registers which drive
   the opposite side of the dtran.

This process of evaluating one side of the dtran and placing the value on
the other side makes the dtran go.
*/


  
int dtran_misctf(data, reason)
int data,reason;
{
  void 
    handle_value_changes(),
    handle_dtran_save(),
    handle_dtran_restore();

  switch(reason)
    {
    case reason_synch:
      handle_value_changes();
      break;
    case reason_save:
      handle_dtran_save();
      break;

    case reason_restart:
      handle_dtran_restore();
    }

  return 0;
}

void handle_value_changes()
{
  register int new_value = 0;
  int driver;
  dtran_inst_info *info;
  void get_newvalue();
  handle 
    reg_a = acc_handle_tfarg(1),
    reg_b = acc_handle_tfarg(2);
  
  static s_setval_delay delay_s = {accRealTime, accNoDelay};
  static s_setval_value value_s = {accBinStrVal};
  value_s.value.str = malloc (2);
  delay_s.time.real = 0;

  info = (dtran_inst_info *) tf_getworkarea();

  for (driver = 0; driver < info -> number_of_a_drivers; driver++)
    new_value = new_value | info -> a_values[driver];

  get_newvalue(value_s.value.str, new_value, info -> a_nettype);
 
  acc_set_value(reg_b, &value_s, &delay_s);
  
  new_value = 0;
  for (driver = 0; driver < info -> number_of_b_drivers; driver++)
    new_value = new_value | info -> b_values[driver];
  
  get_newvalue(value_s.value.str, new_value, info -> b_nettype);
  acc_set_value(reg_a, &value_s, &delay_s);

}


void get_newvalue(newvalstr, new_value, nettype)
char newvalstr[];
int new_value, nettype;

{
  newvalstr[1] ='\0';
  switch (nettype)
    {
    case accWire:
    case accTri:
      switch (new_value)
	{
	case Wire0:
	  newvalstr[0] = '0';
	  break;
	case Wire1:
	  newvalstr[0] = '1';
	  break;
	case WireX:
	  newvalstr[0] = 'X';
	  break;
	case WireZ:
	  newvalstr[0] = 'Z';
	  break;
	}
    break;
    case accWand:
    case accTriand:
      switch (new_value)
	{
	case Wand0:
	  newvalstr[0] = '0';
	  break;
	case Wand1:
	  newvalstr[0] = '1';
	  break;
	case WandX:
	  newvalstr[0] = 'X';
	  break;
	case WandZ:
	  newvalstr[0] = 'Z';
	  break;
	}
    break;
    case accWor:
    case accTrior:
      switch (new_value)
	{
	case Wor0:
	  newvalstr[0] = '0';
	  break;
	case Wor1:
	  newvalstr[0] = '1';
	  break;
	case WorX:
	  newvalstr[0] = 'X';
	  break;
	case WorZ:
	  newvalstr[0] = 'Z';
	  break;
	}
    }
}

void handle_dtran_save()
{
tf_message(ERR_WARNING, "Verilog", "DTRNSV", 
           "The DTRAN does not support $save");
}

void handle_dtran_restore(){
tf_message(ERR_WARNING, "Verilog", "DTRNRST", 
           "The DTRAN does not support $restart");
}
