/* Created:   Thu Dec 20 12:28:01 1990 by rays */
/* Last Edit: Tue May  7 15:41:22 1991 by rays */
#include "dtran.h"
/*                         
                          DTRAN CHECKTF

PLEASE READ DTRAN_PROGRAM.DOC BEFORE READING THIS DOCUMENTATION

This routine sets up the dtran data structure and fills it.

It counts the drivers on neta and netb.  Then it uses this information
to allocate memory for a structure to store the data structure.  The data
structure looks like this:


typedef struct {
  int 
    number_of_a_drivers,
    number_of_b_drivers,
    *a_values,
    *b_values,
    a_nettype,
    b_nettype;
} dtran_inst_info;

a_values and b_values are pointers to arrays.  dtran_checktf uses the
number of a and b drivers to allocate memory for the value arrays.  This
array will be filled by values the first time the drivers change value.

After setting up the instance specific data structure, dtran_checktf
sets up the vcl monitoring.  First it allocates a data strucutre for
the consumer routine.  This structure looks like this:


typedef struct {
  char *instance;  S* The instance pointer for a dtran *S
  int  *value;    S* A pointer to the array member this terminal effects *S
  int  nettype;
} consumer_data;


The consumer routine will use the instance pointer to schedule the misctf
routine.  It uses the net type to decide on the value representation, 
and it uses the value pointer to store the value.

The value pointer is a pointer to a specific element in the a_values or
b_values array.  The consumer routine will store the value of the terminal
in the value array by using the value pointer.

Notice that this method allows the consumer routine to be very efficient.
It doesn't have to figure out the net type, and it doesn't have to know if 
its on the a_net or b_net side of the dtran.  All these details are handled
once, in dtran_checktf.

*/

int dtran_checktf()
{
 
  handle module, porta, portb, neta, netb, driver;
  int 
    numb_a_drivers, numb_b_drivers,
    *a_ptr, *b_ptr,

    initialize_array();
  char *instance;
  dtran_inst_info *info;
  consumer_data *c_data;
  void dtran_consumer();

  acc_initialize();
#if 0
/* acc_configure(accDevelopmentVersion, "??"); */
#endif
 module = acc_handle_parent(acc_handle_tfarg(1));
  
  porta = acc_next_port(module, null);
  neta = acc_next_hiconn(porta, null);
  numb_a_drivers = acc_count(acc_next_driver, neta)-1;
  portb = acc_next_port(module, porta);
  netb = acc_next_hiconn(portb, null);
  numb_b_drivers = acc_count(acc_next_driver, netb)-1;

  info = (dtran_inst_info *) malloc (sizeof(dtran_inst_info));

  tf_setworkarea((char *)info);

  info -> number_of_a_drivers = numb_a_drivers;
  info -> number_of_b_drivers = numb_b_drivers;

  info -> a_values = (int *) malloc (sizeof(int) * numb_a_drivers);
  info -> b_values = (int *) malloc (sizeof(int) * numb_b_drivers);

  info -> a_nettype = acc_fetch_fulltype(
                           acc_handle_simulated_net(neta));
  info -> b_nettype = acc_fetch_fulltype(
      			   acc_handle_simulated_net(netb));

  instance = tf_getinstance();

  /* now set up the monitoring circuit */
  a_ptr = info -> a_values;
  driver = null;
  while ((driver = acc_next_driver(neta,driver)) != null)
    {
      if (!acc_compare_handles(
		acc_handle_parent(
                  acc_handle_parent(
                    acc_handle_parent(driver))), module))
	{
	  *a_ptr = initialize_array(info -> a_nettype);
	  c_data = (consumer_data *) malloc(sizeof(consumer_data));
	  c_data -> instance = instance;
	  c_data -> nettype = info -> a_nettype;
	  c_data -> value = a_ptr;
	  acc_vcl_add(driver, (int (*)())dtran_consumer, (char *)c_data, vcl_verilog_logic);
	  a_ptr++;
	}
    }
  b_ptr = info -> b_values;
  driver = null;
  while ((driver = acc_next_driver(netb,driver)) != null)
    {
      if (!acc_compare_handles(
		acc_handle_parent(
                  acc_handle_parent(
                    acc_handle_parent(driver))), module))
	  {
	    *b_ptr = initialize_array(info -> b_nettype);
	    c_data = (consumer_data *) malloc(sizeof(consumer_data));
	    c_data -> instance = instance;
	    c_data -> nettype = info -> b_nettype;
	    c_data -> value = b_ptr;
	    acc_vcl_add(driver, (int (*)())dtran_consumer, (char *)c_data, vcl_verilog_logic);
	    b_ptr++;
	  }
    }

  return 0;
}


int initialize_array(nettype)
     int nettype;
{
  switch (nettype)
    {
    case accWire:
    case accTri:
      return (WireX);
    case accWand:
    case accTriand:
      return (WandX);
    case accWor:
    case accTrior:
      return (WorX);
    default:
      tf_message(ERR_ERROR, "Dtran", "BADNET", "Bad nettype on dtran %s",
	 acc_fetch_fullname(acc_handle_parent(acc_handle_tfarg(1))));
    }
  tf_synchronize();

  return 0;
}

