primitive dff(q,clk,d);
input clk, d;
output q;
reg q;

   table
   //  clk   d  :  q  :  q+
        r    0  :  ?  :  0;
        r    1  :  ?  :  1;
        f    ?  :  ?  :  -;
        ?    *  :  ?  :  -;
   endtable
endprimitive


// D flip-flop path delay timing model
`celldefine
module dflop(q,qb,clk,d);
input clk, d;
output q, qb;

   dff g1(q,clk,d);
   not g2(qb,q);

   specify
      // specparam attributes
      specparam FanoutLoad$clk = 1,
                FanoutLoad$d = 2,
                FanoutLoad$q = 25,
                FanoutLoad$qb = 28,
                RiseStrength$clk$q = 5,
                FallStrength$clk$q = 4,
                RiseStrength$clk$qb = 9,
                FallStrength$clk$qb = 6;

      // path delays
      (clk *> q) = 102;
      (clk *> qb) = 156;

      // timing checks
      $setup(d,edge[01,x1] clk,9);
      $hold(posedge clk,d,6);
   endspecify
endmodule
`endcelldefine


// 2x1 multiplexer path delay timing model
`celldefine
module mux21(y,i1,i2,sel);
input i1, i2, sel;
output y;

   bufif0 g1(yi,i1,sel);
   bufif1 g2(yi,i2,sel);
   buf g3(y,yi);

   specify
      // specparam attributes
      specparam FanoutLoad$sel = 2,
                FanoutLoad$y = 15,
                FanoutLoad$ = 3,
                RiseStrength$ = 4,
                FallStrength$ = 3;

      // path delays
      (sel *> y) = 72;
      (i1,i2 *> y) = 56;
   endspecify
endmodule
`endcelldefine


module rmux221(q,qb,da,db,select,clk);
input select, clk;
input [1:0] da, db;
output [1:0] q, qb;

   mux21 m1(dm1,da[0],db[0],select);
   mux21 m2(dm2,da[1],db[1],select);
   dflop m3(q[0],qb[0],clk,dm1);
   dflop m4(q[1],qb[1],clk,dm2);
endmodule


module top;

reg clk, select;
reg [1:0] da, db;
wire [1:0] q, qb;

   rmux221 m1(q,qb,da,db,select,clk);

   // calculate delays
   initial
      $dcalc_path("test_inp.cap");

   // monitor
   initial
      $monitor($time,,"clk=%b  sel=%b  da=%b  db=%b  q=%b  qb=%b",
                                                        clk,select,da,db,q,qb);

   // clock
   initial
   begin 
      clk = 0;
      forever
         #200 clk = ~clk;
   end

   initial
   begin
      // test clocking through 'da'
      $display("test clocking through 'da'");
      da = 0;
      select = 0;
      repeat(3) 
         @(negedge clk) da = da + 1;

      @(negedge clk);

      // test clocking through 'db'
      $display("\ntest clocking through 'db'");
      db = 0;
      select = 1;
      repeat(3)
         @(negedge clk) db = db + 1;

      @(negedge clk);

      // violate setup time
      $display("\nviolate setup time\n");
      @(negedge clk)
         #140 db = ~db;

      @(negedge clk);

      // violate hold time
      $display("\nviolate hold time\n");
      @(negedge clk)
         #148 db = ~db;

      @(negedge clk)
         $finish;
   end 
endmodule

