/*
	etc.c -- etc routines (common use routines)
*/

#include	<stdio.h>
#include	<ctype.h>

#include	"veriuser.h"

#include	"common.h"

char *xalloc(n)
SIZE_T n;
{
	REG char *p;

	if ((p = calloc((SIZE_T)1, n)) == NULL) {
		fprintf(stderr, "Not enough memory.\n");
		exit(1);
	} else {
		return (p);
	}
}

char *strsave(p)
char *p;
{
	char *strcpy();
	return (strcpy(xalloc(strlen(p) + 1), p));
}

unsigned *usave(p, n)
unsigned *p;
SIZE_T n;
{
	unsigned *r, *q;

	r = q = unew(n);
	while (n--)
		*q++ = *p++;
	return (r);
}

unsigned *ucopy(s, d, n)
REG unsigned *s, *d;
REG SIZE_T n;
{
	while (n--)
		*d++ = *s++;
	return (d);
}

unsigned *unew(n)
REG SIZE_T n;
{
	return ((unsigned *)xalloc(n * sizeof(unsigned)));
}

int htoi(ch)
int ch;
{
	char c;
	int n;

	c = isupper(ch) ? tolower(ch) : ch;
	if (isdigit(c))
		n = c - '0';
	else if ('a' <= c && c <= 'f')
		n = c - 'a' + 10;
	else
		n = -1;
	return (n);
}
