// This Program is  the Confidential and Proprietary product  //
// of Cadence   Design Systems, Inc.   Any  unauthorized use, //
// reproduction   or  transfer of  this  program  is strictly //
// prohibited. Copyright (c)1992  by Cadence Design  Systems, //
// Inc.  All Rights Reserved.                                 //

module alu_16 (Cn, Din, Clk, Sel, A_, A_eq_B, Cout);

input [15:0] Din;
input [4:0] Sel;
input Cn, Clk;

output [15:0] A_;
output A_eq_B, Cout;

reg [15:0] A_, B_;

wire Cout;
wire [15:0] Fout_, y;
wire [16:0] x, arith_result, logic_result;

arith u1 (Cn, x,y,Sel,arith_result);

logic u3 (A_, B_, Sel, logic_result, x, y);

assign {Cout,Fout_} = (Sel[4] == 1'b1) ? logic_result : arith_result;

assign A_eq_B = (Fout_ == 16'hFFFF ? 1'b1 : 1'b0);

always @(posedge Clk)
  begin
    B_ = Din;
    A_ = Fout_;
  end

endmodule




module logic (A_, B_, Sel, logic_result, x, y); // this is a test

input [15:0] A_, B_;
input [4:0] Sel;

output [16:0] x, logic_result;
output [15:0] y;

reg [16:0] x, logic_result;
reg [15:0] y;
	
always @(Sel or A_ or B_ )
  begin
    x = A_; y = A_; logic_result = A_; 
    case (Sel)
      5'b10000: logic_result = ~A_;
      5'b10001: logic_result = ~(A_ | B_);
      5'b10010: logic_result = ~A_ & B_;
      5'b10011: logic_result = 17'h10000;

      5'b10100: logic_result = ~(A_ & B_);
      5'b10101: logic_result = ~B_;
      5'b10110: logic_result = A_ ^ B_;
      5'b10111: logic_result = A_ & ~B_;

      5'b11000: logic_result = ~A_ | B_;
      5'b11001: logic_result = ~(A_ ^ B_);
      5'b11010: logic_result = B_;
      5'b11011: logic_result = A_ & B_;

      5'b11100: logic_result = 17'h0ffff;
      5'b11101: logic_result = A_ | ~B_;
      5'b11110: logic_result = A_ | B_;

      5'b00000: begin
                  x=A_;
		  y=16'h0000;
		end

      5'b00001: begin
                  x=(A_ | B_);
	          y=16'h0000;
		end

      5'b00010: begin
                  x = (A_ | ~B_);
	          y=16'h0000;
		end

      5'b00011: begin
                  x = 4'hf;
	          y=16'h0000;
		end

      5'b00100: y=(A_ & ~B_);

      5'b00101: begin
		  x=(A_ | B_); 
	          y=(A_ & ~B_);
		end

      5'b00110: begin
	          x=(A_ - B_);
	          y=16'h0001;
		end

      5'b00111: begin
                  x=(A_ & ~B_); 
	          y=16'h0001;
	        end

      5'b01000: y=(A_ & B_);

      5'b01001: y=B_;

      5'b01010: begin
	          x=(A_ | ~B_); 
	          y=(A_ & B_);
	        end

      5'b01011: begin
	          x=(A_ & B_); 
 	          y=16'h0001;
	        end

      5'b01101: x=(A_ | B_); 

      5'b01110: x=(A_ | ~B_); 

      5'b01111: y=16'h0001;
		
      default:  begin
	          logic_result = A_;
	          x = A_; 
                  y = A_;
                end
    endcase
  end
endmodule




module arith (Cn, x, y, Sel, arith_result);
input [4:0] Sel;
input [16:0] x;
input [15:0] y;
input Cn;

output [16:0] arith_result;

reg[16:0] arith_result, int_res;

always@(x or y or Sel or Cn)
  case (Sel[3:0])
    4'h6, 4'h7, 4'hb, 4'hf : arith_result = x - y + !Cn;
    default : begin
                int_res = x[15:0] + y[15:0] + !Cn;
                arith_result = {~int_res[16],int_res[15:0]};
              end
  endcase
endmodule

module test_alu;

   reg [15:0] Din, op_a, op_b;
   reg [4:0] Sel, sel;
   reg Clk, Cin_, cn;

   wire [15:0] A_;
   wire Co, AeqB;

   integer strobe_out, i, j;

   alu_16 u1 (Cin_, Din, Clk, Sel, A_, A_eq_B, Cout);
   

  always
  #100 $fstrobe(strobe_out,$time,"  Clk=%b  Din=%h  op_a=%h  Cin_=%b  Sel=%h  A_=%h  Cout_=%b  A_eq_B=%b",
        Clk, Din, op_a, Cin_, Sel, A_, Cout, A_eq_B);




   initial 
      begin
      strobe_out = $fopen("strobe.dat");

      #10 Clk=0; 

      perform_op(16'h0000, 16'h0000, 5'h1a, 1'b1);   
      perform_op(16'haaff, 16'h4321, 5'h03, 1'b0);
      perform_op(16'haaaa, 16'h1234, 5'h10, 1'b1);	

//      $stop;

      begin
	op_a = 16'hff00;
        op_b = 16'h0af0;
        cn = 1'b1;
        for(i=0;i<1000;i=i+1)
           begin
		op_a = op_a + 1;
                op_b = op_b + 3;
                cn = ~cn;
                for(j=0;j<32;j=j+1)
                 begin
                  sel = j;
                  perform_op(op_a, op_b, sel, cn);	
                 end
           end
      end







//repeat(2000) begin ran=$random; doit(ran[36:21],ran[20:5],ran[4:0]); end // new
	  $stop;
      $finish;
      end


task perform_op;
input [15:0] rega;
input [15:0] regb;
input [4:0] sel;
input cn;
begin
    #20 Clk = 0; Din = rega; 		// op_a
    #25 Clk = 1;			// clk 1st op into B_
    #5  Sel=5'b11010;       		// pass B_ thru ALU
    #20 Clk = 0; Din = regb; Cin_=cn;  	// op_b
    #25 Clk = 1;                        // clk ALU output into A_, clk 2nd op into B_
    #5  Sel=sel;			// perform operation
end
endtask

endmodule


