/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC7000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : D-LATCH WITH SET and RESET.
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`delay_mode_path

`timescale  1 ns / 100 ps
`celldefine 
module ldcpx1 (q, clr, d, g, pre);

    parameter size = 1;
    
    output   q;
    
    input    clr, d, g, pre;

`protect

    // if not connected, default to 0
    tri0     clr, pre;

    reg  NOTIFY_REG;

	// used for timing checks
	not  NOT2 (PREB, pre);
	not  NOT1 (CLRB, clr);
	and  AND1 (CLRB_PREB, CLRB, PREB);

     	U_LD_P_S_R_NO
            INST1 (q, d, g, clr, pre, NOTIFY_REG);
            
    specify
    
    // Specify path delays
     
	if (!clr && !pre && g)
	    (d +=> q) = (1, 1);

	if (!clr && !pre)
	    (posedge g  => (q +: d))    = (1, 1);

	if (!clr)
	     (posedge pre => (q +: 1'b1)) = (1, 1);

	(posedge clr => (q +: 1'b0)) = (1, 1);

	if (g && !clr)
	    (negedge pre => (q +: d))    = (1, 1);
	 
	if (g && !pre)
	    (negedge clr => (q +: d))    = (1, 1);

     // Timing Checks
     
	// setup and hold checks between d and the falling edge of g 
	// when clr=0 pre=0
	$setuphold(negedge g &&& CLRB_PREB, d, 1, 1, NOTIFY_REG);
     
	// setup and hold checks between the falling edge of pre and the falling edge of g
	// when clr=0
	$setuphold(negedge g &&& CLRB_PREB, pre, 1, 1, NOTIFY_REG);
     
	// setup and hold checks between the falling edge of clr and the falling edge of g
	// when  pre=0
	$setuphold(negedge g &&& CLRB_PREB, clr, 1, 1, NOTIFY_REG);
     
    // pulse width checks

	// g high time when clr=0 pre=0
	$width(posedge g &&& CLRB_PREB, 1, 1, NOTIFY_REG);

	// clear high time
	$width(posedge clr, 1, 1, NOTIFY_REG);

	// pre high time when clr=0
	$width(posedge pre &&& CLRB, 1, 1, NOTIFY_REG);

   
    endspecify

`endprotect

endmodule
`endcelldefine
    

