/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC7000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : D-FLIP-FLOP
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/

`delay_mode_path

`timescale  1 ns / 100 ps 
`celldefine     
module fdcp (q, c, clr, d, prld, pre);

    parameter size = 1;
    
    output   q;
    
    input    c, clr, d, prld, pre;

`protect

    // if not connected, default to 0
    tri0     clr, pre, prld;

    reg  NOTIFY_REG;
    
	// clear circuitry
        or      OR1 (RESET, clr, prld);

	// used for timing checks
	nor	NOR1 (PRLD_CLR_PREB, clr, pre, prld);
	nor	NOR2 (PRLD_CLRB, prld, clr);
	
	U_FD_P_R_S_NO
	     INST1 (q, d, c, RESET, pre, NOTIFY_REG);
            

    specify
    
    // Specify path delays

	// d->q delay on posedge of clock
	if (!clr && !prld && !pre)
	    (posedge c => (q +: d)) = (1, 1);

	// clear FF with clr, q->0 delay
	if (!prld)
	    (posedge clr => (q +: 1'b0)) = (1, 1);

	// preset FF, q->1 delay
	if (!prld && !clr)
	    (posedge pre => (q +: 1'b1)) = (1, 1);

	// clear FF with prld,  q->0 delay
	(posedge prld => (q +: 1'b0)) = (1, 1);
      
     // Timing Checks
     
	// setup and hold checks between d and the rising edge of clock 
	// when prld=0 clr=0 pre=0
	$setuphold(posedge c &&& PRLD_CLR_PREB, d, 1, 1, NOTIFY_REG);
     
	// setup and hold checks between the falling edge of pre and the rising edge of clock
	// when prld=0 clr=0
	$setuphold(posedge c &&& PRLD_CLR_PREB, pre, 1, 1, NOTIFY_REG);
     
	// setup and hold checks between the falling edge of clr and the rising edge of clock
	// when prld=0 pre=0
	$setuphold(posedge c &&& PRLD_CLR_PREB, clr, 1, 1, NOTIFY_REG);
     
	// setup and hold checks between the falling edge of prld and the rising edge of clock
	// when clr=0 pre=0
	$setuphold(posedge c &&& PRLD_CLR_PREB, prld, 1, 1, NOTIFY_REG);
     
    // pulse width checks

	// clock high time when prld=0 clr=0 pre=0
	$width(posedge c &&& PRLD_CLR_PREB, 1, 1, NOTIFY_REG);

	// clock low time when prld=0 clr=0 pre=0
	$width(negedge c &&& PRLD_CLR_PREB, 1, 1, NOTIFY_REG);
     
	// prld high time
	$width(posedge prld, 1, 1, NOTIFY_REG);

	// clear high time when prld=0
	$width(posedge clr &&& ~prld, 1, 1, NOTIFY_REG);

	// pre high time when prld=0 clr=0
	$width(posedge pre &&& PRLD_CLRB, 1, 1, NOTIFY_REG);

    endspecify

`endprotect

endmodule
`endcelldefine
                                                                                                                                                 



