
//do a single PCI write cycle
task pci_wrs;//single data phase
input [31:0] Address, Data;
input [3:0] Cmd, BytEn;
begin
  $display("Writing Data = %h", Data,
           " 	To Address = %h", Address,
	   "	at Time = %0t", $time);
  @(posedge CLK) begin
	AD_OE = 1'b1;
	CBE_OE = 1'b1;
    	FRAMEn = 1'b0;
    	AD_REG = Address;
    	PCI_CBE_REG = Cmd;
    end //first clock
  @(posedge CLK) begin
	PAR_OE = 1'b1;
    	AD_REG = Data;
	PAR_REG = (^Address) ^ (^Cmd);
	IRDYn = 1'b0;
    	FRAMEn = 1'b1; // to do only a single transfer
	PCI_CBE_REG = BytEn;
    end //2nd clock
  fork
    begin //parity
    	@(posedge CLK) PAR_REG = (^Data) ^ (^BytEn);
    end
    begin //wait TRDY and TERMinate
 	wait(~TRDYn);
	@(posedge CLK) IRDYn = 1'b1;
	AD_OE = 1'b0;
	PAR_OE = 1'b0;	
	CBE_OE = 1'b0;
    end
  join
end
endtask