task pci_rdm;//Nbeats data phases read burst
input [31:0] Address, Data;
input [3:0] Cmd, BytEn;
input [7:0] Nbeats;
integer i;
reg [31:0] ExpData, DataRegQ, DataReg;
reg ParReg;
begin
  DataRegQ = 32'b0;
  ExpData = Data;
  $display("Reading Data = %h", ExpData,
           "	From Address = %h", Address,
	   "	at Time = %0t", $time);
  @(posedge CLK) begin
	AD_OE = 1'b1;
	CBE_OE = 1'b1;
    	FRAMEn = 1'b0;
    	AD_REG = Address;
    	PCI_CBE_REG = Cmd;
    end //first clock
  @(posedge CLK) begin
	PAR_OE = 1'b1;
	AD_OE = 1'b0;
	PAR_REG = (^Address) ^ (^Cmd);
	IRDYn = 1'b0;
	PCI_CBE_REG = BytEn;
    end //2nd clock
   fork
	@(posedge CLK) PAR_OE = 1'b0;
  	for (i=0; i<Nbeats; i=i+1) begin
	    wait(~TRDYn);
      	    @(posedge CLK) begin
		DataRegQ <= DataReg;
	        DataReg <= PCI_AD;
	        ParReg <= PCI_PAR;
	        if(i==Nbeats-1) IRDYn = 1'b1;
	        if(i==Nbeats-2) FRAMEn <= 1'b1;
	    end
	    if ((ExpData) != PCI_AD) $display("ERROR: Expected Data %h", ExpData,
                                         "	Actual Data %h", PCI_AD,
                                         "	at time = %0t", $time);
	    if((i>1) & (ParReg != (^DataRegQ ^ ^PCI_CBE_REG)))
		                 $display("Parity Error at %0t", $time);
	    ExpData = ExpData +1'b1;
 	end//for
    join
    @(posedge CLK) begin 
	CBE_OE = 1'b0; 
	ParReg <= PCI_PAR;
	if(ParReg != (^DataRegQ ^ ^PCI_CBE_REG)) $display("Parity Error at %t", $time);
    end 
end
endtask