module arbiter(CLK, RSTn, LOC_REQ, PCI_REQ, PCI_GNT, LOC_GNT_D, PCI_GNT_D);
input CLK, RSTn, LOC_REQ, PCI_REQ;
output PCI_GNT, LOC_GNT_D, PCI_GNT_D;
reg LOC_GNT, PCI_GNT, LAST_LOC;
reg LOC_GNT_D, PCI_GNT_D;

always @(LOC_REQ or PCI_REQ or LAST_LOC or LOC_GNT or PCI_GNT or RSTn)
//these are the transition equations for the arbiter state machine
begin
    LOC_GNT_D = 1'b0;
    PCI_GNT_D = 1'b0;
    casex({LOC_GNT, PCI_GNT})//(current state)
        2'b00: begin   //ungranted
	    if (LOC_REQ & (~PCI_REQ | ~LAST_LOC) )LOC_GNT_D = 1;
            else if (PCI_REQ) PCI_GNT_D = 1;
        end

	2'bx1: begin  //granted to PCI
	    if(PCI_REQ) begin
		    PCI_GNT_D = 1'b1;
	        end
	    end

	2'b1x: begin  //granted to LOC
	    if(LOC_REQ) begin
		    LOC_GNT_D = 1'b1;
	        end
	    end
    endcase
end

//LAST_LOC stores which port was last granted access
//so higher priority can be given to opposite port 
always @(posedge CLK or negedge RSTn)
begin
   if(~RSTn)LAST_LOC = 1'b0;
   else if (LOC_GNT) LAST_LOC = 1'b0;
   else if (PCI_GNT) LAST_LOC = 1'b1;
end

//instantiate the arbiter state machine flipflops
always @(posedge CLK or negedge RSTn)
begin
    if(~RSTn) begin
	LOC_GNT <= 1'b0;	
	PCI_GNT <= 1'b0;	
    end
    else begin
	LOC_GNT <= LOC_GNT_D;	
	PCI_GNT <= PCI_GNT_D;	
    end
end
endmodule