/* Example of Instatiating a RPM
 * RPM_EXAMPLE.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995                                    */

module rpm_example (B_IN3, B_IN2, B_IN1, B_IN0, 
		    D_IN3, D_IN2, D_IN1, D_IN0, 
                    CI_IN, L_IN, ADD_IN, CE_OUT, 
		    CLK_IN, Q_OUT3, Q_OUT2, Q_OUT1,
                    Q_OUT0, CO_OUT, OFL_OUT);

input  B_IN3, B_IN2, B_IN1, B_IN0, D_IN3, 
       D_IN2, D_IN1, D_IN0, 
       CI_IN, L_IN, ADD_IN, CE_OUT, CLK_IN;
output Q_OUT3, Q_OUT2, Q_OUT1, Q_OUT0, CO_OUT, 
       OFL_OUT;

acc4 U1 (.B3(B_IN3), .B2(B_IN2), .B1(B_IN1), 
	 .B0(B_IN0), .D3(D_IN3), .D2(D_IN2),
         .D1(D_IN1), .D0(D_IN0), .CI(CI_IN), 
	 .L(L_IN), .ADD(ADD_IN), .CE(CE_OUT),
         .C(CLK_IN), .Q3(Q_OUT3), .Q2(Q_OUT2), 
	 .Q1(Q_OUT1), .Q0(Q_OUT0),
         .CO(CO_OUT), .OFL(OFL_OUT)); 	

endmodule

module acc4 (B3, B2, B1, B0, D3, D2, D1, D0, 
	     CI, L, ADD, CE, C, Q3, Q2, Q1, Q0,
             CO, OFL);

input  B3, B2, B1, B0, D3, D2, D1, D0, 
       CI, L, ADD, CE, C;
output Q3, Q2, Q1, Q0, CO, OFL;

endmodule 
   
