/* Edge Encoder
 * A XC4000 LCA has special decoder circuits 
 * at each edge. These decoders and open-drained
 * wired-AND gates. When one or more of the inputs 
 * (i) are Low output(0) is Low. When all of the 
 * inputs are High, the output is High.  A pull-up  
 * resistor must be connected to the output node 
 * to achieve a true logic High. 

 * IO_DECODER.v
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995                                  */
 
module io_decoder (CLOCK, CS, DATA, ADR, QOUT);

input 	CLOCK;
input 	CS;
input 	[3:0]	DATA;
input 	[4:0]	ADR;
output	[3:0] 	QOUT;

wire 	[3:0]	CLKEN;
wire	[3:0] 	ADR_INV, CLB_INV;
reg 	[3:0]	CLB_INT;
reg 	[3:0]	QOUT;
wire 	[3:0]	DECODE;

assign ADR_INV = ~ADR[3:0];
assign CLB_INV = ~CLB_INT;

/* instantiation of Edge Decoder: Output "DECODE[0]" */
 
    DECODE4 A0 (.A3(ADR[3]), .A2(ADR[2]), .A1(ADR[1]), 
		.A0(ADR_INV[0]), .O(DECODE[0]));
    
    DECODE1_IO A1 (.I(ADR[4]), .O(DECODE[0]));

    DECODE1_INT A2 (.I(CLB_INV[0]), .O(DECODE[0])); 
    
    DECODE1_INT A3 (.I(CLB_INT[1]), .O(DECODE[0])); 
   
    DECODE1_INT A4 (.I(CLB_INT[2]), .O(DECODE[0])); 
   
    DECODE1_INT A5 (.I(CLB_INT[3]), .O(DECODE[0])); 
	
    PULLUP A6 (.O(DECODE[0]));

/* instantiation of Edge Decoder: Output "DECODE[1]" */
  
    DECODE4 B0 (.A3(ADR[3]), .A2(ADR[2]), .A1(ADR_INV[1]),
                .A0(ADR[0]), .O(DECODE[0]));
 
    DECODE1_IO B1 (.I(ADR[4]), .O(DECODE[1]));
 
    DECODE1_INT B2 (.I(CLB_INT[0]), .O(DECODE[1]));
 
    DECODE1_INT B3 (.I(CLB_INV[1]), .O(DECODE[1]));
 
    DECODE1_INT B4 (.I(CLB_INT[2]), .O(DECODE[1]));
  
    DECODE1_INT B5 (.I(CLB_INT[3]), .O(DECODE[1]));
       
    PULLUP B6 (.O(DECODE[1]));

/* instantiation of Edge Decoder: Output "DECODE[2]" */
    
    DECODE4 C0 (.A3(ADR[3]), .A2(ADR_INV[2]), .A1(ADR[1]),
                .A0(ADR[0]), .O(DECODE[0]));
 
    DECODE1_IO C1 (.I(ADR[4]), .O(DECODE[2]));
 
    DECODE1_INT C2 (.I(CLB_INT[0]), .O(DECODE[2]));
 
    DECODE1_INT C3 (.I(CLB_INT[1]), .O(DECODE[2]));
 
    DECODE1_INT C4 (.I(CLB_INV[2]), .O(DECODE[2]));
  
    DECODE1_INT C5 (.I(CLB_INT[3]), .O(DECODE[2]));
       
    PULLUP C6 (.O(DECODE[2]));

/* instantiation of Edge Decoder: Output "DECODE[3]" */
   
    DECODE4 D0 (.A3(ADR_INV[3]), .A2(ADR[2]), .A1(ADR[1]),
                .A0(ADR[0]), .O(DECODE[0]));
 
    DECODE1_IO D1 (.I(ADR[4]), .O(DECODE[3]));
 
    DECODE1_INT D2 (.I(CLB_INT[0]), .O(DECODE[3]));
 
    DECODE1_INT D3 (.I(CLB_INT[1]), .O(DECODE[3]));
 
    DECODE1_INT D4 (.I(CLB_INT[2]), .O(DECODE[3]));
  
    DECODE1_INT D5 (.I(CLB_INV[3]), .O(DECODE[3]));
       
    PULLUP D6 (.O(DECODE[3]));

/* CLKEN is the AND function of CS & DECODE */

assign CLKEN[0] = CS & DECODE[0];
assign CLKEN[1] = CS & DECODE[1];
assign CLKEN[2] = CS & DECODE[2];
assign CLKEN[3] = CS & DECODE[3];

/* internal 4-bit counter */
    always @ (posedge CLOCK)
    begin
            CLB_INT = CLB_INT + 1'b1;
    end

/* "QOUT[0]" Data Register Enabled by "CLKEN[0]" */
    always @ (posedge CLOCK)
    begin
	if (CLKEN[0] == 1'b1) 
	    QOUT[0] = DATA[0];
    end

/* "QOUT[1]" Data Register Enabled by "CLKEN[1]" */
    always @ (posedge CLOCK)
    begin
     	if (CLKEN[1] == 1'b1) 
            QOUT[1] = DATA[1];
    end

/* "QOUT[2]" Data Register Enabled by "CLKEN[2]" */
    always @ (posedge CLOCK)
        begin
        if (CLKEN[2] == 1'b1) 
            QOUT[2] = DATA[2];
        end

/* "QOUT[3]" Data Register Enabled by "CLKEN[3]" */
    always @ (posedge CLOCK)
    begin
        if (CLKEN[3] == 1'b1) 
            QOUT[3] = DATA[3];
        end

endmodule 
