/*
 * BIDI_REG.V - Structural Model
 * Register Bidirectional I/O Example
 * Xilinx HDL Synthesis Design Guide for FPGAs
 *	@(#)bidi_reg.v	8/19/94
 */

module bidi_reg (SIGA, LOADA, CLOCK1, CLOCK2, RST) ;
inout	[3:0]	SIGA ;
input 		LOADA ;
input		CLOCK1 ;
input		CLOCK2 ;
input		RST;

wire	[3:0]	INA, OUTA ;
// Netlist

reg4 U5 (INA, LOADA, CLOCK1, RST, OUTA) ;


OFDT_F	U0 (.D(OUTA[0]), .C(CLOCK2), .T(LOADA), .O(SIGA[0])) ;
OFDT_F	U1 (.D(OUTA[1]), .C(CLOCK2), .T(LOADA), .O(SIGA[1])) ;
OFDT_F	U2 (.D(OUTA[2]), .C(CLOCK2), .T(LOADA), .O(SIGA[2])) ;
OFDT_F	U3 (.D(OUTA[3]), .C(CLOCK2), .T(LOADA), .O(SIGA[3])) ;
IBUF	U4 (.I(SIGA[0]), .O(INA[0])) ;
IBUF	U6 (.I(SIGA[1]), .O(INA[1])) ;
IBUF	U7 (.I(SIGA[2]), .O(INA[2])) ;
IBUF	U8 (.I(SIGA[3]), .O(INA[3])) ;

endmodule
