/* BARREL.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * XAPP 26 [1994 Data Book p. 8-152]
 * 16-bit barrelshifter [shift right]
 * June 1995                                  */

module barrel (S, A_P, B_P);
 
input [3:0] S;
input [15:0] A_P;
output [15:0] B_P;
 
reg [15:0] B_P;

wire [1:0] SEL1, SEL2;
reg [15:0] C; 

assign SEL1 = S[1:0];
assign SEL2 = S[3:2];

    always @ (A_P or SEL1)
	begin
        case (SEL1) 
             2'b00 : // Shift by 0 
	       	begin	
               	C 	<= A_P;
		end

             2'b01 : // Shift by 1
		begin
               	C[15]   <= A_P[0];
               	C[14:0]	<= A_P[15:1];
		end

             2'b10 : // Shift by 2
		begin
               	C[15:14] <= A_P[1:0];
               	C[13:0]  <= A_P[15:2];
		end
             
	     2'b11 : // Shift by 3
		begin
               	C[15:13] <= A_P[2:0];
               	C[12:0]  <= A_P[15:3];
		end

             default :
	       	C        <= A_P;
        endcase
    end 

    always @ (C or SEL2)
    begin
        case (SEL2) 
            2'b00 : // Shift by 0
		begin
               	B_P 		<=  C;
		end
     
            2'b01 : // Shift by 4
		begin
               	B_P[15:12] 	<= C[3:0];
               	B_P[11:0]	<= C[15:4];
		end

            2'b10 : // Shift by 8 
		begin
               	B_P[7:0] 	<= C[15:8];
	       	B_P[15:8]	<= C[7:0];
		end

            2'b11 : // Shift by 12 
		begin
	       	B_P[3:0]   	<= C[15:12];
	       	B_P[15:4]  	<= C[11:0];
		end

            default :
               	B_P               <= C;
        endcase
    end 

endmodule
