/*  COUNT8.V
 *  Xilinx HDL Synthesis Design Guide for FPGAs
 *  8 bit counter with enable and clear
 *  May, 1995                                         */

module count8(CLOCK, CLEAR, ENABLE, COUT);
input         CLOCK;
input         CLEAR;
input         ENABLE;
output [7:0]  COUT;

reg    [7:0]  COUT;

always @(posedge CLEAR or posedge CLOCK)
begin
    if (CLEAR == 1'b1)
       COUT = 8'h00;
    else if (ENABLE == 1'b1)
       COUT = COUT + 1'b1;
end

endmodule
