/* 
 * ALIGN_STR.V 
 * This example contains two 8 bit registers, two 8 bit counters, and a 8 bit
 * bidirectional bus. The counters are tri-stated to the bidirectional bus.
 * Xilinx HDL Synthesis Design Guide for FPGAs
 *     align_str.v  5/17/95
 */

module align_str (X, CLK, CLR_C, CLR_D, EN_C, EN_D, MUX_SEL, SEL) ;
inout 	[7:0]	X;
input		CLK;
input		CLR_C;
input		CLR_D;
input		EN_C;
input		EN_D;
input	[1:0]  	MUX_SEL;
input           SEL;

wire	[7:0]	C, D;

reg	[7:0]	A, B, X_I;

// Instantiating the 8 bit counter. 
count8	countC (.CLOCK(CLK), .CLEAR(CLR_C), .ENABLE(EN_C), .COUT(C)) ;
count8  countD (.CLOCK(CLK), .CLEAR(CLR_D), .ENABLE(EN_D), .COUT(D)) ;

assign X = (!SEL) ? X_I : 8'bz;

always @ (MUX_SEL or A)
    begin
        if (MUX_SEL == 2'b00)
            X_I = A;
        else
            X_I = 8'bz;
    end

always @ (MUX_SEL or B)
    begin
        if (MUX_SEL == 2'b01)
            X_I = B;
        else
            X_I = 8'bz;
    end

always @ (MUX_SEL or C)
    begin
        if (MUX_SEL == 2'b10)
            X_I = C;
        else
            X_I = 8'bz;
    end

always @ (MUX_SEL or D)
    begin
        if (MUX_SEL == 2'b11)
            X_I = D;
        else
            X_I = 8'bz;
    end

always @( posedge CLK )
    begin
       A = X;
       B = X;
    end

endmodule

