/* TIME_STATE_MACHINE.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995 */

module time_state_machine (TIME_BUTTON, HOURS_BUTTON, 
       MINUTES_BUTTON, CLK, SECS, HOURS, MINS);
input TIME_BUTTON, HOURS_BUTTON, MINUTES_BUTTON, CLK;
output SECS, HOURS, MINS;

parameter COUNT_TIME=0, SET_HOURS=1, SET_MINUTES=2;

reg [1:0] CURRENT_STATE, NEXT_STATE;
reg SECS, HOURS, MINS;
	
always @ (CURRENT_STATE or TIME_BUTTON or HOURS_BUTTON or MINUTES_BUTTON)
begin
    SECS =0;
    HOURS = 0;
    MINS = 0;
    NEXT_STATE = CURRENT_STATE;

    case (CURRENT_STATE) //synopsys full_case parallel_case

    COUNT_TIME: begin
	if (TIME_BUTTON & HOURS_BUTTON & !MINUTES_BUTTON)
	   begin
	   NEXT_STATE = SET_HOURS;
	   HOURS = 1;
	   end
	else if (TIME_BUTTON & !HOURS_BUTTON & MINUTES_BUTTON) 
	   begin
	   NEXT_STATE = SET_MINUTES;
	   MINS = 1;
	   end
	else
	   begin
	   NEXT_STATE = COUNT_TIME;
	   SECS = 1;
	   end
	end
    SET_HOURS: begin
	if (TIME_BUTTON & HOURS_BUTTON & !MINUTES_BUTTON)
	   begin
	   NEXT_STATE = SET_HOURS;
	   HOURS = 0;
	   end
	else
	   begin
	   NEXT_STATE = COUNT_TIME;
	   SECS = 1;
	   end
	end
    SET_MINUTES: begin
	 if (TIME_BUTTON & !HOURS_BUTTON & MINUTES_BUTTON)
	   begin
	   NEXT_STATE = SET_MINUTES;
	   MINS = 0;
	   end
	else
	   begin
	   NEXT_STATE = COUNT_TIME;
	   SECS = 1;
	   end
	end
    endcase
end

always @ (posedge CLK)
begin
CURRENT_STATE = NEXT_STATE;
end

endmodule
