/* ALARM_STATE_MACHINE.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995  */

module alarm_state_machine (ALARM_BUTTON, HOURS_BUTTON, MINUTES_BUTTON, CLK, HOURS, MINS);
input ALARM_BUTTON, HOURS_BUTTON, MINUTES_BUTTON, CLK;
output HOURS, MINS;

parameter IDLE=0, SET_HOURS=1, SET_MINUTES=2;

reg [1:0] CURRENT_STATE, NEXT_STATE;
reg HOURS, MINS;

always @ (CURRENT_STATE or ALARM_BUTTON or HOURS_BUTTON or MINUTES_BUTTON)
begin
    HOURS = 0;
    MINS = 0;
    NEXT_STATE = CURRENT_STATE;

    case (CURRENT_STATE) //synopsys full_case parallel_case

    IDLE: begin
	  if (ALARM_BUTTON & HOURS_BUTTON & !MINUTES_BUTTON)
	     begin
	     NEXT_STATE = SET_HOURS;
	     HOURS = 1;
	     end
	  else if (ALARM_BUTTON & !HOURS_BUTTON & MINUTES_BUTTON)
	     begin
	     NEXT_STATE = SET_MINUTES;
	     MINS = 1;
	     end
	  else
	     NEXT_STATE = IDLE;
	  end
    SET_HOURS: begin
          if (ALARM_BUTTON & HOURS_BUTTON & !MINUTES_BUTTON)
             begin
             NEXT_STATE = SET_HOURS;
             HOURS = 0;
             end
          else
             NEXT_STATE = IDLE;
          end
    SET_MINUTES: begin
           if (ALARM_BUTTON & !HOURS_BUTTON & MINUTES_BUTTON)
             begin
             NEXT_STATE = SET_MINUTES;
             MINS = 0;
             end
          else
             NEXT_STATE = IDLE;
          end
    endcase
end


always @ (posedge CLK)
begin
CURRENT_STATE = NEXT_STATE;
end

endmodule
