/* ALARM_COUNTER.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995 */

module alarm_counter (HOURS, MINS, CLK, HOURS_OUT, MINUTES_OUT, AM_PM_OUT);
input HOURS, MINS, CLK;
output [3:0] HOURS_OUT;
output [5:0] MINUTES_OUT;
output AM_PM_OUT;

reg [3:0] HOURS_OUT;
reg [5:0] MINUTES_OUT;
reg AM_PM_OUT;

always @ (posedge CLK)
begin

    MINUTES_OUT = MINUTES_OUT;
    HOURS_OUT = HOURS_OUT;
    AM_PM_OUT = AM_PM_OUT;

    if (MINS & !HOURS)
       begin
       if (MINUTES_OUT == 6'd59)
	  begin
	  MINUTES_OUT = 6'd0;
	  if (HOURS_OUT == 4'd12)
	     begin
	     HOURS_OUT = 4'd1;
	     AM_PM_OUT = !AM_PM_OUT;
	     end
	  else
	     HOURS_OUT = HOURS_OUT + 1'd1;
	  end
       else
	  MINUTES_OUT = MINUTES_OUT + 1'd1;
       end
    else if (!MINS & HOURS)
       begin
       if (HOURS_OUT == 4'd12)
	  begin
	  HOURS_OUT = 4'd1;
	  AM_PM_OUT = !AM_PM_OUT;
	  end
       else
	  HOURS_OUT = HOURS_OUT + 1'd1;
       end

end

endmodule
