/* ALARM_BLOCK.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995  */

module alarm_block ( ALARM, HRS, MINS, CLK, CONNECT9, 
    CONNECT10, CONNECT11);

input  ALARM, HRS, MINS, CLK;
output [3:0] CONNECT9; 
output [5:0] CONNECT10; 
output CONNECT11;

    wire CONNECT1, CONNECT2; /* top level nets that connect major modules */

    alarm_state_machine U0 ( .ALARM_BUTTON(ALARM), .HOURS_BUTTON(HRS), 
        .MINUTES_BUTTON(MINS), .CLK(CLK), .HOURS(CONNECT1), .MINS(CONNECT2) );

    alarm_counter U3 ( .HOURS(CONNECT1), .MINS(CONNECT2), .CLK(CLK), 
        .HOURS_OUT(CONNECT9), .MINUTES_OUT(CONNECT10), .AM_PM_OUT(CONNECT11));

endmodule

