/* ALARM.V
 * Xilinx HDL Synthesis Design Guide for FPGAs
 * June 1995  */

module alarm ( SET_TIME, ALARM, HRS, MINS, TOGGLE_SWITCH, CLK, SPEAKER_OUT, 
               DISP1, DISP2, AM_PM_DISPLAY );
output [13:0] DISP1;
output [13:0] DISP2;
input  SET_TIME, ALARM, HRS, MINS, TOGGLE_SWITCH, CLK;
output SPEAKER_OUT, AM_PM_DISPLAY;

/*Top level nets that connect major modules */

wire [5:0] KONNECT7,KONNECT10;
wire KONNECT8,KONNECT11,KONNECT12;
wire [3:0] KONNECT6,KONNECT9;
wire [9:0] KONNECT13;
    time_block U1 ( .SET_TIME(SET_TIME), .HRS(HRS), .MINS(MINS),  
     .CLK(CLK), .CONNECT6(KONNECT6), .CONNECT7(KONNECT7), .CONNECT8(KONNECT8) );

    alarm_block  U2 ( .ALARM(ALARM), .HRS(HRS), .MINS(MINS), .CLK(CLK), 
        .CONNECT9(KONNECT9), .CONNECT10(KONNECT10), .CONNECT11(KONNECT11));

    convertor_ckt U3 (.connect13(KONNECT13),.disp1(DISP1),.disp2(DISP2)); 

    comparator U4 ( .ALARM_HRS(KONNECT9),.CLOCK_HRS(KONNECT6), 
        .ALARM_MINS(KONNECT10), .CLOCK_MINS(KONNECT7),
        .ALARM_AM_PM(KONNECT11), .CLOCK_AM_PM(KONNECT8), .RINGER(KONNECT12) );

    alarm_sm_2 U5 ( .COMPARE_IN(KONNECT12), .TOGGLE_ON(TOGGLE_SWITCH), .CLOCK(
        CLK), .RING(SPEAKER_OUT) );

    mux U6 ( .ALARM_HRS(KONNECT9), .ALARM_MINS(KONNECT10),
        .ALARM_AM_PM(KONNECT11), .TIME_HRS(KONNECT6),
        .TIME_MINS(KONNECT7), .TIME_AM_PM(KONNECT8), .ALARM_SET(ALARM),
         .OUTBUS({KONNECT13,AM_PM_DISPLAY}));
endmodule

