/*
*       1/1/94     V 3.0   DP2ABEL only dor divide by N
*       12/29/93   V 2.0   add pipelined MAX for better speed
*       12/28/93   V 1.01  modified taps for better routing
*       12/27/93   V1.0    original
*
*	Sequence.c
*       Modified from D2ABEL.c
*       Used to create a sequencer using a LFSR counter
*       as the sequence position.
*         Inputs
*                 clock, clock enable, start
*
*	Output is aa ABEL file named seqN.abl
*       Where N is the number of steps
*
*	See also LSI Logic Book September 1984
*		 CMOS Macro Cell Manual
*		 Page 15-3 -> 15-6	 
*
*/
#include "STDIO.H"
int ntaps[21] ={0,0,2,2,2,2,2,2,4,2,2,2,4,4,4,2,4,2,2,4,2};
int taps[21][4] = { 
		0,0,0,0,
		0,0,0,0,
		1,2,0,0,
		1,3,0,0,
		1,4,0,0,
		2,5,0,0,
		1,6,0,0,
		1,7,0,0, /* ALSO 6,7,0,0 */
		1,2,7,8,
		4,9,0,0,
		3,10,0,0,
		2,11,0,0,
		2,10,11,12,
		1,11,12,13,
		2,12,13,14,
		14,15,0,0,
		11,13,14,16,
		14,17,0,0,
		11,18,0,0,
		14,16,18,19,
		17,20
		  };
/*
 * pre-set decisions on pipelining
 *  first column, # of taps (kind of redundant)
 *  2nd         , # of signal groups
 *  3rd         , # of taps group 1
 *  4th         ,                 2
 */
int pipe [21][7] = {
		      1,0,0,0,0,0,0,
		      2,1,2,0,0,0,0,
		      3,1,3,0,0,0,0,
		      4,1,4,0,0,0,0,
		      5,2,3,2,0,0,0,
		      6,2,3,3,0,0,0,
		      7,2,4,3,0,0,0,
		      8,2,4,4,0,0,0,
		      9,3,3,3,3,0,0,
		     10,3,4,3,3,0,0,
		     11,3,4,4,3,0,0,
		     12,3,4,4,4,0,0,
		     13,4,4,3,3,3,0,
		     14,4,4,4,3,3,0,
		     15,4,4,4,4,3,0,
		     16,4,4,4,4,4,0,
		     17,5,4,4,3,3,3,
		     18,5,4,4,4,3,3,
		     19,5,4,4,4,4,3,
		     20,5,4,4,4,4,4,
		     21,5,5,4,4,4,4,
		     };											
main (argc,argv)
	int argc;
	char *argv[];
{
        char fname[80];
        FILE *ab;	       /* pointer to abel file */	
	int mxgroup;
	int c,x,y,z;
	int i,j,k,l;
	int startg,egroup;
	int first;
        long int a, b;
	long int x1,x2;
	long int length;
	long int il;
	int match;
	int state;		/* state counter for skip states */
        int natural;		/* first bit of normal sequence */
        int force;              /* value logic needs to force to shorten */
        int stbit[20];		/* start of skip states */
	int endbit[20];		/* 1st non skipped state */
	int initbit[20];	/* hold initial state */
        int detect[20];         /* hold the detect state */
        a = 1;
        b = 0;
	first = 0;
        match = 0;
        if (argc != 2)
         {
         printf("\n expected usage: \n");
         printf("   sequence  #\n");
         printf("   where # is the number of sequence steps\n");
         exit();
         }
	sscanf(argv[1],"%D",&length);
        if (length <=2 )
	 {
         printf("\n Bad length count, must be 3 or greater\n");
	 exit();
	 }
        if (length > 1048575 )
	 {
         printf("\n TOO Big, Split into two smaller counters 3 or greater\n");
	 exit();
	 }
	strcpy(fname[0],"DP");
	strcat(fname[0],argv[1]);
	strcat(fname[0],".abl");	
	printf("\n DP2ABEL version 3.0\n");
	printf("Building %s pipelined divide by N \n", argv[1]);
	printf("Create file %s \n", fname[0]);
	printf("\n\n length = %ld \n\n",length);
	ab = fopen(fname[0], "w");
/*
 *  Set up abel simple stuff, ie headers and all
 */
	fprintf(ab,"module DP%ld\n",length);
	fprintf(ab,"title 'DP%ld, Divide by N, pipelined Detect & LFSR counter'\n",length,length);
	fputc(0x22,ab);
	fprintf(ab," Version 3.01, T Leach 1/1/94\n\n");
	fprintf(ab,"\n");
/*
 *  Declare the inputs
 */
        fprintf(ab,"\n");
	fputc(0x22,ab);
	fprintf(ab," primary inputs\n");
	fprintf(ab,"     en               pin;\n");
	fprintf(ab,"     clock            pin;\n\n");

	fputc('"',ab);
	fprintf(ab,"Outputs\n\n");
	fprintf(ab,"    max         pin;\n");
	fprintf(ab,"    d1          node;\n");
 /*
  *     Figure out how many F/F's we need
  */  
	x1 = 0;
	x2 = length - x1 ;
	while(length >= a  && b < 21)
		{
		b++;
		while(ntaps[b] == 0)
			{
        		a = 2*a ;
			b++;
			}
        	a = 2*a ;
		}
	c = a - length - 1;
/* 
 *  a = max # of states
 *  b = # of FF's
 *  c = # of states to skip to hit proper modulo
 */
printf("\n");
printf(" Max # of states (a) = %ld \n",a); 
/*
 *  Now we know # of Flip-Flops that we need
 */
printf(" Number of F/F's = %ld\n",b);
printf(" Number of MX's = %d\n",pipe[b-1][1]);
printf(" Number of loads on mx1 = %d\n",pipe[b-1][2]);
printf(" Number of loads on mx2 = %d\n",pipe[b-1][3]);
if (pipe[b-1][4] != 0)
{
printf(" Number of loads on mx3 = %d\n",pipe[b-1][4]);
printf(" Number of loads on mx4 = %d\n",pipe[b-1][5]);
printf(" Number of loads on mx5 = %d\n",pipe[b-1][6]);
}
        fprintf(ab,"\n");
	fputc(0x22,ab);
	fprintf(ab,"  Nodes for pipelined Detect \n\n");
	fprintf(ab,"    ");
	for (i=0;i<=pipe[b-1][1]-1; i++)
	 {
 	 if (i != 0)
	  {fprintf(ab,",");}			/* place comma's between */ 
	  fprintf(ab,"mx%d",i+1);
	 }
	fprintf(ab,"               node;\n\n");
/*
 *   Build up Node Q
 */
	fprintf(ab,"    ");
	for (i=0; i<= b-1; i++)
	 { 
 	 if (i != 0)
	  {fprintf(ab,",");}			/* place comma's between */ 
	 fprintf(ab,"q%d",i);
	 }
	fprintf(ab,"      node;\n\n");
/*
 * Now declare combinatorial or registered
 */        
	fprintf(ab,"    ");
	for (i=0; i<= b-1; i++)
	 { 
 	 if (i != 0)
	  {fprintf(ab,",");}			/* place comma's between */ 
	 fprintf(ab,"q%d",i);
	 }
	fprintf(ab,"        ISTYPE 'reg_d';\n");
        fprintf(ab,"    ");
	for (i=0;i<=pipe[b-1][1]-1; i++)
	 {
 	 if (i != 0)
	  {fprintf(ab,",");}			/* place comma's between */ 
	  fprintf(ab,"mx%d",i+1);
	 }
	fprintf(ab,"              ISTYPE 'reg_d';\n");
	fprintf(ab,"    max                ISTYPE 'reg_d' ;\n");
	fprintf(ab,"    d1                 ISTYPE 'com';\n");

/* clear the shift registers */	

	for (i=0;i<=b;i++)
	{
         stbit[i] = 0;
	 endbit[i] = 0;
	 detect[i] = 0;
        }
/*
 *  Find the Detect stage for the pipeline (2 states back from length)
 */
	for (il=0;il<=length-4;il++)
	{
         detect[0] = 0;
	 for(y = 0 ; y < ntaps[b] ; y++)
           detect[0] = detect[0] ^ detect[taps[b][y]];
         detect[0] = !detect[0];    		 /* xnor function */
	 for(y=b; y >= 1; y--)
	 {
	  detect[y] = detect[y-1];
	 }
        }	
/*
 *   Now set up the flip-flops
 */
	fprintf(ab,"\nEquations\n\n");
	fputc(0x22,ab);
	fprintf(ab," Flip-Flop constants\n\n");
	fprintf(ab,"       max.clk = clock;\n");
	fprintf(ab,"       max.ce =  en;\n");
        fprintf(ab," \n");
	fprintf(ab,"       [q%d..q0].clk = clock;\n",b-1);
        fprintf(ab,"       [q%d..q0].ce = en;\n",b-1);
        fprintf(ab," \n");
	for (i=0;i<=pipe[b-1][1]-1; i++)
	 {
	  fprintf(ab,"       mx%d.clk = clock;\n",i+1);
	 }
	for (i=0;i<=pipe[b-1][1]-1; i++)
	 {
	  fprintf(ab,"       mx%d.ce = en;\n",i+1);
	 }
	 fprintf(ab,"       q0 := d1 & !max;\n");

	for (i=1; i<= b-1; i++)
	{
	 fprintf(ab,"       q%d := q%d & !max;\n",i,i-1);
	}
        fprintf(ab," \n");
/*
 *   AND together the MX groups
 */
	fprintf(ab,"       max := ");
	for (i=0; i <= pipe[b-1][1]-1; i++)
	 {
	  if (i != 0 && i != pipe[b-1][1])
	  { fprintf(ab," & ");}	
	  fprintf(ab,"mx%d",i+1);
	 }
	fprintf(ab,";\n");
/*
 * print the Detect state
 */
printf(" detect state = "); 	
fprintf(ab,"\n");
fputc(0x22,ab);
fprintf(ab," Detect state = "); 	
for (k=1; k<=b; k++)
  {
   printf("%d",detect[k]);
   fprintf(ab,"%d",detect[k]);
  }
fprintf(ab," \n\n");
printf("\n");
/*
 *  Build the MX Groups
 */
	fprintf(ab,"       mx1 := ");
	for (k=0; k <= pipe[b-1][2]-1; k++)
	{
	 if (k > 0 && k < pipe[b-1][2])
	  {
           fprintf(ab," & ");
          }	
	if (detect[k+1] == 0)
	 { fprintf(ab,"!");}
	fprintf(ab,"q%d",k);
        }
	fprintf(ab,";\n");
/*
 * test for group 2
 */
	if (pipe[b-1][3] > 1)
	{
	startg = pipe[b-1][2];
	egroup = startg + pipe[b-1][3];
	fprintf(ab,"       mx2 := ");
	for (k=startg; k <= egroup-1; k++)
	{
	 if (k > startg && k < egroup)
	  {fprintf(ab," & ");}	
	 if (detect[k+1] == 0)
	  { fprintf(ab,"!");}
	 fprintf(ab,"q%d",k);
        }
	fprintf(ab,";\n");
        }
/*
 * group 3
 */
	if (pipe[b-1][4] > 1)
	{
	startg = pipe[b-1][2] + pipe[b-1][3];
	egroup = startg + pipe[b-1][4];
	fprintf(ab,"       mx3 := ");
	for (k=startg; k <= egroup-1; k++)
	{
	 if (k > startg && k < egroup)
	  {fprintf(ab," & ");}	
	 if (detect[k+1] == 0)
	  { fprintf(ab,"!");}
	 fprintf(ab,"q%d",k);
        }
	fprintf(ab,";\n");
        }
/*
 * group 4
 */
	if (pipe[b-1][5] > 1)
	{
	startg = pipe[b-1][2] + pipe[b-1][3] + pipe[b-1][4];
	egroup = startg + pipe[b-1][5];
	fprintf(ab,"       mx4 := ");
	for (k=startg; k <= egroup-1; k++)
	{
	 if (k > startg && k < egroup)
	  {fprintf(ab," & ");}	
	 if (detect[k+1] == 0)
	  { fprintf(ab,"!");}
	 fprintf(ab,"q%d",k);
        }
	fprintf(ab,";\n");
        }
/*
 * group 5
 */
	if (pipe[b-1][6] > 1)
	{
	startg = pipe[b-1][2] + pipe[b-1][3] + pipe[b-1][4] + pipe[b-1][5];
	egroup = startg + pipe[b-1][6];
	fprintf(ab,"       mx5 := ");
	for (k=startg; k <= egroup-1; k++)
	{
	 if (k > startg && k < egroup)
	  {fprintf(ab," & ");}	
	 if (detect[k+1] == 0)
	  { fprintf(ab,"!");}
	 fprintf(ab,"q%d",k);
        }
	fprintf(ab,";\n");
        }

	fputc(0x22,ab);
	fprintf(ab," \n");
/*
 *  Build the feedback term in ABEL
 */
	fprintf(ab," \n");
	fputc(0x22,ab);
	fprintf(ab," Build the feedback information\n");
	fputc(0x22,ab);
	fprintf(ab," Number of taps = %d\n",ntaps[b]);

	fprintf(ab,"  d1 =  ");
	for(y = 0 ; y < ntaps[b] ; y++)
 	 {	
	 fprintf(ab,"q%d ",taps[b][y]-1);
	 if (y+1 < ntaps[b] )
	  fprintf(ab,"!$ ");
	 } 
	fprintf(ab,";\n");
/*
 *  Finish the abel file
 */
	fprintf(ab,"\nend\n");
}
               