-- BINARY.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

Library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity binary is
    port (CLOCK, RESET : in STD_LOGIC;
	  A, B, C, D, E: in BOOLEAN;
          SINGLE, MULTI, CONTIG: out STD_LOGIC);
end binary; 

architecture BEHV of binary is

type STATE_TYPE is (S1, S2, S3, S4, S5, S6, S7);
attribute ENUM_ENCODING: STRING;
attribute ENUM_ENCODING of STATE_TYPE: type is "001 010 011 100 101 110 111";

signal CS, NS: STATE_TYPE;

begin 

    SYNC_PROC: process (CLOCK, RESET)
    begin
	if (RESET='1') then
       	    CS <= S1;
    	elsif (CLOCK'event and CLOCK = '1') then
            CS <= NS;
    	end if;
    end process; --End REG_PROC

    COMB_PROC: process (CS, A, B, C, D, E)
    begin
    	case CS is
            when S1 =>
	     	MULTI  <= '0';
	    	CONTIG <= '0';
	    	SINGLE <= '0';
            	if (A and not B and C) then
                    NS <= S2;
            	elsif (A and B and not C) then
		    NS <= S4;
            	else
		    NS <= S1;   
	    	end if;
            when S2 =>
            	MULTI  <= '1';
            	CONTIG <= '0';
            	SINGLE <= '0';
	    	if (not D) then
                    NS <= S3;
            	else
                    NS <= S4;
            	end if;
            when S3 =>
                MULTI  <= '0';
                CONTIG <= '1';
                SINGLE <= '0';
	    	if (A or D) then
            	    NS <= S4;
		else 
		    NS <= S3;
		end if;
	    when S4 =>
		MULTI  <= '1';
		CONTIG <= '1';
		SINGLE <= '0';
		if (A and B and not C) then
            	    NS <= S5;
		else 
		    NS <= S4;
		end if;
	    when S5 =>
		MULTI  <= '1';
		CONTIG <= '0';
		SINGLE <= '0';
		NS <= S6;
	    when S6 =>
		MULTI  <= '0';
		CONTIG <= '1';
		SINGLE <= '1';
		if (not E) then
		    NS <= S7;
		else 
		    NS <= S6;
		end if;
	    when S7 =>
		MULTI  <= '0';
		CONTIG <= '1';
		SINGLE <= '0';
		if (E) then
		    NS <= S1;
		else 
		    NS <= S7;
		end if;
	end case;
    end process; -- End COMB_PROC

end BEHV;
