-- RPM_EXAMPLE.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_1164.all;

entity rpm_example is
    port (B_IN, D_IN: in STD_LOGIC_VECTOR (3 downto 0);
         CARRY_IN_PORT, L_IN, ADD_IN, CLK_EN_PORT, CLK_IN: in STD_LOGIC;
         Q_OUT: out STD_LOGIC_VECTOR (3 downto 0);
         COUT_PORT, OVFL_PORT: out STD_LOGIC);
end rpm_example;

architecture STRUCTURE of rpm_example is

component rpm_test              
    port (b, d : in STD_LOGIC_VECTOR (3 downto 0);
           carry_in, l, add, clk_en, clk: in STD_LOGIC;
           q: out STD_LOGIC_VECTOR (3 downto 0);
           cout, ovfl: out STD_LOGIC);
 end component;

begin

U1: rpm_test port map (b=>B_IN, d=>D_IN, carry_in=>CARRY_IN_PORT, l=>L_IN,
                       add=>ADD_IN, clk_en=>CLK_EN_PORT, clk=>CLK_IN, q=>Q_OUT,                        cout=> COUT_PORT, ovfl=>OVFL_PORT);

end STRUCTURE;
