-- MUX_GATE.VHD
-- 5-to-1 Mux Implemented in Gates
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- May 1995                        

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;

entity mux_gate is
port (	SEL: in STD_LOGIC_VECTOR (2 downto 0);
	A,B,C,D,E: in STD_LOGIC;
        SIG: out STD_LOGIC);
end mux_gate;

architecture RTL of mux_gate is
begin
    SEL_PROCESS: process (SEL,A,B,C,D,E)
    begin
	case SEL is
           when "000"  => SIG <= A;
           when "001"  => SIG <= B;
           when "010"  => SIG <= C;
           when "011"  => SIG <= D;
           when others => SIG <= E;
        end case;
    end process SEL_PROCESS;
end RTL;
