-- IO_DECODER.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- Edge Encoder
-- A XC4000 LCA has special decoder circuits at each edge. These decoders
-- are open-drained wired-AND gates. When one or more of the inputs (I) are Low
-- output(O) is Low. When all of the inputs are High, the output is High.
-- A pull-up resistor must be connected to the output node to achieve a true
-- logic High.
-- June 1995
 
Library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

entity io_decoder is
  port (ADR: in std_logic_vector (4 downto 0);
	CS: in std_logic;
	DATA: in std_logic_vector (3 downto 0);	
	CLOCK: in std_logic;
	QOUT: out std_logic_vector (3 downto 0));
end io_decoder;

architecture Xilinx of io_decoder is

COMPONENT DECODE1_IO
  PORT ( I: IN std_logic; 
         O: OUT std_logic );
END COMPONENT;

COMPONENT DECODE1_INT
  PORT ( I: IN std_logic; 
         O: OUT std_logic );
END COMPONENT;

COMPONENT DECODE4
  PORT ( A3, A2, A1, A0: IN std_logic;
         O: OUT std_logic );
END COMPONENT;

COMPONENT PULLUP
  PORT ( O: OUT std_logic );
END COMPONENT;

---- Internal Signal Declarations ----------------------
signal DECODE, CLKEN, CLB_INT: std_logic_vector (3 downto 0);
signal ADR_INV, CLB_INV: std_logic_vector (3 downto 0);
begin

ADR_INV <= not ADR (3 downto 0);
CLB_INV <= not CLB_INT;

----- Instantiation of Edge Decoder: Output "DECODE(0)" ---------------
    A0: DECODE4 port map (ADR(3), ADR(2), ADR(1), ADR_INV(0), DECODE(0));
    
    A1: DECODE1_IO port map (ADR(4), DECODE(0));

    A2: DECODE1_INT port map (CLB_INV(0), DECODE(0)); 
    
    A3: DECODE1_INT port map (CLB_INT(1), DECODE(0)); 
   
    A4: DECODE1_INT port map (CLB_INT(2), DECODE(0)); 
   
    A5: DECODE1_INT port map (CLB_INT(3), DECODE(0)); 
	
    A6: PULLUP port map (DECODE(0));

----- Instantiation of Edge Decoder: Output "DECODE(1)" ---------------
    B0: DECODE4 port map (ADR(3), ADR(2), ADR_INV(1), ADR(0), DECODE(1));
   
    B1: DECODE1_IO port map (ADR(4), DECODE(1));
 
    B2: DECODE1_INT port map (CLB_INT(0), DECODE(1));
   
    B3: DECODE1_INT port map (CLB_INV(1), DECODE(1));
  
    B4: DECODE1_INT port map (CLB_INT(2), DECODE(1));
  
    B5: DECODE1_INT port map (CLB_INT(3), DECODE(1));
 
    B6: PULLUP port map (DECODE(1));

----- Instantiation of Edge Decoder: Output "DECODE(2)" ---------------
    C0: DECODE4 port map (ADR(3), ADR_INV(2), ADR(1), ADR(0), DECODE(2));
   
    C1: DECODE1_IO port map (ADR(4), DECODE(2));
 
    C2: DECODE1_INT port map (CLB_INT(0), DECODE(2));
   
    C3: DECODE1_INT port map (CLB_INT(1), DECODE(2));
  
    C4: DECODE1_INT port map (CLB_INV(2), DECODE(2));
  
    C5: DECODE1_INT port map (CLB_INT(3), DECODE(2));
 
    C6: PULLUP port map (DECODE(2));

----- Instantiation of Edge Decoder: Output "DECODE(3)" ---------------
    D0: DECODE4 port map (ADR_INV(3), ADR(2), ADR(1), ADR(0), DECODE(3));
   
    D1: DECODE1_IO port map (ADR(4), DECODE(3));

    D2: DECODE1_INT port map (CLB_INT(0), DECODE(3));
   
    D3: DECODE1_INT port map (CLB_INT(1), DECODE(3));
  
    D4: DECODE1_INT port map (CLB_INT(2), DECODE(3));
  
    D5: DECODE1_INT port map (CLB_INV(3), DECODE(3));
    
    D6: PULLUP port map (DECODE(3));

-----CLKEN is the AND function of CS & DECODE--------

CLKEN(0) <= CS and DECODE(0);
CLKEN(1) <= CS and DECODE(1);
CLKEN(2) <= CS and DECODE(2);
CLKEN(3) <= CS and DECODE(3);

--------Internal 4-bit counter --------------
    process (CLOCK)
        begin
        if (CLOCK'event and CLOCK='1') then
                CLB_INT <= CLB_INT + 1;
        end if;
    end process;

-------"QOUT(0)" Data Register Enabled by "CLKEN(0)"-----
    process (CLOCK)
  	begin
	if (CLOCK'event and CLOCK='1') then
	  if (CLKEN(0) = '1') then
	      QOUT(0) <= DATA(0);
          end if;
	end if;
    end process;

-------"QOUT(1)" Data Register Enabled by "CLKEN(1)"-----
    process (CLOCK)
        begin
        if (CLOCK'event and CLOCK='1') then
          if (CLKEN(1) = '1') then
              QOUT(1) <= DATA(1);
          end if;
        end if;
    end process;

-------"QOUT(2)" Data Register Enabled by "CLKEN(2)"-----
    process (CLOCK)
        begin
        if (CLOCK'event and CLOCK='1') then
          if (CLKEN(2) = '1') then
              QOUT(2) <= DATA(2);
          end if;
        end if;
    end process;

-------"QOUT(3)" Data Register Enabled by "CLKEN(3)"-----
    process (CLOCK)
        begin
        if (CLOCK'event and CLOCK='1') then
          if (CLKEN(3) = '1') then
              QOUT(3) <= DATA(3);
          end if;
        end if;
    end process;

end Xilinx;
 
