-- CLR_PRE_BEFORE.VHD 
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

Library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
 
entity clr_pre_before is
   port (CLR, PRE, CLK: in STD_LOGIC;
         QOUT: out STD_LOGIC);
end clr_pre_before;

architecture BEHAV of clr_pre_before is
begin

    CLR_PRE: process (CLR, PRE, CLK) 
    begin
        if (CLR = '1') then
            QOUT <= '0';
        elsif (PRE = '1') then
            QOUT <= '1';
        elsif (CLK'event and CLK = '1') then
            QOUT <= '0';
        end if;
    end process; -- End CLR_PRE

end BEHAV;
