-- TIME_STATE_MACHINE.VHD
-- Xilinx HDL Synthesis Design Guide for FPGAs
-- June 1995

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity time_state_machine is
port ( TIME_BUTTON, HOURS_BUTTON, MINUTES_BUTTON, CLK: in STD_LOGIC;
       HOURS, MINS, SECS: out STD_LOGIC);
end;

architecture BEHAVIOR of time_state_machine is
    type STATE_TYPE is (COUNT_TIME,SET_HOURS,SET_MINUTES);
    signal CURRENT_STATE, NEXT_STATE: STATE_TYPE;
begin

    COMBIN: process(CURRENT_STATE, TIME_BUTTON, HOURS_BUTTON, MINUTES_BUTTON)
    begin
        NEXT_STATE <= CURRENT_STATE;
        SECS <= '0';
        HOURS <= '0';
        MINS <= '0';
        case CURRENT_STATE is
            when COUNT_TIME =>
	        if ( TIME_BUTTON  = '1' and HOURS_BUTTON  = '1' 
		     and MINUTES_BUTTON = '0') then
	             NEXT_STATE <= SET_HOURS;
	             HOURS <= '1';
	        elsif ( TIME_BUTTON  = '1' and MINUTES_BUTTON  = '1' 
		        and HOURS_BUTTON  = '0') then
	            NEXT_STATE <= SET_MINUTES;
	            MINS <= '1';
	        else
	            NEXT_STATE <= COUNT_TIME;
	            SECS <= '1';
	        end if;
            when SET_HOURS =>
	        if ( TIME_BUTTON  = '1' and HOURS_BUTTON  = '1' 
		     and MINUTES_BUTTON = '0') then
	            NEXT_STATE <= SET_HOURS;
	            HOURS <= '0';
	        else
	            NEXT_STATE <= COUNT_TIME;
	            SECS <= '1';
	        end if;
            when SET_MINUTES =>
	        if ( TIME_BUTTON  = '1' and MINUTES_BUTTON  = '1' 
		     and HOURS_BUTTON  = '0') then
	            NEXT_STATE <= SET_MINUTES;
	            MINS <= '0';
	        else
	            NEXT_STATE <= COUNT_TIME;
	            SECS <= '1';
	        end if;
        end case;
   end process;

   SYNCH: process 
   begin
       wait until CLK'event and CLK = '1';
           CURRENT_STATE <= NEXT_STATE;
   end process;

end BEHAVIOR;
           
