;
; DVCI RS232 interface w/C language support
;

	 .width   100
	 .length   55
	 .title "Backplane PHY test board RS232 interface w/C Language support"
	 .version 50
	 .mmregs

;
; Define C-callable global variables
;

         .global _putc,_getc
         .global _bitlen,_bitlen2,scratch,scratch2
         .global loadstart

;
;        .bss section: be careful with some predefined addresses !!!!!
;

_bitlen2  .usect "b2",1
_bitlen   .usect "b2",1
scratch   .usect "b2",1
scratch2  .usect "b2",1

;======================================================================
;
;  BEGIN OF MAIN PROGRAM
;
;====================================================================

          .sect ".ramcode"
          .label loadstart
;
; Receive routine .... as called from C
;

_getc   popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,0           ;Size of Frame is zero
        lar     ar0,*0+,ar2     ;Set up FP and SP

        ldp     #0              ;Point to zero page
reads:    rpt    _bitlen
	  nop
wait      Bcndd  STOK,bio     ;wait for start bit
	  lar    AR5,#7
	  lacl   #0
	  B      wait         ;
STOK      rpt    _bitlen2      ;_bitlen is scaled and
	  nop
	  mar    *,AR5        ;number of bits - 1
WTBIT     sfr
	  rpt    _bitlen       ;decremented by 8/3 for
	  nop                 ;_bitlen/2 wait
	  bcnd   ZEROBT,bio
	  add    #80h
ZEROBT    BANZ   WTBIT,*-     ;last bit ?

        larp    ar1             ;Pop off frame
        sbrk    1
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

;
; Transmit RS232 character ... as called from C
;

_putc   popd    *+              ;Ret return address
        sar     ar0,*+          ;Save Frame Pointer
        sar     ar1,*           ;Save Stack Pinter
        lark    ar0,1           ;Size of frame
        lar     ar0,*0+,ar2     ;Set up FP and SP

        ldp     #0              ;Point to page 0
        lark    ar2,-3          ;Offset of argument
        mar     *0+             ;Point to argument
        lacc    *,ar0           ;Load argument from C stack

xmtbyte  clrc c               ; startbit=0
	 lar  ar5,#8          ; counter: 1 startbit+ 8 databits (+ 2 stopbits)
nextbit1 bcnd snd0,nc         ; if c=1 send 1 else send 0
snd1     setc xf              ; send one
	 b    snd
snd0     clrc xf
snd      rpt  _bitlen          ; send one bit
	 mar  *,ar5
	 ror                  ; lsb(accu) -> carrybit
	 banz nextbit1,*-     ; repeat for entire word (10 bits)
	 setc xf
	 rpt  _bitlen           ;Stop bit 1
	 nop
	 rpt  _bitlen           ;Stop bit 2
	 nop

        larp    ar1             ;Pop off frame
        sbrk    2
        lar     ar0,*-          ;Restore frame pointer
        pshd    *               ;move return addr to stack
        ret

;
; End of file
;

	 .end
