/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                      TIGA DEMO FRAME                                     */
/*                                                                          */
/* Draw a series of bouncing pattern-filled rectangles                      */
/*                                                                          */
/*    7/01/87...Original version written..................J. Van Aken       */
/*   10/10/88...Converted to TIGA.........................Graham Short      */
/*    2/08/89...Mods to make more resolution independent..J. Van Aken       */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#include "tigademo.h"
#include "colors.h"


void frame5()
{
    short   xmin, ymin, xmax, ymax, wmin, hmin, wmax, hmax;
    short   x, y, w, h, vx, vy, vw, vh, i, fcolor, bcolor, pattern;

    xmin = 0;
    ymin = 3*CHAR_HIGH;
    xmax = HRES - 1;
    ymax = VRES - 1;
    wmin = HRES / 6;
    hmin = VRES / 5;
    wmax = HRES / 3;
    hmax = VRES / 2;
    w = wmin;
    h = hmin;
    x = (xmin + xmax - w) / 2;
    y = (ymin + ymax - h) / 2;
    vx = HRES / 11;
    vy = HRES / 15;
    vw = HRES / 29;
    vh = HRES / 33;
    fcolor = 1;
    bcolor = 0;
    pattern = 0;
    for (i = 0; i < ITERATION_COUNT; i++)
    {
        if( iscolor )
        {
            set_colors(phys_color[fcolor], phys_color[bcolor]);
            if (++fcolor == max_colors)
                fcolor = 1;
            if (++bcolor == max_colors)
                bcolor = 0;
        }
        patn.data = gsp_patterns+((long)pattern<<8);
        set_patn(&patn);
        if (++pattern >= PMAX)
            pattern = 0;
        patnfill_rect(w, h, x, y);

        /* calculate size and position of next rectangle */
        w += vw;
        if (w < wmin)
        {
            vw = -vw;
            w = 2*wmin - w;
        }
        else
            if (w > wmax)
            {
                vw = -vw;
                w = 2*wmax - w;
            }
        x += vx;
        if (x < xmin)
        {
            vx = -vx;
            x = 2*xmin - x;
        }
        else
            if (x > xmax-w)
            {
                vx = -vx;
                x = 2*(xmax-w) - x;
            }
        h += vh;
        if (h < hmin)
        {
            vh = -vh;
            h = 2*hmin - h;
        }
        else
            if (h > hmax)
            {
                vh = -vh;
                h = 2*hmax - h;
            }
        y += vy;
        if (y < ymin)
        {
            vy = -vy;
            y = 2*ymin - y;
        }
        else
            if (y > ymax-h)
            {
                vy = -vy;
                y = 2*(ymax-h) - y;
            }
    }
}


