;----------------------------------------------------------------------;
; TiGA Demonstration Program                                           ;
;----------------------------------------------------------------------;
; DATACOPY.ASM                                                         ;
;                                                                      ;
; This program simply is a modified version of the NDP compilation of  ;
; the following "C" program, where the SRC pointer is considered to    ;
; be in 16bit far pointer format (as passed from AUX_CONFIG in the     ;
; NDPAI.LIB).                                                          ;
;----------------------------------------------------------------------;
;    datacopy( dst, src, size )                                        ;
;    char *dst;                                                        ;
;    char *src;                                                        ;
;    int size;                                                         ;
;    {                                                                 ;
;        int i;                                                        ;
;                                                                      ;
;        for(i=0; i<size; i++)                                         ;
;            *dst++ = *src++;                                          ;
;    }                                                                 ;
;----------------------------------------------------------------------;

	assume	cs:codeseg
	assume	ds:dataseg
codeseg	segment dword er use32 public 'code'
dataseg	segment dword rw use32 public 'data'

public  _datacopy

dataseg	ends
	align	4
_datacopy	proc	near

        push    es
        push    esi
	push	ebx
        mov     ecx,[esp]+16            ; ECX = Destination Ptr
;	.bf:	;

        mov     eax,[esp]+20            ; Get SRC pointer
        mov     ebx,eax                 ; Make a tmp copy
        shr     ebx,16                  ; EBX = Far ptr seg
        shl     eax,16                  ; EAX = offset::0
        shr     eax,16                  ; EBX = Pointer offset
        mov     [esp]+20,eax            ; Restore SRC pointer (offset only)
        mov     es,bx                   ; Set ES to point to far segment

        xor     eax,eax                 ; EAX = i = 0
        cmp     [esp]+24,eax            ; While EAX < size
        jle     L4      short           ;   perform copy
	align	4
L2:

        mov     ebx,ecx                 ; EBX = dst
        inc     ecx                     ; dst++
        mov     esi,[esp]+20            ; ESI = src
        inc     dword ptr [esp]+20      ; src++
        mov     dl,es:[esi]             ; Note reference to far seg
        mov     [ebx],dl                ; *EBX = *ESI
        inc     eax                     ; i++
	align	4
L5:

        cmp     [esp]+24,eax            ; While EAX < size
        jg      L2      short           ;   keep copying
	align	4
L4:

;	.ef:	;

	pop	ebx
        pop     esi
        pop     es
	ret
	align	4

	align	4
_datacopy	endp
codeseg	ends
	end
