;***********************************************************************;
;* Usage: makepatn( intensity, psize, buffer)                          *;
;*        unsigned char  intensity;                                    *;
;*        unsigned short psize;                                        *;
;*        unsigned char  *buffer;                                      *;
;*                                                                     *;
;*  intensity - value between 0 and 63                                 *;
;*     buffer - address of pattern destination                         *;
;***********************************************************************;
        .include    "gspreg.inc"
        .mlib       "gspmac.lib"

        .globl      _makepatn
        .sect       ".TIGAEXT"
        .long       _makepatn
        .text

dither_tbl:
        .word       00000h,00000h,00000h,00000h        ;0
        .word       08000h,00000h,00000h,00000h        ;1
        .word       08000h,00000h,00800h,00000h        ;2
        .word       08800h,00000h,00800h,00000h        ;3
        .word       08800h,00000h,08800h,00000h        ;4
        .word       08800h,02000h,08800h,00000h        ;5
        .word       08800h,02000h,08800h,00200h        ;6
        .word       08800h,02200h,08800h,00200h        ;7
        .word       08800h,02200h,08800h,02200h        ;8
        .word       0A800h,02200h,08800h,02200h        ;9
        .word       0A800h,02200h,08A00h,02200h        ;10
        .word       0AA00h,02200h,08A00h,02200h        ;11
        .word       0AA00h,02200h,0AA00h,02200h        ;12
        .word       0AA00h,0A200h,0AA00h,02200h        ;13
        .word       0AA00h,0A200h,0AA00h,02A00h        ;14
        .word       0AA00h,0AA00h,0AA00h,02A00h        ;15
        .word       0AA00h,0AA00h,0AA00h,0AA00h        ;16
        .word       0AA40h,0AA00h,0AA00h,0AA00h        ;17
        .word       0AA40h,0AA00h,0AA04h,0AA00h        ;18
        .word       0AA44h,0AA00h,0AA04h,0AA00h        ;19
        .word       0AA44h,0AA00h,0AA44h,0AA00h        ;20
        .word       0AA44h,0AA10h,0AA44h,0AA00h        ;21
        .word       0AA44h,0AA10h,0AA44h,0AA01h        ;22
        .word       0AA44h,0AA11h,0AA44h,0AA01h        ;23
        .word       0AA44h,0AA11h,0AA44h,0AA11h        ;24
        .word       0AA54h,0AA11h,0AA44h,0AA11h        ;25
        .word       0AA54h,0AA11h,0AA45h,0AA11h        ;26
        .word       0AA55h,0AA11h,0AA45h,0AA11h        ;27
        .word       0AA55h,0AA11h,0AA55h,0AA11h        ;28
        .word       0AA55h,0AA51h,0AA55h,0AA11h        ;29
        .word       0AA55h,0AA51h,0AA55h,0AA15h        ;30
        .word       0AA55h,0AA55h,0AA55h,0AA15h        ;31
        .word       0AA55h,0AA55h,0AA55h,0AA55h        ;32
        .word       0EA55h,0AA55h,0AA55h,0AA55h        ;33
        .word       0EA55h,0AA55h,0AE55h,0AA55h        ;34
        .word       0EE55h,0AA55h,0AE55h,0AA55h        ;35
        .word       0EE55h,0AA55h,0EE55h,0AA55h        ;36
        .word       0EE55h,0BA55h,0EE55h,0AA55h        ;37
        .word       0EE55h,0BA55h,0EE55h,0AB55h        ;38
        .word       0EE55h,0BB55h,0EE55h,0AB55h        ;39
        .word       0EE55h,0BB55h,0EE55h,0BB55h        ;40
        .word       0FE55h,0BB55h,0EE55h,0BB55h        ;41
        .word       0FE55h,0BB55h,0EF55h,0BB55h        ;42
        .word       0FF55h,0BB55h,0EF55h,0BB55h        ;43
        .word       0FF55h,0BB55h,0FF55h,0BB55h        ;44 
        .word       0FF55h,0FB55h,0FF55h,0BB55h        ;45 
        .word       0FF55h,0FB55h,0FF55h,0BF55h        ;46 
        .word       0FF55h,0FF55h,0FF55h,0BF55h        ;47 
        .word       0FF55h,0FF55h,0FF55h,0FF55h        ;48 
        .word       0FFD5h,0FF55h,0FF55h,0FF55h        ;49 
        .word       0FFD5h,0FF55h,0FF5Dh,0FF55h        ;50 
        .word       0FFDDh,0FF55h,0FF5Dh,0FF55h        ;51 
        .word       0FFDDh,0FF55h,0FFDDh,0FF55h        ;52 
        .word       0FFDDh,0FF75h,0FFDDh,0FF55h        ;53 
        .word       0FFDDh,0FF75h,0FFDDh,0FF57h        ;54 
        .word       0FFDDh,0FF77h,0FFDDh,0FF57h        ;55 
        .word       0FFDDh,0FF77h,0FFDDh,0FF77h        ;56 
        .word       0FFFDh,0FF77h,0FFDDh,0FF77h        ;57 
        .word       0FFFDh,0FF77h,0FFDFh,0FF77h        ;58 
        .word       0FFFFh,0FF77h,0FFDFh,0FF77h        ;59 
        .word       0FFFFh,0FF77h,0FFFFh,0FF77h        ;60 
        .word       0FFFFh,0FFF7h,0FFFFh,0FF77h        ;61 
        .word       0FFFFh,0FFF7h,0FFFFh,0FF7Fh        ;62 
        .word       0FFFFh,0FFFFh,0FFFFh,0FFFFh        ;63

;
Rsrc    .set        A0    
Rdest   .set        A1
Rsave   .set        A2
Rtmp    .set        A3

_makepatn:
        mmtm    SP,A0,A1,A2,A3
        Popc    A8                      ;Pop intensity (0-63)
        sll     6,A8                    ;Convert to table offset (*64)
        movi    dither_tbl,Rsrc
        add     A8,Rsrc                 ;Rsrc points to dither pattern
        Popc    Rdest                   ;Dest address
        move    Rdest,Rsave             ;Save ptr to dest for later
;------------------------------------------------------------------------;
;   Copy 8x8 dithered pattern into 16x16 dest array                      ;
;   Duplicate each 8-bit row twice to form a 16-bit wide pattern.        ;
;------------------------------------------------------------------------;
        setf    8,0,0                   ;8 bytes to move
        movk    8,A8                    ;8 rows in src pattern
byte_expand:
        move    *Rsrc+,Rtmp,0           ;Read row of 8x8 src pattern
        move    Rtmp,*Rdest+,0          ;Xfer to 1st byte of dest row
        move    Rtmp,*Rdest+,0          ;Xfer to 2nd byte of dest row
        dsjs    A8,byte_expand          ;Xfer all rows in src pattern
;------------------------------------------------------------------------;
;   All 8 rows of source has been copied into destination.  Now, copy    ;
;   each row of destination to get 16 total rows and a 16x16 pattern.    ;
;------------------------------------------------------------------------;
        setf    16,0,0                  ;Move a row (16-bit wide)
        movk    8,A8                    ;8 rows to duplicate
        move    Rsave,Rdest
        addi    8*16,Rdest              ;A1 points to end of (8x16) dest patn
dup_row: 
        move    *Rsave+,*Rdest+,0       ;Duplicate row
        dsjs    A8,dup_row              ;Repeat for all rows
;------------------------------------------------------------------------;
;   Exit point of makepatn function                                      ;
;------------------------------------------------------------------------;
exit_makepatn:
        mmfm    SP,A0,A1,A2,A3
        rets    2
