        .width    132

*----------------------------------------------------------------------
*                                    TIGA
*          Copyright (C) 1989-1990  Texas Instruments Incorporated.
*                            All Rights Reserved
*----------------------------------------------------------------------
* setcolor1, setcolor0, and setcolors functions
*
*    These functions load the specified color values into the COLOR1
*    (foreground color) and COLOR0 (background color) registers of the
*    GSP.  Each color argument is a 32-bit value containing the n-bit
*    pixel value replicated 32/n times.
*
*    The setcolor1 and setcolor0 functions load the COLOR1 and COLOR0
*    register, respectively, with the specified color value.
*
*    The setcolors function loads the COLOR1 register with its first
*    argument, and the COLOR0 register with its second argument.
*----------------------------------------------------------------------
* Usage:  setcolor1(0x55555555);
*         setcolor0(0x22222222);
*         setcolors(0x55555555, 0x22222222);
*
* Stack arguments:
*     long color;       /* pixel value replicated to 32 bits */
*----------------------------------------------------------------------
* Revision history:
*     03/22/89...Original version written...................J. Van Aken
*----------------------------------------------------------------------
;
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _setcolor1,_setcolor0,_setcolors
;
;
;     ENTRY POINTS
;
_setcolor1:
        MOVE      *-A14,A8,1          ;get foreground color argument
        MOVX      A8,A14
        SLL       16,A14
        MOVY      A14,A8
        MOVE      A8,B9               ;load COLOR1 register
        MOVE      *SP(32),A14,1       ;restore program stack pointer
        RETS      2                   ;done

_setcolor0:
        MOVE      *-A14,A8,1          ;get background color argument
        MOVX      A8,A14
        SLL       16,A14
        MOVY      A14,A8
        MOVE      A8,B8               ;load COLOR0 register
        MOVE      *SP(32),A14,1       ;restore program stack pointer
        RETS      2                   ;done

_setcolors:
        MOVE      *-A14,A8,1          ;get foreground color argument
        MOVE      A8,B9               ;load COLOR1 register
        MOVX      B9,B8
        SLL       16,B8
        MOVY      B8,B9
        JR        _setcolor0          ;

        .end

