
/*----------------------------------------------------------------------
 *                                    TIGA
 *          Copyright (C) 1989-1990  Texas Instruments Incorporated.
 *                            All Rights Reserved
 *----------------------------------------------------------------------
 *
 * Define names of special TMS34010 GSP B-file registers.
 *
 *----------------------------------------------------------------------
 */
#define SADDR	  0	/* register B0	*/
#define SPTCH	  1	/* register B1	*/
#define DADDR	  2	/* register B2	*/
#define DPTCH	  3	/* register B3	*/
#define OFFSET	  4	/* register B4	*/
#define WSTART	  5	/* register B5	*/
#define WEND	  6	/* register B6	*/
#define DYDX	  7	/* register B7	*/
#define COLOR0	  8	/* register B8	*/
#define COLOR1	  9	/* register B9	*/

/*----------------------------------------------------------------------
 *
 * Define base location of TMS34010's on-chip I/O register file.
 *
 *----------------------------------------------------------------------
 */
#define IO_BASE   0xC0000000	/* address of 1st I/O register */

/*----------------------------------------------------------------------
 *
 * Define names of I/O registers.
 *
 *----------------------------------------------------------------------
 */
#define HESYNC	  0xC0000000
#define HEBLNK	  0xC0000010
#define HSBLNK	  0xC0000020
#define HTOTAL	  0xC0000030
#define VESYNC	  0xC0000040
#define VEBLNK	  0xC0000050
#define VSBLNK	  0xC0000060
#define VTOTAL	  0xC0000070
#define DPYCTL	  0xC0000080
#define DPYSTRT   0xC0000090
#define DPYINT	  0xC00000A0
#define CONTROL   0xC00000B0
#define HSTDATA   0xC00000C0
#define HSTADRL   0xC00000D0
#define HSTADRH   0xC00000E0
#define HSTCTLL   0xC00000F0
#define HSTCTLH   0xC0000100
#define INTENB	  0xC0000110
#define INTPEND   0xC0000120
#define CONVSP	  0xC0000130
#define CONVDP	  0xC0000140
#define PSIZE	  0xC0000150
#define PMASK	  0xC0000160
                              /* I/O registers 23-26 are reserved */
#define DPYTAP    0xC00001B0
#define HCOUNT	  0xC00001C0
#define VCOUNT	  0xC00001D0
#define DPYADR	  0xC00001E0
#define REFCNT	  0xC00001F0

