/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  TIGA 1.1 - Bouncing line demo                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#include <time.h>

#include "tigademo.h"
#include "colors.h"

#define ITERATIONS      15000
#define COLOR_CHANGE    100

void frame4()
{
    short    xs, ys, xe, ye, fcolor, step, xmin, ymin, xmax, ymax;
    short    xs_go, xe_go, ys_go, ye_go;
    int      i;
    time_t   tim1, tim2;

    xmin = 2;
    ymin = 3*CHAR_HIGH + 2;
    xmax = HRES - 3;
    ymax = VRES - 3;
    step = HRES/32;
    xs = xmin;
    ys = ymin;
    xe = xmax;
    ye = ymax;
    xs_go = 5;
    ys_go = 3;
    xe_go = -6;
    ye_go = -2;
    fcolor = 1;

    for (i = 0; i < ITERATIONS; i++)
    {
        if( (i % COLOR_CHANGE) == 0 )
        {
            if( iscolor )
                set_fcolor(phys_color[fcolor]);
            else
                set_fcolor(fcolor % 2);
            if (++fcolor == max_colors)
                fcolor = 1;
        }
        draw_line(xs,ys,xe,ye);

        xs += xs_go;
        if (xs >= xmax)
            { xs = xmax; xs_go = -xs_go; }
        else
            if (xs <= xmin) { xs = xmin; xs_go = -xs_go; }

        ys += ys_go;
        if (ys >= ymax)
            { ys = ymax; ys_go = -ys_go; }
        else
            if (ys <= ymin) { ys = ymin; ys_go = -ys_go; }

        xe += xe_go;
        if (xe >= xmax)
            { xe = xmax; xe_go = -xe_go; }
        else
            if (xe <= xmin) { xe = xmin; xe_go = -xe_go; }

        ye += ye_go;
        if (ye <= ymin)
            { ye = ymin; ye_go = -ye_go; }
        else
            if (ye >= ymax) { ye = ymax; ye_go = -ye_go; }
    }
    if( !iscolor )
        set_fcolor(0xFFFFFFFF);
    
    /* time delay */
    time(&tim1);
    do
        time(&tim2);
    while (difftime(tim2, tim1) < 1.0);
}

