/*---------------------------------------------------------------------------*/
/* Tiga 2.0 Example Programs                                                 */
/*---------------------------------------------------------------------------*/
/*                                                                           */
/* CB.C         Callback Example Program                                     */
/*                                                                           */
/*      This file contains the host side source of an example of reading     */
/* keyboard input and performing simple host operations from a Gsp function  */
/* using callback.                                                           */
/*                                                                           */
/* The functions at the end of this file are those to be called from the     */
/* Gsp.  They illustrate the various types of argument passing available.    */
/*                                                                           */
/*---------------------------------------------------------------------------*/
#include "../metatiga.h"

HOST_INIT         hinit;

long read_number(),add_numbers(),read_list(),add_list(),double_list();
void *malloc();

void (*hcmds[5])() = { (void (*)())read_number, (void (*)())add_numbers,
                       (void (*)())read_list,   (void (*)())add_list,
                       (void (*)())double_list };

#define test_cb() cp_ret(USER_CP(module | 0), 0)

main()
{
    int module;
    unsigned long gptr;
    char *hptr;

    /*--------------------------------------------------------------*/
    /* Attempt to open the CD                                       */
    /*--------------------------------------------------------------*/
    if( tiga_set( CD_OPEN ) )
    {
        printf("Tiga CD is not installed\n");
        exit(1);
    }

    /*--------------------------------------------------------------*/
    /* Check to see that graphical interface is installed.          */
    /*--------------------------------------------------------------*/
    if( !set_videomode(TIGA,INIT) )
        error("Set Videomode error",0);

    printf("\nTiGA System Responding...\n\n");

    /* attempt to install module */
    printf("Installing Rlm\n");
    if ((module = install_rlm("cb340")) < 0 )
        error("Couldn't install RLM",module);

    if( !(gptr = gsp_malloc(5000)) )
        error("Initial block GSP Alloc Error",0);

    if( !(hptr = (char *) malloc(5000)) )
        error("Initial block HOST Alloc Error",0);

    hinit.host_buffer   = hptr;
    hinit.gsp_buffer    = gptr;
    hinit.buffer_size   = 5000;
    hinit.host_commands = &hcmds[0];
    hinit.command_count = 4;

    setup_hostcmd( &hinit );

    printf("Initialized!\n");

    printf("Gsp Buffer Address = %X\n",gptr);
    printf("Gsp Buffer Size    = %d\n",5000);

    test_cb();                                  /* Call the 340 Test Routine */

    printf("\nFreeing Buffers...\n");
    gsp_free( gptr );
    free( hptr );

    set_videomode(PREVIOUS,0);
    /*--------------------------------------------------------------*/
    /* Close the CD                                                 */
    /*--------------------------------------------------------------*/
    if( tiga_set( CD_CLOSE ) )
        printf("Error on CD close\n");
}

/*------------------------------------------------------------------*/
/* Routine to Abort with Error Message, Closing the Tiga CD         */
/*------------------------------------------------------------------*/
error(message,err)
char *message;
int err;
{
    printf("%s, Number < %05d >\n",message,err);
    set_videomode(PREVIOUS,0);
    tiga_set( CD_CLOSE );
    exit(1);
}

/*------------------------------------------------------------------*/
/* Routine to be called from the Gsp                                */
/*------------------------------------------------------------------*/
long read_number()
{
    long i;

    printf("Enter a number : ");
    scanf("%ld",&i);
    return(i);
}

/*------------------------------------------------------------------*/
/* Routine to be called from the Gsp                                */
/*------------------------------------------------------------------*/
long add_numbers(i,j)
int i,j;
{
    return(i+j);
}

/*------------------------------------------------------------------*/
/* Routine to be called from the Gsp                                */
/*------------------------------------------------------------------*/
long read_list( cnt, list )
short cnt;
short *list;
{
    int i;
    int tmp;

    printf("Enter %d numbers\n",cnt);

    for(i=0;i<cnt;i++)
    {
        scanf("%d",&tmp);
        *(list+i) = tmp;
    }
}

/*------------------------------------------------------------------*/
/* Routine to be called from the Gsp                                */
/*------------------------------------------------------------------*/
long add_list( cnt, list )
short cnt;
short *list;
{
    int i;
    long sum = 0;

    for(i=0;i<cnt;i++)
        sum+=*list++;

    return(sum);
}

/*------------------------------------------------------------------*/
/* Routine to be called from the Gsp                                */
/*------------------------------------------------------------------*/
long double_list( cnt, list )
short cnt;
short *list;
{
    int i;

    for(i=0;i<cnt;i++,*list++*=2);
}
