/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*          Copyright (c) 1990 Texas Instruments Incorporated.           */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  file            oemdata.c                                            */
/*                                                                       */
/*  description     This file contains global variable definitions for   */
/*		    alternate video modes and monitors. 		 */
/*									 */
/*  TMS34010 TIGA Development Board with minimum memory configuration:	 */
/*	512 kilobytes of VRAM (uses only 1 bank; 2nd bank ignored)	 */
/*	0 bytes of DRAM (software ignores any on-board DRAM)		 */
/*	Monitor:     SONY Multi Scan HG (Model no. CPD-1304)		 */
/*	Dot clocks:  OSC0 = 63.960 Mhz for 1024x768 noninterlaced	 */
/*		     OSC1 = 25.175 MHz for 640x480 noninterlaced	 */
/*		     OSC3 = 44.736 MHz for 1024x768 interlaced		 */
/*									 */
/*   12 graphics modes: 						 */
/*									 */
/*   mode #   resolution   # colors   # pages	display 		 */
/*   ------   ----------   --------   -------	------- 		 */
/*	0      640x480x4      16	 1	noninterlaced		 */
/*	1      640x480x2       4	 2	noninterlaced		 */
/*	2      640x480x1       2	 2	noninterlaced		 */
/*	3      320x240x8     256	 2	noninterlaced		 */
/*	4     1024x768x4      16	 1	noninterlaced		 */
/*	5     1024x768x2       4	 2	noninterlaced		 */
/*	6     1024x768x1       2	 2	noninterlaced		 */
/*	7      512x384x8     256	 2	noninterlaced		 */
/*	8     1024x768x4      16	 2	interlaced		 */
/*	9     1024x768x2       4	 2	interlaced		 */
/*     10     1024x768x1       2	 2	interlaced		 */
/*     11      512x384x8     256	 2	interlaced		 */
/*									 */
/*-----------------------------------------------------------------------*/
/*  05/15/90...Converted from OEMDATA.ASM file in CD.....J.R. Van Aken	 */
/*  09/14/90...Added 320x240 and 512x384 modes...........J.R. Van Aken	 */
/*-----------------------------------------------------------------------*/
#include <gsptypes.h>	      /* type definitions */
#include "oem.h"              /* hardware-specific constants */

#define NUM_MODES    12       /* number of graphics modes supported */

/*--------------------------------------------------------------------*/
/*  The constant CLK25MHZ is set to 1 (this is the default) if the    */
/*  640x480-resolution modes are driven by a separate 25.16-MHz       */
/*  oscillator #1.  It is set to 0 if these modes are driven by the   */
/*  34010's 50.35-MHz INCLK, which must be divided by two.            */
/*--------------------------------------------------------------------*/
#define CLK25MHZ     1			    /* 0=INCLK/2, 1=25MHz OSC */
#define OSC1DIV2     (CLK25MHZ<<10)	    /* setting for CR1 bit 10 */

/* List of globals defined in this file */
extern short num_modes;
extern SETUP mode_setup[];

short num_modes = NUM_MODES;  /* This global is accessed in CONFIG.C. */

/*-------------------------------------------------------------------*/
/*								     */
/*  34010 TDB Card, baseline configuration -- modes 0 through 5      */
/*								     */
/*-------------------------------------------------------------------*/
SETUP mode_setup[NUM_MODES] =
{
    /*-------------------------------------------------------------------*/
    /*	TDB Mode 0:	640x480x4,  16 colors,	1 video page,		 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 0			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    480,			 /* disp_vres			  */
	    640,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    4,				 /* disp_psize			  */
	    0x0000000Fl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    16, 			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    1,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x10000A00, 		 /* workspace address		  */
	    0X1000,			 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 0			  */
	/*----------------------------------------------------------------*/
	{
	    0x0004,			 /* hesync	  */
	    0x001F,			 /* heblnk	  */
	    0x00BF,			 /* hsblnk	  */
	    0x00C7,			 /* htotal	  */
	    0x0008,			 /* vesync	  */
	    0x0020,			 /* veblnk	  */
	    0x0200,			 /* vsblnk	  */
	    0x0207,			 /* vtotal	  */
	    0xF010,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 0			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0, 0 },				     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 0			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x10000A00,	384,  480 },	     /* buffer 0 */
	    { (PTR)0x101E0000, 1024,  288 },	     /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 0			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x30A0,0x8010|OSC1DIV2,0x0000	    /* TDB CRs 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 1:	640x480x2,  4 colors,  2 video pages,		 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 1			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000800, 		 /* disp_pitch			  */
	    480,			 /* disp_vres			  */
	    640,			 /* disp_hres			  */
	    27, 			 /* screen_wide     (Taken from   */
	    20, 			 /* screen_high      monitorinfo) */
	    2,				 /* disp_psize			  */
	    0x00000003l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    4,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x10000500, 		 /* workspace address		  */
	    0x800,			 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 1			  */
	/*----------------------------------------------------------------*/
	{
	    0x0004,			 /* hesync	  */
	    0x001E,			 /* heblnk	  */
	    0x00BE,			 /* hsblnk	  */
	    0x00C7,			 /* htotal	  */
	    0x0008,			 /* vesync	  */
	    0x0020,			 /* veblnk	  */
	    0x0200,			 /* vsblnk	  */
	    0x0207,			 /* vtotal	  */
	    0xF008,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 1			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x100F0000, 0x100F0000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 1			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x10000500,	384,  992 },	     /* buffer 0 */
	    { (PTR)0x101E0000, 1024,  576 },	     /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 1			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x10A0,0x8011|OSC1DIV2,0x0000	    /* TDB CRs 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 2:	640x480x1,  2 colors,  2 video pages,		 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 2			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000400, 		 /* disp_pitch			  */
	    480,			 /* disp_vres			  */
	    640,			 /* disp_hres			  */
	    27, 			 /* screen_wide     (Taken from   */
	    20, 			 /* screen_high      monitorinfo) */
	    1,				 /* disp_psize			  */
	    0x00000001l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    2,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x100F0000, 		 /* workspace address		  */
	    0x400,			 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 2			  */
	/*----------------------------------------------------------------*/
	{
	    0x0004,			 /* hesync	  */
	    0x001B,			 /* heblnk	  */
	    0x00BB,			 /* hsblnk	  */
	    0x00C7,			 /* htotal	  */
	    0x0008,			 /* vesync	  */
	    0x0020,			 /* veblnk	  */
	    0x0200,			 /* vsblnk	  */
	    0x0207,			 /* vtotal	  */
	    0xF004,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 2			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10078000, 0x10078000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 2			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x100F0000, 1024,  480 },	     /* buffer 0 */
	    { (PTR)0x10168000, 1024, 1632 },	     /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 2			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x30A0,0x8011|OSC1DIV2,0x0000	    /* TDB CRs 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 3:	320x240x8, 256 colors,	2 video pages,		 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 3			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    240,			 /* disp_vres			  */
	    320,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    8,				 /* disp_psize			  */
	    0x000000FFl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    256,			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    2,				 /* n of offscreen address blocks */
	    0x10000A00, 		 /* workspace address		  */
	    0X1000,			 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 3			  */
	/*----------------------------------------------------------------*/
	{
	    0x0002,			 /* hesync	  */
	    0x000E,			 /* heblnk	  */
	    0x005E,			 /* hsblnk	  */
	    0x0063,			 /* htotal	  */
	    0x0008,			 /* vesync	  */
	    0x0020,			 /* veblnk	  */
	    0x0200,			 /* vsblnk	  */
	    0x0207,			 /* vtotal	  */
	    0xF008,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 3			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x100F0000, 0x100F0000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 3			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x10000A00,	192,  480 },	     /* buffer 0 */
	    { (PTR)0x101E0000,	512,  288 },	     /* buffer 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 3			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x10A0,0x80D0|OSC1DIV2,0x0000	    /* TDB CRs 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 4:	1024x768x4,  16 colors,  1 video page,		 */
    /*			NO statically allocated workspace buffer	 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 4			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    4,				 /* disp_psize			  */
	    0x0000000Fl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    16, 			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    1,				 /* n_of_pages			  */
	    0,				 /* n of offscreen address blocks */
	    0,				 /* workspace address		  */
	    0,				 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 4			  */
	/*----------------------------------------------------------------*/
	{
	    0x0006,			 /* hesync	  */
	    0x0020,			 /* heblnk	  */
	    0x00A0,			 /* hsblnk	  */
	    0x00A8,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x001F,			 /* veblnk	  */
	    0x031F,			 /* vsblnk	  */
	    0x0322,			 /* vtotal	  */
	    0xF010,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 4			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0, 0 },				     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 4			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 4			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x3098,0x8010,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 5:	1024x768x2,  4 colors,	2 video pages,		 */
    /*			NO statically allocated workspace buffer	 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 5			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000800, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    2,				 /* disp_psize			  */
	    0x00000003l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    4,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    0,				 /* n of offscreen address blocks */
	    0,				 /* workspace address		  */
	    0,				 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 5			  */
	/*----------------------------------------------------------------*/
	{
	    0x0006,			 /* hesync	  */
	    0x0020,			 /* heblnk	  */
	    0x00A0,			 /* hsblnk	  */
	    0x00A8,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x001F,			 /* veblnk	  */
	    0x031F,			 /* vsblnk	  */
	    0x0322,			 /* vtotal	  */
	    0xF008,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 5			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10180000, 0x10180000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 5			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 5			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x1098,0x8011,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 6:	1024x768x1,   2 colors,  2 video pages, 	 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 6			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000400, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    1,				 /* disp_psize			  */
	    0x00000001l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    2,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    1,				 /* n of offscreen address blocks */
	    0x10180000, 		 /* workspace address		  */
	    0x400,			 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 6			  */
	/*----------------------------------------------------------------*/
	{
	    0x0006,			 /* hesync	  */
	    0x001E,			 /* heblnk	  */
	    0x009E,			 /* hsblnk	  */
	    0x00A8,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x001F,			 /* veblnk	  */
	    0x031F,			 /* vsblnk	  */
	    0x0322,			 /* vtotal	  */
	    0xF004,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 6			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x100C0000, 0x100C0000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 6			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x10180000, 1024, 1536 },	     /* buffer 0 */
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 6			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x3098,0x8011,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	TDB Mode 7:	512x384x8,  256 colors,  2 video pages, 	 */
    /*			statically allocated workspace buffer		 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 TDB Mode 7			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    384,			 /* disp_vres			  */
	    512,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    8,				 /* disp_psize			  */
	    0x000000FFl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    256,			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    0,				 /* n of offscreen address blocks */
	    0,				 /* workspace address		  */
	    0,				 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 TDB Mode 7			  */
	/*----------------------------------------------------------------*/
	{
	    0x0003,			 /* hesync	  */
	    0x000F,			 /* heblnk	  */
	    0x004F,			 /* hsblnk	  */
	    0x0054,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x001F,			 /* veblnk	  */
	    0x031F,			 /* vsblnk	  */
	    0x0322,			 /* vtotal	  */
	    0xF008,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 TDB Mode 7			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10180000, 0x10180000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 TDB Mode 7			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 TDB Mode 7			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x1098,0x80D0,0x0000    /* TDB Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	BGA Mode 8:	1024x768x4,  16 colors,  1 video page,		 */
    /*			NO statically allocated workspace buffer,	 */
    /*			INTERLACED					 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 BGA Mode 8			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    4,				 /* disp_psize			  */
	    0x0000000Fl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    16, 			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    1,				 /* n_of_pages			  */
	    0,				 /* n of offscreen address blocks */
	    0,				 /* workspace address		  */
	    0,				 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 BGA Mode 8			  */
	/*----------------------------------------------------------------*/
	{
	    0x0015,			 /* hesync	  */
	    0x001A,			 /* heblnk	  */
	    0x009A,			 /* hsblnk	  */
	    0x009D,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x0016,			 /* veblnk	  */
	    0x0196,			 /* vsblnk	  */
	    0x0198,			 /* vtotal	  */
	    0xB020,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 BGA Mode 8			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0, 0 },				     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 BGA Mode 8			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 BGA Mode 8			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x30F8,0x8010,0x0000    /* BGA Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	BGA Mode 9:	1024x768x2,  4 colors,	2 video pages,		 */
    /*			NO statically allocated workspace buffer,	 */
    /*			INTERLACED					 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 BGA Mode 9			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000800, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    2,				 /* disp_psize			  */
	    0x00000003l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    4,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    0,				 /* n of offscreen address blocks */
	    0,				 /* workspace address		  */
	    0,				 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 BGA Mode 9			  */
	/*----------------------------------------------------------------*/
	{
	    0x0015,			 /* hesync	  */
	    0x0019,			 /* heblnk	  */
	    0x0099,			 /* hsblnk	  */
	    0x009D,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x0016,			 /* veblnk	  */
	    0x0196,			 /* vsblnk	  */
	    0x0198,			 /* vtotal	  */
	    0xB010,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 BGA Mode 9			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10180000, 0x10180000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 BGA Mode 9			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 BGA Mode 9			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x10F8,0x8011,0x0000    /* BGA Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	BGA Mode 10:	1024x768x1,   2 colors,  2 video pages, 	 */
    /*			statically allocated workspace buffer,		 */
    /*			INTERLACED					 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 BGA Mode 10			  */
	/*----------------------------------------------------------------*/
	{
	    0x00000400, 		 /* disp_pitch			  */
	    768,			 /* disp_vres			  */
	    1024,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    1,				 /* disp_psize			  */
	    0x00000001l,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    2,				 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    1,				 /* n of offscreen address blocks */
	    0x10180000, 		 /* workspace address		  */
	    0x400,			 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 BGA Mode 10			  */
	/*----------------------------------------------------------------*/
	{
	    0x0015,			 /* hesync	  */
	    0x0018,			 /* heblnk	  */
	    0x0098,			 /* hsblnk	  */
	    0x009D,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x0016,			 /* veblnk	  */
	    0x0196,			 /* vsblnk	  */
	    0x0198,			 /* vtotal	  */
	    0xB008,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 BGA Mode 10			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x100C0000, 0x100C0000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 BGA Mode 10			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x10180000, 1024, 1536 },	     /* buffer 0 */
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 BGA Mode 10			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x30F8,0x8011,0x0000    /* BGA Control Registers 0, 1 and 2 */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	BGA Mode 11:	512x384x8,  256 colors,  2 video pages, 	 */
    /*			NO statically allocated workspace buffer,	 */
    /*			INTERLACED					 */
    /*-------------------------------------------------------------------*/
    {
	{
	    0,
	    sizeof(HEADER),
	    sizeof(HEADER)+sizeof(MODEINFO),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES),
	    /*------------------------------------------------------------*/
	    /*	  Offset to OEM_Data field of SETUP structure		  */
	    /*------------------------------------------------------------*/
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	    sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	       (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	       sizeof(OEMDATA)
	},
	/*----------------------------------------------------------------*/
	/*  MODEINFO			 BGA Mode 11			  */
	/*----------------------------------------------------------------*/
	{
	    0x00001000, 		 /* disp_pitch			  */
	    384,			 /* disp_vres			  */
	    512,			 /* disp_hres			  */
	    27, 			 /* screen_wide - taken from	  */
	    20, 			 /* screen_high   monitorinfo	  */
	    8,				 /* disp_psize			  */
	    0x000000FFl,		 /* pixel mask			  */
	    8,				 /* palette gun depth		  */
	    256,			 /* palette entries		  */
	    0,				 /* palette inset		  */
	    2,				 /* n_of_pages			  */
	    0,				 /* n of offscreen address blocks */
	    0,				 /* workspace address		  */
	    0,				 /* workspace pitch		  */
	    0				 /* no block write capability	  */
	},
	/*----------------------------------------------------------------*/
	/*  MONITORINFO10		 BGA Mode 11			  */
	/*----------------------------------------------------------------*/
	{
	    0x000A,			 /* hesync	  */
	    0x000C,			 /* heblnk	  */
	    0x004C,			 /* hsblnk	  */
	    0x004E,			 /* htotal	  */
	    0x0003,			 /* vesync	  */
	    0x0016,			 /* veblnk	  */
	    0x0196,			 /* vsblnk	  */
	    0x0198,			 /* vtotal	  */
	    0xB010,			 /* dpyctl	  */
	    30, 			 /* screen_delay  */
	    0				 /* monitor flags */
	},
	/*----------------------------------------------------------------*/
	/*  PAGE			 BGA Mode 11			  */
	/*----------------------------------------------------------------*/
	{
	    { 0x10000000, 0x10000000 }, 	     /* display page 0 */
	    { 0x10180000, 0x10180000 }, 	     /* display page 1 */
	},
	/*----------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 BGA Mode 11			  */
	/*----------------------------------------------------------------*/
	{
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	    { (PTR)0x00000000,	  0,	0 },	     /* empty */
	},
	/*----------------------------------------------------------------*/
	/*  OEMDATA			 BGA Mode 11			  */
	/*	(Fields CR0, CR1 and CR2 defined in oem.h)		  */
	/*----------------------------------------------------------------*/
	{
	      0x10F8,0x80D0,0x0000    /* BGA Control Registers 0, 1 and 2 */
	}
    },
};

