/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*       Copyright (c) 1988-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TIGA - Graphics Manager                                              */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  void init_palet()                                                    */
/*                                                                       */
/*  This function initializes the first 16 entries in the palette to     */
/*  the EGA default colors.                                              */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/*  07/11/88  Original Version Written                      Graham Short */
/*  03/14/90  Modified palette init based on psize          W.S.Egr      */
/*-----------------------------------------------------------------------*/

#include <gsptypes.h>
#include <gspglobs.h>
#include <gsptiga.h>
#include "oem.h"

extern PALET Palet1bpp[], Palet2bpp[], Palet4bpp[];


dm_init_palet(dataptr)
short *dataptr;
{
    InitPalette();
}


init_palet()
{
    InitPalette();
}


InitPalette()
{
    PALET           *Palette;
    register long    indices;
    unsigned short   i;

    switch( config.mode.disp_psize )
    {
        case 1:
            Palette = Palet1bpp;
            break;
        case 2:
            Palette = Palet2bpp;
            break;
        case 4:
            Palette = Palet4bpp;
            break;
        /*--------------------------------------------------------------*/
        /*  Special case for 8bpp:                                      */
        /*      Replicate (16 times) 4bpp palette through 8bpp palette  */
        /*--------------------------------------------------------------*/
        case 8:
            for( i=0; i<16; i++ )
                set_palet( 16, i<<4, Palet4bpp );
            return;
    };
    /*------------------------------------------------------------------*/
    /*  Set palettes for 1,2, and 4 bpp                                 */
    /*------------------------------------------------------------------*/
    indices = 2 << (config.mode.disp_psize-1);
    set_palet( indices, 0, Palette );
}
