/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *          Copyright (c) 1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Use the draw_point function to cover the screen with a 256x256
 *   arabesque pattern of dots.
 *----------------------------------------------------------------------
 *   05/19/90...Original version written..................J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif


main()
{
    CONFIG cfg;
    short hres, vres, k, n, x, y;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(-1);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */
    for (x = 0; x < hres; x += 256)
        for (y = 0; y < vres; y += 256) {
            set_draw_origin(x, y);
            for (n = 16384, k = 7; n; n--) {
                k = ~(2*k | (1 & ((k/16 ^ k)/32 ^ k)/64));
                draw_point(0xFF & k, 0xFF & k/256);
            }
        }
}

