;-------------------------------------------------------------------------;
;                                   TIGA                                  ;
;   Copyright (c) 1988-1990  Texas Instruments.  All Rights Reserved      ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;   void clear_screen(c)                                                  ;
;   long  c;            /* clear screen to this pixel value */            ;
;                                                                         ;
;   This function clears the screen to the color corresponding to the     ;
;   specified color index.                                                ;
;                                                                         ;
;   Notes:- A8 is destroyed                                               ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  07/14/88...Original Version...........................Mike Denio       ;
;  07/16/88...Added TIGA direct mode.....................Graham Short     ;
;  09/07/88...Access globals thru env struct.............W.S.Egr          ;
;  01/10/89...Accept color parameter.....................W.S.Egr          ;
;  01/25/89...Modified clear CONTROL to not clear CD bit.Graham Short     ;
;  10/02/90...Clear PMASK register prior to FILL.........J. Van Aken      ;
;-------------------------------------------------------------------------;
;
        .title    'clear screen'
        .file     'clearscr.asm'
        include   gspreg.inc
        include   gsptypes.inc            
        include   gspglobs.inc            
        .mlib     gspmac.lib
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _clear_screen
        .globl    _dm_clear_screen
;
;     GLOBAL REFERENCES
;
        .globl    _set_fcolor        
;
;   C-PACKET ENTRY POINT
;
_clear_screen:
        mmtm      SP,B2,B7,B9,B10,B11,B12,B13,B14
        Popc      A8                  ;get color index 
        jruc      common_ep           ;
;
;   DIRECT MODE ENTRY POINT
;
_dm_clear_screen:
        mmtm      SP,B2,B7,B9,B10,B11,B12,B13,B14
        Popc      A8                  ;get pointer to dm-data
        move      *A8,A8,1            ;get color index
;
;   COMMON ENTRY POINT
;
common_ep:

        move      A8,COLOR1           ;copy arg c
        jrz       color_is_set        ;jump if arg c == all 0s
        inc       COLOR1              ;is arg c == -1?
        jrz       use_color0          ;jump if arg c == -1
;-----------------------------------------------------------------------;
;   Replicate pixel in COLOR1 register to 32 bits.                      ;
;-----------------------------------------------------------------------;
        Push      STK                 ;push C program stack pointer
        Pushc     A8                  ;push pixel value to be replicated
        calla     _set_fcolor         ;call function to replicate pixel
        jruc      color_is_set        ;
;-----------------------------------------------------------------------;
;   Screen will be cleared to background color in COLOR0.               ;
;-----------------------------------------------------------------------;
use_color0:
        move      COLOR0,COLOR1       ;
;-----------------------------------------------------------------------;
;   Clear the screen to the specified pixel value.                      ;
;-----------------------------------------------------------------------;
color_is_set: 
        clr       DADDR               ;start fill at x-y origin = (0,0)
        move      @PMASK,A8,1         ;save PMASK register
        move      DADDR,@PMASK,1      ;clear PMASK register
        setf      16-1-5,0,0          ;
        move      @CONTROL+5,A14,0    ;save CONTROL register bits 5-14
        move      DADDR,@CONTROL+5,0  ;clear T thru PPOP in CONTROL
        move      @(_config+CONFIG_DISP_VRES),DYDX,1 ;get VRES, HRES
        rl        16,DYDX             ;set DX=HRES, DY=VRES
        fill      XY                  ;clear the entire screen
        move      A14,@CONTROL+5,0    ;restore CONTROL register
        move      A8,@PMASK,1         ;restore PMASK register
        mmfm      SP,B2,B7,B9,B10,B11,B12,B13,B14
        move      *SP(32),A14,1       ;restore C program stack pointer
        rets      2                   ;
        .end

