/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *          Copyright (c) 1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Use set_config function to cycle through all graphics modes
 *   supported by current graphics configuration.  Print mode
 *   number, screen resolution, and pixel depth to screen.  Delay
 *   3 seconds between mode switches.
 *----------------------------------------------------------------------
 *   03/27/90...Original version written..................J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>

static CONFIG cfg;
static FONTINFO fntinf;


main()
{
    int mode, hres, vres, x, y, n;
    char c[80];

    set_config(0, 1);
    clear_frame_buffer(0);
    for (;;)
	for (mode = 0; set_config(mode, 1); mode++) {
	    clear_frame_buffer(0);
	    get_config(&cfg);
	    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
	    vres = cfg.mode.disp_vres;	 /* vertical resolution */
	    get_fontinfo(0, &fntinf);	 /* get system font parameters */

	    frame_rect(hres, vres, 0, 0, hres/32, vres/32);
	    x = hres/16;
	    y = vres/16;
	    n = strlen(strcpy(c, "graphics mode "));
	    ltoa(mode, &c[n]);
	    text_out(x, y, c);
	    y += fntinf.charhigh;

	    n = strlen(strcpy(c, "  resolution = "));
	    n += ltoa(hres, &c[n]);
	    n += strlen(strcpy(&c[n], "-by-"));
	    n += ltoa(vres, &c[n]);
	    text_out(x, y, c);
	    y += fntinf.charhigh;

	    n = strlen(strcpy(c, "  pixel depth = "));
	    ltoa(cfg.mode.disp_psize, &c[n]);
	    text_out(x, y, c);

	    if (cfg.mode.num_pages > 1)
		text_out(x, y+fntinf.charhigh, "  double buffered");

	    for (n = 180; n; n--)    /* 3-second delay */
		wait_scan(vres);
	    clear_frame_buffer(0);
	}
}

